/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;

public abstract class FloatVectorValues
extends DocIdSetIterator {
    protected FloatVectorValues() {
    }

    public abstract int dimension();

    public abstract int size();

    @Override
    public final long cost() {
        return this.size();
    }

    public abstract float[] vectorValue() throws IOException;

    public static void checkField(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null && fi.hasVectorValues() && fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            throw new IllegalStateException("Unexpected vector encoding (" + String.valueOf((Object)fi.getVectorEncoding()) + ") for field " + field + "(expected=" + String.valueOf((Object)VectorEncoding.FLOAT32) + ")");
        }
    }

    public abstract VectorScorer scorer(float[] var1) throws IOException;
}

