/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.api.model.FileStoreDirectoryListingResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UploadToFileStoreResponse;
import org.apache.solr.client.solrj.InputStreamResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class FileStoreApi {

    public static class UploadFile
    extends SolrRequest<UploadFileResponse> {
        private final Object requestBody;
        private final String filePath;
        private List<String> sig;

        public UploadFile(String filePath, Object requestBody) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/cluster/filestore/files{filePath}".replace("{filePath}", filePath));
            this.filePath = filePath;
            this.requestBody = requestBody;
        }

        public void setSig(List<String> sig) {
            this.sig = sig;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new RequestWriter.ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    ((InputStream)requestBody).transferTo(os);
                }

                @Override
                public String getContentType() {
                    return "application/octet-stream";
                }
            };
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.sig != null) {
                this.sig.forEach(v -> params.add("sig", (String)v));
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("sig");
            return queryParams;
        }

        @Override
        protected UploadFileResponse createResponse(SolrClient client) {
            return new UploadFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class UploadFileResponse
    extends JacksonParsingResponse<UploadToFileStoreResponse> {
        public UploadFileResponse() {
            super(UploadToFileStoreResponse.class);
        }
    }

    public static class SyncFile
    extends SolrRequest<SyncFileResponse> {
        private final String path;

        public SyncFile(String path) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cluster/filestore/commands/sync{path}".replace("{path}", path));
            this.path = path;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected SyncFileResponse createResponse(SolrClient client) {
            return new SyncFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class SyncFileResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public SyncFileResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class GetMetadata
    extends SolrRequest<GetMetadataResponse> {
        private final String path;

        public GetMetadata(String path) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cluster/filestore/metadata{path}".replace("{path}", path));
            this.path = path;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetMetadataResponse createResponse(SolrClient client) {
            return new GetMetadataResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetMetadataResponse
    extends JacksonParsingResponse<FileStoreDirectoryListingResponse> {
        public GetMetadataResponse() {
            super(FileStoreDirectoryListingResponse.class);
        }
    }

    public static class GetFile
    extends SolrRequest<GetFileResponse> {
        private final String filePath;

        public GetFile(String filePath) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cluster/filestore/files{filePath}".replace("{filePath}", filePath));
            this.filePath = filePath;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetFileResponse createResponse(SolrClient client) {
            return new GetFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetFileResponse
    extends InputStreamResponse {
    }

    public static class FetchFile
    extends SolrRequest<FetchFileResponse> {
        private final String path;
        private String getFrom;

        public FetchFile(String path) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cluster/filestore/commands/fetch{path}".replace("{path}", path));
            this.path = path;
        }

        public void setGetFrom(String getFrom) {
            this.getFrom = getFrom;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.getFrom != null) {
                params.add("getFrom", this.getFrom);
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("getFrom");
            return queryParams;
        }

        @Override
        protected FetchFileResponse createResponse(SolrClient client) {
            return new FetchFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchFileResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public FetchFileResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class DeleteFile
    extends SolrRequest<DeleteFileResponse> {
        private final String path;
        private Boolean localDelete;

        public DeleteFile(String path) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/cluster/filestore/files{path}".replace("{path}", path));
            this.path = path;
        }

        public void setLocalDelete(Boolean localDelete) {
            this.localDelete = localDelete;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.localDelete != null) {
                params.add("localDelete", this.localDelete.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("localDelete");
            return queryParams;
        }

        @Override
        protected DeleteFileResponse createResponse(SolrClient client) {
            return new DeleteFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteFileResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteFileResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

