/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.api.model.ListLevelsResponse;
import org.apache.solr.client.api.model.LogLevelChange;
import org.apache.solr.client.api.model.LogMessagesResponse;
import org.apache.solr.client.api.model.LoggingResponse;
import org.apache.solr.client.api.model.SetThresholdRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class LoggingApi {

    public static class SetMessageThreshold
    extends SolrRequest<SetMessageThresholdResponse> {
        private final SetThresholdRequestBody requestBody = new SetThresholdRequestBody();

        public SetMessageThreshold() {
            super(SolrRequest.METHOD.valueOf("PUT"), "/node/logging/messages/threshold");
        }

        public void setLevel(String level) {
            this.requestBody.level = level;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected SetMessageThresholdResponse createResponse(SolrClient client) {
            return new SetMessageThresholdResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class SetMessageThresholdResponse
    extends JacksonParsingResponse<LoggingResponse> {
        public SetMessageThresholdResponse() {
            super(LoggingResponse.class);
        }
    }

    public static class ModifyLocalLogLevel
    extends SolrRequest<ModifyLocalLogLevelResponse> {
        private final List<LogLevelChange> requestBody = new ArrayList<LogLevelChange>();

        public ModifyLocalLogLevel() {
            super(SolrRequest.METHOD.valueOf("PUT"), "/node/logging/levels");
        }

        public void addLogLevelChange(LogLevelChange entry) {
            this.requestBody.add(entry);
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ModifyLocalLogLevelResponse createResponse(SolrClient client) {
            return new ModifyLocalLogLevelResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ModifyLocalLogLevelResponse
    extends JacksonParsingResponse<LoggingResponse> {
        public ModifyLocalLogLevelResponse() {
            super(LoggingResponse.class);
        }
    }

    public static class ListAllLoggersAndLevels
    extends SolrRequest<ListAllLoggersAndLevelsResponse> {
        public ListAllLoggersAndLevels() {
            super(SolrRequest.METHOD.valueOf("GET"), "/node/logging/levels");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListAllLoggersAndLevelsResponse createResponse(SolrClient client) {
            return new ListAllLoggersAndLevelsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListAllLoggersAndLevelsResponse
    extends JacksonParsingResponse<ListLevelsResponse> {
        public ListAllLoggersAndLevelsResponse() {
            super(ListLevelsResponse.class);
        }
    }

    public static class FetchLocalLogMessages
    extends SolrRequest<FetchLocalLogMessagesResponse> {
        private Long since;

        public FetchLocalLogMessages() {
            super(SolrRequest.METHOD.valueOf("GET"), "/node/logging/messages");
        }

        public void setSince(Long since) {
            this.since = since;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.since != null) {
                params.add("since", this.since.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("since");
            return queryParams;
        }

        @Override
        protected FetchLocalLogMessagesResponse createResponse(SolrClient client) {
            return new FetchLocalLogMessagesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchLocalLogMessagesResponse
    extends JacksonParsingResponse<LogMessagesResponse> {
        public FetchLocalLogMessagesResponse() {
            super(LogMessagesResponse.class);
        }
    }
}

