/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.netty.UdsNameResolver;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;

@Internal
public final class UdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "unix";

    public UdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new UdsNameResolver(targetUri.getAuthority(), UdsNameResolverProvider.getTargetPathFromUri(targetUri));
        }
        return null;
    }

    static String getTargetPathFromUri(URI targetUri) {
        Preconditions.checkArgument((boolean)SCHEME.equals(targetUri.getScheme()), (Object)"scheme must be unix");
        String targetPath = targetUri.getPath();
        if (targetPath == null) {
            targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getSchemeSpecificPart(), (Object)"targetPath");
        }
        return targetPath;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 3;
    }

    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

