/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.descriptor.LocalResolver;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.res.StringManager;

public class DigesterFactory {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final Class<ServletContext> CLASS_SERVLET_CONTEXT = ServletContext.class;
    private static final Class<?> CLASS_JSP_CONTEXT;
    public static final Map<String, String> SERVLET_API_PUBLIC_IDS;
    public static final Map<String, String> SERVLET_API_SYSTEM_IDS;

    private static void addSelf(Map<String, String> map, String string) {
        String string2 = DigesterFactory.locationFor(string);
        if (string2 != null) {
            map.put(string, string2);
            map.put(string2, string2);
        }
    }

    private static void add(Map<String, String> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
            if (string.startsWith("http://")) {
                String string3 = "https://" + string.substring(7);
                map.put(string3, string2);
            }
        }
    }

    private static String locationFor(String string) {
        URL uRL = CLASS_SERVLET_CONTEXT.getResource("resources/" + string);
        if (uRL == null && CLASS_JSP_CONTEXT != null) {
            uRL = CLASS_JSP_CONTEXT.getResource("resources/" + string);
        }
        if (uRL == null) {
            Log log = LogFactory.getLog(DigesterFactory.class);
            log.warn((Object)sm.getString("digesterFactory.missingSchema", new Object[]{string}));
            return null;
        }
        return uRL.toExternalForm();
    }

    public static Digester newDigester(boolean bl, boolean bl2, RuleSet ruleSet, boolean bl3) {
        Digester digester = new Digester();
        digester.setNamespaceAware(bl2);
        digester.setValidating(bl);
        digester.setUseContextClassLoader(true);
        LocalResolver localResolver = new LocalResolver(SERVLET_API_PUBLIC_IDS, SERVLET_API_SYSTEM_IDS, bl3);
        digester.setEntityResolver(localResolver);
        if (ruleSet != null) {
            digester.addRuleSet(ruleSet);
        }
        return digester;
    }

    static {
        Serializable serializable = null;
        try {
            serializable = Class.forName("javax.servlet.jsp.JspContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        CLASS_JSP_CONTEXT = serializable;
        serializable = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DigesterFactory.add(serializable, "-//W3C//DTD XMLSCHEMA 200102//EN", DigesterFactory.locationFor("XMLSchema.dtd"));
        DigesterFactory.add(serializable, "datatypes", DigesterFactory.locationFor("datatypes.dtd"));
        DigesterFactory.add(hashMap, "http://www.w3.org/2001/xml.xsd", DigesterFactory.locationFor("xml.xsd"));
        DigesterFactory.add(serializable, "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", DigesterFactory.locationFor("web-app_2_2.dtd"));
        DigesterFactory.add(serializable, "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", DigesterFactory.locationFor("web-jsptaglibrary_1_1.dtd"));
        DigesterFactory.add(serializable, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", DigesterFactory.locationFor("web-app_2_3.dtd"));
        DigesterFactory.add(serializable, "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", DigesterFactory.locationFor("web-jsptaglibrary_1_2.dtd"));
        DigesterFactory.add(hashMap, "http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", DigesterFactory.locationFor("j2ee_web_services_1_1.xsd"));
        DigesterFactory.add(hashMap, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", DigesterFactory.locationFor("j2ee_web_services_client_1_1.xsd"));
        DigesterFactory.add(hashMap, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", DigesterFactory.locationFor("web-app_2_4.xsd"));
        DigesterFactory.add(hashMap, "http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd", DigesterFactory.locationFor("web-jsptaglibrary_2_0.xsd"));
        DigesterFactory.addSelf(hashMap, "j2ee_1_4.xsd");
        DigesterFactory.addSelf(hashMap, "jsp_2_0.xsd");
        DigesterFactory.add(hashMap, "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", DigesterFactory.locationFor("web-app_2_5.xsd"));
        DigesterFactory.add(hashMap, "http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd", DigesterFactory.locationFor("web-jsptaglibrary_2_1.xsd"));
        DigesterFactory.addSelf(hashMap, "javaee_5.xsd");
        DigesterFactory.addSelf(hashMap, "jsp_2_1.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_web_services_1_2.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_web_services_client_1_2.xsd");
        DigesterFactory.add(hashMap, "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", DigesterFactory.locationFor("web-app_3_0.xsd"));
        DigesterFactory.add(hashMap, "http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", DigesterFactory.locationFor("web-fragment_3_0.xsd"));
        DigesterFactory.addSelf(hashMap, "web-common_3_0.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_6.xsd");
        DigesterFactory.addSelf(hashMap, "jsp_2_2.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_web_services_1_3.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_web_services_client_1_3.xsd");
        DigesterFactory.add(hashMap, "http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd", DigesterFactory.locationFor("web-app_3_1.xsd"));
        DigesterFactory.add(hashMap, "http://xmlns.jcp.org/xml/ns/javaee/web-fragment_3_1.xsd", DigesterFactory.locationFor("web-fragment_3_1.xsd"));
        DigesterFactory.addSelf(hashMap, "web-common_3_1.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_7.xsd");
        DigesterFactory.addSelf(hashMap, "jsp_2_3.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_web_services_1_4.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_web_services_client_1_4.xsd");
        DigesterFactory.add(hashMap, "http://xmlns.jcp.org/xml/ns/javaee/web-app_4_0.xsd", DigesterFactory.locationFor("web-app_4_0.xsd"));
        DigesterFactory.add(hashMap, "http://xmlns.jcp.org/xml/ns/javaee/web-fragment_4_0.xsd", DigesterFactory.locationFor("web-fragment_4_0.xsd"));
        DigesterFactory.addSelf(hashMap, "web-common_4_0.xsd");
        DigesterFactory.addSelf(hashMap, "javaee_8.xsd");
        SERVLET_API_PUBLIC_IDS = Collections.unmodifiableMap(serializable);
        SERVLET_API_SYSTEM_IDS = Collections.unmodifiableMap(hashMap);
    }
}

