/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.RequestContext;

public class ClientMetricsInstanceMetadata {
    private final Map<String, String> attributesMap;

    public ClientMetricsInstanceMetadata(Uuid clientInstanceId, RequestContext requestContext) {
        Objects.requireNonNull(clientInstanceId);
        Objects.requireNonNull(requestContext);
        this.attributesMap = new HashMap<String, String>();
        this.attributesMap.put("client_instance_id", clientInstanceId.toString());
        this.attributesMap.put("client_id", requestContext.clientId());
        this.attributesMap.put("client_software_name", requestContext.clientInformation != null ? requestContext.clientInformation.softwareName() : null);
        this.attributesMap.put("client_software_version", requestContext.clientInformation != null ? requestContext.clientInformation.softwareVersion() : null);
        this.attributesMap.put("client_source_address", requestContext.clientAddress != null ? requestContext.clientAddress.getHostAddress() : null);
        this.attributesMap.put("client_source_port", requestContext.clientPort.map(String::valueOf).orElse(null));
    }

    public boolean isMatch(Map<String, Pattern> patterns) {
        if (!patterns.isEmpty()) {
            return this.matchPatterns(patterns);
        }
        return true;
    }

    private boolean matchPatterns(Map<String, Pattern> matchingPatterns) {
        return matchingPatterns.entrySet().stream().allMatch(entry -> {
            String attribute = this.attributesMap.get(entry.getKey());
            return attribute != null && ((Pattern)entry.getValue()).matcher(attribute).matches();
        });
    }
}

