/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.internal.EmptyArray;
import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import java.util.Arrays;
import java.util.Objects;

final class DistinctElementHashProvider
implements ElementHashProvider {
    private static final double EXTENSION_FACTOR = 1.5;
    private static final long INITIAL_SEED = -292647701612425068L;
    private final PseudoRandomGenerator pseudoRandomGenerator;
    private long nullConstant;
    private long[] work;
    private int distinctCount = 0;

    public DistinctElementHashProvider(PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        Objects.requireNonNull(pseudoRandomGeneratorProvider);
        this.pseudoRandomGenerator = pseudoRandomGeneratorProvider.create();
        this.pseudoRandomGenerator.reset(-292647701612425068L);
        this.work = EmptyArray.EMPTY_LONG_ARRAY;
        this.nullConstant = this.pseudoRandomGenerator.nextLong();
    }

    private static int computeWorkArrayLength(int numElements) {
        return Integer.highestOneBit((int)((double)numElements * 1.5)) << 1;
    }

    private static boolean contains(long[] array, int len, long key) {
        for (int i = 0; i < len; ++i) {
            if (array[i] != key) continue;
            return true;
        }
        return false;
    }

    private void changeNullConstant(int workLen) {
        long newNullConstant;
        while (this.nullConstant == (newNullConstant = this.pseudoRandomGenerator.nextLong()) || DistinctElementHashProvider.contains(this.work, workLen, newNullConstant)) {
        }
        for (int i = 0; i < workLen; ++i) {
            if (this.work[i] != this.nullConstant) continue;
            this.work[i] = newNullConstant;
        }
        this.nullConstant = newNullConstant;
    }

    public void reset(ElementHashProvider elementHashProvider) {
        int numElements = elementHashProvider.getNumberOfElements();
        Preconditions.checkArgument((long)numElements <= 0x40000000L);
        int workLen = DistinctElementHashProvider.computeWorkArrayLength(numElements);
        if (this.work.length < workLen) {
            this.work = new long[workLen];
        }
        Arrays.fill(this.work, 0, workLen, this.nullConstant);
        int workLenMinus1 = workLen - 1;
        for (int elementIdx = 0; elementIdx < numElements; ++elementIdx) {
            long hash = elementHashProvider.getElementHash(elementIdx);
            if (hash == this.nullConstant) {
                this.changeNullConstant(workLen);
            }
            int pos = (int)hash & workLenMinus1;
            while (this.work[pos] != this.nullConstant && this.work[pos] != hash) {
                pos = pos + 1 & workLenMinus1;
            }
            this.work[pos] = hash;
        }
        this.distinctCount = 0;
        for (int pos = 0; pos < workLen; ++pos) {
            if (this.work[pos] == this.nullConstant) continue;
            this.work[this.distinctCount] = this.work[pos];
            ++this.distinctCount;
        }
    }

    @Override
    public int getNumberOfElements() {
        return this.distinctCount;
    }

    @Override
    public long getElementHash(int elementIndex) {
        return this.work[elementIndex];
    }
}

