/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.contextvars.ContextVarBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.contextvars.ContextVarBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.ContextVarBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsToken;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ContextVar})
public final class ContextVarBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ContextVarBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextVarBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="reset", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ResetNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object reset(PContextVar self, PContextVarsToken token, @Bind Node inliningTarget, @Bind PythonContext pythonContext, @Cached.Shared @Cached PRaiseNode raise) {
            if (self == token.getVar()) {
                token.use(inliningTarget, raise);
                PythonContext.PythonThreadState threadState = pythonContext.getThreadState(pythonContext.getLanguage(inliningTarget));
                if (token.getOldValue() == null) {
                    PContextVarsContext context = threadState.getContextVarsContext(inliningTarget);
                    context.contextVarValues = context.contextVarValues.without(self, self.getHash());
                } else {
                    self.setValue(inliningTarget, threadState, token.getOldValue());
                }
            } else {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TOKEN_FOR_DIFFERENT_CONTEXTVAR, token);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isToken(token)"})
        Object doError(PContextVar self, Object token, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raise) {
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_TOKEN_EXPECTED, token);
        }

        static boolean isToken(Object obj) {
            return obj instanceof PContextVarsToken;
        }
    }

    @Builtin(name="set", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object set(PContextVar self, Object value, @Bind Node inliningTarget, @Bind PythonContext context) {
            PythonLanguage language = context.getLanguage(inliningTarget);
            PythonContext.PythonThreadState threadState = context.getThreadState(language);
            Object oldValue = self.getValue(inliningTarget, threadState);
            self.setValue(inliningTarget, threadState, value);
            return PFactory.createContextVarsToken(language, self, oldValue);
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object get(PContextVar self, Object def, @Bind Node inliningTarget, @Cached InlinedConditionProfile defIsNoValueProfile, @Cached PRaiseNode raiseNode) {
            Object defValue = defIsNoValueProfile.profile(inliningTarget, PGuards.isNoValue(def)) ? PContextVar.NO_DEFAULT : def;
            PythonContext context = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage(inliningTarget));
            Object value = self.get(inliningTarget, threadState, defValue);
            if (value != null) {
                return value;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.LookupError);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="ContextVar", minNumOfPositionalArgs=2, parameterNames={"cls", "name", "default"})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class ContextVarNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ContextVarBuiltinsClinicProviders.ContextVarNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        protected static Object constructDef(Object cls, TruffleString name, Object def, @Bind Node inliningTarget, @Cached InlinedConditionProfile noValueProfile, @Bind PythonLanguage language) {
            if (noValueProfile.profile(inliningTarget, PGuards.isNoValue(def))) {
                def = PContextVar.NO_DEFAULT;
            }
            return PFactory.createContextVar(language, name, def);
        }
    }
}

