% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.R
\name{se0_ridge}
\alias{se0_ridge}
\title{Logistic ridge regression state evolution functions with no intercept}
\usage{
se0_ridge(mu, b, sigma, kappa, gamma, lambda, gh = NULL, prox_tol = 1e-10)
}
\arguments{
\item{mu}{aggregate bias parameter.}

\item{b}{parameter \code{b} in the state evolution functions.}

\item{sigma}{square root of the aggregate variance of the MDYPL
estimator.}

\item{kappa}{asymptotic ratio of columns/rows of the design
matrix. \code{kappa} should be in \verb{(0, 1)}.}

\item{gamma}{the square root of the limit of the variance of the
linear predictor.}

\item{lambda}{the shrinkage parameter of the logistic regression penalty
estimator. \code{lambda} should be in greater than zero.}

\item{gh}{A list with the Gauss-Hermite quadrature nodes and
weights, as returned from \code{statmod::gauss.quad()} with \code{kind = "hermite"}. Default is \code{NULL}, in which case \code{gh} is set to
\code{statmod::gauss.quad(200, kind = "hermite")} is used.}

\item{prox_tol}{tolerance for the computation of the proximal
operator; default is \code{1e-10}.}
}
\description{
Logistic ridge regression state evolution functions with no intercept
}
\details{
It is assumed that the ridge penalty to the logistic regression
log-likelihood is \code{n * lambda * sum(beta^2) / (2 * length(beta))},
where \code{n} is the sum of the binomial totals.
}
