---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, images, Postscript,
              convertir du PostScript en PostScript encapsulé, 
              encapsuler du PostScript, convertir de l'EPS en PS
---

# Comment passer d'un format PS à EPS ?

## Quelle est la différence entre ces deux formats ?

Un fichier PS (dont le nom se termine généralement par l'extension `.ps`) est 
un document (texte et images) codé en PostScript. [PostScript](wpfr:PostScript)
lui-même est un "langage de description de page", adapté pour décrire où sont
placés des objets sur une page : éléments de dessins, caractères, images, etc.

Un fichier EPS est au format PostScript *encapsulé*, c'est à dire qu'il a été
conçu pour être inclus dans un autre document. D'où deux différences 
importantes avec un fichier PS, autrement dit au format PS :

- un fichier EPS contient au plus une page. Afin d'être inclus 
  dans un autre document, il est important que sa taille soit précisément 
  et facilement accessible. Elle doit donc être indiquée en début 
  de fichier, sur une ligne commençant par `%%BoundingBox:`, 
  suivie des deux coordonnées du coin inférieur gauche, et des dimensions 
  de la figure (c'est d'ailleurs la seule chose   qui soit obligatoire 
  dans un fichier EPS) ;
- un fichier EPS ne contient pas la commande PostScript `\showpage`. 
  Cette commande indique en effet à l'interpréteur PS d'afficher 
  la page courante. Si cette commande est incluse, l'interpréteur PS
  va afficher la page juste après avoir lu le fichier EPS, donc probablement
  avant la fin de la page du document englobant.


## Comment convertir l'un en l'autre ?

Pour convertir un fichier PS en EPS, il convient donc, essentiellement :

- de calculer assez précisément les dimensions de la figure PS et d'ajouter 
  la ligne `%%BoundingBox:` ;
- de désactiver la commande `\showpage`.

De nombreux outils permettent de faire cette conversion de manière automatique.
L'outil spécialisé le plus connu est [ghostscript](wpfr:Ghostscript). 
Par exemple, la ligne de commande suivante réalisera la conversion 
de `fig.ps` en `fig.eps` :

```bash
gs -sDEVICE=epswrite -sOutputFile=fig.eps -q -dNOPAUSE -dBATCH -dSAFER fig.ps
```

Il existe également des programmes `ps2epsi` et `pstoeps` 
(et toutes les variantes possibles sur ces noms...) qui font automatiquement
ces conversions.

La conversion inverse (EPS vers PS) n'a généralement pas besoin d'être faite : 
un fichier EPS est avant tout un fichier PS tout à fait valide. Si l'absence 
de commande `\showpage` pose problème, vous pouvez utiliser LaTeX pour inclure
le fichier EPS, nommé ici `image.eps` dans un document PS, grâce au document
suivant (il faudra le compiler ce document en un document PS avec LaTeX et
`dvips`).

```{noedit}
\documentclass{standalone}
  \usepackage{graphicx}

\begin{document}
\includegraphics{image.eps}
\end{document}
```