# Microsoft.NET.Build.Containers 7.0.400

This version brings the following new features and enhancements:

* For WebSdk projects (and any project that includes the `Microsoft.NET.Publish.Sdk` SDK), the container tools are included and available by default! This means that you no longer need to set the `EnableSdkContainerSupport` property in your project files or include the `Microsoft.NET.Build.Containers` package in your projects in order to publish containers. For project types that do not include the Publish SDK (like console or webjob projects), you still must add the `Microsoft.NET.Build.Containers` NuGet package as a PackageReference to your project, and publish using the `/t:PublishContainer` target explicitly.
* When targeting `net8.0` TargetFrameworks during preview release time frames, the inferred preview image will be more correct. Previously it could get out of sync with the actual image tagging scheme used by the dotnet-docker team.
* The layer upload process was massively refactored. This resulted in more performance, more reliability, and better support for more kinds of registries. As part of this, we now try the following upload algorithm for a layer:
    * Try to upload the whole layer in one compressed payload
    * If that fails, try to upload in chunks
    * When uploading chunks, we look for indicators from the registry to choose the chunk size

    In addition, we fixed some protocol bugs that blocked usage with registries like Harbor.
* Several environment variables were added to allow more explicit control over the layer upload process:
    * SDK_CONTAINER_REGISTRY_PARALLEL_UPLOAD
        * determines if layers of the generated image can be uploaded in parallel or in series.
        * defaults to `true` for all registries except AWS ECR
    * SDK_CONTAINER_DEBUG_REGISTRY_FORCE_CHUNKED_UPLOAD
        * if set to `true`, we will always try to upload layers in chunks instead of all in one upload.
        * defaults to `false`.
    * SDK_CONTAINER_REGISTRY_CHUNKED_UPLOAD_SIZE_BYTES
        * allows for explicit control over the size of the chunks uploaded when using chunked uploads.
        * note that by default we prefer atomic uploads, so setting this might not have any impact if your registry supports atomic uploads.
        * does not have a default, but the default chunk size is 64Kb.
* Naming is important, so we've renamed the `ContainerImageName` property to `ContainerRepository`. Repository is the name used for the user-facing image (for example `dotnet/runtime`), and it's used this way in most container documentation, so we've adopted that naming to make it easier to keep the terminology aligned. We still handle `ContainerImageName`, but we now will emit a validation warning during the publish if that property is used.
* The default OS for inferred containers is now `linux` instead of `windows`. Windows container usage is much less than Linux container usage, and we should default to the most likely configuration to make the onbaording story for the tooling easier. You can always control this explicitly by publishing for a specific `RuntimeIdentifier` (via the `-r` parameter or the `RuntimeIdentifier` MSBuild property) or setting the `ContainerRuntimeIdentifier` to a valid runtime identifier value.
* We added read support for OCI Container manifests. Practically speaking this means that you can now use base images from registries like Quay.io, Artifactory, and Docker Hub that typically send image manifests in this format instead of the older Docker-based format.
