// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//**********************************************************************`
//* This is an include file generated by Message Compiler.             *`
//*                                                                    *`
//*
//**********************************************************************`
#pragma once
#include <wmistr.h>
#include <evntrace.h>
#include "evntprov.h"
//
//  Initial Defs
//
#if !defined(ETW_INLINE)
#define ETW_INLINE DECLSPEC_NOINLINE __inline
#endif

#if defined(__cplusplus)
extern "C" {
#endif

//
// Allow Diasabling of code generation
//
#ifndef MCGEN_DISABLE_PROVIDER_CODE_GENERATION
#if  !defined(McGenDebug)
#define McGenDebug(a,b)
#endif 


#if !defined(MCGEN_TRACE_CONTEXT_DEF)
#define MCGEN_TRACE_CONTEXT_DEF
typedef struct _MCGEN_TRACE_CONTEXT
{
    TRACEHANDLE            RegistrationHandle;
    TRACEHANDLE            Logger;
    ULONGLONG              MatchAnyKeyword;
    ULONGLONG              MatchAllKeyword;
    ULONG                  Flags;
    ULONG                  IsEnabled;
    UCHAR                  Level; 
    UCHAR                  Reserve;
    USHORT                 EnableBitsCount;
    PULONG                 EnableBitMask;
    const ULONGLONG*       EnableKeyWords;
    const UCHAR*           EnableLevel;
} MCGEN_TRACE_CONTEXT, *PMCGEN_TRACE_CONTEXT;
#endif

//**********************************************************************
//
// Vista Down level Support 
//
//**********************************************************************

#define __WARNING_BANNED_LEGACY_INSTRUMENTATION_API_USAGE 28735

typedef
ULONG
(__stdcall *PFN_EVENT_WRITE)(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR EventDescriptor,
    _In_ ULONG UserDataCount,
    _In_reads_opt_(UserDataCount) PEVENT_DATA_DESCRIPTOR UserData
    );


typedef
ULONG
(__stdcall *PFN_EVENT_REGISTER)(
    _In_ LPCGUID ProviderId,
    _In_opt_ PENABLECALLBACK EnableCallback,
    _In_opt_ PVOID CallbackContext,
    _Out_ PREGHANDLE RegHandle
    );

typedef
ULONG
(__stdcall *PFN_EVENT_UNREGISTER)(
    _In_ REGHANDLE RegHandle
    );

typedef
BOOLEAN
(__stdcall *PFN_EVENT_ENABLED)(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR EventDescriptor
    );

ULONG __stdcall
McGenEventTracingRegister(
    _In_ LPCGUID ProviderId,
    _In_opt_ PENABLECALLBACK EnableCallback,
    _In_opt_ PVOID CallbackContext,
    _Inout_ PREGHANDLE RegHandle
    );

ULONG __stdcall
McGenEventTracingUnregister(_In_ PREGHANDLE RegHandle);

BOOLEAN __stdcall
McGenEventTracingEnabled(
    _In_ PMCGEN_TRACE_CONTEXT EnableInfo,
    _In_ PCEVENT_DESCRIPTOR EventDescriptor
    );

BOOLEAN __stdcall
McGenLevelKeywordEnabled(
    _In_ PMCGEN_TRACE_CONTEXT EnableInfo,
    _In_ UCHAR Level,
    _In_ ULONGLONG Keyword
    );

#if !defined(MCGEN_TRACE_GLOBALS_DEF)
#define MCGEN_TRACE_GLOBALS_DEF
__declspec(selectany) BOOLEAN McGenTracingSupportInit = FALSE;
__declspec(selectany) BOOLEAN McGenPreVista = FALSE;


#pragma prefast(suppress:__WARNING_ENCODE_GLOBAL_FUNCTION_POINTER, "this pointer can not be encoded");
__declspec(selectany) PFN_EVENT_WRITE  PfnEventWrite = NULL;

#pragma prefast(suppress:__WARNING_ENCODE_GLOBAL_FUNCTION_POINTER, "this pointer can not be encoded");
__declspec(selectany) PFN_EVENT_REGISTER  PfnEventRegister = McGenEventTracingRegister;

#pragma prefast(suppress:__WARNING_ENCODE_GLOBAL_FUNCTION_POINTER, "this pointer can not be encoded");
__declspec(selectany) PFN_EVENT_UNREGISTER PfnEventUnregister = NULL;
#endif



#if !defined(MCGEN_CONTROL_CALLBACK)
#define MCGEN_CONTROL_CALLBACK

DECLSPEC_NOINLINE __inline
ULONG __stdcall
McGenControlCallback(
    _In_ WMIDPREQUESTCODE RequestCode,
    _In_ PVOID Context,
    _Inout_ ULONG *InOutBufferSize,
    _Inout_ PVOID Buffer
    )
/*++

Routine Description:

    This is the notification callback for Pre Vista support.

Arguments:

Remarks:

    ETW calls this function to notify provider of enable/disable

--*/
{
    PMCGEN_TRACE_CONTEXT Ctx = (PMCGEN_TRACE_CONTEXT)Context;
    TRACEHANDLE Logger;
    ULONG Flags;
    ULONG IsEnabled = 0;
    UCHAR Level;
    ULONG Ix;

    *InOutBufferSize = 0;

    switch (RequestCode) {


        case WMI_ENABLE_EVENTS:
            {
                Logger = GetTraceLoggerHandle( Buffer );
                Level = GetTraceEnableLevel(Logger);
                Flags = GetTraceEnableFlags(Logger);
                IsEnabled = 1;

                McGenDebug(1, ("[Callback] WMI_ENABLE_EVENTS Ctx %p Flags %x"
                         " Lev %d Logger %I64x\n",
                         Ctx, Flags, Level, Logger) );

                //
                // 0 for flags is considered "ALL"
                //
                if (Flags == 0) {
                    Flags = 0xFFFFFFFF;
                }

                break;
            }
        case WMI_DISABLE_EVENTS:
            {
                Logger = 0;
                Flags  = 0;
                Level  = 0;
                if (Ctx->EnableBitsCount > 0) {
                    RtlZeroMemory(Ctx->EnableBitMask, (((Ctx->EnableBitsCount - 1) / 32) + 1) * sizeof(ULONG));
                }
                McGenDebug(1, ("[Callback] WMI_DISABLE_EVENTS Ctx 0x%08p\n", Ctx));
                break;
            }
        default:
            {
                return(ERROR_INVALID_PARAMETER);
            }
        }
    
    Ctx->Logger   = Logger;
    Ctx->Level    = Level;
    Ctx->Flags    = Flags;
    Ctx->IsEnabled = IsEnabled;

    for (Ix = 0; Ix < Ctx->EnableBitsCount; Ix += 1) {
        if (McGenLevelKeywordEnabled(Ctx, Ctx->EnableLevel[Ix], Ctx->EnableKeyWords[Ix]) != FALSE) {
            Ctx->EnableBitMask[Ix >> 5] |= (1 << (Ix % 32));
        } else {
            Ctx->EnableBitMask[Ix >> 5] &= ~(1 << (Ix % 32));
        }
    }
        

#ifdef MCGEN_PRIVATE_ENABLE_CALLBACK
    //
    // Call user defined callback down-level
    //
    MCGEN_PRIVATE_ENABLE_CALLBACK(
        RequestCode,
        Context,
        InOutBufferSize,
        Buffer
        );
#endif
   
    return(ERROR_SUCCESS);
}

DECLSPEC_NOINLINE __inline
VOID
__stdcall
McGenControlCallbackV2(
    _In_ LPCGUID SourceId,
    _In_ ULONG ControlCode,
    _In_ UCHAR Level,
    _In_ ULONGLONG MatchAnyKeyword,
    _In_ ULONGLONG MatchAllKeyword,
    _In_opt_ PEVENT_FILTER_DESCRIPTOR FilterData,
    _Inout_opt_ PVOID CallbackContext
    )
/*++

Routine Description:

    This is the notification callback for Vista.

Arguments:

    SourceId - The GUID that identifies the session that enabled the provider. 

    ControlCode - The parameter indicates whether the provider 
                  is being enabled or disabled.

    Level - The level at which the event is enabled.

    MatchAnyKeyword - The bitmask of keywords that the provider uses to 
                      determine the category of events that it writes.

    MatchAllKeyword - This bitmask additionally restricts the category 
                      of events that the provider writes. 

    FilterData - The provider-defined data.

    CallbackContext - The context of the callback that is defined when the provider 
                      called EtwRegister to register itself.

Remarks:

    ETW calls this function to notify provider of enable/disable

--*/
{
    PMCGEN_TRACE_CONTEXT Ctx = (PMCGEN_TRACE_CONTEXT)CallbackContext;
    ULONG Ix;
#ifndef MCGEN_PRIVATE_ENABLE_CALLBACK_V2
    UNREFERENCED_PARAMETER(SourceId);
    UNREFERENCED_PARAMETER(FilterData);
#endif

    if (Ctx == NULL) {
        return;
    }

    switch (ControlCode) {

        case EVENT_CONTROL_CODE_ENABLE_PROVIDER:
            Ctx->Level = Level;
            Ctx->MatchAnyKeyword = MatchAnyKeyword;
            Ctx->MatchAllKeyword = MatchAllKeyword;
            Ctx->IsEnabled = EVENT_CONTROL_CODE_ENABLE_PROVIDER;

            for (Ix = 0; Ix < Ctx->EnableBitsCount; Ix += 1) {
                if (McGenLevelKeywordEnabled(Ctx, Ctx->EnableLevel[Ix], Ctx->EnableKeyWords[Ix]) != FALSE) {
                    Ctx->EnableBitMask[Ix >> 5] |= (1 << (Ix % 32));
                } else {
                    Ctx->EnableBitMask[Ix >> 5] &= ~(1 << (Ix % 32));
                }
            }
            break;

        case EVENT_CONTROL_CODE_DISABLE_PROVIDER:
            Ctx->IsEnabled = EVENT_CONTROL_CODE_DISABLE_PROVIDER;
            Ctx->Level = 0;
            Ctx->MatchAnyKeyword = 0;
            Ctx->MatchAllKeyword = 0;
            if (Ctx->EnableBitsCount > 0) {
                RtlZeroMemory(Ctx->EnableBitMask, (((Ctx->EnableBitsCount - 1) / 32) + 1) * sizeof(ULONG));
            }
            break;
 
        default:
            break;
    }

#ifdef MCGEN_PRIVATE_ENABLE_CALLBACK_V2
    //
    // Call user defined callback
    //
    MCGEN_PRIVATE_ENABLE_CALLBACK_V2(
        SourceId,
        ControlCode,
        Level,
        MatchAnyKeyword,
        MatchAllKeyword,
        FilterData,
        CallbackContext
        );
#endif
   
    return;
}

#endif

#define MANIFEST_MAX_MOF_FIELDS_SUPPORTED 16

VOID McGenInitTracingSupport(
    VOID
    );
#if !defined(McGenEventRegisterUnregister)
#define McGenEventRegisterUnregister
#pragma warning(push)
#pragma warning(disable:4068)
FORCEINLINE
ULONG __stdcall
McGenEventTracingRegister(
    _In_ LPCGUID ProviderId,
    _In_opt_ PENABLECALLBACK EnableCallback,
    _In_opt_ PVOID CallbackContext,
    _Inout_ PREGHANDLE RegHandle
    )
/*++

Routine Description:

    This function register the provider with ETW and handles OS version.

Arguments:
    ProviderId      - Provider Id to be register with ETW
    EnableCallback  - Callback to be used: 
                      Vista : McGenControlCallbackV2
                      down-level : McGenControlCallback
    CallbackContext - Context for this provider is PMCGEN_TRACE_CONTEXT
    RegHandle       - down-level is a pointer to PMCGEN_TRACE_CONTEXT

Remarks:

    Register with ETW Vista down-level, and set the RegHandle as a pointer to
    PMCGEN_TRACE_CONTEXT for this provider. For Vista registers the provider.

--*/
{
    ULONG Error = ERROR_SUCCESS;

    if(!RegHandle) {
        return ERROR_INVALID_PARAMETER;
    }

    if(*RegHandle) {
        //
        // already registered, ignore this one
        //
        goto Cleanup;
    }

    //
    // Initialize Tracing funtion pointers according to OS version
    //
    McGenInitTracingSupport();

    //
    // Vista
    //
    if(!McGenPreVista ){
        Error = PfnEventRegister(ProviderId, 
                                 (EnableCallback == NULL) ? McGenControlCallbackV2 : EnableCallback,
                                 CallbackContext,
                                 RegHandle);
    } else {
        //
        // down-level : XP/W2K3
        //
        PMCGEN_TRACE_CONTEXT Context = (PMCGEN_TRACE_CONTEXT)CallbackContext;
        TRACE_GUID_REGISTRATION TraceRegistration;
        
        if(CallbackContext == NULL) {
            Error =  ERROR_INVALID_PARAMETER;
            goto Cleanup;
        }

        *RegHandle = (REGHANDLE)CallbackContext;

        TraceRegistration.Guid = ProviderId;
        TraceRegistration.RegHandle = 0;
 
#pragma prefast(suppress:__WARNING_BANNED_LEGACY_INSTRUMENTATION_API_USAGE, "Generated Code Down-Level Support");
        Error = RegisterTraceGuids((EnableCallback == NULL) ? McGenControlCallback : (WMIDPREQUEST)EnableCallback,
                                    CallbackContext,
                                    ProviderId,
                                    1,
                                    &TraceRegistration,
                                    0, 
                                    0, 
                                    &Context->RegistrationHandle);
    }

Cleanup:
    return Error;
}


FORCEINLINE
ULONG __stdcall
McGenEventTracingUnregister(_In_ PREGHANDLE RegHandle)
/*++

Routine Description:

    Unregister from ETW.

Arguments:
            RegHandle is the pointer to the provider context down-level
Remarks:

    Unregister provider and disables provider context

--*/
{
    ULONG Error = ERROR_SUCCESS;

    if(!RegHandle) {
        return ERROR_INVALID_PARAMETER;
    }

    if (!McGenTracingSupportInit){
        //
        // EventRegistermanifestmacro has not been called
        //
        return ERROR_SUCCESS;
    }

    if(!(*RegHandle)) {
        //
        // Provider has not registerd
        //
        return ERROR_SUCCESS;
    }


    //
    // Vista
    //
    if(!McGenPreVista ){
        Error = PfnEventUnregister(*RegHandle);
    } else {
        //
        // down-level : XP/W2K3
        //
        PMCGEN_TRACE_CONTEXT Context = (PMCGEN_TRACE_CONTEXT)(ULONG_PTR)(*RegHandle);

#pragma prefast(suppress:__WARNING_BANNED_LEGACY_INSTRUMENTATION_API_USAGE, "Generated Code Down-Level Support");
        Error = UnregisterTraceGuids(Context->RegistrationHandle);

        Context->Flags = 0;
        Context->Level = 0;
        Context->Logger = 0;
        if (Context->EnableBitsCount > 0) {
            RtlZeroMemory(Context->EnableBitMask, (((Context->EnableBitsCount - 1) / 32) + 1) * sizeof(ULONG));
        }
        Context->RegistrationHandle = 0;
    }

    *RegHandle = (REGHANDLE)0;
    
    return Error;    
}
#pragma warning(pop)
#endif

#if !defined(McGenEventEnabledCheck)
#define McGenEventEnabledCheck
FORCEINLINE 
BOOLEAN __stdcall
McGenLevelKeywordEnabled(
    _In_ PMCGEN_TRACE_CONTEXT EnableInfo,
    _In_ UCHAR Level,
    _In_ ULONGLONG Keyword
    )
{

    if(!EnableInfo){
        return FALSE;
    }


    if(McGenPreVista){

      return ( ((Level <= EnableInfo->Level) || (EnableInfo->Level == 0)) &&
               (((ULONG)(Keyword & 0xFFFFFFFF) == 0) || ((ULONG)(Keyword & 0xFFFFFFFF) & EnableInfo->Flags)));
    }
    //
    // Check if the event Level is lower than the level at which
    // the channel is enabled.
    // If the event Level is 0 or the channel is enabled at level 0,
    // all levels are enabled.
    //

    if ((Level <= EnableInfo->Level) || // This also covers the case of Level == 0.
        (EnableInfo->Level == 0)) {

        //
        // Check if Keyword is enabled
        //

        if ((Keyword == (ULONGLONG)0) ||
            ((Keyword & EnableInfo->MatchAnyKeyword) &&
             ((Keyword & EnableInfo->MatchAllKeyword) == EnableInfo->MatchAllKeyword))) {
            return TRUE;
        }
    }

    return FALSE;
}


FORCEINLINE 
BOOLEAN __stdcall
McGenEventTracingEnabled(
    _In_ PMCGEN_TRACE_CONTEXT EnableInfo,
    _In_ PCEVENT_DESCRIPTOR EventDescriptor
    )
{

    return McGenLevelKeywordEnabled(EnableInfo, EventDescriptor->Level, EventDescriptor->Keyword);
}
#endif


#if !defined(MCGEN_TRACING_DLL)
#define MCGEN_TRACING_DLL L"advapi32.dll"
#endif
#if !defined(MCGEN_TRACING_DLL_V2)
#define MCGEN_TRACING_DLL_V2 L"api-ms-win-eventing-provider-l1-1-0.dll"
#endif
#if !defined(MCGEN_EVENTWRITE_API)
#define MCGEN_EVENTWRITE_API  "EventWrite"
#endif
#if !defined(MCGEN_EVENTREGISTER_API)
#define MCGEN_EVENTREGISTER_API   "EventRegister"
#endif
#if !defined(MCGEN_EVENTUNREGISTER_API)
#define MCGEN_EVENTUNREGISTER_API "EventUnregister"
#endif

#if !defined(McGenInitTracingSupportFunc)
#define McGenInitTracingSupportFunc
FORCEINLINE
VOID McGenInitTracingSupport(
    VOID
    )
/*++

Routine Description:

    This function assigns at runtime the ETW API set to be use for tracing.

Arguments:

Remarks:

    At runtime assign the functions pointers for the trace APIs to be use.
    Vista use WriteEVent, else TraceEvent

--*/
{
    OSVERSIONINFO OSVersion;
    HINSTANCE TraceApiDll = NULL;
    BOOL OkVersion;
    BOOL IsWin8OrLater = FALSE;

    if (McGenTracingSupportInit){
        return;
    }

    
    OSVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    

    OkVersion = GetVersionEx(&OSVersion);
    
    if (OkVersion) {

        McGenPreVista = (OSVersion.dwMajorVersion < 6);
        IsWin8OrLater = (OSVersion.dwMajorVersion > 6) || ((OSVersion.dwMajorVersion == 6) && (OSVersion.dwMinorVersion > 1));

        if (McGenPreVista) {

            goto done;

        }
        
    } 


    TraceApiDll = GetModuleHandleW(MCGEN_TRACING_DLL);
    if ((TraceApiDll == NULL) && (IsWin8OrLater != FALSE)) {
        TraceApiDll = GetModuleHandleW(MCGEN_TRACING_DLL_V2);
    }
    
    if (TraceApiDll != NULL)
    {
        PfnEventWrite = (PFN_EVENT_WRITE)GetProcAddress(TraceApiDll, MCGEN_EVENTWRITE_API);

        if (NULL == PfnEventWrite) {

            if (OkVersion) {
                McGenDebug(1, ("[McGenInitTracing] Failed to load EventWrite, using PreVista ETW \n"));
            }
            
            McGenPreVista = TRUE;
            goto done;

        } 

        PfnEventRegister = (PFN_EVENT_REGISTER) GetProcAddress(TraceApiDll, MCGEN_EVENTREGISTER_API);
        
        if (NULL == PfnEventRegister) {
            McGenDebug(1, ("[McGenInitTracing] Failed to load EventRegister, using PreVista ETW \n"));
            PfnEventRegister =  McGenEventTracingRegister;
            McGenPreVista = TRUE;
            goto done;

        }

        PfnEventUnregister = (PFN_EVENT_UNREGISTER) GetProcAddress(TraceApiDll, MCGEN_EVENTUNREGISTER_API);
        
        if (NULL == PfnEventUnregister) {
            McGenDebug(1, ("[McGenInitTracing] Failed to load EventUnregister, using PreVista ETW \n"));
            PfnEventRegister = McGenEventTracingRegister;
            McGenPreVista = TRUE;
            goto done;
       }

    } else {
    
        McGenDebug(1, ("[McGenInitTracing] Failed to load %ws, using PreVista ETW \n", MCGEN_TRACING_DLL));
        McGenPreVista = TRUE;

    }

done:
    
    McGenDebug(1, ("[McGenInitTracing] Prevista %s \n", McGenPreVista ? "TRUE" : "FALSE" ));
    McGenTracingSupportInit = TRUE;
}
#endif
#endif // MCGEN_DISABLE_PROVIDER_CODE_GENERATION

//
// EnableCheckMacro
//
#ifndef MCGEN_ENABLE_CHECK
#define MCGEN_ENABLE_CHECK(Context, Descriptor) (Context.IsEnabled &&  McGenEventTracingEnabled(&Context, &Descriptor))
#endif

//+
// Provider Microsoft-Windows-WPF Event Count 333
//+
EXTERN_C __declspec(selectany) const GUID MICROSOFT_WINDOWS_WPF_PROVIDER = {0xe13b77a8, 0x14b6, 0x11de, {0x80, 0x69, 0x00, 0x1b, 0x21, 0x2b, 0x50, 0x09}};

//
// Channel
//
#define MICROSOFT_WINDOWS_WPF_PROVIDER_DEFAULT_CHANNEL 0x10

//
// Levels
//
#define PERF 0x10
#define PERF_LOW 0x11
#define PERF_MED 0x12
#define PERF_HIGH 0x13

//
// Opcodes
//
#define OP_BITMAPSTART 0x38
#define OP_BITMAPEND 0x39
#define OP_RECTANGLESTART 0x3a
#define OP_RECTANGLEEND 0x3b
#define OP_GEOMETRYSTART 0x3c
#define OP_GEOMETRYEND 0x3d
#define OP_IMAGESTART 0x3e
#define OP_IMAGEEND 0x3f
#define OP_GLYPHRUNSTART 0x40
#define OP_GLYPHRUNEND 0x41
#define OP_BEGINLAYERSTART 0x44
#define OP_BEGINLAYEREND 0x45
#define OP_ENDLAYERSTART 0x46
#define OP_ENDLAYEREND 0x47
#define OP_CLIPPEDBITMAPSTART 0x4e
#define OP_CLIPPEDBITMAPEND 0x4f
#define OP_LAYOUT_ABORT 0xa
#define OP_SIZE_CHANGED 0xb
#define OP_SIZE_CHANGED_END 0xc
#define OP_FIRE_LAYOUT_UPDATED_START 0xd
#define OP_FIRE_LAYOUT_UPDATED_STOP 0xe
#define OP_FIRE_AUTOMATION_EVENTS 0xf
#define OP_FIRE_AUTOMATION_EVENTS_END 0x10
#define OP_LAYOUT_EXCEPTION 0x11
#define OP_LAYOUT_INVALIDATED 0x12
#define OP_MEASURE_ABORT 0xa
#define OP_MEASURE_ELEMENT_BEGIN 0xb
#define OP_MEASURE_ELEMENT_END 0xc
#define OP_ARRANGE_ABORT 0xa
#define OP_ARRANGE_ELEMENT_BEGIN 0xb
#define OP_ARRANGE_ELEMENT_END 0xc
#define WINMAINSTART 0x1e
#define WINMAINEND 0x1f
#define INVOKINGBROWSER 0x20
#define LAUNCHINGRESTRICTEDPROCESS 0x21
#define ENTERINGMESSAGELOOP 0x22
#define CLASSFACTORYCREATEINSTANCE 0x23
#define READINGDEPLMANIFESTSTART 0x28
#define READINGDEPLMANIFESTEND 0x29
#define READINGAPPMANIFESTSTART 0x2a
#define READINGAPPMANIFESTEND 0x2b
#define PARSINGMARKUPVERSIONSTART 0x2c
#define PARSINGMARKUPVERSIONEND 0x2d
#define IPERSISTFILELOAD 0x32
#define IPERSISTMONIKERLOADSTART 0x33
#define IPERSISTMONIKERLOADEND 0x34
#define BINDPROGRESS 0x35
#define ONSTOPBINDING 0x36
#define VERSIONATTACH 0x3c
#define VERSIONACTIVATESTART 0x3d
#define VERSIONACTIVATEEND 0x3e
#define STARTINGCLRSTART 0x5a
#define STARTINGCLREND 0x5b
#define IHLINKTARGETNAVIGATESTART 0x5f
#define IHLINKTARGETNAVIGATEEND 0x60
#define READYSTATECHANGED 0x61
#define INITDOCHOSTSTART 0x62
#define INITDOCHOSTEND 0x63
#define MERGINGMENUSSTART 0x64
#define MERGINGMENUSEND 0x65
#define UIACTIVATIONSTART 0x66
#define UIACTIVATIONEND 0x67
#define LOADINGRESOURCEDLLSTART 0x68
#define LOADINGRESOURCEDLLEND 0x69
#define OLECMDQUERYSTATUSSTART 0x6a
#define OLECMDQUERYSTATUSEND 0x6b
#define OLECMDEXECSTART 0x6c
#define OLECMDEXECEND 0x6d
#define PROGRESSPAGESHOWN 0x6e
#define ADHOCPROFILE1START 0x98
#define ADHOCPROFILE1END 0x99
#define ADHOCPROFILE2START 0x9a
#define ADHOCPROFILE2END 0x9b
#define DOCOBJHOSTCREATED 0xa
#define IBHSRUNSTART 0xb
#define IBHSRUNEND 0xc
#define XAPPLAUNCHERAPPSTARTUP 0xd
#define XAPPLAUNCHERAPPEXIT 0xe
#define DOCOBJHOSTRUNAPPLICATIONSTART 0xf
#define DOCOBJHOSTRUNAPPLICATIONEND 0x10
#define CLICKONCEACTIVATIONSTART 0x11
#define CLICKONCEACTIVATIONEND 0x12
#define INITAPPPROXYSTART 0x13
#define INITAPPPROXYEND 0x14
#define APPPROXYCTOR 0x1e
#define ROOTBROWSERWINDOWSETUPSTART 0x1f
#define ROOTBROWSERWINDOWSETUPEND 0x20
#define APPPROXYRUNSTART 0x21
#define APPPROXYRUNEND 0x22
#define APPDOMAINMANAGERCCTOR 0x28
#define APPLICATIONACTIVATORCREATEINSTANCESTART 0x29
#define APPLICATIONACTIVATORCREATEINSTANCEEND 0x2a
#define DETERMINEAPPLICATIONTRUSTSTART 0x2b
#define DETERMINEAPPLICATIONTRUSTEND 0x2c
#define FIRSTTIMEACTIVATION 0x32
#define GETDOWNLOADPAGESTART 0x33
#define GETDOWNLOADPAGEEND 0x34
#define DOWNLOADDEPLMANIFESTSTART 0x35
#define DOWNLOADDEPLMANIFESTEND 0x36
#define ASSERTAPPREQUIREMENTSSTART 0x37
#define ASSERTAPPREQUIREMENTSEND 0x38
#define DOWNLOADAPPLICATIONSTART 0x39
#define DOWNLOADAPPLICATIONEND 0x3a
#define DOWNLOADPROGRESSUPDATE 0x3b
#define XAPPLAUNCHERAPPNAVIGATED 0x3c
#define UPDATEBROWSERCOMMANDSSTART 0x46
#define UPDATEBROWSERCOMMANDSEND 0x47
#define POSTSHUTDOWN 0x50
#define ABORTINGACTIVATION 0x51
#define NAVIGATIONSTART 0xa
#define NAVIGATIONASYNCWORKITEM 0xb
#define NAVIGATIONWEBRESPONSERECEIVED 0xc
#define NAVIGATIONLAUNCHBROWSER 0xd
#define NAVIGATIONEND 0xe
#define NAVIGATIONCONTENTRENDERED 0xf
#define NAVIGATIONPAGEFUNCTIONRETURN 0x10
#define OP_WPF_ELEMENT_NAME 0xa

//
// Tasks
//
#define TDrawBitmap 0x1
EXTERN_C __declspec(selectany) const GUID DrawBitmapId = {0xa7f1ef9d, 0x9bb9, 0x4c7d, {0x93, 0xad, 0x11, 0x91, 0x9b, 0x12, 0x2f, 0xa2}};
#define TBitmapCopy 0x2
EXTERN_C __declspec(selectany) const GUID BitmapCopyId = {0x5c02c62f, 0xaec1, 0x4f0c, {0xb4, 0xa7, 0x51, 0x1d, 0x28, 0x01, 0x84, 0xfd}};
#define TSetClip 0x3
EXTERN_C __declspec(selectany) const GUID SetClipId = {0x6acaf5f0, 0xd340, 0x4373, {0xa8, 0x51, 0xfe, 0xa1, 0x26, 0x7a, 0xa2, 0x10}};
#define TDWMDraw_Clear 0x5
EXTERN_C __declspec(selectany) const GUID DWMDraw_ClearId = {0xc8960930, 0xbf29, 0x4c06, {0x85, 0x74, 0xd4, 0xbe, 0x80, 0x3f, 0x13, 0xf9}};
#define TDWMDraw_ 0x8
EXTERN_C __declspec(selectany) const GUID DWMDraw_Id = {0xc4e8f367, 0x3ba1, 0x4c75, {0xb9, 0x85, 0xfa, 0xcb, 0xb4, 0x27, 0x4d, 0xd7}};
#define TLayerEvent 0x9
EXTERN_C __declspec(selectany) const GUID LayerEventId = {0xead9a51b, 0xd3d3, 0x4b0b, {0x8d, 0x25, 0xe4, 0x91, 0x4e, 0xd4, 0xc1, 0xed}};
#define TWClientDesktopRTCreate 0xc
EXTERN_C __declspec(selectany) const GUID WClientDesktopRTCreateId = {0x2e62c3bf, 0x7c51, 0x43fb, {0x8c, 0xdc, 0x91, 0x5d, 0x4a, 0xbc, 0x09, 0xdd}};
#define TWClientUceProcessQueue 0xd
EXTERN_C __declspec(selectany) const GUID WClientUceProcessQueueId = {0xb7c7f692, 0xf2b4, 0x447a, {0xb5, 0xdf, 0xfa, 0x6c, 0x31, 0x48, 0x89, 0xae}};
#define TWClientUcePrecompute 0xe
EXTERN_C __declspec(selectany) const GUID WClientUcePrecomputeId = {0xde51ae60, 0x46ad, 0x4cc0, {0x9a, 0x29, 0x42, 0x6a, 0x87, 0xe8, 0x8e, 0x9f}};
#define TWClientUceRender 0xf
EXTERN_C __declspec(selectany) const GUID WClientUceRenderId = {0x92ca500c, 0x67b1, 0x447f, {0x94, 0x97, 0xcf, 0xd6, 0xd5, 0x2a, 0x5b, 0x0e}};
#define TWClientUcePresent 0x10
EXTERN_C __declspec(selectany) const GUID WClientUcePresentId = {0x4c48d6ef, 0xac14, 0x4d84, {0xba, 0x37, 0x49, 0xa9, 0x4b, 0xa8, 0xd2, 0xaf}};
#define TWClientUceResponse 0x11
EXTERN_C __declspec(selectany) const GUID WClientUceResponseId = {0x4c253b24, 0x7230, 0x4fa1, {0x97, 0x48, 0xac, 0x4c, 0x59, 0xcf, 0x28, 0x8c}};
#define TWClientUceCheckDeviceState 0x13
EXTERN_C __declspec(selectany) const GUID WClientUceCheckDeviceStateId = {0x76601d6d, 0xc6d4, 0x4e8d, {0xac, 0x6e, 0x3f, 0x9b, 0x4f, 0x17, 0x45, 0xe0}};
#define TWClientUIContextDispatch 0x14
EXTERN_C __declspec(selectany) const GUID WClientUIContextDispatchId = {0x2481a374, 0x999f, 0x4ad2, {0x9f, 0x22, 0x6b, 0x7c, 0x8e, 0x2a, 0x5d, 0xb0}};
#define TWClientUIContextPost 0x15
EXTERN_C __declspec(selectany) const GUID WClientUIContextPostId = {0x76287aef, 0xf674, 0x4061, {0xa6, 0x0a, 0x76, 0xf9, 0x55, 0x50, 0xef, 0xeb}};
#define TWClientUIContextAbort 0x16
EXTERN_C __declspec(selectany) const GUID WClientUIContextAbortId = {0x39404da9, 0x413f, 0x4581, {0xa0, 0xa1, 0x47, 0x15, 0x16, 0x8b, 0x5a, 0xd8}};
#define TWClientUIContextPromote 0x17
EXTERN_C __declspec(selectany) const GUID WClientUIContextPromoteId = {0x632d4e9e, 0xb988, 0x4b32, {0xab, 0x2a, 0xb3, 0x7a, 0xa3, 0x49, 0x27, 0xee}};
#define TWClientUIContextIdle 0x18
EXTERN_C __declspec(selectany) const GUID WClientUIContextIdleId = {0xc626ebef, 0x0780, 0x487f, {0x81, 0xd7, 0x38, 0xd3, 0xf0, 0xa6, 0xf0, 0x5e}};
#define TWClientLayout 0x19
EXTERN_C __declspec(selectany) const GUID WClientLayoutId = {0xa3edb710, 0x21fc, 0x4f91, {0x97, 0xf4, 0xac, 0x2b, 0x0d, 0xf1, 0xc2, 0x0f}};
#define TWClientMeasure 0x1a
EXTERN_C __declspec(selectany) const GUID WClientMeasureId = {0x3005e67b, 0x129c, 0x4ced, {0xbc, 0xaa, 0x91, 0xd7, 0xd7, 0x3b, 0x15, 0x44}};
#define TWClientArrange 0x1b
EXTERN_C __declspec(selectany) const GUID WClientArrangeId = {0x4b0ef3d1, 0x0cbb, 0x4847, {0xb9, 0x8f, 0x16, 0x40, 0x8e, 0x7e, 0x83, 0xf3}};
#define TWClientCreateVisual 0x1c
EXTERN_C __declspec(selectany) const GUID WClientCreateVisualId = {0x2dbecf62, 0x51ea, 0x493a, {0x8d, 0xd0, 0x4b, 0xee, 0x1c, 0xcb, 0xe8, 0xaa}};
#define TWClientInputMessage 0x1d
EXTERN_C __declspec(selectany) const GUID WClientInputMessageId = {0x4ac79bac, 0x7dfb, 0x4402, {0xa9, 0x10, 0xfd, 0xaf, 0xe1, 0x6f, 0x29, 0xb2}};
#define TWClientRenderHandler 0x1e
EXTERN_C __declspec(selectany) const GUID WClientRenderHandlerId = {0x7723d8b7, 0x488b, 0x4f80, {0xb0, 0x89, 0x46, 0xa4, 0xc6, 0xac, 0xa1, 0xc4}};
#define TWClientAnimRenderHandler 0x1f
EXTERN_C __declspec(selectany) const GUID WClientAnimRenderHandlerId = {0x521c1c8d, 0xfaaa, 0x435b, {0xad, 0x8c, 0x1d, 0x64, 0x44, 0x2b, 0xfd, 0x70}};
#define TWClientMediaRender 0x20
EXTERN_C __declspec(selectany) const GUID WClientMediaRenderId = {0x6827e447, 0x0e0e, 0x4b5e, {0xae, 0x81, 0xb7, 0x9a, 0x00, 0xec, 0x83, 0x49}};
#define TWClientPostRender 0x21
EXTERN_C __declspec(selectany) const GUID WClientPostRenderId = {0xfb69cd45, 0xc00d, 0x4c23, {0x97, 0x65, 0x69, 0xc0, 0x03, 0x44, 0xb2, 0xc5}};
#define TWClientQPCFrequency 0x22
EXTERN_C __declspec(selectany) const GUID WClientQPCFrequencyId = {0x30ee0097, 0x084c, 0x408b, {0x90, 0x38, 0x73, 0xbe, 0xd0, 0x47, 0x98, 0x73}};
#define TWClientPrecomputeScene 0x23
EXTERN_C __declspec(selectany) const GUID WClientPrecomputeSceneId = {0x3331420f, 0x7a3b, 0x42b6, {0x8d, 0xfe, 0xaa, 0xbf, 0x47, 0x28, 0x01, 0xda}};
#define TWClientCompileScene 0x24
EXTERN_C __declspec(selectany) const GUID WClientCompileSceneId = {0xaf36fcb5, 0x58e5, 0x48d0, {0x88, 0xd0, 0xd8, 0xf4, 0xdc, 0xb5, 0x6a, 0x12}};
#define TWClientUIResponse 0x25
EXTERN_C __declspec(selectany) const GUID WClientUIResponseId = {0xab29585b, 0x4794, 0x4465, {0x91, 0xe6, 0x9d, 0xf5, 0x86, 0x1c, 0x88, 0xc5}};
#define TWClientUICommitChannel 0x26
EXTERN_C __declspec(selectany) const GUID WClientUICommitChannelId = {0xf9c0372e, 0x60bd, 0x46c9, {0xbc, 0x64, 0x94, 0xfe, 0x5f, 0xd3, 0x1f, 0xe4}};
#define TWClientUceNotifyPresent 0x27
EXTERN_C __declspec(selectany) const GUID WClientUceNotifyPresentId = {0x24cd1476, 0xe145, 0x4e5a, {0x8b, 0xfc, 0x50, 0xc3, 0x6b, 0xbd, 0xf9, 0xcc}};
#define TWClientScheduleRender 0x28
EXTERN_C __declspec(selectany) const GUID WClientScheduleRenderId = {0x6d5aeaf3, 0xa433, 0x4daa, {0x8b, 0x31, 0xd8, 0xae, 0x49, 0xcf, 0x6b, 0xd1}};
#define TWClientParseBaml 0x29
EXTERN_C __declspec(selectany) const GUID WClientParseBamlId = {0x8a1e3af5, 0x3a6d, 0x4582, {0x86, 0xd1, 0x59, 0x01, 0x47, 0x1e, 0xbb, 0xde}};
#define TWClientParseXaml 0x2a
EXTERN_C __declspec(selectany) const GUID WClientParseXamlId = {0x3164257a, 0xc9be, 0x4c36, {0x9d, 0x8f, 0x09, 0xb1, 0x8a, 0xc8, 0x80, 0xa6}};
#define TWClientParseXml 0x2b
EXTERN_C __declspec(selectany) const GUID WClientParseXmlId = {0xbf86e5bf, 0x3fb4, 0x442f, {0xa3, 0x4a, 0xb2, 0x07, 0xa3, 0xb1, 0x9c, 0x3b}};
#define TWClientParseFefCrInst 0x2c
EXTERN_C __declspec(selectany) const GUID WClientParseFefCrInstId = {0xf7555161, 0x6c1a, 0x4a12, {0x82, 0x8d, 0x84, 0x92, 0xa7, 0x69, 0x9a, 0x49}};
#define TWClientParseInstVisTree 0x2d
EXTERN_C __declspec(selectany) const GUID WClientParseInstVisTreeId = {0xa8c3b9c0, 0x562b, 0x4509, {0xbe, 0xcb, 0xa0, 0x8e, 0x48, 0x1a, 0x72, 0x73}};
#define TWClientParseRdrCrInst 0x2e
EXTERN_C __declspec(selectany) const GUID WClientParseRdrCrInstId = {0x8ba8f51c, 0x0775, 0x4adf, {0x9e, 0xed, 0xb1, 0x65, 0x4c, 0xa0, 0x88, 0xf5}};
#define TWClientParseRdrCrInFTyp 0x2f
EXTERN_C __declspec(selectany) const GUID WClientParseRdrCrInFTypId = {0x0da15d58, 0xc3a7, 0x40de, {0x91, 0x13, 0x72, 0xdb, 0x0c, 0x4a, 0x93, 0x51}};
#define TWClientAppCtor 0x30
EXTERN_C __declspec(selectany) const GUID WClientAppCtorId = {0xf9f048c6, 0x2011, 0x4d0a, {0x81, 0x2a, 0x23, 0xa4, 0xa4, 0xd8, 0x01, 0xf5}};
#define TWClientAppRun 0x31
EXTERN_C __declspec(selectany) const GUID WClientAppRunId = {0x08a719d6, 0xea79, 0x4abc, {0x97, 0x99, 0x38, 0xed, 0xed, 0x60, 0x21, 0x33}};
#define TWClientTimeManagerTick 0x32
EXTERN_C __declspec(selectany) const GUID WClientTimeManagerTickId = {0xea3b4b66, 0xb25f, 0x4e5d, {0x8b, 0xd4, 0xec, 0x62, 0xbb, 0x44, 0x58, 0x3e}};
#define TWClientString 0x33
EXTERN_C __declspec(selectany) const GUID WClientStringId = {0x6b3c0258, 0x9ddb, 0x4579, {0x86, 0x60, 0x41, 0xc3, 0xad, 0xa2, 0x5c, 0x34}};
#define TWClientFontCache 0x34
EXTERN_C __declspec(selectany) const GUID WClientFontCacheId = {0xf3362106, 0xb861, 0x4980, {0x9a, 0xac, 0xb1, 0xef, 0x0b, 0xab, 0x75, 0xaa}};
#define TWClientDRXOpenPackage 0x35
EXTERN_C __declspec(selectany) const GUID WClientDRXOpenPackageId = {0x2b8f75f3, 0xf8f9, 0x4075, {0xb9, 0x14, 0x5a, 0xe8, 0x53, 0xc7, 0x62, 0x76}};
#define TWClientDRXReadStream 0x36
EXTERN_C __declspec(selectany) const GUID WClientDRXReadStreamId = {0xc2b15025, 0x7812, 0x4e44, {0x8b, 0x68, 0x7d, 0x73, 0x43, 0x03, 0x43, 0x8a}};
#define TWClientDRXGetStream 0x37
EXTERN_C __declspec(selectany) const GUID WClientDRXGetStreamId = {0x3f4510eb, 0x9ee8, 0x4b80, {0x9e, 0xc7, 0x77, 0x5e, 0xfe, 0xb1, 0xba, 0x72}};
#define TWClientDRXPageVisible 0x38
EXTERN_C __declspec(selectany) const GUID WClientDRXPageVisibleId = {0x2ae7c601, 0x0aec, 0x4c99, {0xba, 0x80, 0x2e, 0xca, 0x71, 0x2d, 0x1b, 0x97}};
#define TWClientDRXPageLoaded 0x39
EXTERN_C __declspec(selectany) const GUID WClientDRXPageLoadedId = {0x66028645, 0xe022, 0x4d90, {0xa7, 0xbd, 0xa8, 0xcc, 0xda, 0xcd, 0xb2, 0xe1}};
#define TWClientDRXInvalidateView 0x3a
EXTERN_C __declspec(selectany) const GUID WClientDRXInvalidateViewId = {0x3be3740f, 0x0a31, 0x4d22, {0xa2, 0xa3, 0x4d, 0x4b, 0x6d, 0x3a, 0xb8, 0x99}};
#define TWClientDRXLineDown 0x3b
EXTERN_C __declspec(selectany) const GUID WClientDRXLineDownId = {0xb67ab12c, 0x29bf, 0x4020, {0xb6, 0x78, 0xf0, 0x43, 0x92, 0x5b, 0x82, 0x35}};
#define TWClientDRXPageDown 0x3c
EXTERN_C __declspec(selectany) const GUID WClientDRXPageDownId = {0xd7cdeb52, 0x5ba3, 0x4e02, {0xb1, 0x14, 0x38, 0x5a, 0x61, 0xe7, 0xba, 0x9d}};
#define TWClientDRXPageJump 0x3d
EXTERN_C __declspec(selectany) const GUID WClientDRXPageJumpId = {0xf068b137, 0x7b09, 0x44a1, {0x84, 0xd0, 0x4f, 0xf1, 0x59, 0x2e, 0x0a, 0xc1}};
#define TWClientDRXLayout 0x3e
EXTERN_C __declspec(selectany) const GUID WClientDRXLayoutId = {0x34fbea40, 0x0238, 0x498f, {0xb1, 0x2a, 0x63, 0x1f, 0x5a, 0x8e, 0xf9, 0xa5}};
#define TWClientDRXInstantiated 0x3f
EXTERN_C __declspec(selectany) const GUID WClientDRXInstantiatedId = {0x9de677e1, 0x914a, 0x426c, {0xbc, 0xd9, 0x2c, 0xcd, 0xea, 0x36, 0x48, 0xdf}};
#define TWClientDRXStyleCreated 0x40
EXTERN_C __declspec(selectany) const GUID WClientDRXStyleCreatedId = {0x69737c35, 0x1636, 0x43be, {0xa3, 0x52, 0x42, 0x8c, 0xa3, 0x6d, 0x1b, 0x2c}};
#define TWClientDRXFind 0x41
EXTERN_C __declspec(selectany) const GUID WClientDRXFindId = {0xff8efb74, 0xefaa, 0x424d, {0x90, 0x22, 0xee, 0x8d, 0x21, 0xad, 0x80, 0x4e}};
#define TWClientDRXZoom 0x42
EXTERN_C __declspec(selectany) const GUID WClientDRXZoomId = {0x2e5045a1, 0x8dac, 0x4c90, {0x99, 0x95, 0x32, 0x60, 0xde, 0x16, 0x6c, 0x8f}};
#define TWClientDRXEnsureOM 0x43
EXTERN_C __declspec(selectany) const GUID WClientDRXEnsureOMId = {0x28e3a8bb, 0xaebb, 0x48e8, {0x86, 0xb6, 0x32, 0x75, 0x9b, 0x47, 0xfc, 0xbe}};
#define TWClientDRXGetPage 0x44
EXTERN_C __declspec(selectany) const GUID WClientDRXGetPageId = {0xa0c17259, 0xc6b1, 0x4850, {0xa9, 0xab, 0x13, 0x65, 0x9f, 0xe6, 0xdc, 0x58}};
#define TWClientDRXTreeFlatten 0x45
EXTERN_C __declspec(selectany) const GUID WClientDRXTreeFlattenId = {0xb4557454, 0x212b, 0x4f57, {0xb9, 0xca, 0x2b, 0xa9, 0xd5, 0x82, 0x73, 0xb3}};
#define TWClientDRXAlphaFlatten 0x46
EXTERN_C __declspec(selectany) const GUID WClientDRXAlphaFlattenId = {0x302f02e9, 0xf025, 0x4083, {0xab, 0xd5, 0x2c, 0xe3, 0xaa, 0xa9, 0xa3, 0xcf}};
#define TWClientDRXGetDevMode 0x47
EXTERN_C __declspec(selectany) const GUID WClientDRXGetDevModeId = {0x573ea8dc, 0xdb6c, 0x42c0, {0x91, 0xf8, 0x96, 0x4e, 0x39, 0xcb, 0x6a, 0x70}};
#define TWClientDRXStartDoc 0x48
EXTERN_C __declspec(selectany) const GUID WClientDRXStartDocId = {0xf3fba666, 0xfa0f, 0x4487, {0xb8, 0x46, 0x9f, 0x20, 0x48, 0x11, 0xbf, 0x3d}};
#define TWClientDRXEndDoc 0x49
EXTERN_C __declspec(selectany) const GUID WClientDRXEndDocId = {0x743dd3cf, 0xbbce, 0x4e69, {0xa4, 0xdb, 0x85, 0x22, 0x6e, 0xc6, 0xa4, 0x45}};
#define TWClientDRXStartPage 0x4a
EXTERN_C __declspec(selectany) const GUID WClientDRXStartPageId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x57}};
#define TWClientDRXEndPage 0x4b
EXTERN_C __declspec(selectany) const GUID WClientDRXEndPageId = {0xe20fddf4, 0x17a6, 0x4e5f, {0x86, 0x93, 0x3d, 0xd7, 0xcb, 0x04, 0x94, 0x22}};
#define TWClientDRXCommitPage 0x4c
EXTERN_C __declspec(selectany) const GUID WClientDRXCommitPageId = {0x7d7ee18d, 0xaea5, 0x493f, {0x9e, 0xf2, 0xbb, 0xdb, 0x36, 0xfc, 0xaa, 0x78}};
#define TWClientDRXConvertFont 0x4d
EXTERN_C __declspec(selectany) const GUID WClientDRXConvertFontId = {0x88fc2d42, 0xb1de, 0x4588, {0x8c, 0x3b, 0xdc, 0x5b, 0xec, 0x03, 0xa9, 0xac}};
#define TWClientDRXConvertImage 0x4e
EXTERN_C __declspec(selectany) const GUID WClientDRXConvertImageId = {0x17fddfdc, 0xa1be, 0x43b3, {0xb2, 0xee, 0xf5, 0xe8, 0x9b, 0x7b, 0x1b, 0x26}};
#define TWClientDRXSaveXps 0x4f
EXTERN_C __declspec(selectany) const GUID WClientDRXSaveXpsId = {0xba0320d5, 0x2294, 0x4067, {0x8b, 0x19, 0xef, 0x9c, 0xdd, 0xad, 0x4b, 0x1a}};
#define TWClientDRXLoadPrimitive 0x50
EXTERN_C __declspec(selectany) const GUID WClientDRXLoadPrimitiveId = {0xd0b70c99, 0x450e, 0x4872, {0xa2, 0xd4, 0xfb, 0xfb, 0x1d, 0xc7, 0x97, 0xfa}};
#define TWClientDRXSavePage 0x51
EXTERN_C __declspec(selectany) const GUID WClientDRXSavePageId = {0xb0e3e78b, 0x9ac7, 0x473c, {0x89, 0x03, 0xb5, 0xd2, 0x12, 0x39, 0x9e, 0x3b}};
#define TWClientDRXSerialization 0x52
EXTERN_C __declspec(selectany) const GUID WClientDRXSerializationId = {0x0527276c, 0xd3f4, 0x4293, {0xb8, 0x8c, 0xec, 0xdf, 0x7c, 0xac, 0x44, 0x30}};
#define TWClientPropParentCheck 0x55
EXTERN_C __declspec(selectany) const GUID WClientPropParentCheckId = {0x831bea07, 0x5a2c, 0x434c, {0x8e, 0xf8, 0x7e, 0xba, 0x41, 0xc8, 0x81, 0xfb}};
#define TWClientResourceFind 0x56
EXTERN_C __declspec(selectany) const GUID WClientResourceFindId = {0x228d90d5, 0x7e19, 0x4480, {0x9e, 0x56, 0x3a, 0xf2, 0xe9, 0x0f, 0x8d, 0xa6}};
#define TWClientResourceCacheValue 0x57
EXTERN_C __declspec(selectany) const GUID WClientResourceCacheValueId = {0x3b253e2d, 0x72a5, 0x489e, {0x8c, 0x65, 0x56, 0xc1, 0xe6, 0xc8, 0x59, 0xb5}};
#define TWClientResourceCacheNull 0x58
EXTERN_C __declspec(selectany) const GUID WClientResourceCacheNullId = {0x7866a65b, 0x2f38, 0x43b6, {0xab, 0xd2, 0xdf, 0x43, 0x3b, 0xbc, 0xa0, 0x73}};
#define TWClientResourceCacheMiss 0x59
EXTERN_C __declspec(selectany) const GUID WClientResourceCacheMissId = {0x0420755f, 0xd416, 0x4f15, {0x93, 0x9f, 0x3e, 0x2c, 0xd3, 0xfc, 0xea, 0x23}};
#define TWClientResourceStock 0x5a
EXTERN_C __declspec(selectany) const GUID WClientResourceStockId = {0x06f0fee4, 0x72dd, 0x4802, {0xbd, 0x3d, 0x09, 0x85, 0x13, 0x9f, 0xa9, 0x1a}};
#define TWClientResourceBamlAssembly 0x5b
EXTERN_C __declspec(selectany) const GUID WClientResourceBamlAssemblyId = {0x19df4373, 0x6680, 0x4a04, {0x8c, 0x77, 0xd2, 0xf6, 0x80, 0x9c, 0xa7, 0x03}};
#define TCreateStickyNote 0x5c
EXTERN_C __declspec(selectany) const GUID CreateStickyNoteId = {0xe3dbffac, 0x1e92, 0x4f48, {0xa6, 0x5a, 0xc2, 0x90, 0xbd, 0x5f, 0x5f, 0x15}};
#define TDeleteTextNote 0x5d
EXTERN_C __declspec(selectany) const GUID DeleteTextNoteId = {0x7626a2f9, 0x9a61, 0x43a3, {0xb7, 0xcc, 0xbb, 0x84, 0xc2, 0x49, 0x3a, 0xa7}};
#define TDeleteInkNote 0x5e
EXTERN_C __declspec(selectany) const GUID DeleteInkNoteId = {0xbf7e2a93, 0x9d6a, 0x453e, {0xba, 0xdb, 0x3f, 0x8f, 0x60, 0x07, 0x5c, 0xf2}};
#define TCreateHighlight 0x5f
EXTERN_C __declspec(selectany) const GUID CreateHighlightId = {0xc2a5edb8, 0xac73, 0x41ef, {0xa9, 0x43, 0xa8, 0xa4, 0x9f, 0xa2, 0x84, 0xb1}};
#define TClearHighlight 0x60
EXTERN_C __declspec(selectany) const GUID ClearHighlightId = {0xe1a59147, 0xd28d, 0x4c5f, {0xb9, 0x80, 0x69, 0x1b, 0xe2, 0xfd, 0x42, 0x08}};
#define TLoadAnnotations 0x61
EXTERN_C __declspec(selectany) const GUID LoadAnnotationsId = {0xcf3a283e, 0xc004, 0x4e7d, {0xb3, 0xb9, 0xcc, 0x9b, 0x58, 0x2a, 0x4a, 0x5f}};
#define TAddAnnotation 0x63
EXTERN_C __declspec(selectany) const GUID AddAnnotationId = {0x8f4b2faa, 0x24d6, 0x4ee2, {0x99, 0x35, 0xbb, 0xf8, 0x45, 0xf7, 0x58, 0xa2}};
#define TDeleteAnnotation 0x64
EXTERN_C __declspec(selectany) const GUID DeleteAnnotationId = {0x4d832230, 0x952a, 0x4464, {0x80, 0xaf, 0xaa, 0xb2, 0xac, 0x86, 0x17, 0x03}};
#define TGetAnnotationById 0x65
EXTERN_C __declspec(selectany) const GUID GetAnnotationByIdId = {0x3d27753f, 0xeb8a, 0x4e75, {0x9d, 0x5b, 0x82, 0xfb, 0xa5, 0x5c, 0xde, 0xd1}};
#define TGetAnnotationByLoc 0x66
EXTERN_C __declspec(selectany) const GUID GetAnnotationByLocId = {0x741a41bc, 0x8ecd, 0x43d1, {0xa7, 0xf1, 0xd2, 0xfa, 0xca, 0x73, 0x62, 0xef}};
#define TGetAnnotations 0x67
EXTERN_C __declspec(selectany) const GUID GetAnnotationsId = {0xcd9f6017, 0x7e64, 0x4c61, {0xb9, 0xed, 0x5c, 0x2f, 0xc8, 0xc4, 0xd8, 0x49}};
#define TSerializeAnnotation 0x68
EXTERN_C __declspec(selectany) const GUID SerializeAnnotationId = {0x0148924b, 0x5bea, 0x43e9, {0xb3, 0xed, 0x39, 0x9c, 0xa1, 0x3b, 0x35, 0xeb}};
#define TDeserializeAnnotation 0x69
EXTERN_C __declspec(selectany) const GUID DeserializeAnnotationId = {0x2e32c255, 0xd6db, 0x4de7, {0x9e, 0x62, 0x95, 0x86, 0x37, 0x77, 0x78, 0xd5}};
#define TUpdateAnnotationWithSNC 0x6a
EXTERN_C __declspec(selectany) const GUID UpdateAnnotationWithSNCId = {0x205e0a58, 0x3c7d, 0x495d, {0xb3, 0xed, 0x18, 0xc3, 0xfb, 0x38, 0x92, 0x3f}};
#define TUpdateSNCWithAnnotation 0x6b
EXTERN_C __declspec(selectany) const GUID UpdateSNCWithAnnotationId = {0x59c337ce, 0x9cc2, 0x4a86, {0x9b, 0xfa, 0x06, 0x1f, 0xe9, 0x54, 0x08, 0x6b}};
#define TAnnotationTextChanged 0x6c
EXTERN_C __declspec(selectany) const GUID AnnotationTextChangedId = {0x8bb912b9, 0x39dd, 0x4208, {0xad, 0x62, 0xbe, 0x66, 0xfe, 0x5b, 0x7b, 0xa5}};
#define TAnnotationInkChanged 0x6d
EXTERN_C __declspec(selectany) const GUID AnnotationInkChangedId = {0x1228e154, 0xf171, 0x426e, {0xb6, 0x72, 0x5e, 0xe1, 0x9b, 0x75, 0x5e, 0xdf}};
#define TAddAttachedSN 0x6e
EXTERN_C __declspec(selectany) const GUID AddAttachedSNId = {0x9ca660f6, 0x8d7c, 0x4a90, {0xa9, 0x2f, 0x74, 0x48, 0x2d, 0x9c, 0xc1, 0xcf}};
#define TRemoveAttachedSN 0x6f
EXTERN_C __declspec(selectany) const GUID RemoveAttachedSNId = {0x8c4c69f7, 0x1185, 0x46df, {0xa5, 0xf5, 0xe3, 0x1a, 0xc7, 0xe9, 0x6c, 0x07}};
#define TAddAttachedHighlight 0x70
EXTERN_C __declspec(selectany) const GUID AddAttachedHighlightId = {0x56d2cae5, 0x5ec0, 0x44fb, {0x98, 0xc2, 0x45, 0x3e, 0x87, 0xa0, 0x87, 0x7b}};
#define TRemoveAttachedHighlight 0x71
EXTERN_C __declspec(selectany) const GUID RemoveAttachedHighlightId = {0x4c81d490, 0x9004, 0x49d1, {0x87, 0xd7, 0x28, 0x9d, 0x53, 0xa3, 0x14, 0xef}};
#define TAddAttachedMH 0x72
EXTERN_C __declspec(selectany) const GUID AddAttachedMHId = {0x7ea1d548, 0xca17, 0xca17, {0xa1, 0xa8, 0xf1, 0x85, 0x7d, 0xb6, 0x30, 0x2e}};
#define TRemoveAttachedMH 0x73
EXTERN_C __declspec(selectany) const GUID RemoveAttachedMHId = {0x296c7961, 0xb975, 0x450b, {0x89, 0x75, 0xbf, 0x86, 0x2b, 0x6c, 0x71, 0x59}};
#define TWpfHostUm_ 0x74
EXTERN_C __declspec(selectany) const GUID WpfHostUmId = {0xed251760, 0x7bbc, 0x4b25, {0x83, 0x28, 0xcd, 0x7f, 0x27, 0x1f, 0xee, 0x89}};
#define TWpfHost_ 0x75
EXTERN_C __declspec(selectany) const GUID WpfHostId = {0x5ff6b585, 0x7fb9, 0x4189, {0xbe, 0xb3, 0x54, 0xc8, 0x2c, 0xe4, 0xd7, 0xd1}};
#define TNavigation 0x76
EXTERN_C __declspec(selectany) const GUID NavigationId = {0x6ffb9c25, 0x5c8a, 0x4091, {0x98, 0x9c, 0x5b, 0x59, 0x6a, 0xb2, 0x86, 0xa0}};
#define TWClientOnRender 0x78
EXTERN_C __declspec(selectany) const GUID WClientOnRenderId = {0x3a475cef, 0x0e2a, 0x449b, {0x98, 0x6e, 0xef, 0xff, 0x5d, 0x62, 0x60, 0xe7}};
#define WClientDRXFlushPage 0x79
EXTERN_C __declspec(selectany) const GUID WClientDRXFlushPageId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x58}};
#define WClientDRXGetVisual 0x7a
EXTERN_C __declspec(selectany) const GUID WClientDRXGetVisualId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x59}};
#define WClientDRXSerializeTree 0x7b
EXTERN_C __declspec(selectany) const GUID WClientDRXSerializeTreeId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x5a}};
#define WClientDRXReleaseWriter 0x7c
EXTERN_C __declspec(selectany) const GUID WClientDRXReleaseWriterId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x5b}};
#define WClientDRXGetPrintCap 0x7d
EXTERN_C __declspec(selectany) const GUID WClientDRXGetPrintCapId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x5c}};
#define WClientDRXPTProvider 0x7e
EXTERN_C __declspec(selectany) const GUID WClientDRXPTProviderId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x5d}};
#define WClientDRXRaster 0x7f
EXTERN_C __declspec(selectany) const GUID WClientDRXRasterId = {0x5303d552, 0x28ab, 0x4dac, {0x8b, 0xcd, 0x0f, 0x7d, 0x56, 0x75, 0xa1, 0x5e}};
#define TUnexpectedSoftwareFallback 0x80
EXTERN_C __declspec(selectany) const GUID UnexpectedSoftwareFallbackId = {0x7d2c8338, 0xc13c, 0x4c5c, {0x86, 0x7a, 0xc5, 0x6c, 0x98, 0x03, 0x54, 0xe4}};
#define UpdateVisualState 0x81
EXTERN_C __declspec(selectany) const GUID UpdateVisualStateId = {0x07a7dd63, 0xb52d, 0x4eff, {0xac, 0x3f, 0x24, 0x48, 0xda, 0xf9, 0x74, 0x99}};
#define TVisualCacheAlloc 0x82
EXTERN_C __declspec(selectany) const GUID VisualCacheAllocId = {0x85eb64f6, 0xdc84, 0x43c6, {0xb1, 0x4c, 0x3b, 0xd6, 0x07, 0xf4, 0x2c, 0x0d}};
#define TVisualCacheUpdate 0x83
EXTERN_C __declspec(selectany) const GUID VisualCacheUpdateId = {0xa4fdb257, 0xf156, 0x48f6, {0xb0, 0xf5, 0xc4, 0xa9, 0x44, 0xb5, 0x53, 0xfb}};
#define TStylusEventQueued 0x84
EXTERN_C __declspec(selectany) const GUID StylusEventQueuedId = {0x41ecd0f8, 0xf5a6, 0x4aae, {0x9e, 0x85, 0xca, 0xec, 0xe1, 0x19, 0xb8, 0x53}};
#define TTouchDownReported 0x85
EXTERN_C __declspec(selectany) const GUID TouchDownReportedId = {0x837ad37a, 0x8cef, 0x4c0c, {0x94, 0x4a, 0xae, 0x3b, 0x1f, 0x1c, 0x25, 0x57}};
#define TTouchMoveReported 0x86
EXTERN_C __declspec(selectany) const GUID TouchMoveReportedId = {0xfd718e3f, 0x5462, 0x4227, {0xa6, 0x10, 0x75, 0xd5, 0xbf, 0x89, 0x67, 0xa2}};
#define TTouchUpReported 0x87
EXTERN_C __declspec(selectany) const GUID TouchUpReportedId = {0xc2ac85a3, 0xe16b, 0x4d07, {0x90, 0xde, 0x1e, 0x68, 0x63, 0x94, 0xb8, 0x31}};
#define TManipulationReportFrame 0x88
EXTERN_C __declspec(selectany) const GUID ManipulationReportFrameId = {0xe185d096, 0x6eb9, 0x41be, {0x81, 0xf4, 0x75, 0xd9, 0x24, 0x42, 0x58, 0x72}};
#define TManipulationEventRaised 0x89
EXTERN_C __declspec(selectany) const GUID ManipulationEventRaisedId = {0x51f685eb, 0xb111, 0x400d, {0xb3, 0xe3, 0x46, 0x02, 0x2f, 0x66, 0xa8, 0x94}};
#define TWClientInterlockedRender 0x8a
EXTERN_C __declspec(selectany) const GUID WClientInterlockedRenderId = {0x7fe9630d, 0x93dd, 0x45b1, {0x94, 0x59, 0x21, 0xc7, 0xa4, 0x11, 0x31, 0x74}};
#define TCreateOrAddResourceOnChannel 0x8b
EXTERN_C __declspec(selectany) const GUID CreateOrAddOnChnlId = {0xa9ee6bda, 0xf0df, 0x4e2d, {0xa3, 0xdd, 0x25, 0xca, 0x8f, 0xb3, 0x9f, 0x1f}};
#define TCreateWpfGfxResource 0x8c
EXTERN_C __declspec(selectany) const GUID CreateWpfGfxResourceId = {0x9de2b56b, 0x79a4, 0x497c, {0x88, 0xf2, 0xd5, 0xbe, 0xdc, 0x04, 0x2a, 0x9d}};
#define TCreateChannel 0x8d
EXTERN_C __declspec(selectany) const GUID CreateChannelId = {0x1c415c02, 0x1446, 0x480c, {0xa8, 0x1e, 0xb2, 0x96, 0x7e, 0xe7, 0xe2, 0x0a}};
#define TReleaseOnChannel 0x8e
EXTERN_C __declspec(selectany) const GUID ReleaseOnChannelId = {0x8a61870b, 0xa794, 0x477e, {0x90, 0x93, 0x28, 0x2e, 0x09, 0xea, 0xbe, 0x59}};
#define TWPFName 0x8f
EXTERN_C __declspec(selectany) const GUID WPFElementIDId = {0xa060d980, 0x4c18, 0x4953, {0x81, 0xdf, 0xcf, 0xdf, 0xd3, 0x45, 0xc5, 0xca}};
#define TWClientParseXamlBamlInfo 0x90
EXTERN_C __declspec(selectany) const GUID WClientParseXamlBamlInfoId = {0x00c117d0, 0x8234, 0x4efa, {0xac, 0xe3, 0x73, 0xba, 0x1c, 0x65, 0x5f, 0x28}};
#define TWClientCreateIRT 0x91
EXTERN_C __declspec(selectany) const GUID WClientCreateIRTId = {0xd56e7b1e, 0xe24c, 0x4b0b, {0x9c, 0x4a, 0x88, 0x81, 0xf7, 0x00, 0x56, 0x33}};
#define TWClientPotentialIRTResource 0x92
EXTERN_C __declspec(selectany) const GUID WClientPotentialIRTResourceId = {0x4055bbd6, 0xba41, 0x4bd0, {0xbc, 0x0d, 0x6b, 0x67, 0x96, 0x52, 0x29, 0xbe}};
#define TPenThreadPoolThreadAcquisition 0x93
EXTERN_C __declspec(selectany) const GUID PenThreadPoolThreadAcquisitionId = {0x6c325c36, 0x4d5f, 0x4328, {0xb1, 0xc6, 0xe1, 0x64, 0x79, 0x6d, 0xfe, 0x2b}};
//
// Keyword
//
#define KeywordGeneral 0x1
#define KeywordPerf 0x2
#define KeywordText 0x4
#define KeywordInput 0x8
#define KeywordAnnotation 0x10
#define KeywordXamlBaml 0x20
#define KeywordXPS 0x40
#define KeywordAnimation 0x80
#define KeywordLayout 0x100
#define KeywordHosting 0x400
#define KeywordHeapMeter 0x800
#define KeywordGraphics 0x1000
#define KeywordDispatcher 0x2000

//
// Event Descriptors
//
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientCreateVisual = {0x1, 0x2, 0x10, 0x4, 0x0, 0x1c, 0x8000000000000001};
#define WClientCreateVisual_value 0x1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientAppCtor = {0x2, 0x2, 0x10, 0x4, 0x0, 0x30, 0x8000000000000003};
#define WClientAppCtor_value 0x2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientAppRun = {0x3, 0x2, 0x10, 0x4, 0x0, 0x31, 0x8000000000000003};
#define WClientAppRun_value 0x3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientString = {0x4, 0x2, 0x10, 0x4, 0x0, 0x33, 0x8000000000000001};
#define WClientString_value 0x4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientStringBegin = {0x5, 0x2, 0x10, 0x4, 0x1, 0x33, 0x8000000000000001};
#define WClientStringBegin_value 0x5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientStringEnd = {0x6, 0x2, 0x10, 0x4, 0x2, 0x33, 0x8000000000000001};
#define WClientStringEnd_value 0x6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientPropParentCheck = {0x7, 0x2, 0x10, 0x4, 0x0, 0x55, 0x8000000000000001};
#define WClientPropParentCheck_value 0x7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UpdateVisualStateStart = {0x8, 0x0, 0x10, 0x4, 0x1, 0x81, 0x8000000000000003};
#define UpdateVisualStateStart_value 0x8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UpdateVisualStateEnd = {0x9, 0x0, 0x10, 0x4, 0x2, 0x81, 0x8000000000000003};
#define UpdateVisualStateEnd_value 0x9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR PerfElementIDName = {0xa, 0x0, 0x10, 0x5, 0xa, 0x8f, 0x8000000000000001};
#define PerfElementIDName_value 0xa
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR PerfElementIDAssignment = {0xb, 0x0, 0x10, 0x5, 0x0, 0x8f, 0x8000000000000001};
#define PerfElementIDAssignment_value 0xb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientFontCache = {0x3e9, 0x2, 0x10, 0x4, 0x0, 0x34, 0x8000000000000004};
#define WClientFontCache_value 0x3e9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientInputMessage = {0x7d1, 0x2, 0x10, 0x4, 0x0, 0x1d, 0x800000000000000a};
#define WClientInputMessage_value 0x7d1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR StylusEventQueued = {0x7d2, 0x0, 0x10, 0x4, 0x0, 0x84, 0x800000000000000a};
#define StylusEventQueued_value 0x7d2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR TouchDownReported = {0x7d3, 0x0, 0x10, 0x4, 0x0, 0x85, 0x800000000000000a};
#define TouchDownReported_value 0x7d3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR TouchMoveReported = {0x7d4, 0x0, 0x10, 0x4, 0x0, 0x86, 0x800000000000000a};
#define TouchMoveReported_value 0x7d4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR TouchUpReported = {0x7d5, 0x0, 0x10, 0x4, 0x0, 0x87, 0x800000000000000a};
#define TouchUpReported_value 0x7d5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ManipulationReportFrame = {0x7d6, 0x0, 0x10, 0x4, 0x0, 0x88, 0x800000000000000a};
#define ManipulationReportFrame_value 0x7d6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ManipulationEventRaised = {0x7d7, 0x0, 0x10, 0x4, 0x0, 0x89, 0x800000000000000a};
#define ManipulationEventRaised_value 0x7d7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR PenThreadPoolThreadAcquisition = {0x7d8, 0x0, 0x10, 0x4, 0x0, 0x93, 0x8000000000000009};
#define PenThreadPoolThreadAcquisition_value 0x7d8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateStickyNoteBegin = {0xbb9, 0x2, 0x10, 0x4, 0x1, 0x5c, 0x8000000000000010};
#define CreateStickyNoteBegin_value 0xbb9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateStickyNoteEnd = {0xbba, 0x2, 0x10, 0x4, 0x2, 0x5c, 0x8000000000000010};
#define CreateStickyNoteEnd_value 0xbba
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeleteTextNoteBegin = {0xbbb, 0x2, 0x10, 0x4, 0x1, 0x5d, 0x8000000000000010};
#define DeleteTextNoteBegin_value 0xbbb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeleteTextNoteEnd = {0xbbc, 0x2, 0x10, 0x4, 0x2, 0x5d, 0x8000000000000010};
#define DeleteTextNoteEnd_value 0xbbc
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeleteInkNoteBegin = {0xbbd, 0x2, 0x10, 0x4, 0x1, 0x5e, 0x8000000000000010};
#define DeleteInkNoteBegin_value 0xbbd
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeleteInkNoteEnd = {0xbbe, 0x2, 0x10, 0x4, 0x2, 0x5e, 0x8000000000000010};
#define DeleteInkNoteEnd_value 0xbbe
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateHighlightBegin = {0xbbf, 0x2, 0x10, 0x4, 0x1, 0x5f, 0x8000000000000010};
#define CreateHighlightBegin_value 0xbbf
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateHighlightEnd = {0xbc0, 0x2, 0x10, 0x4, 0x2, 0x5f, 0x8000000000000010};
#define CreateHighlightEnd_value 0xbc0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ClearHighlightBegin = {0xbc1, 0x2, 0x10, 0x4, 0x1, 0x60, 0x8000000000000010};
#define ClearHighlightBegin_value 0xbc1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ClearHighlightEnd = {0xbc2, 0x2, 0x10, 0x4, 0x2, 0x60, 0x8000000000000010};
#define ClearHighlightEnd_value 0xbc2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR LoadAnnotationsBegin = {0xbc3, 0x2, 0x10, 0x4, 0x1, 0x61, 0x8000000000000010};
#define LoadAnnotationsBegin_value 0xbc3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR LoadAnnotationsEnd = {0xbc4, 0x2, 0x10, 0x4, 0x2, 0x61, 0x8000000000000010};
#define LoadAnnotationsEnd_value 0xbc4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAnnotationBegin = {0xbc5, 0x2, 0x10, 0x4, 0x1, 0x63, 0x8000000000000010};
#define AddAnnotationBegin_value 0xbc5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAnnotationEnd = {0xbc6, 0x2, 0x10, 0x4, 0x2, 0x63, 0x8000000000000010};
#define AddAnnotationEnd_value 0xbc6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeleteAnnotationBegin = {0xbc7, 0x2, 0x10, 0x4, 0x1, 0x64, 0x8000000000000010};
#define DeleteAnnotationBegin_value 0xbc7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeleteAnnotationEnd = {0xbc8, 0x2, 0x10, 0x4, 0x2, 0x64, 0x8000000000000010};
#define DeleteAnnotationEnd_value 0xbc8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GetAnnotationByIdBegin = {0xbc9, 0x2, 0x10, 0x4, 0x1, 0x65, 0x8000000000000010};
#define GetAnnotationByIdBegin_value 0xbc9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GetAnnotationByIdEnd = {0xbca, 0x2, 0x10, 0x4, 0x2, 0x65, 0x8000000000000010};
#define GetAnnotationByIdEnd_value 0xbca
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GetAnnotationByLocBegin = {0xbcb, 0x2, 0x10, 0x4, 0x1, 0x66, 0x8000000000000010};
#define GetAnnotationByLocBegin_value 0xbcb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GetAnnotationByLocEnd = {0xbcc, 0x2, 0x10, 0x4, 0x2, 0x66, 0x8000000000000010};
#define GetAnnotationByLocEnd_value 0xbcc
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GetAnnotationsBegin = {0xbcd, 0x2, 0x10, 0x4, 0x1, 0x67, 0x8000000000000010};
#define GetAnnotationsBegin_value 0xbcd
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR GetAnnotationsEnd = {0xbce, 0x2, 0x10, 0x4, 0x2, 0x67, 0x8000000000000010};
#define GetAnnotationsEnd_value 0xbce
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR SerializeAnnotationBegin = {0xbcf, 0x2, 0x10, 0x4, 0x1, 0x68, 0x8000000000000010};
#define SerializeAnnotationBegin_value 0xbcf
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR SerializeAnnotationEnd = {0xbd0, 0x2, 0x10, 0x4, 0x2, 0x68, 0x8000000000000010};
#define SerializeAnnotationEnd_value 0xbd0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeserializeAnnotationBegin = {0xbd1, 0x2, 0x10, 0x4, 0x1, 0x69, 0x8000000000000010};
#define DeserializeAnnotationBegin_value 0xbd1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DeserializeAnnotationEnd = {0xbd2, 0x2, 0x10, 0x4, 0x2, 0x69, 0x8000000000000010};
#define DeserializeAnnotationEnd_value 0xbd2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UpdateAnnotationWithSNCBegin = {0xbd3, 0x2, 0x10, 0x4, 0x1, 0x6a, 0x8000000000000010};
#define UpdateAnnotationWithSNCBegin_value 0xbd3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UpdateAnnotationWithSNCEnd = {0xbd4, 0x2, 0x10, 0x4, 0x2, 0x6a, 0x8000000000000010};
#define UpdateAnnotationWithSNCEnd_value 0xbd4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UpdateSNCWithAnnotationBegin = {0xbd5, 0x2, 0x10, 0x4, 0x1, 0x6b, 0x8000000000000010};
#define UpdateSNCWithAnnotationBegin_value 0xbd5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UpdateSNCWithAnnotationEnd = {0xbd6, 0x2, 0x10, 0x4, 0x2, 0x6b, 0x8000000000000010};
#define UpdateSNCWithAnnotationEnd_value 0xbd6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AnnotationTextChangedBegin = {0xbd7, 0x2, 0x10, 0x4, 0x1, 0x6c, 0x8000000000000010};
#define AnnotationTextChangedBegin_value 0xbd7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AnnotationTextChangedEnd = {0xbd8, 0x2, 0x10, 0x4, 0x2, 0x6c, 0x8000000000000010};
#define AnnotationTextChangedEnd_value 0xbd8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AnnotationInkChangedBegin = {0xbd9, 0x2, 0x10, 0x4, 0x1, 0x6d, 0x8000000000000010};
#define AnnotationInkChangedBegin_value 0xbd9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AnnotationInkChangedEnd = {0xbda, 0x2, 0x10, 0x4, 0x2, 0x6d, 0x8000000000000010};
#define AnnotationInkChangedEnd_value 0xbda
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAttachedSNBegin = {0xbdb, 0x2, 0x10, 0x4, 0x1, 0x6e, 0x8000000000000010};
#define AddAttachedSNBegin_value 0xbdb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAttachedSNEnd = {0xbdc, 0x2, 0x10, 0x4, 0x2, 0x6e, 0x8000000000000010};
#define AddAttachedSNEnd_value 0xbdc
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RemoveAttachedSNBegin = {0xbdd, 0x2, 0x10, 0x4, 0x1, 0x6f, 0x8000000000000010};
#define RemoveAttachedSNBegin_value 0xbdd
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RemoveAttachedSNEnd = {0xbde, 0x2, 0x10, 0x4, 0x2, 0x6f, 0x8000000000000010};
#define RemoveAttachedSNEnd_value 0xbde
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAttachedHighlightBegin = {0xbdf, 0x2, 0x10, 0x4, 0x1, 0x70, 0x8000000000000010};
#define AddAttachedHighlightBegin_value 0xbdf
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAttachedHighlightEnd = {0xbe0, 0x2, 0x10, 0x4, 0x2, 0x70, 0x8000000000000010};
#define AddAttachedHighlightEnd_value 0xbe0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RemoveAttachedHighlightBegin = {0xbe1, 0x2, 0x10, 0x4, 0x1, 0x71, 0x8000000000000010};
#define RemoveAttachedHighlightBegin_value 0xbe1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RemoveAttachedHighlightEnd = {0xbe2, 0x2, 0x10, 0x4, 0x2, 0x71, 0x8000000000000010};
#define RemoveAttachedHighlightEnd_value 0xbe2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAttachedMHBegin = {0xbe3, 0x2, 0x10, 0x4, 0x1, 0x72, 0x8000000000000010};
#define AddAttachedMHBegin_value 0xbe3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR AddAttachedMHEnd = {0xbe4, 0x2, 0x10, 0x4, 0x2, 0x72, 0x8000000000000010};
#define AddAttachedMHEnd_value 0xbe4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RemoveAttachedMHBegin = {0xbe5, 0x2, 0x10, 0x4, 0x1, 0x73, 0x8000000000000010};
#define RemoveAttachedMHBegin_value 0xbe5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR RemoveAttachedMHEnd = {0xbe6, 0x2, 0x10, 0x4, 0x2, 0x73, 0x8000000000000010};
#define RemoveAttachedMHEnd_value 0xbe6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseBamlBegin = {0xfa1, 0x2, 0x10, 0x4, 0x1, 0x29, 0x8000000000000022};
#define WClientParseBamlBegin_value 0xfa1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseBamlEnd = {0xfa2, 0x2, 0x10, 0x4, 0x2, 0x29, 0x8000000000000022};
#define WClientParseBamlEnd_value 0xfa2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseXmlBegin = {0xfa3, 0x2, 0x10, 0x4, 0x1, 0x2b, 0x8000000000000020};
#define WClientParseXmlBegin_value 0xfa3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseXmlEnd = {0xfa4, 0x2, 0x10, 0x4, 0x2, 0x2b, 0x8000000000000020};
#define WClientParseXmlEnd_value 0xfa4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseFefCrInstBegin = {0xfa5, 0x2, 0x10, 0x5, 0x1, 0x2c, 0x8000000000000020};
#define WClientParseFefCrInstBegin_value 0xfa5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseFefCrInstEnd = {0xfa6, 0x2, 0x10, 0x5, 0x2, 0x2c, 0x8000000000000020};
#define WClientParseFefCrInstEnd_value 0xfa6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseInstVisTreeBegin = {0xfa7, 0x2, 0x10, 0x5, 0x1, 0x2d, 0x8000000000000020};
#define WClientParseInstVisTreeBegin_value 0xfa7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseInstVisTreeEnd = {0xfa8, 0x2, 0x10, 0x5, 0x2, 0x2d, 0x8000000000000020};
#define WClientParseInstVisTreeEnd_value 0xfa8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseRdrCrInstBegin = {0xfa9, 0x2, 0x10, 0x5, 0x1, 0x2e, 0x8000000000000020};
#define WClientParseRdrCrInstBegin_value 0xfa9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseRdrCrInstEnd = {0xfaa, 0x2, 0x10, 0x5, 0x2, 0x2e, 0x8000000000000020};
#define WClientParseRdrCrInstEnd_value 0xfaa
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseRdrCrInFTypBegin = {0xfab, 0x2, 0x10, 0x4, 0x1, 0x2f, 0x8000000000000020};
#define WClientParseRdrCrInFTypBegin_value 0xfab
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseRdrCrInFTypEnd = {0xfac, 0x2, 0x10, 0x4, 0x2, 0x2f, 0x8000000000000020};
#define WClientParseRdrCrInFTypEnd_value 0xfac
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceFindBegin = {0xfad, 0x2, 0x10, 0x4, 0x1, 0x56, 0x8000000000000022};
#define WClientResourceFindBegin_value 0xfad
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceFindEnd = {0xfae, 0x2, 0x10, 0x4, 0x2, 0x56, 0x8000000000000022};
#define WClientResourceFindEnd_value 0xfae
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceCacheValue = {0xfaf, 0x2, 0x10, 0x4, 0x0, 0x57, 0x8000000000000020};
#define WClientResourceCacheValue_value 0xfaf
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceCacheNull = {0xfb0, 0x2, 0x10, 0x4, 0x0, 0x58, 0x8000000000000020};
#define WClientResourceCacheNull_value 0xfb0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceCacheMiss = {0xfb1, 0x2, 0x10, 0x4, 0x0, 0x59, 0x8000000000000022};
#define WClientResourceCacheMiss_value 0xfb1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceStock = {0xfb2, 0x2, 0x10, 0x4, 0x0, 0x5a, 0x8000000000000022};
#define WClientResourceStock_value 0xfb2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientResourceBamlAssembly = {0xfb3, 0x2, 0x10, 0x4, 0x0, 0x5b, 0x8000000000000020};
#define WClientResourceBamlAssembly_value 0xfb3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseXamlBegin = {0xfb4, 0x0, 0x10, 0x4, 0x1, 0x2a, 0x8000000000000020};
#define WClientParseXamlBegin_value 0xfb4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseXamlBamlInfo = {0xfb5, 0x0, 0x10, 0x5, 0x0, 0x90, 0x8000000000000020};
#define WClientParseXamlBamlInfo_value 0xfb5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientParseXamlEnd = {0xfb6, 0x0, 0x10, 0x4, 0x2, 0x2a, 0x8000000000000020};
#define WClientParseXamlEnd_value 0xfb6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXFlushPageStart = {0x1389, 0x0, 0x10, 0x4, 0x1, 0x79, 0x8000000000000040};
#define WClientDRXFlushPageStart_value 0x1389
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXFlushPageStop = {0x138a, 0x0, 0x10, 0x4, 0x2, 0x79, 0x8000000000000040};
#define WClientDRXFlushPageStop_value 0x138a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSerializeTreeStart = {0x138b, 0x0, 0x10, 0x4, 0x1, 0x7b, 0x8000000000000040};
#define WClientDRXSerializeTreeStart_value 0x138b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSerializeTreeEnd = {0x138c, 0x0, 0x10, 0x4, 0x2, 0x7b, 0x8000000000000040};
#define WClientDRXSerializeTreeEnd_value 0x138c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetVisualStart = {0x138d, 0x0, 0x10, 0x4, 0x1, 0x7a, 0x8000000000000040};
#define WClientDRXGetVisualStart_value 0x138d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetVisualEnd = {0x138e, 0x0, 0x10, 0x4, 0x2, 0x7a, 0x8000000000000040};
#define WClientDRXGetVisualEnd_value 0x138e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXReleaseWriterStart = {0x138f, 0x0, 0x10, 0x4, 0x1, 0x7c, 0x8000000000000040};
#define WClientDRXReleaseWriterStart_value 0x138f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXReleaseWriterEnd = {0x1390, 0x0, 0x10, 0x4, 0x2, 0x7c, 0x8000000000000040};
#define WClientDRXReleaseWriterEnd_value 0x1390
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetPrintCapStart = {0x1391, 0x0, 0x10, 0x4, 0x1, 0x7d, 0x8000000000000040};
#define WClientDRXGetPrintCapStart_value 0x1391
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetPrintCapEnd = {0x1392, 0x0, 0x10, 0x4, 0x2, 0x7d, 0x8000000000000040};
#define WClientDRXGetPrintCapEnd_value 0x1392
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXPTProviderStart = {0x1393, 0x0, 0x10, 0x4, 0x1, 0x7e, 0x8000000000000040};
#define WClientDRXPTProviderStart_value 0x1393
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXPTProviderEnd = {0x1394, 0x0, 0x10, 0x4, 0x2, 0x7e, 0x8000000000000040};
#define WClientDRXPTProviderEnd_value 0x1394
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXRasterStart = {0x1395, 0x0, 0x10, 0x4, 0x1, 0x7f, 0x8000000000000040};
#define WClientDRXRasterStart_value 0x1395
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXRasterEnd = {0x1396, 0x0, 0x10, 0x4, 0x2, 0x7f, 0x8000000000000040};
#define WClientDRXRasterEnd_value 0x1396
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXOpenPackageBegin = {0x1397, 0x2, 0x10, 0x4, 0x1, 0x35, 0x8000000000000040};
#define WClientDRXOpenPackageBegin_value 0x1397
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXOpenPackageEnd = {0x1398, 0x2, 0x10, 0x4, 0x2, 0x35, 0x8000000000000040};
#define WClientDRXOpenPackageEnd_value 0x1398
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetStreamBegin = {0x1399, 0x2, 0x10, 0x4, 0x1, 0x37, 0x8000000000000040};
#define WClientDRXGetStreamBegin_value 0x1399
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetStreamEnd = {0x139a, 0x2, 0x10, 0x4, 0x2, 0x37, 0x8000000000000040};
#define WClientDRXGetStreamEnd_value 0x139a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXPageVisible = {0x139b, 0x2, 0x10, 0x4, 0x0, 0x38, 0x8000000000000040};
#define WClientDRXPageVisible_value 0x139b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXPageLoaded = {0x139c, 0x2, 0x10, 0x4, 0x0, 0x39, 0x8000000000000040};
#define WClientDRXPageLoaded_value 0x139c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXInvalidateView = {0x139d, 0x2, 0x10, 0x4, 0x0, 0x3a, 0x8000000000000040};
#define WClientDRXInvalidateView_value 0x139d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXStyleCreated = {0x139e, 0x2, 0x10, 0x4, 0x0, 0x40, 0x8000000000000040};
#define WClientDRXStyleCreated_value 0x139e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXFindBegin = {0x139f, 0x2, 0x10, 0x4, 0x1, 0x41, 0x8000000000000040};
#define WClientDRXFindBegin_value 0x139f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXFindEnd = {0x13a0, 0x2, 0x10, 0x4, 0x2, 0x41, 0x8000000000000040};
#define WClientDRXFindEnd_value 0x13a0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXZoom = {0x13a1, 0x2, 0x10, 0x4, 0x0, 0x42, 0x8000000000000040};
#define WClientDRXZoom_value 0x13a1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXEnsureOMBegin = {0x13a2, 0x2, 0x10, 0x4, 0x1, 0x43, 0x8000000000000040};
#define WClientDRXEnsureOMBegin_value 0x13a2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXEnsureOMEnd = {0x13a3, 0x2, 0x10, 0x4, 0x2, 0x43, 0x8000000000000040};
#define WClientDRXEnsureOMEnd_value 0x13a3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXTreeFlattenBegin = {0x13a4, 0x2, 0x10, 0x4, 0x1, 0x45, 0x8000000000000040};
#define WClientDRXTreeFlattenBegin_value 0x13a4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXTreeFlattenEnd = {0x13a5, 0x2, 0x10, 0x4, 0x2, 0x45, 0x8000000000000040};
#define WClientDRXTreeFlattenEnd_value 0x13a5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXAlphaFlattenBegin = {0x13a6, 0x2, 0x10, 0x4, 0x1, 0x46, 0x8000000000000040};
#define WClientDRXAlphaFlattenBegin_value 0x13a6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXAlphaFlattenEnd = {0x13a7, 0x2, 0x10, 0x4, 0x2, 0x46, 0x8000000000000040};
#define WClientDRXAlphaFlattenEnd_value 0x13a7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetDevModeBegin = {0x13a8, 0x2, 0x10, 0x4, 0x1, 0x47, 0x8000000000000040};
#define WClientDRXGetDevModeBegin_value 0x13a8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetDevModeEnd = {0x13a9, 0x2, 0x10, 0x4, 0x2, 0x47, 0x8000000000000040};
#define WClientDRXGetDevModeEnd_value 0x13a9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXStartDocBegin = {0x13aa, 0x2, 0x10, 0x4, 0x1, 0x48, 0x8000000000000040};
#define WClientDRXStartDocBegin_value 0x13aa
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXStartDocEnd = {0x13ab, 0x2, 0x10, 0x4, 0x2, 0x48, 0x8000000000000040};
#define WClientDRXStartDocEnd_value 0x13ab
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXEndDocBegin = {0x13ac, 0x2, 0x10, 0x4, 0x1, 0x49, 0x8000000000000040};
#define WClientDRXEndDocBegin_value 0x13ac
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXEndDocEnd = {0x13ad, 0x2, 0x10, 0x4, 0x2, 0x49, 0x8000000000000040};
#define WClientDRXEndDocEnd_value 0x13ad
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXStartPageBegin = {0x13ae, 0x2, 0x10, 0x4, 0x1, 0x4a, 0x8000000000000040};
#define WClientDRXStartPageBegin_value 0x13ae
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXStartPageEnd = {0x13af, 0x2, 0x10, 0x4, 0x2, 0x4a, 0x8000000000000040};
#define WClientDRXStartPageEnd_value 0x13af
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXEndPageBegin = {0x13b0, 0x2, 0x10, 0x4, 0x1, 0x4b, 0x8000000000000040};
#define WClientDRXEndPageBegin_value 0x13b0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXEndPageEnd = {0x13b1, 0x2, 0x10, 0x4, 0x2, 0x4b, 0x8000000000000040};
#define WClientDRXEndPageEnd_value 0x13b1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXCommitPageBegin = {0x13b2, 0x2, 0x10, 0x4, 0x1, 0x4c, 0x8000000000000040};
#define WClientDRXCommitPageBegin_value 0x13b2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXCommitPageEnd = {0x13b3, 0x2, 0x10, 0x4, 0x2, 0x4c, 0x8000000000000040};
#define WClientDRXCommitPageEnd_value 0x13b3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXConvertFontBegin = {0x13b4, 0x2, 0x10, 0x4, 0x1, 0x4d, 0x8000000000000040};
#define WClientDRXConvertFontBegin_value 0x13b4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXConvertFontEnd = {0x13b5, 0x2, 0x10, 0x4, 0x2, 0x4d, 0x8000000000000040};
#define WClientDRXConvertFontEnd_value 0x13b5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXConvertImageBegin = {0x13b6, 0x2, 0x10, 0x4, 0x1, 0x4e, 0x8000000000000040};
#define WClientDRXConvertImageBegin_value 0x13b6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXConvertImageEnd = {0x13b7, 0x2, 0x10, 0x4, 0x2, 0x4e, 0x8000000000000040};
#define WClientDRXConvertImageEnd_value 0x13b7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSaveXpsBegin = {0x13b8, 0x2, 0x10, 0x4, 0x1, 0x4f, 0x8000000000000040};
#define WClientDRXSaveXpsBegin_value 0x13b8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSaveXpsEnd = {0x13b9, 0x2, 0x10, 0x4, 0x2, 0x4f, 0x8000000000000040};
#define WClientDRXSaveXpsEnd_value 0x13b9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXLoadPrimitiveBegin = {0x13ba, 0x2, 0x10, 0x4, 0x1, 0x50, 0x8000000000000040};
#define WClientDRXLoadPrimitiveBegin_value 0x13ba
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXLoadPrimitiveEnd = {0x13bb, 0x2, 0x10, 0x4, 0x2, 0x50, 0x8000000000000040};
#define WClientDRXLoadPrimitiveEnd_value 0x13bb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSavePageBegin = {0x13bc, 0x2, 0x10, 0x4, 0x1, 0x51, 0x8000000000000040};
#define WClientDRXSavePageBegin_value 0x13bc
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSavePageEnd = {0x13bd, 0x2, 0x10, 0x4, 0x2, 0x51, 0x8000000000000040};
#define WClientDRXSavePageEnd_value 0x13bd
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSerializationBegin = {0x13be, 0x2, 0x10, 0x4, 0x1, 0x52, 0x8000000000000040};
#define WClientDRXSerializationBegin_value 0x13be
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXSerializationEnd = {0x13bf, 0x2, 0x10, 0x4, 0x2, 0x52, 0x8000000000000040};
#define WClientDRXSerializationEnd_value 0x13bf
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXReadStreamBegin = {0x13c0, 0x2, 0x10, 0x5, 0x1, 0x36, 0x8000000000000040};
#define WClientDRXReadStreamBegin_value 0x13c0
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXReadStreamEnd = {0x13c1, 0x2, 0x10, 0x5, 0x2, 0x36, 0x8000000000000040};
#define WClientDRXReadStreamEnd_value 0x13c1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetPageBegin = {0x13c2, 0x2, 0x10, 0x4, 0x1, 0x44, 0x8000000000000040};
#define WClientDRXGetPageBegin_value 0x13c2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXGetPageEnd = {0x13c3, 0x2, 0x10, 0x4, 0x2, 0x44, 0x8000000000000040};
#define WClientDRXGetPageEnd_value 0x13c3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXLineDown = {0x13c4, 0x2, 0x10, 0x4, 0x0, 0x3b, 0x8000000000000040};
#define WClientDRXLineDown_value 0x13c4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXPageDown = {0x13c5, 0x2, 0x10, 0x4, 0x0, 0x3c, 0x8000000000000040};
#define WClientDRXPageDown_value 0x13c5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXPageJump = {0x13c6, 0x2, 0x10, 0x4, 0x0, 0x3d, 0x8000000000000040};
#define WClientDRXPageJump_value 0x13c6
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXLayoutBegin = {0x13c7, 0x2, 0x10, 0x4, 0x1, 0x3e, 0x8000000000000040};
#define WClientDRXLayoutBegin_value 0x13c7
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXLayoutEnd = {0x13c8, 0x2, 0x10, 0x4, 0x2, 0x3e, 0x8000000000000040};
#define WClientDRXLayoutEnd_value 0x13c8
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDRXInstantiated = {0x13c9, 0x2, 0x10, 0x4, 0x0, 0x3f, 0x8000000000000040};
#define WClientDRXInstantiated_value 0x13c9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientTimeManagerTickBegin = {0x1771, 0x2, 0x10, 0x4, 0x1, 0x32, 0x8000000000000082};
#define WClientTimeManagerTickBegin_value 0x1771
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientTimeManagerTickEnd = {0x1772, 0x2, 0x10, 0x4, 0x2, 0x32, 0x8000000000000082};
#define WClientTimeManagerTickEnd_value 0x1772
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutBegin = {0x1b59, 0x3, 0x10, 0x4, 0x1, 0x19, 0x8000000000000102};
#define WClientLayoutBegin_value 0x1b59
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutEnd = {0x1b5a, 0x2, 0x10, 0x4, 0x2, 0x19, 0x8000000000000102};
#define WClientLayoutEnd_value 0x1b5a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMeasureBegin = {0x1b5d, 0x2, 0x10, 0x4, 0x1, 0x1a, 0x8000000000000102};
#define WClientMeasureBegin_value 0x1b5d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMeasureAbort = {0x1b5e, 0x0, 0x10, 0x4, 0xa, 0x1a, 0x8000000000000102};
#define WClientMeasureAbort_value 0x1b5e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMeasureEnd = {0x1b5f, 0x2, 0x10, 0x4, 0x2, 0x1a, 0x8000000000000102};
#define WClientMeasureEnd_value 0x1b5f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMeasureElementBegin = {0x1b60, 0x0, 0x10, 0x5, 0xb, 0x1a, 0x8000000000000100};
#define WClientMeasureElementBegin_value 0x1b60
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMeasureElementEnd = {0x1b61, 0x0, 0x10, 0x5, 0xc, 0x1a, 0x8000000000000100};
#define WClientMeasureElementEnd_value 0x1b61
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientArrangeBegin = {0x1b62, 0x2, 0x10, 0x4, 0x1, 0x1b, 0x8000000000000102};
#define WClientArrangeBegin_value 0x1b62
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientArrangeAbort = {0x1b63, 0x2, 0x10, 0x4, 0xa, 0x1b, 0x8000000000000102};
#define WClientArrangeAbort_value 0x1b63
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientArrangeEnd = {0x1b64, 0x2, 0x10, 0x4, 0x2, 0x1b, 0x8000000000000102};
#define WClientArrangeEnd_value 0x1b64
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientArrangeElementBegin = {0x1b65, 0x0, 0x10, 0x5, 0xb, 0x1b, 0x8000000000000100};
#define WClientArrangeElementBegin_value 0x1b65
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientArrangeElementEnd = {0x1b66, 0x0, 0x10, 0x5, 0xc, 0x1b, 0x8000000000000100};
#define WClientArrangeElementEnd_value 0x1b66
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutAbort = {0x1b67, 0x0, 0x10, 0x4, 0xa, 0x19, 0x8000000000000102};
#define WClientLayoutAbort_value 0x1b67
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutFireSizeChangedBegin = {0x1b68, 0x0, 0x10, 0x5, 0xb, 0x19, 0x8000000000000100};
#define WClientLayoutFireSizeChangedBegin_value 0x1b68
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutFireSizeChangedEnd = {0x1b69, 0x0, 0x10, 0x5, 0xc, 0x19, 0x8000000000000100};
#define WClientLayoutFireSizeChangedEnd_value 0x1b69
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutFireLayoutUpdatedBegin = {0x1b6a, 0x0, 0x10, 0x5, 0xd, 0x19, 0x8000000000000100};
#define WClientLayoutFireLayoutUpdatedBegin_value 0x1b6a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutFireLayoutUpdatedEnd = {0x1b6b, 0x0, 0x10, 0x5, 0xe, 0x19, 0x8000000000000100};
#define WClientLayoutFireLayoutUpdatedEnd_value 0x1b6b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutFireAutomationEventsBegin = {0x1b6c, 0x0, 0x10, 0x5, 0xf, 0x19, 0x8000000000000100};
#define WClientLayoutFireAutomationEventsBegin_value 0x1b6c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutFireAutomationEventsEnd = {0x1b6d, 0x0, 0x10, 0x5, 0x10, 0x19, 0x8000000000000100};
#define WClientLayoutFireAutomationEventsEnd_value 0x1b6d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutException = {0x1b6e, 0x0, 0x10, 0x4, 0x11, 0x19, 0x8000000000000102};
#define WClientLayoutException_value 0x1b6e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientLayoutInvalidated = {0x1b6f, 0x0, 0x10, 0x5, 0x12, 0x19, 0x8000000000000100};
#define WClientLayoutInvalidated_value 0x1b6f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_WinMainStart = {0x232b, 0x2, 0x10, 0x4, 0x1e, 0x74, 0x8000000000000402};
#define WpfHostUm_WinMainStart_value 0x232b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_WinMainEnd = {0x232c, 0x2, 0x10, 0x4, 0x1f, 0x74, 0x8000000000000400};
#define WpfHostUm_WinMainEnd_value 0x232c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_InvokingBrowser = {0x232d, 0x2, 0x10, 0x4, 0x20, 0x74, 0x8000000000000402};
#define WpfHostUm_InvokingBrowser_value 0x232d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_LaunchingRestrictedProcess = {0x232e, 0x2, 0x10, 0x4, 0x21, 0x74, 0x8000000000000400};
#define WpfHostUm_LaunchingRestrictedProcess_value 0x232e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_EnteringMessageLoop = {0x232f, 0x2, 0x10, 0x4, 0x22, 0x74, 0x8000000000000402};
#define WpfHostUm_EnteringMessageLoop_value 0x232f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ClassFactoryCreateInstance = {0x2330, 0x2, 0x10, 0x4, 0x23, 0x74, 0x8000000000000402};
#define WpfHostUm_ClassFactoryCreateInstance_value 0x2330
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ReadingDeplManifestStart = {0x2331, 0x2, 0x10, 0x4, 0x28, 0x74, 0x8000000000000402};
#define WpfHostUm_ReadingDeplManifestStart_value 0x2331
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ReadingDeplManifestEnd = {0x2332, 0x2, 0x10, 0x4, 0x29, 0x74, 0x8000000000000402};
#define WpfHostUm_ReadingDeplManifestEnd_value 0x2332
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ReadingAppManifestStart = {0x2333, 0x2, 0x10, 0x4, 0x2a, 0x74, 0x8000000000000400};
#define WpfHostUm_ReadingAppManifestStart_value 0x2333
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ReadingAppManifestEnd = {0x2334, 0x2, 0x10, 0x4, 0x2b, 0x74, 0x8000000000000400};
#define WpfHostUm_ReadingAppManifestEnd_value 0x2334
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ParsingMarkupVersionStart = {0x2335, 0x2, 0x10, 0x4, 0x2c, 0x74, 0x8000000000000402};
#define WpfHostUm_ParsingMarkupVersionStart_value 0x2335
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ParsingMarkupVersionEnd = {0x2336, 0x2, 0x10, 0x4, 0x2d, 0x74, 0x8000000000000402};
#define WpfHostUm_ParsingMarkupVersionEnd_value 0x2336
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_IPersistFileLoad = {0x2337, 0x2, 0x10, 0x4, 0x32, 0x74, 0x8000000000000402};
#define WpfHostUm_IPersistFileLoad_value 0x2337
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_IPersistMonikerLoadStart = {0x2338, 0x2, 0x10, 0x4, 0x33, 0x74, 0x8000000000000402};
#define WpfHostUm_IPersistMonikerLoadStart_value 0x2338
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_IPersistMonikerLoadEnd = {0x2339, 0x2, 0x10, 0x4, 0x34, 0x74, 0x8000000000000402};
#define WpfHostUm_IPersistMonikerLoadEnd_value 0x2339
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_BindProgress = {0x233a, 0x2, 0x10, 0x4, 0x35, 0x74, 0x8000000000000402};
#define WpfHostUm_BindProgress_value 0x233a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_OnStopBinding = {0x233b, 0x2, 0x10, 0x4, 0x36, 0x74, 0x8000000000000400};
#define WpfHostUm_OnStopBinding_value 0x233b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_VersionAttach = {0x233c, 0x2, 0x10, 0x4, 0x3c, 0x74, 0x8000000000000402};
#define WpfHostUm_VersionAttach_value 0x233c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_VersionActivateStart = {0x233d, 0x2, 0x10, 0x4, 0x3d, 0x74, 0x8000000000000402};
#define WpfHostUm_VersionActivateStart_value 0x233d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_VersionActivateEnd = {0x233e, 0x2, 0x10, 0x4, 0x3e, 0x74, 0x8000000000000402};
#define WpfHostUm_VersionActivateEnd_value 0x233e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_StartingCLRStart = {0x233f, 0x2, 0x10, 0x4, 0x5a, 0x74, 0x8000000000000402};
#define WpfHostUm_StartingCLRStart_value 0x233f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_StartingCLREnd = {0x2340, 0x2, 0x10, 0x4, 0x5b, 0x74, 0x8000000000000402};
#define WpfHostUm_StartingCLREnd_value 0x2340
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_IHlinkTargetNavigateStart = {0x2341, 0x2, 0x10, 0x4, 0x5f, 0x74, 0x8000000000000402};
#define WpfHostUm_IHlinkTargetNavigateStart_value 0x2341
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_IHlinkTargetNavigateEnd = {0x2342, 0x2, 0x10, 0x4, 0x60, 0x74, 0x8000000000000400};
#define WpfHostUm_IHlinkTargetNavigateEnd_value 0x2342
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ReadyStateChanged = {0x2343, 0x2, 0x10, 0x4, 0x61, 0x74, 0x8000000000000402};
#define WpfHostUm_ReadyStateChanged_value 0x2343
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_InitDocHostStart = {0x2344, 0x2, 0x10, 0x4, 0x62, 0x74, 0x8000000000000402};
#define WpfHostUm_InitDocHostStart_value 0x2344
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_InitDocHostEnd = {0x2345, 0x2, 0x10, 0x4, 0x63, 0x74, 0x8000000000000402};
#define WpfHostUm_InitDocHostEnd_value 0x2345
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_MergingMenusStart = {0x2346, 0x2, 0x10, 0x4, 0x64, 0x74, 0x8000000000000402};
#define WpfHostUm_MergingMenusStart_value 0x2346
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_MergingMenusEnd = {0x2347, 0x2, 0x10, 0x4, 0x65, 0x74, 0x8000000000000402};
#define WpfHostUm_MergingMenusEnd_value 0x2347
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_UIActivationStart = {0x2348, 0x2, 0x10, 0x4, 0x66, 0x74, 0x8000000000000402};
#define WpfHostUm_UIActivationStart_value 0x2348
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_UIActivationEnd = {0x2349, 0x2, 0x10, 0x4, 0x67, 0x74, 0x8000000000000402};
#define WpfHostUm_UIActivationEnd_value 0x2349
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_LoadingResourceDLLStart = {0x234a, 0x2, 0x10, 0x5, 0x68, 0x74, 0x8000000000000402};
#define WpfHostUm_LoadingResourceDLLStart_value 0x234a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_LoadingResourceDLLEnd = {0x234b, 0x2, 0x10, 0x5, 0x69, 0x74, 0x8000000000000402};
#define WpfHostUm_LoadingResourceDLLEnd_value 0x234b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_OleCmdQueryStatusStart = {0x234c, 0x2, 0x10, 0x4, 0x6a, 0x74, 0x8000000000000402};
#define WpfHostUm_OleCmdQueryStatusStart_value 0x234c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_OleCmdQueryStatusEnd = {0x234d, 0x2, 0x10, 0x4, 0x6b, 0x74, 0x8000000000000400};
#define WpfHostUm_OleCmdQueryStatusEnd_value 0x234d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_OleCmdExecStart = {0x234e, 0x2, 0x10, 0x4, 0x6c, 0x74, 0x8000000000000402};
#define WpfHostUm_OleCmdExecStart_value 0x234e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_OleCmdExecEnd = {0x234f, 0x2, 0x10, 0x4, 0x6d, 0x74, 0x8000000000000402};
#define WpfHostUm_OleCmdExecEnd_value 0x234f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_ProgressPageShown = {0x2350, 0x2, 0x10, 0x4, 0x6e, 0x74, 0x8000000000000402};
#define WpfHostUm_ProgressPageShown_value 0x2350
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_AdHocProfile1Start = {0x2351, 0x2, 0x10, 0x4, 0x98, 0x74, 0x8000000000000400};
#define WpfHostUm_AdHocProfile1Start_value 0x2351
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_AdHocProfile1End = {0x2352, 0x2, 0x10, 0x4, 0x99, 0x74, 0x8000000000000400};
#define WpfHostUm_AdHocProfile1End_value 0x2352
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_AdHocProfile2Start = {0x2353, 0x2, 0x10, 0x4, 0x9a, 0x74, 0x8000000000000402};
#define WpfHostUm_AdHocProfile2Start_value 0x2353
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHostUm_AdHocProfile2End = {0x2354, 0x2, 0x10, 0x4, 0x9b, 0x74, 0x8000000000000400};
#define WpfHostUm_AdHocProfile2End_value 0x2354
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DocObjHostCreated = {0x2355, 0x2, 0x10, 0x4, 0xa, 0x75, 0x8000000000000402};
#define WpfHost_DocObjHostCreated_value 0x2355
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_XappLauncherAppStartup = {0x2356, 0x2, 0x10, 0x5, 0xd, 0x75, 0x8000000000000402};
#define WpfHost_XappLauncherAppStartup_value 0x2356
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_XappLauncherAppExit = {0x2357, 0x2, 0x10, 0x5, 0xe, 0x75, 0x8000000000000402};
#define WpfHost_XappLauncherAppExit_value 0x2357
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DocObjHostRunApplicationStart = {0x2358, 0x2, 0x10, 0x5, 0xf, 0x75, 0x8000000000000402};
#define WpfHost_DocObjHostRunApplicationStart_value 0x2358
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DocObjHostRunApplicationEnd = {0x2359, 0x2, 0x10, 0x5, 0x10, 0x75, 0x8000000000000402};
#define WpfHost_DocObjHostRunApplicationEnd_value 0x2359
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_ClickOnceActivationStart = {0x235a, 0x2, 0x10, 0x5, 0x11, 0x75, 0x8000000000000402};
#define WpfHost_ClickOnceActivationStart_value 0x235a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_ClickOnceActivationEnd = {0x235b, 0x2, 0x10, 0x4, 0x12, 0x75, 0x8000000000000402};
#define WpfHost_ClickOnceActivationEnd_value 0x235b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_InitAppProxyStart = {0x235c, 0x2, 0x10, 0x4, 0x13, 0x75, 0x8000000000000402};
#define WpfHost_InitAppProxyStart_value 0x235c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_InitAppProxyEnd = {0x235d, 0x2, 0x10, 0x4, 0x14, 0x75, 0x8000000000000402};
#define WpfHost_InitAppProxyEnd_value 0x235d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AppProxyCtor = {0x235e, 0x2, 0x10, 0x5, 0x1e, 0x75, 0x8000000000000402};
#define WpfHost_AppProxyCtor_value 0x235e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_RootBrowserWindowSetupStart = {0x235f, 0x2, 0x10, 0x4, 0x1f, 0x75, 0x8000000000000402};
#define WpfHost_RootBrowserWindowSetupStart_value 0x235f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_RootBrowserWindowSetupEnd = {0x2360, 0x2, 0x10, 0x4, 0x20, 0x75, 0x8000000000000402};
#define WpfHost_RootBrowserWindowSetupEnd_value 0x2360
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AppProxyRunStart = {0x2361, 0x2, 0x10, 0x5, 0x21, 0x75, 0x8000000000000402};
#define WpfHost_AppProxyRunStart_value 0x2361
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AppProxyRunEnd = {0x2362, 0x2, 0x10, 0x5, 0x22, 0x75, 0x8000000000000402};
#define WpfHost_AppProxyRunEnd_value 0x2362
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AppDomainManagerCctor = {0x2363, 0x2, 0x10, 0x5, 0x28, 0x75, 0x8000000000000402};
#define WpfHost_AppDomainManagerCctor_value 0x2363
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_ApplicationActivatorCreateInstanceStart = {0x2364, 0x2, 0x10, 0x5, 0x29, 0x75, 0x8000000000000402};
#define WpfHost_ApplicationActivatorCreateInstanceStart_value 0x2364
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_ApplicationActivatorCreateInstanceEnd = {0x2365, 0x2, 0x10, 0x5, 0x2a, 0x75, 0x8000000000000402};
#define WpfHost_ApplicationActivatorCreateInstanceEnd_value 0x2365
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DetermineApplicationTrustStart = {0x2366, 0x2, 0x10, 0x5, 0x2b, 0x75, 0x8000000000000402};
#define WpfHost_DetermineApplicationTrustStart_value 0x2366
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DetermineApplicationTrustEnd = {0x2367, 0x2, 0x10, 0x5, 0x2c, 0x75, 0x8000000000000402};
#define WpfHost_DetermineApplicationTrustEnd_value 0x2367
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_FirstTimeActivation = {0x2368, 0x2, 0x10, 0x4, 0x32, 0x75, 0x8000000000000402};
#define WpfHost_FirstTimeActivation_value 0x2368
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_GetDownloadPageStart = {0x2369, 0x2, 0x10, 0x5, 0x33, 0x75, 0x8000000000000400};
#define WpfHost_GetDownloadPageStart_value 0x2369
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_GetDownloadPageEnd = {0x236a, 0x2, 0x10, 0x5, 0x34, 0x75, 0x8000000000000400};
#define WpfHost_GetDownloadPageEnd_value 0x236a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DownloadDeplManifestStart = {0x236b, 0x2, 0x10, 0x4, 0x35, 0x75, 0x8000000000000402};
#define WpfHost_DownloadDeplManifestStart_value 0x236b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DownloadDeplManifestEnd = {0x236c, 0x2, 0x10, 0x4, 0x36, 0x75, 0x8000000000000402};
#define WpfHost_DownloadDeplManifestEnd_value 0x236c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AssertAppRequirementsStart = {0x236d, 0x2, 0x10, 0x5, 0x37, 0x75, 0x8000000000000402};
#define WpfHost_AssertAppRequirementsStart_value 0x236d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AssertAppRequirementsEnd = {0x236e, 0x2, 0x10, 0x5, 0x38, 0x75, 0x8000000000000402};
#define WpfHost_AssertAppRequirementsEnd_value 0x236e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DownloadApplicationStart = {0x236f, 0x2, 0x10, 0x4, 0x39, 0x75, 0x8000000000000402};
#define WpfHost_DownloadApplicationStart_value 0x236f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DownloadApplicationEnd = {0x2370, 0x2, 0x10, 0x4, 0x3a, 0x75, 0x8000000000000402};
#define WpfHost_DownloadApplicationEnd_value 0x2370
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_DownloadProgressUpdate = {0x2371, 0x2, 0x10, 0x5, 0x3b, 0x75, 0x8000000000000402};
#define WpfHost_DownloadProgressUpdate_value 0x2371
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_XappLauncherAppNavigated = {0x2372, 0x2, 0x10, 0x5, 0x3c, 0x75, 0x8000000000000402};
#define WpfHost_XappLauncherAppNavigated_value 0x2372
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_UpdateBrowserCommandsStart = {0x2375, 0x2, 0x10, 0x5, 0x46, 0x75, 0x8000000000000402};
#define WpfHost_UpdateBrowserCommandsStart_value 0x2375
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_UpdateBrowserCommandsEnd = {0x2376, 0x2, 0x10, 0x5, 0x47, 0x75, 0x8000000000000402};
#define WpfHost_UpdateBrowserCommandsEnd_value 0x2376
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_PostShutdown = {0x2377, 0x2, 0x10, 0x4, 0x50, 0x75, 0x8000000000000400};
#define WpfHost_PostShutdown_value 0x2377
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_AbortingActivation = {0x2378, 0x2, 0x10, 0x4, 0x51, 0x75, 0x8000000000000400};
#define WpfHost_AbortingActivation_value 0x2378
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_IBHSRunStart = {0x2379, 0x2, 0x10, 0x4, 0xb, 0x75, 0x8000000000000402};
#define WpfHost_IBHSRunStart_value 0x2379
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WpfHost_IBHSRunEnd = {0x237a, 0x2, 0x10, 0x4, 0xc, 0x75, 0x8000000000000402};
#define WpfHost_IBHSRunEnd_value 0x237a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationAsyncWorkItem = {0x237b, 0x2, 0x10, 0x4, 0xb, 0x76, 0x8000000000000402};
#define Wpf_NavigationAsyncWorkItem_value 0x237b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationWebResponseReceived = {0x237c, 0x2, 0x10, 0x4, 0xc, 0x76, 0x8000000000000402};
#define Wpf_NavigationWebResponseReceived_value 0x237c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationEnd = {0x237d, 0x2, 0x10, 0x4, 0xe, 0x76, 0x8000000000000402};
#define Wpf_NavigationEnd_value 0x237d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationContentRendered = {0x237e, 0x2, 0x10, 0x4, 0xf, 0x76, 0x8000000000000402};
#define Wpf_NavigationContentRendered_value 0x237e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationStart = {0x237f, 0x2, 0x10, 0x4, 0xa, 0x76, 0x8000000000000402};
#define Wpf_NavigationStart_value 0x237f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationLaunchBrowser = {0x2380, 0x2, 0x10, 0x4, 0xd, 0x76, 0x8000000000000400};
#define Wpf_NavigationLaunchBrowser_value 0x2380
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR Wpf_NavigationPageFunctionReturn = {0x2381, 0x2, 0x10, 0x4, 0x10, 0x76, 0x8000000000000400};
#define Wpf_NavigationPageFunctionReturn_value 0x2381
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DrawBitmapInfo = {0x2af9, 0x0, 0x10, 0x4, 0x0, 0x1, 0x8000000000001000};
#define DrawBitmapInfo_value 0x2af9
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR BitmapCopyInfo = {0x2afa, 0x0, 0x10, 0x4, 0x0, 0x2, 0x8000000000001000};
#define BitmapCopyInfo_value 0x2afa
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR SetClipInfo = {0x2afb, 0x0, 0x10, 0x5, 0x0, 0x3, 0x8000000000001000};
#define SetClipInfo_value 0x2afb
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_ClearStart = {0x2afc, 0x0, 0x10, 0x4, 0x1, 0x5, 0x8000000000001000};
#define DWMDraw_ClearStart_value 0x2afc
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_ClearEnd = {0x2afd, 0x0, 0x10, 0x4, 0x2, 0x5, 0x8000000000001000};
#define DWMDraw_ClearEnd_value 0x2afd
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_BitmapStart = {0x2afe, 0x0, 0x10, 0x5, 0x38, 0x8, 0x8000000000001000};
#define DWMDraw_BitmapStart_value 0x2afe
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_BitmapEnd = {0x2aff, 0x0, 0x10, 0x5, 0x39, 0x8, 0x8000000000001000};
#define DWMDraw_BitmapEnd_value 0x2aff
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_RectangleStart = {0x2b00, 0x0, 0x10, 0x5, 0x3a, 0x8, 0x8000000000001000};
#define DWMDraw_RectangleStart_value 0x2b00
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_RectangleEnd = {0x2b01, 0x0, 0x10, 0x5, 0x3b, 0x8, 0x8000000000001000};
#define DWMDraw_RectangleEnd_value 0x2b01
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_GeometryStart = {0x2b02, 0x0, 0x10, 0x5, 0x3c, 0x8, 0x8000000000001000};
#define DWMDraw_GeometryStart_value 0x2b02
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_GeometryEnd = {0x2b03, 0x0, 0x10, 0x5, 0x3d, 0x8, 0x8000000000001000};
#define DWMDraw_GeometryEnd_value 0x2b03
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_ImageStart = {0x2b04, 0x0, 0x10, 0x5, 0x3e, 0x8, 0x8000000000001000};
#define DWMDraw_ImageStart_value 0x2b04
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_ImageEnd = {0x2b05, 0x0, 0x10, 0x5, 0x3f, 0x8, 0x8000000000001000};
#define DWMDraw_ImageEnd_value 0x2b05
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_GlyphRunStart = {0x2b06, 0x0, 0x10, 0x5, 0x40, 0x8, 0x8000000000001000};
#define DWMDraw_GlyphRunStart_value 0x2b06
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_GlyphRunEnd = {0x2b07, 0x0, 0x10, 0x5, 0x41, 0x8, 0x8000000000001000};
#define DWMDraw_GlyphRunEnd_value 0x2b07
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_BeginLayerStart = {0x2b08, 0x0, 0x10, 0x5, 0x44, 0x8, 0x8000000000001000};
#define DWMDraw_BeginLayerStart_value 0x2b08
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_BeginLayerEnd = {0x2b09, 0x0, 0x10, 0x5, 0x45, 0x8, 0x8000000000001000};
#define DWMDraw_BeginLayerEnd_value 0x2b09
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_EndLayerStart = {0x2b0a, 0x0, 0x10, 0x5, 0x46, 0x8, 0x8000000000001000};
#define DWMDraw_EndLayerStart_value 0x2b0a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_EndLayerEnd = {0x2b0b, 0x0, 0x10, 0x5, 0x47, 0x8, 0x8000000000001000};
#define DWMDraw_EndLayerEnd_value 0x2b0b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_ClippedBitmapStart = {0x2b0c, 0x0, 0x10, 0x5, 0x4e, 0x8, 0x8000000000001000};
#define DWMDraw_ClippedBitmapStart_value 0x2b0c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_ClippedBitmapEnd = {0x2b0d, 0x0, 0x10, 0x5, 0x4f, 0x8, 0x8000000000001000};
#define DWMDraw_ClippedBitmapEnd_value 0x2b0d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR DWMDraw_Info = {0x2b0e, 0x0, 0x10, 0x5, 0x0, 0x8, 0x8000000000001000};
#define DWMDraw_Info_value 0x2b0e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR LayerEventStart = {0x2b0f, 0x2, 0x10, 0x5, 0x1, 0x9, 0x8000000000001000};
#define LayerEventStart_value 0x2b0f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR LayerEventEnd = {0x2b10, 0x2, 0x10, 0x5, 0x2, 0x9, 0x8000000000001000};
#define LayerEventEnd_value 0x2b10
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDesktopRTCreateBegin = {0x2b11, 0x2, 0x10, 0x4, 0x1, 0xc, 0x8000000000001002};
#define WClientDesktopRTCreateBegin_value 0x2b11
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientDesktopRTCreateEnd = {0x2b12, 0x2, 0x10, 0x4, 0x2, 0xc, 0x8000000000001002};
#define WClientDesktopRTCreateEnd_value 0x2b12
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceProcessQueueBegin = {0x2b13, 0x2, 0x10, 0x4, 0x1, 0xd, 0x8000000000001002};
#define WClientUceProcessQueueBegin_value 0x2b13
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceProcessQueueEnd = {0x2b14, 0x2, 0x10, 0x4, 0x2, 0xd, 0x8000000000001002};
#define WClientUceProcessQueueEnd_value 0x2b14
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceProcessQueueInfo = {0x2b15, 0x2, 0x10, 0x5, 0x0, 0xd, 0x8000000000001002};
#define WClientUceProcessQueueInfo_value 0x2b15
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUcePrecomputeBegin = {0x2b16, 0x2, 0x10, 0x4, 0x1, 0xe, 0x8000000000001002};
#define WClientUcePrecomputeBegin_value 0x2b16
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUcePrecomputeEnd = {0x2b17, 0x2, 0x10, 0x4, 0x2, 0xe, 0x8000000000001002};
#define WClientUcePrecomputeEnd_value 0x2b17
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceRenderBegin = {0x2b18, 0x2, 0x10, 0x4, 0x1, 0xf, 0x8000000000001002};
#define WClientUceRenderBegin_value 0x2b18
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceRenderEnd = {0x2b19, 0x2, 0x10, 0x4, 0x2, 0xf, 0x8000000000001002};
#define WClientUceRenderEnd_value 0x2b19
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUcePresentBegin = {0x2b1a, 0x2, 0x10, 0x4, 0x1, 0x10, 0x8000000000001002};
#define WClientUcePresentBegin_value 0x2b1a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUcePresentEnd = {0x2b1b, 0x2, 0x10, 0x4, 0x2, 0x10, 0x8000000000001002};
#define WClientUcePresentEnd_value 0x2b1b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceResponse = {0x2b1c, 0x2, 0x10, 0x4, 0x0, 0x11, 0x8000000000001002};
#define WClientUceResponse_value 0x2b1c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceCheckDeviceStateInfo = {0x2b1d, 0x2, 0x10, 0x4, 0x0, 0x13, 0x8000000000001000};
#define WClientUceCheckDeviceStateInfo_value 0x2b1d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR VisualCacheAlloc = {0x2b1e, 0x0, 0x10, 0x4, 0x0, 0x82, 0x8000000000001002};
#define VisualCacheAlloc_value 0x2b1e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR VisualCacheUpdate = {0x2b1f, 0x0, 0x10, 0x4, 0x0, 0x83, 0x8000000000001002};
#define VisualCacheUpdate_value 0x2b1f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateChannel = {0x2b20, 0x0, 0x10, 0x11, 0x0, 0x8d, 0x8000000000001002};
#define CreateChannel_value 0x2b20
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateOrAddResourceOnChannel = {0x2b21, 0x0, 0x10, 0x11, 0x0, 0x8b, 0x8000000000001002};
#define CreateOrAddResourceOnChannel_value 0x2b21
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR CreateWpfGfxResource = {0x2b22, 0x0, 0x10, 0x11, 0x0, 0x8c, 0x8000000000001002};
#define CreateWpfGfxResource_value 0x2b22
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR ReleaseOnChannel = {0x2b23, 0x0, 0x10, 0x11, 0x0, 0x8e, 0x8000000000001002};
#define ReleaseOnChannel_value 0x2b23
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR UnexpectedSoftwareFallback = {0x2b24, 0x0, 0x10, 0x4, 0x0, 0x80, 0x8000000000001000};
#define UnexpectedSoftwareFallback_value 0x2b24
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientInterlockedRenderBegin = {0x2b25, 0x2, 0x10, 0x4, 0x1, 0x8a, 0x8000000000001000};
#define WClientInterlockedRenderBegin_value 0x2b25
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientInterlockedRenderEnd = {0x2b26, 0x2, 0x10, 0x4, 0x2, 0x8a, 0x8000000000001000};
#define WClientInterlockedRenderEnd_value 0x2b26
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientRenderHandlerBegin = {0x2b27, 0x2, 0x10, 0x4, 0x1, 0x1e, 0x8000000000001002};
#define WClientRenderHandlerBegin_value 0x2b27
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientRenderHandlerEnd = {0x2b28, 0x2, 0x10, 0x4, 0x2, 0x1e, 0x8000000000001002};
#define WClientRenderHandlerEnd_value 0x2b28
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientAnimRenderHandlerBegin = {0x2b29, 0x2, 0x10, 0x4, 0x1, 0x1f, 0x8000000000001002};
#define WClientAnimRenderHandlerBegin_value 0x2b29
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientAnimRenderHandlerEnd = {0x2b2a, 0x2, 0x10, 0x4, 0x2, 0x1f, 0x8000000000001002};
#define WClientAnimRenderHandlerEnd_value 0x2b2a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMediaRenderBegin = {0x2b2b, 0x2, 0x10, 0x4, 0x1, 0x20, 0x8000000000001002};
#define WClientMediaRenderBegin_value 0x2b2b
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientMediaRenderEnd = {0x2b2c, 0x2, 0x10, 0x4, 0x2, 0x20, 0x8000000000001002};
#define WClientMediaRenderEnd_value 0x2b2c
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientPostRender = {0x2b2d, 0x2, 0x10, 0x4, 0x0, 0x21, 0x8000000000001002};
#define WClientPostRender_value 0x2b2d
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientQPCFrequency = {0x2b2e, 0x2, 0x10, 0x4, 0x0, 0x22, 0x8000000000001000};
#define WClientQPCFrequency_value 0x2b2e
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientPrecomputeSceneBegin = {0x2b2f, 0x2, 0x10, 0x4, 0x1, 0x23, 0x8000000000001002};
#define WClientPrecomputeSceneBegin_value 0x2b2f
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientPrecomputeSceneEnd = {0x2b30, 0x2, 0x10, 0x4, 0x2, 0x23, 0x8000000000001002};
#define WClientPrecomputeSceneEnd_value 0x2b30
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientCompileSceneBegin = {0x2b31, 0x2, 0x10, 0x4, 0x1, 0x24, 0x8000000000001002};
#define WClientCompileSceneBegin_value 0x2b31
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientCompileSceneEnd = {0x2b32, 0x2, 0x10, 0x4, 0x2, 0x24, 0x8000000000001002};
#define WClientCompileSceneEnd_value 0x2b32
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIResponse = {0x2b33, 0x2, 0x10, 0x4, 0x0, 0x25, 0x8000000000001002};
#define WClientUIResponse_value 0x2b33
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUICommitChannel = {0x2b34, 0x2, 0x10, 0x4, 0x0, 0x26, 0x8000000000001002};
#define WClientUICommitChannel_value 0x2b34
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUceNotifyPresent = {0x2b35, 0x2, 0x10, 0x4, 0x0, 0x27, 0x8000000000001002};
#define WClientUceNotifyPresent_value 0x2b35
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientScheduleRender = {0x2b36, 0x2, 0x10, 0x4, 0x0, 0x28, 0x8000000000001000};
#define WClientScheduleRender_value 0x2b36
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientOnRenderBegin = {0x2b37, 0x0, 0x10, 0x5, 0x1, 0x78, 0x8000000000001002};
#define WClientOnRenderBegin_value 0x2b37
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientOnRenderEnd = {0x2b38, 0x0, 0x10, 0x5, 0x2, 0x78, 0x8000000000001002};
#define WClientOnRenderEnd_value 0x2b38
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientCreateIRT = {0x2b39, 0x0, 0x10, 0x12, 0x0, 0x91, 0x8000000000001000};
#define WClientCreateIRT_value 0x2b39
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientPotentialIRTResource = {0x2b3a, 0x0, 0x10, 0x12, 0x0, 0x92, 0x8000000000001000};
#define WClientPotentialIRTResource_value 0x2b3a
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIContextDispatchBegin = {0x2ee1, 0x3, 0x10, 0x4, 0x1, 0x14, 0x8000000000002002};
#define WClientUIContextDispatchBegin_value 0x2ee1
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIContextDispatchEnd = {0x2ee2, 0x2, 0x10, 0x4, 0x2, 0x14, 0x8000000000002002};
#define WClientUIContextDispatchEnd_value 0x2ee2
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIContextPost = {0x2ee3, 0x3, 0x10, 0x4, 0x0, 0x15, 0x8000000000002002};
#define WClientUIContextPost_value 0x2ee3
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIContextAbort = {0x2ee4, 0x3, 0x10, 0x4, 0x0, 0x16, 0x8000000000002000};
#define WClientUIContextAbort_value 0x2ee4
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIContextPromote = {0x2ee5, 0x3, 0x10, 0x4, 0x0, 0x17, 0x8000000000002000};
#define WClientUIContextPromote_value 0x2ee5
EXTERN_C __declspec(selectany) const EVENT_DESCRIPTOR WClientUIContextIdle = {0x2ee6, 0x2, 0x10, 0x4, 0x0, 0x18, 0x8000000000002002};
#define WClientUIContextIdle_value 0x2ee6

//
// Note on Generate Code from Manifest XP/W2K3/Vista and above
//
//Arrays :  only constant size arrays supported, the length must be specified in manifest
//
//Strings: No support for arrays of strings 
//
//SID No support for array of SIDs, the macro will take a pointer to the SID and use appropriate 
//GetLengthSid function to get the length.
//

//
// Allow Diasabling of code generation
//
#ifndef MCGEN_DISABLE_PROVIDER_CODE_GENERATION

//
// Globals 
//


//
// Event Enablement Bits
//

EXTERN_C __declspec(selectany) DECLSPEC_CACHEALIGN ULONG Microsoft_Windows_WPFEnableBits[1];
EXTERN_C __declspec(selectany) const ULONGLONG Microsoft_Windows_WPFKeywords[27] = {0x8000000000000001, 0x8000000000000003, 0x8000000000000001, 0x8000000000000004, 0x800000000000000a, 0x8000000000000009, 0x8000000000000010, 0x8000000000000022, 0x8000000000000020, 0x8000000000000020, 0x8000000000000040, 0x8000000000000040, 0x8000000000000082, 0x8000000000000102, 0x8000000000000100, 0x8000000000000402, 0x8000000000000400, 0x8000000000000402, 0x8000000000000400, 0x8000000000001000, 0x8000000000001000, 0x8000000000001002, 0x8000000000001002, 0x8000000000001002, 0x8000000000001000, 0x8000000000002002, 0x8000000000002000};
EXTERN_C __declspec(selectany) const UCHAR Microsoft_Windows_WPFLevels[27] = {4, 4, 5, 4, 4, 4, 4, 4, 4, 5, 4, 5, 4, 4, 5, 4, 4, 5, 5, 4, 5, 4, 5, 17, 18, 4, 4};
EXTERN_C __declspec(selectany) MCGEN_TRACE_CONTEXT MICROSOFT_WINDOWS_WPF_PROVIDER_Context = {0, 0, 0, 0, 0, 0, 0, 0, 27, Microsoft_Windows_WPFEnableBits, Microsoft_Windows_WPFKeywords, Microsoft_Windows_WPFLevels};

EXTERN_C __declspec(selectany) REGHANDLE Microsoft_Windows_WPFHandle = (REGHANDLE)0;

//
// Register with ETW XP, W2K, W2K3, Vista +
//
#ifndef EventRegisterMicrosoft_Windows_WPF
#define EventRegisterMicrosoft_Windows_WPF() McGenEventTracingRegister(&MICROSOFT_WINDOWS_WPF_PROVIDER, NULL, &MICROSOFT_WINDOWS_WPF_PROVIDER_Context, &Microsoft_Windows_WPFHandle) 
#endif

//
// UnRegister with ETW
//
#ifndef EventUnregisterMicrosoft_Windows_WPF
#define EventUnregisterMicrosoft_Windows_WPF() McGenEventTracingUnregister(&Microsoft_Windows_WPFHandle) 
#endif

//
// Enablement check macro for WClientCreateVisual
//

#define EventEnabledWClientCreateVisual() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for WClientCreateVisual
//
#define EventWriteWClientCreateVisual(Id, HWND)\
        EventEnabledWClientCreateVisual() ?\
        MofTemplate_di(Microsoft_Windows_WPFHandle, &WClientCreateVisual, &WClientCreateVisualId, Id, HWND)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientAppCtor
//

#define EventEnabledWClientAppCtor() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000002) != 0)

//
// Event Macro for WClientAppCtor
//
#define EventWriteWClientAppCtor()\
        EventEnabledWClientAppCtor() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientAppCtor, &WClientAppCtorId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientAppRun
//

#define EventEnabledWClientAppRun() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000002) != 0)

//
// Event Macro for WClientAppRun
//
#define EventWriteWClientAppRun()\
        EventEnabledWClientAppRun() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientAppRun, &WClientAppRunId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientString
//

#define EventEnabledWClientString() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for WClientString
//
#define EventWriteWClientString(Info)\
        EventEnabledWClientString() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientString, &WClientStringId, Info)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientStringBegin
//

#define EventEnabledWClientStringBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for WClientStringBegin
//
#define EventWriteWClientStringBegin(Info)\
        EventEnabledWClientStringBegin() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientStringBegin, &WClientStringId, Info)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientStringEnd
//

#define EventEnabledWClientStringEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for WClientStringEnd
//
#define EventWriteWClientStringEnd(Info)\
        EventEnabledWClientStringEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientStringEnd, &WClientStringId, Info)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientPropParentCheck
//

#define EventEnabledWClientPropParentCheck() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000001) != 0)

//
// Event Macro for WClientPropParentCheck
//
#define EventWriteWClientPropParentCheck(Id, TypeAndName)\
        EventEnabledWClientPropParentCheck() ?\
        MofTemplate_dz(Microsoft_Windows_WPFHandle, &WClientPropParentCheck, &WClientPropParentCheckId, Id, TypeAndName)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UpdateVisualStateStart
//

#define EventEnabledUpdateVisualStateStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000002) != 0)

//
// Event Macro for UpdateVisualStateStart
//
#define EventWriteUpdateVisualStateStart()\
        EventEnabledUpdateVisualStateStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &UpdateVisualStateStart, &UpdateVisualStateId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UpdateVisualStateEnd
//

#define EventEnabledUpdateVisualStateEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000002) != 0)

//
// Event Macro for UpdateVisualStateEnd
//
#define EventWriteUpdateVisualStateEnd()\
        EventEnabledUpdateVisualStateEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &UpdateVisualStateEnd, &UpdateVisualStateId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for PerfElementIDName
//

#define EventEnabledPerfElementIDName() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000004) != 0)

//
// Event Macro for PerfElementIDName
//
#define EventWritePerfElementIDName(Id, Type, Name)\
        EventEnabledPerfElementIDName() ?\
        MofTemplate_izz(Microsoft_Windows_WPFHandle, &PerfElementIDName, &WPFElementIDId, Id, Type, Name)\
        : ERROR_SUCCESS\

//
// Enablement check macro for PerfElementIDAssignment
//

#define EventEnabledPerfElementIDAssignment() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000004) != 0)

//
// Event Macro for PerfElementIDAssignment
//
#define EventWritePerfElementIDAssignment(Id, Type, Data, AssemblyID)\
        EventEnabledPerfElementIDAssignment() ?\
        MofTemplate_izzi(Microsoft_Windows_WPFHandle, &PerfElementIDAssignment, &WPFElementIDId, Id, Type, Data, AssemblyID)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientFontCache
//

#define EventEnabledWClientFontCache() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000008) != 0)

//
// Event Macro for WClientFontCache
//
#define EventWriteWClientFontCache()\
        EventEnabledWClientFontCache() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientFontCache, &WClientFontCacheId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientInputMessage
//

#define EventEnabledWClientInputMessage() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for WClientInputMessage
//
#define EventWriteWClientInputMessage(Id, HWND, Msg, WParam, LParam)\
        EventEnabledWClientInputMessage() ?\
        MofTemplate_diddd(Microsoft_Windows_WPFHandle, &WClientInputMessage, &WClientInputMessageId, Id, HWND, Msg, WParam, LParam)\
        : ERROR_SUCCESS\

//
// Enablement check macro for StylusEventQueued
//

#define EventEnabledStylusEventQueued() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for StylusEventQueued
//
#define EventWriteStylusEventQueued(Id)\
        EventEnabledStylusEventQueued() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &StylusEventQueued, &StylusEventQueuedId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for TouchDownReported
//

#define EventEnabledTouchDownReported() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for TouchDownReported
//
#define EventWriteTouchDownReported(Id)\
        EventEnabledTouchDownReported() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &TouchDownReported, &TouchDownReportedId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for TouchMoveReported
//

#define EventEnabledTouchMoveReported() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for TouchMoveReported
//
#define EventWriteTouchMoveReported(Id)\
        EventEnabledTouchMoveReported() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &TouchMoveReported, &TouchMoveReportedId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for TouchUpReported
//

#define EventEnabledTouchUpReported() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for TouchUpReported
//
#define EventWriteTouchUpReported(Id)\
        EventEnabledTouchUpReported() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &TouchUpReported, &TouchUpReportedId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ManipulationReportFrame
//

#define EventEnabledManipulationReportFrame() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for ManipulationReportFrame
//
#define EventWriteManipulationReportFrame(Id)\
        EventEnabledManipulationReportFrame() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &ManipulationReportFrame, &ManipulationReportFrameId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ManipulationEventRaised
//

#define EventEnabledManipulationEventRaised() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000010) != 0)

//
// Event Macro for ManipulationEventRaised
//
#define EventWriteManipulationEventRaised(Id)\
        EventEnabledManipulationEventRaised() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &ManipulationEventRaised, &ManipulationEventRaisedId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for PenThreadPoolThreadAcquisition
//

#define EventEnabledPenThreadPoolThreadAcquisition() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000020) != 0)

//
// Event Macro for PenThreadPoolThreadAcquisition
//
#define EventWritePenThreadPoolThreadAcquisition(Id)\
        EventEnabledPenThreadPoolThreadAcquisition() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &PenThreadPoolThreadAcquisition, &PenThreadPoolThreadAcquisitionId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateStickyNoteBegin
//

#define EventEnabledCreateStickyNoteBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for CreateStickyNoteBegin
//
#define EventWriteCreateStickyNoteBegin()\
        EventEnabledCreateStickyNoteBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &CreateStickyNoteBegin, &CreateStickyNoteId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateStickyNoteEnd
//

#define EventEnabledCreateStickyNoteEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for CreateStickyNoteEnd
//
#define EventWriteCreateStickyNoteEnd()\
        EventEnabledCreateStickyNoteEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &CreateStickyNoteEnd, &CreateStickyNoteId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeleteTextNoteBegin
//

#define EventEnabledDeleteTextNoteBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeleteTextNoteBegin
//
#define EventWriteDeleteTextNoteBegin()\
        EventEnabledDeleteTextNoteBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeleteTextNoteBegin, &DeleteTextNoteId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeleteTextNoteEnd
//

#define EventEnabledDeleteTextNoteEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeleteTextNoteEnd
//
#define EventWriteDeleteTextNoteEnd()\
        EventEnabledDeleteTextNoteEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeleteTextNoteEnd, &DeleteTextNoteId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeleteInkNoteBegin
//

#define EventEnabledDeleteInkNoteBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeleteInkNoteBegin
//
#define EventWriteDeleteInkNoteBegin()\
        EventEnabledDeleteInkNoteBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeleteInkNoteBegin, &DeleteInkNoteId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeleteInkNoteEnd
//

#define EventEnabledDeleteInkNoteEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeleteInkNoteEnd
//
#define EventWriteDeleteInkNoteEnd()\
        EventEnabledDeleteInkNoteEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeleteInkNoteEnd, &DeleteInkNoteId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateHighlightBegin
//

#define EventEnabledCreateHighlightBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for CreateHighlightBegin
//
#define EventWriteCreateHighlightBegin()\
        EventEnabledCreateHighlightBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &CreateHighlightBegin, &CreateHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateHighlightEnd
//

#define EventEnabledCreateHighlightEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for CreateHighlightEnd
//
#define EventWriteCreateHighlightEnd()\
        EventEnabledCreateHighlightEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &CreateHighlightEnd, &CreateHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ClearHighlightBegin
//

#define EventEnabledClearHighlightBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for ClearHighlightBegin
//
#define EventWriteClearHighlightBegin()\
        EventEnabledClearHighlightBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &ClearHighlightBegin, &ClearHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ClearHighlightEnd
//

#define EventEnabledClearHighlightEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for ClearHighlightEnd
//
#define EventWriteClearHighlightEnd()\
        EventEnabledClearHighlightEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &ClearHighlightEnd, &ClearHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for LoadAnnotationsBegin
//

#define EventEnabledLoadAnnotationsBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for LoadAnnotationsBegin
//
#define EventWriteLoadAnnotationsBegin()\
        EventEnabledLoadAnnotationsBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &LoadAnnotationsBegin, &LoadAnnotationsId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for LoadAnnotationsEnd
//

#define EventEnabledLoadAnnotationsEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for LoadAnnotationsEnd
//
#define EventWriteLoadAnnotationsEnd()\
        EventEnabledLoadAnnotationsEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &LoadAnnotationsEnd, &LoadAnnotationsId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAnnotationBegin
//

#define EventEnabledAddAnnotationBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAnnotationBegin
//
#define EventWriteAddAnnotationBegin()\
        EventEnabledAddAnnotationBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAnnotationBegin, &AddAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAnnotationEnd
//

#define EventEnabledAddAnnotationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAnnotationEnd
//
#define EventWriteAddAnnotationEnd()\
        EventEnabledAddAnnotationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAnnotationEnd, &AddAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeleteAnnotationBegin
//

#define EventEnabledDeleteAnnotationBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeleteAnnotationBegin
//
#define EventWriteDeleteAnnotationBegin()\
        EventEnabledDeleteAnnotationBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeleteAnnotationBegin, &DeleteAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeleteAnnotationEnd
//

#define EventEnabledDeleteAnnotationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeleteAnnotationEnd
//
#define EventWriteDeleteAnnotationEnd()\
        EventEnabledDeleteAnnotationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeleteAnnotationEnd, &DeleteAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GetAnnotationByIdBegin
//

#define EventEnabledGetAnnotationByIdBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for GetAnnotationByIdBegin
//
#define EventWriteGetAnnotationByIdBegin()\
        EventEnabledGetAnnotationByIdBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &GetAnnotationByIdBegin, &GetAnnotationByIdId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GetAnnotationByIdEnd
//

#define EventEnabledGetAnnotationByIdEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for GetAnnotationByIdEnd
//
#define EventWriteGetAnnotationByIdEnd()\
        EventEnabledGetAnnotationByIdEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &GetAnnotationByIdEnd, &GetAnnotationByIdId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GetAnnotationByLocBegin
//

#define EventEnabledGetAnnotationByLocBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for GetAnnotationByLocBegin
//
#define EventWriteGetAnnotationByLocBegin()\
        EventEnabledGetAnnotationByLocBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &GetAnnotationByLocBegin, &GetAnnotationByLocId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GetAnnotationByLocEnd
//

#define EventEnabledGetAnnotationByLocEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for GetAnnotationByLocEnd
//
#define EventWriteGetAnnotationByLocEnd()\
        EventEnabledGetAnnotationByLocEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &GetAnnotationByLocEnd, &GetAnnotationByLocId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GetAnnotationsBegin
//

#define EventEnabledGetAnnotationsBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for GetAnnotationsBegin
//
#define EventWriteGetAnnotationsBegin()\
        EventEnabledGetAnnotationsBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &GetAnnotationsBegin, &GetAnnotationsId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for GetAnnotationsEnd
//

#define EventEnabledGetAnnotationsEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for GetAnnotationsEnd
//
#define EventWriteGetAnnotationsEnd()\
        EventEnabledGetAnnotationsEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &GetAnnotationsEnd, &GetAnnotationsId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for SerializeAnnotationBegin
//

#define EventEnabledSerializeAnnotationBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for SerializeAnnotationBegin
//
#define EventWriteSerializeAnnotationBegin()\
        EventEnabledSerializeAnnotationBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &SerializeAnnotationBegin, &SerializeAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for SerializeAnnotationEnd
//

#define EventEnabledSerializeAnnotationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for SerializeAnnotationEnd
//
#define EventWriteSerializeAnnotationEnd()\
        EventEnabledSerializeAnnotationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &SerializeAnnotationEnd, &SerializeAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeserializeAnnotationBegin
//

#define EventEnabledDeserializeAnnotationBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeserializeAnnotationBegin
//
#define EventWriteDeserializeAnnotationBegin()\
        EventEnabledDeserializeAnnotationBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeserializeAnnotationBegin, &DeserializeAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DeserializeAnnotationEnd
//

#define EventEnabledDeserializeAnnotationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for DeserializeAnnotationEnd
//
#define EventWriteDeserializeAnnotationEnd()\
        EventEnabledDeserializeAnnotationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DeserializeAnnotationEnd, &DeserializeAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UpdateAnnotationWithSNCBegin
//

#define EventEnabledUpdateAnnotationWithSNCBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for UpdateAnnotationWithSNCBegin
//
#define EventWriteUpdateAnnotationWithSNCBegin()\
        EventEnabledUpdateAnnotationWithSNCBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &UpdateAnnotationWithSNCBegin, &UpdateAnnotationWithSNCId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UpdateAnnotationWithSNCEnd
//

#define EventEnabledUpdateAnnotationWithSNCEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for UpdateAnnotationWithSNCEnd
//
#define EventWriteUpdateAnnotationWithSNCEnd()\
        EventEnabledUpdateAnnotationWithSNCEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &UpdateAnnotationWithSNCEnd, &UpdateAnnotationWithSNCId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UpdateSNCWithAnnotationBegin
//

#define EventEnabledUpdateSNCWithAnnotationBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for UpdateSNCWithAnnotationBegin
//
#define EventWriteUpdateSNCWithAnnotationBegin()\
        EventEnabledUpdateSNCWithAnnotationBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &UpdateSNCWithAnnotationBegin, &UpdateSNCWithAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UpdateSNCWithAnnotationEnd
//

#define EventEnabledUpdateSNCWithAnnotationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for UpdateSNCWithAnnotationEnd
//
#define EventWriteUpdateSNCWithAnnotationEnd()\
        EventEnabledUpdateSNCWithAnnotationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &UpdateSNCWithAnnotationEnd, &UpdateSNCWithAnnotationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AnnotationTextChangedBegin
//

#define EventEnabledAnnotationTextChangedBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AnnotationTextChangedBegin
//
#define EventWriteAnnotationTextChangedBegin()\
        EventEnabledAnnotationTextChangedBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AnnotationTextChangedBegin, &AnnotationTextChangedId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AnnotationTextChangedEnd
//

#define EventEnabledAnnotationTextChangedEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AnnotationTextChangedEnd
//
#define EventWriteAnnotationTextChangedEnd()\
        EventEnabledAnnotationTextChangedEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AnnotationTextChangedEnd, &AnnotationTextChangedId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AnnotationInkChangedBegin
//

#define EventEnabledAnnotationInkChangedBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AnnotationInkChangedBegin
//
#define EventWriteAnnotationInkChangedBegin()\
        EventEnabledAnnotationInkChangedBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AnnotationInkChangedBegin, &AnnotationInkChangedId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AnnotationInkChangedEnd
//

#define EventEnabledAnnotationInkChangedEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AnnotationInkChangedEnd
//
#define EventWriteAnnotationInkChangedEnd()\
        EventEnabledAnnotationInkChangedEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AnnotationInkChangedEnd, &AnnotationInkChangedId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAttachedSNBegin
//

#define EventEnabledAddAttachedSNBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAttachedSNBegin
//
#define EventWriteAddAttachedSNBegin()\
        EventEnabledAddAttachedSNBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAttachedSNBegin, &AddAttachedSNId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAttachedSNEnd
//

#define EventEnabledAddAttachedSNEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAttachedSNEnd
//
#define EventWriteAddAttachedSNEnd()\
        EventEnabledAddAttachedSNEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAttachedSNEnd, &AddAttachedSNId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RemoveAttachedSNBegin
//

#define EventEnabledRemoveAttachedSNBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for RemoveAttachedSNBegin
//
#define EventWriteRemoveAttachedSNBegin()\
        EventEnabledRemoveAttachedSNBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &RemoveAttachedSNBegin, &RemoveAttachedSNId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RemoveAttachedSNEnd
//

#define EventEnabledRemoveAttachedSNEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for RemoveAttachedSNEnd
//
#define EventWriteRemoveAttachedSNEnd()\
        EventEnabledRemoveAttachedSNEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &RemoveAttachedSNEnd, &RemoveAttachedSNId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAttachedHighlightBegin
//

#define EventEnabledAddAttachedHighlightBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAttachedHighlightBegin
//
#define EventWriteAddAttachedHighlightBegin()\
        EventEnabledAddAttachedHighlightBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAttachedHighlightBegin, &AddAttachedHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAttachedHighlightEnd
//

#define EventEnabledAddAttachedHighlightEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAttachedHighlightEnd
//
#define EventWriteAddAttachedHighlightEnd()\
        EventEnabledAddAttachedHighlightEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAttachedHighlightEnd, &AddAttachedHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RemoveAttachedHighlightBegin
//

#define EventEnabledRemoveAttachedHighlightBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for RemoveAttachedHighlightBegin
//
#define EventWriteRemoveAttachedHighlightBegin()\
        EventEnabledRemoveAttachedHighlightBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &RemoveAttachedHighlightBegin, &RemoveAttachedHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RemoveAttachedHighlightEnd
//

#define EventEnabledRemoveAttachedHighlightEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for RemoveAttachedHighlightEnd
//
#define EventWriteRemoveAttachedHighlightEnd()\
        EventEnabledRemoveAttachedHighlightEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &RemoveAttachedHighlightEnd, &RemoveAttachedHighlightId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAttachedMHBegin
//

#define EventEnabledAddAttachedMHBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAttachedMHBegin
//
#define EventWriteAddAttachedMHBegin()\
        EventEnabledAddAttachedMHBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAttachedMHBegin, &AddAttachedMHId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for AddAttachedMHEnd
//

#define EventEnabledAddAttachedMHEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for AddAttachedMHEnd
//
#define EventWriteAddAttachedMHEnd()\
        EventEnabledAddAttachedMHEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &AddAttachedMHEnd, &AddAttachedMHId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RemoveAttachedMHBegin
//

#define EventEnabledRemoveAttachedMHBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for RemoveAttachedMHBegin
//
#define EventWriteRemoveAttachedMHBegin()\
        EventEnabledRemoveAttachedMHBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &RemoveAttachedMHBegin, &RemoveAttachedMHId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for RemoveAttachedMHEnd
//

#define EventEnabledRemoveAttachedMHEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000040) != 0)

//
// Event Macro for RemoveAttachedMHEnd
//
#define EventWriteRemoveAttachedMHEnd()\
        EventEnabledRemoveAttachedMHEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &RemoveAttachedMHEnd, &RemoveAttachedMHId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseBamlBegin
//

#define EventEnabledWClientParseBamlBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for WClientParseBamlBegin
//
#define EventWriteWClientParseBamlBegin(URI)\
        EventEnabledWClientParseBamlBegin() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseBamlBegin, &WClientParseBamlId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseBamlEnd
//

#define EventEnabledWClientParseBamlEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for WClientParseBamlEnd
//
#define EventWriteWClientParseBamlEnd(URI)\
        EventEnabledWClientParseBamlEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseBamlEnd, &WClientParseBamlId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseXmlBegin
//

#define EventEnabledWClientParseXmlBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientParseXmlBegin
//
#define EventWriteWClientParseXmlBegin(URI)\
        EventEnabledWClientParseXmlBegin() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseXmlBegin, &WClientParseXmlId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseXmlEnd
//

#define EventEnabledWClientParseXmlEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientParseXmlEnd
//
#define EventWriteWClientParseXmlEnd(URI)\
        EventEnabledWClientParseXmlEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseXmlEnd, &WClientParseXmlId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseFefCrInstBegin
//

#define EventEnabledWClientParseFefCrInstBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseFefCrInstBegin
//
#define EventWriteWClientParseFefCrInstBegin()\
        EventEnabledWClientParseFefCrInstBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientParseFefCrInstBegin, &WClientParseFefCrInstId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseFefCrInstEnd
//

#define EventEnabledWClientParseFefCrInstEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseFefCrInstEnd
//
#define EventWriteWClientParseFefCrInstEnd()\
        EventEnabledWClientParseFefCrInstEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientParseFefCrInstEnd, &WClientParseFefCrInstId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseInstVisTreeBegin
//

#define EventEnabledWClientParseInstVisTreeBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseInstVisTreeBegin
//
#define EventWriteWClientParseInstVisTreeBegin()\
        EventEnabledWClientParseInstVisTreeBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientParseInstVisTreeBegin, &WClientParseInstVisTreeId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseInstVisTreeEnd
//

#define EventEnabledWClientParseInstVisTreeEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseInstVisTreeEnd
//
#define EventWriteWClientParseInstVisTreeEnd(Message)\
        EventEnabledWClientParseInstVisTreeEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseInstVisTreeEnd, &WClientParseInstVisTreeId, Message)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseRdrCrInstBegin
//

#define EventEnabledWClientParseRdrCrInstBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseRdrCrInstBegin
//
#define EventWriteWClientParseRdrCrInstBegin()\
        EventEnabledWClientParseRdrCrInstBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientParseRdrCrInstBegin, &WClientParseRdrCrInstId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseRdrCrInstEnd
//

#define EventEnabledWClientParseRdrCrInstEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseRdrCrInstEnd
//
#define EventWriteWClientParseRdrCrInstEnd()\
        EventEnabledWClientParseRdrCrInstEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientParseRdrCrInstEnd, &WClientParseRdrCrInstId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseRdrCrInFTypBegin
//

#define EventEnabledWClientParseRdrCrInFTypBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientParseRdrCrInFTypBegin
//
#define EventWriteWClientParseRdrCrInFTypBegin()\
        EventEnabledWClientParseRdrCrInFTypBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientParseRdrCrInFTypBegin, &WClientParseRdrCrInFTypId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseRdrCrInFTypEnd
//

#define EventEnabledWClientParseRdrCrInFTypEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientParseRdrCrInFTypEnd
//
#define EventWriteWClientParseRdrCrInFTypEnd(Type)\
        EventEnabledWClientParseRdrCrInFTypEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseRdrCrInFTypEnd, &WClientParseRdrCrInFTypId, Type)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceFindBegin
//

#define EventEnabledWClientResourceFindBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for WClientResourceFindBegin
//
#define EventWriteWClientResourceFindBegin(Key)\
        EventEnabledWClientResourceFindBegin() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientResourceFindBegin, &WClientResourceFindId, Key)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceFindEnd
//

#define EventEnabledWClientResourceFindEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for WClientResourceFindEnd
//
#define EventWriteWClientResourceFindEnd()\
        EventEnabledWClientResourceFindEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientResourceFindEnd, &WClientResourceFindId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceCacheValue
//

#define EventEnabledWClientResourceCacheValue() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientResourceCacheValue
//
#define EventWriteWClientResourceCacheValue()\
        EventEnabledWClientResourceCacheValue() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientResourceCacheValue, &WClientResourceCacheValueId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceCacheNull
//

#define EventEnabledWClientResourceCacheNull() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientResourceCacheNull
//
#define EventWriteWClientResourceCacheNull()\
        EventEnabledWClientResourceCacheNull() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientResourceCacheNull, &WClientResourceCacheNullId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceCacheMiss
//

#define EventEnabledWClientResourceCacheMiss() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for WClientResourceCacheMiss
//
#define EventWriteWClientResourceCacheMiss()\
        EventEnabledWClientResourceCacheMiss() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientResourceCacheMiss, &WClientResourceCacheMissId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceStock
//

#define EventEnabledWClientResourceStock() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000080) != 0)

//
// Event Macro for WClientResourceStock
//
#define EventWriteWClientResourceStock(Key)\
        EventEnabledWClientResourceStock() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientResourceStock, &WClientResourceStockId, Key)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientResourceBamlAssembly
//

#define EventEnabledWClientResourceBamlAssembly() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientResourceBamlAssembly
//
#define EventWriteWClientResourceBamlAssembly(AssemblyName)\
        EventEnabledWClientResourceBamlAssembly() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientResourceBamlAssembly, &WClientResourceBamlAssemblyId, AssemblyName)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseXamlBegin
//

#define EventEnabledWClientParseXamlBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientParseXamlBegin
//
#define EventWriteWClientParseXamlBegin(URI)\
        EventEnabledWClientParseXamlBegin() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseXamlBegin, &WClientParseXamlId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseXamlBamlInfo
//

#define EventEnabledWClientParseXamlBamlInfo() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000200) != 0)

//
// Event Macro for WClientParseXamlBamlInfo
//
#define EventWriteWClientParseXamlBamlInfo(PerfElementID, LineNumber, LinePosition)\
        EventEnabledWClientParseXamlBamlInfo() ?\
        MofTemplate_idd(Microsoft_Windows_WPFHandle, &WClientParseXamlBamlInfo, &WClientParseXamlBamlInfoId, PerfElementID, LineNumber, LinePosition)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientParseXamlEnd
//

#define EventEnabledWClientParseXamlEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000100) != 0)

//
// Event Macro for WClientParseXamlEnd
//
#define EventWriteWClientParseXamlEnd(URI)\
        EventEnabledWClientParseXamlEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WClientParseXamlEnd, &WClientParseXamlId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXFlushPageStart
//

#define EventEnabledWClientDRXFlushPageStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXFlushPageStart
//
#define EventWriteWClientDRXFlushPageStart()\
        EventEnabledWClientDRXFlushPageStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXFlushPageStart, &WClientDRXFlushPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXFlushPageStop
//

#define EventEnabledWClientDRXFlushPageStop() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXFlushPageStop
//
#define EventWriteWClientDRXFlushPageStop()\
        EventEnabledWClientDRXFlushPageStop() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXFlushPageStop, &WClientDRXFlushPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSerializeTreeStart
//

#define EventEnabledWClientDRXSerializeTreeStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSerializeTreeStart
//
#define EventWriteWClientDRXSerializeTreeStart()\
        EventEnabledWClientDRXSerializeTreeStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSerializeTreeStart, &WClientDRXSerializeTreeId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSerializeTreeEnd
//

#define EventEnabledWClientDRXSerializeTreeEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSerializeTreeEnd
//
#define EventWriteWClientDRXSerializeTreeEnd()\
        EventEnabledWClientDRXSerializeTreeEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSerializeTreeEnd, &WClientDRXSerializeTreeId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetVisualStart
//

#define EventEnabledWClientDRXGetVisualStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetVisualStart
//
#define EventWriteWClientDRXGetVisualStart()\
        EventEnabledWClientDRXGetVisualStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetVisualStart, &WClientDRXGetVisualId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetVisualEnd
//

#define EventEnabledWClientDRXGetVisualEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetVisualEnd
//
#define EventWriteWClientDRXGetVisualEnd()\
        EventEnabledWClientDRXGetVisualEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetVisualEnd, &WClientDRXGetVisualId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXReleaseWriterStart
//

#define EventEnabledWClientDRXReleaseWriterStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXReleaseWriterStart
//
#define EventWriteWClientDRXReleaseWriterStart()\
        EventEnabledWClientDRXReleaseWriterStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXReleaseWriterStart, &WClientDRXReleaseWriterId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXReleaseWriterEnd
//

#define EventEnabledWClientDRXReleaseWriterEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXReleaseWriterEnd
//
#define EventWriteWClientDRXReleaseWriterEnd()\
        EventEnabledWClientDRXReleaseWriterEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXReleaseWriterEnd, &WClientDRXReleaseWriterId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetPrintCapStart
//

#define EventEnabledWClientDRXGetPrintCapStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetPrintCapStart
//
#define EventWriteWClientDRXGetPrintCapStart()\
        EventEnabledWClientDRXGetPrintCapStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetPrintCapStart, &WClientDRXGetPrintCapId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetPrintCapEnd
//

#define EventEnabledWClientDRXGetPrintCapEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetPrintCapEnd
//
#define EventWriteWClientDRXGetPrintCapEnd()\
        EventEnabledWClientDRXGetPrintCapEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetPrintCapEnd, &WClientDRXGetPrintCapId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXPTProviderStart
//

#define EventEnabledWClientDRXPTProviderStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXPTProviderStart
//
#define EventWriteWClientDRXPTProviderStart()\
        EventEnabledWClientDRXPTProviderStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXPTProviderStart, &WClientDRXPTProviderId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXPTProviderEnd
//

#define EventEnabledWClientDRXPTProviderEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXPTProviderEnd
//
#define EventWriteWClientDRXPTProviderEnd()\
        EventEnabledWClientDRXPTProviderEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXPTProviderEnd, &WClientDRXPTProviderId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXRasterStart
//

#define EventEnabledWClientDRXRasterStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXRasterStart
//
#define EventWriteWClientDRXRasterStart()\
        EventEnabledWClientDRXRasterStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXRasterStart, &WClientDRXRasterId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXRasterEnd
//

#define EventEnabledWClientDRXRasterEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXRasterEnd
//
#define EventWriteWClientDRXRasterEnd()\
        EventEnabledWClientDRXRasterEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXRasterEnd, &WClientDRXRasterId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXOpenPackageBegin
//

#define EventEnabledWClientDRXOpenPackageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXOpenPackageBegin
//
#define EventWriteWClientDRXOpenPackageBegin()\
        EventEnabledWClientDRXOpenPackageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXOpenPackageBegin, &WClientDRXOpenPackageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXOpenPackageEnd
//

#define EventEnabledWClientDRXOpenPackageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXOpenPackageEnd
//
#define EventWriteWClientDRXOpenPackageEnd()\
        EventEnabledWClientDRXOpenPackageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXOpenPackageEnd, &WClientDRXOpenPackageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetStreamBegin
//

#define EventEnabledWClientDRXGetStreamBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetStreamBegin
//
#define EventWriteWClientDRXGetStreamBegin()\
        EventEnabledWClientDRXGetStreamBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetStreamBegin, &WClientDRXGetStreamId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetStreamEnd
//

#define EventEnabledWClientDRXGetStreamEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetStreamEnd
//
#define EventWriteWClientDRXGetStreamEnd()\
        EventEnabledWClientDRXGetStreamEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetStreamEnd, &WClientDRXGetStreamId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXPageVisible
//

#define EventEnabledWClientDRXPageVisible() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXPageVisible
//
#define EventWriteWClientDRXPageVisible(FirstVisiblePage, LastVisiblePage)\
        EventEnabledWClientDRXPageVisible() ?\
        MofTemplate_dd(Microsoft_Windows_WPFHandle, &WClientDRXPageVisible, &WClientDRXPageVisibleId, FirstVisiblePage, LastVisiblePage)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXPageLoaded
//

#define EventEnabledWClientDRXPageLoaded() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXPageLoaded
//
#define EventWriteWClientDRXPageLoaded(PageNumber)\
        EventEnabledWClientDRXPageLoaded() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientDRXPageLoaded, &WClientDRXPageLoadedId, PageNumber)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXInvalidateView
//

#define EventEnabledWClientDRXInvalidateView() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXInvalidateView
//
#define EventWriteWClientDRXInvalidateView()\
        EventEnabledWClientDRXInvalidateView() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXInvalidateView, &WClientDRXInvalidateViewId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXStyleCreated
//

#define EventEnabledWClientDRXStyleCreated() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXStyleCreated
//
#define EventWriteWClientDRXStyleCreated()\
        EventEnabledWClientDRXStyleCreated() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXStyleCreated, &WClientDRXStyleCreatedId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXFindBegin
//

#define EventEnabledWClientDRXFindBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXFindBegin
//
#define EventWriteWClientDRXFindBegin()\
        EventEnabledWClientDRXFindBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXFindBegin, &WClientDRXFindId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXFindEnd
//

#define EventEnabledWClientDRXFindEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXFindEnd
//
#define EventWriteWClientDRXFindEnd()\
        EventEnabledWClientDRXFindEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXFindEnd, &WClientDRXFindId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXZoom
//

#define EventEnabledWClientDRXZoom() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXZoom
//
#define EventWriteWClientDRXZoom(Zoom)\
        EventEnabledWClientDRXZoom() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientDRXZoom, &WClientDRXZoomId, Zoom)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXEnsureOMBegin
//

#define EventEnabledWClientDRXEnsureOMBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXEnsureOMBegin
//
#define EventWriteWClientDRXEnsureOMBegin()\
        EventEnabledWClientDRXEnsureOMBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXEnsureOMBegin, &WClientDRXEnsureOMId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXEnsureOMEnd
//

#define EventEnabledWClientDRXEnsureOMEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXEnsureOMEnd
//
#define EventWriteWClientDRXEnsureOMEnd()\
        EventEnabledWClientDRXEnsureOMEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXEnsureOMEnd, &WClientDRXEnsureOMId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXTreeFlattenBegin
//

#define EventEnabledWClientDRXTreeFlattenBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXTreeFlattenBegin
//
#define EventWriteWClientDRXTreeFlattenBegin()\
        EventEnabledWClientDRXTreeFlattenBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXTreeFlattenBegin, &WClientDRXTreeFlattenId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXTreeFlattenEnd
//

#define EventEnabledWClientDRXTreeFlattenEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXTreeFlattenEnd
//
#define EventWriteWClientDRXTreeFlattenEnd()\
        EventEnabledWClientDRXTreeFlattenEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXTreeFlattenEnd, &WClientDRXTreeFlattenId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXAlphaFlattenBegin
//

#define EventEnabledWClientDRXAlphaFlattenBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXAlphaFlattenBegin
//
#define EventWriteWClientDRXAlphaFlattenBegin()\
        EventEnabledWClientDRXAlphaFlattenBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXAlphaFlattenBegin, &WClientDRXAlphaFlattenId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXAlphaFlattenEnd
//

#define EventEnabledWClientDRXAlphaFlattenEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXAlphaFlattenEnd
//
#define EventWriteWClientDRXAlphaFlattenEnd()\
        EventEnabledWClientDRXAlphaFlattenEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXAlphaFlattenEnd, &WClientDRXAlphaFlattenId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetDevModeBegin
//

#define EventEnabledWClientDRXGetDevModeBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetDevModeBegin
//
#define EventWriteWClientDRXGetDevModeBegin()\
        EventEnabledWClientDRXGetDevModeBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetDevModeBegin, &WClientDRXGetDevModeId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetDevModeEnd
//

#define EventEnabledWClientDRXGetDevModeEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetDevModeEnd
//
#define EventWriteWClientDRXGetDevModeEnd()\
        EventEnabledWClientDRXGetDevModeEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetDevModeEnd, &WClientDRXGetDevModeId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXStartDocBegin
//

#define EventEnabledWClientDRXStartDocBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXStartDocBegin
//
#define EventWriteWClientDRXStartDocBegin()\
        EventEnabledWClientDRXStartDocBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXStartDocBegin, &WClientDRXStartDocId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXStartDocEnd
//

#define EventEnabledWClientDRXStartDocEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXStartDocEnd
//
#define EventWriteWClientDRXStartDocEnd()\
        EventEnabledWClientDRXStartDocEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXStartDocEnd, &WClientDRXStartDocId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXEndDocBegin
//

#define EventEnabledWClientDRXEndDocBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXEndDocBegin
//
#define EventWriteWClientDRXEndDocBegin()\
        EventEnabledWClientDRXEndDocBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXEndDocBegin, &WClientDRXEndDocId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXEndDocEnd
//

#define EventEnabledWClientDRXEndDocEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXEndDocEnd
//
#define EventWriteWClientDRXEndDocEnd()\
        EventEnabledWClientDRXEndDocEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXEndDocEnd, &WClientDRXEndDocId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXStartPageBegin
//

#define EventEnabledWClientDRXStartPageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXStartPageBegin
//
#define EventWriteWClientDRXStartPageBegin()\
        EventEnabledWClientDRXStartPageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXStartPageBegin, &WClientDRXStartPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXStartPageEnd
//

#define EventEnabledWClientDRXStartPageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXStartPageEnd
//
#define EventWriteWClientDRXStartPageEnd()\
        EventEnabledWClientDRXStartPageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXStartPageEnd, &WClientDRXStartPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXEndPageBegin
//

#define EventEnabledWClientDRXEndPageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXEndPageBegin
//
#define EventWriteWClientDRXEndPageBegin()\
        EventEnabledWClientDRXEndPageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXEndPageBegin, &WClientDRXEndPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXEndPageEnd
//

#define EventEnabledWClientDRXEndPageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXEndPageEnd
//
#define EventWriteWClientDRXEndPageEnd()\
        EventEnabledWClientDRXEndPageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXEndPageEnd, &WClientDRXEndPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXCommitPageBegin
//

#define EventEnabledWClientDRXCommitPageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXCommitPageBegin
//
#define EventWriteWClientDRXCommitPageBegin()\
        EventEnabledWClientDRXCommitPageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXCommitPageBegin, &WClientDRXCommitPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXCommitPageEnd
//

#define EventEnabledWClientDRXCommitPageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXCommitPageEnd
//
#define EventWriteWClientDRXCommitPageEnd()\
        EventEnabledWClientDRXCommitPageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXCommitPageEnd, &WClientDRXCommitPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXConvertFontBegin
//

#define EventEnabledWClientDRXConvertFontBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXConvertFontBegin
//
#define EventWriteWClientDRXConvertFontBegin()\
        EventEnabledWClientDRXConvertFontBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXConvertFontBegin, &WClientDRXConvertFontId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXConvertFontEnd
//

#define EventEnabledWClientDRXConvertFontEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXConvertFontEnd
//
#define EventWriteWClientDRXConvertFontEnd()\
        EventEnabledWClientDRXConvertFontEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXConvertFontEnd, &WClientDRXConvertFontId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXConvertImageBegin
//

#define EventEnabledWClientDRXConvertImageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXConvertImageBegin
//
#define EventWriteWClientDRXConvertImageBegin()\
        EventEnabledWClientDRXConvertImageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXConvertImageBegin, &WClientDRXConvertImageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXConvertImageEnd
//

#define EventEnabledWClientDRXConvertImageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXConvertImageEnd
//
#define EventWriteWClientDRXConvertImageEnd()\
        EventEnabledWClientDRXConvertImageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXConvertImageEnd, &WClientDRXConvertImageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSaveXpsBegin
//

#define EventEnabledWClientDRXSaveXpsBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSaveXpsBegin
//
#define EventWriteWClientDRXSaveXpsBegin()\
        EventEnabledWClientDRXSaveXpsBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSaveXpsBegin, &WClientDRXSaveXpsId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSaveXpsEnd
//

#define EventEnabledWClientDRXSaveXpsEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSaveXpsEnd
//
#define EventWriteWClientDRXSaveXpsEnd()\
        EventEnabledWClientDRXSaveXpsEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSaveXpsEnd, &WClientDRXSaveXpsId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXLoadPrimitiveBegin
//

#define EventEnabledWClientDRXLoadPrimitiveBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXLoadPrimitiveBegin
//
#define EventWriteWClientDRXLoadPrimitiveBegin()\
        EventEnabledWClientDRXLoadPrimitiveBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXLoadPrimitiveBegin, &WClientDRXLoadPrimitiveId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXLoadPrimitiveEnd
//

#define EventEnabledWClientDRXLoadPrimitiveEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXLoadPrimitiveEnd
//
#define EventWriteWClientDRXLoadPrimitiveEnd()\
        EventEnabledWClientDRXLoadPrimitiveEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXLoadPrimitiveEnd, &WClientDRXLoadPrimitiveId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSavePageBegin
//

#define EventEnabledWClientDRXSavePageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSavePageBegin
//
#define EventWriteWClientDRXSavePageBegin()\
        EventEnabledWClientDRXSavePageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSavePageBegin, &WClientDRXSavePageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSavePageEnd
//

#define EventEnabledWClientDRXSavePageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSavePageEnd
//
#define EventWriteWClientDRXSavePageEnd()\
        EventEnabledWClientDRXSavePageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSavePageEnd, &WClientDRXSavePageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSerializationBegin
//

#define EventEnabledWClientDRXSerializationBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSerializationBegin
//
#define EventWriteWClientDRXSerializationBegin()\
        EventEnabledWClientDRXSerializationBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSerializationBegin, &WClientDRXSerializationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXSerializationEnd
//

#define EventEnabledWClientDRXSerializationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXSerializationEnd
//
#define EventWriteWClientDRXSerializationEnd()\
        EventEnabledWClientDRXSerializationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXSerializationEnd, &WClientDRXSerializationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXReadStreamBegin
//

#define EventEnabledWClientDRXReadStreamBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000800) != 0)

//
// Event Macro for WClientDRXReadStreamBegin
//
#define EventWriteWClientDRXReadStreamBegin(Count)\
        EventEnabledWClientDRXReadStreamBegin() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientDRXReadStreamBegin, &WClientDRXReadStreamId, Count)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXReadStreamEnd
//

#define EventEnabledWClientDRXReadStreamEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000800) != 0)

//
// Event Macro for WClientDRXReadStreamEnd
//
#define EventWriteWClientDRXReadStreamEnd(Result)\
        EventEnabledWClientDRXReadStreamEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientDRXReadStreamEnd, &WClientDRXReadStreamId, Result)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetPageBegin
//

#define EventEnabledWClientDRXGetPageBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetPageBegin
//
#define EventWriteWClientDRXGetPageBegin()\
        EventEnabledWClientDRXGetPageBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetPageBegin, &WClientDRXGetPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXGetPageEnd
//

#define EventEnabledWClientDRXGetPageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXGetPageEnd
//
#define EventWriteWClientDRXGetPageEnd()\
        EventEnabledWClientDRXGetPageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXGetPageEnd, &WClientDRXGetPageId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXLineDown
//

#define EventEnabledWClientDRXLineDown() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXLineDown
//
#define EventWriteWClientDRXLineDown(VerticalOffset)\
        EventEnabledWClientDRXLineDown() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientDRXLineDown, &WClientDRXLineDownId, VerticalOffset)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXPageDown
//

#define EventEnabledWClientDRXPageDown() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXPageDown
//
#define EventWriteWClientDRXPageDown(VerticalOffset)\
        EventEnabledWClientDRXPageDown() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientDRXPageDown, &WClientDRXPageDownId, VerticalOffset)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXPageJump
//

#define EventEnabledWClientDRXPageJump() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXPageJump
//
#define EventWriteWClientDRXPageJump(PageNumber, FirstVisiblePage)\
        EventEnabledWClientDRXPageJump() ?\
        MofTemplate_dd(Microsoft_Windows_WPFHandle, &WClientDRXPageJump, &WClientDRXPageJumpId, PageNumber, FirstVisiblePage)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXLayoutBegin
//

#define EventEnabledWClientDRXLayoutBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXLayoutBegin
//
#define EventWriteWClientDRXLayoutBegin()\
        EventEnabledWClientDRXLayoutBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXLayoutBegin, &WClientDRXLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXLayoutEnd
//

#define EventEnabledWClientDRXLayoutEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXLayoutEnd
//
#define EventWriteWClientDRXLayoutEnd()\
        EventEnabledWClientDRXLayoutEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXLayoutEnd, &WClientDRXLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDRXInstantiated
//

#define EventEnabledWClientDRXInstantiated() ((Microsoft_Windows_WPFEnableBits[0] & 0x00000400) != 0)

//
// Event Macro for WClientDRXInstantiated
//
#define EventWriteWClientDRXInstantiated()\
        EventEnabledWClientDRXInstantiated() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientDRXInstantiated, &WClientDRXInstantiatedId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientTimeManagerTickBegin
//

#define EventEnabledWClientTimeManagerTickBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00001000) != 0)

//
// Event Macro for WClientTimeManagerTickBegin
//
#define EventWriteWClientTimeManagerTickBegin(TickTime)\
        EventEnabledWClientTimeManagerTickBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientTimeManagerTickBegin, &WClientTimeManagerTickId, TickTime)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientTimeManagerTickEnd
//

#define EventEnabledWClientTimeManagerTickEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00001000) != 0)

//
// Event Macro for WClientTimeManagerTickEnd
//
#define EventWriteWClientTimeManagerTickEnd()\
        EventEnabledWClientTimeManagerTickEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientTimeManagerTickEnd, &WClientTimeManagerTickId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutBegin
//

#define EventEnabledWClientLayoutBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientLayoutBegin
//
#define EventWriteWClientLayoutBegin(Id, source)\
        EventEnabledWClientLayoutBegin() ?\
        MofTemplate_ic(Microsoft_Windows_WPFHandle, &WClientLayoutBegin, &WClientLayoutId, Id, source)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutEnd
//

#define EventEnabledWClientLayoutEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientLayoutEnd
//
#define EventWriteWClientLayoutEnd()\
        EventEnabledWClientLayoutEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutEnd, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMeasureBegin
//

#define EventEnabledWClientMeasureBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientMeasureBegin
//
#define EventWriteWClientMeasureBegin(Id)\
        EventEnabledWClientMeasureBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientMeasureBegin, &WClientMeasureId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMeasureAbort
//

#define EventEnabledWClientMeasureAbort() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientMeasureAbort
//
#define EventWriteWClientMeasureAbort(LoopDurationMS, loopCounter)\
        EventEnabledWClientMeasureAbort() ?\
        MofTemplate_dd(Microsoft_Windows_WPFHandle, &WClientMeasureAbort, &WClientMeasureId, LoopDurationMS, loopCounter)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMeasureEnd
//

#define EventEnabledWClientMeasureEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientMeasureEnd
//
#define EventWriteWClientMeasureEnd(Count)\
        EventEnabledWClientMeasureEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientMeasureEnd, &WClientMeasureId, Count)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMeasureElementBegin
//

#define EventEnabledWClientMeasureElementBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientMeasureElementBegin
//
#define EventWriteWClientMeasureElementBegin(Id, Width, Height)\
        EventEnabledWClientMeasureElementBegin() ?\
        MofTemplate_igg(Microsoft_Windows_WPFHandle, &WClientMeasureElementBegin, &WClientMeasureId, Id, Width, Height)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMeasureElementEnd
//

#define EventEnabledWClientMeasureElementEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientMeasureElementEnd
//
#define EventWriteWClientMeasureElementEnd(Id, Width, Height)\
        EventEnabledWClientMeasureElementEnd() ?\
        MofTemplate_igg(Microsoft_Windows_WPFHandle, &WClientMeasureElementEnd, &WClientMeasureId, Id, Width, Height)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientArrangeBegin
//

#define EventEnabledWClientArrangeBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientArrangeBegin
//
#define EventWriteWClientArrangeBegin(Id)\
        EventEnabledWClientArrangeBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientArrangeBegin, &WClientArrangeId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientArrangeAbort
//

#define EventEnabledWClientArrangeAbort() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientArrangeAbort
//
#define EventWriteWClientArrangeAbort(LoopDurationMS, loopCounter)\
        EventEnabledWClientArrangeAbort() ?\
        MofTemplate_dd(Microsoft_Windows_WPFHandle, &WClientArrangeAbort, &WClientArrangeId, LoopDurationMS, loopCounter)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientArrangeEnd
//

#define EventEnabledWClientArrangeEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientArrangeEnd
//
#define EventWriteWClientArrangeEnd(Count)\
        EventEnabledWClientArrangeEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientArrangeEnd, &WClientArrangeId, Count)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientArrangeElementBegin
//

#define EventEnabledWClientArrangeElementBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientArrangeElementBegin
//
#define EventWriteWClientArrangeElementBegin(Id, Top, Left, Width, Height)\
        EventEnabledWClientArrangeElementBegin() ?\
        MofTemplate_igggg(Microsoft_Windows_WPFHandle, &WClientArrangeElementBegin, &WClientArrangeId, Id, Top, Left, Width, Height)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientArrangeElementEnd
//

#define EventEnabledWClientArrangeElementEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientArrangeElementEnd
//
#define EventWriteWClientArrangeElementEnd(Id, Top, Left, Width, Height)\
        EventEnabledWClientArrangeElementEnd() ?\
        MofTemplate_igggg(Microsoft_Windows_WPFHandle, &WClientArrangeElementEnd, &WClientArrangeId, Id, Top, Left, Width, Height)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutAbort
//

#define EventEnabledWClientLayoutAbort() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientLayoutAbort
//
#define EventWriteWClientLayoutAbort(LoopDurationMS, loopCounter)\
        EventEnabledWClientLayoutAbort() ?\
        MofTemplate_dd(Microsoft_Windows_WPFHandle, &WClientLayoutAbort, &WClientLayoutId, LoopDurationMS, loopCounter)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutFireSizeChangedBegin
//

#define EventEnabledWClientLayoutFireSizeChangedBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutFireSizeChangedBegin
//
#define EventWriteWClientLayoutFireSizeChangedBegin()\
        EventEnabledWClientLayoutFireSizeChangedBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutFireSizeChangedBegin, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutFireSizeChangedEnd
//

#define EventEnabledWClientLayoutFireSizeChangedEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutFireSizeChangedEnd
//
#define EventWriteWClientLayoutFireSizeChangedEnd()\
        EventEnabledWClientLayoutFireSizeChangedEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutFireSizeChangedEnd, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutFireLayoutUpdatedBegin
//

#define EventEnabledWClientLayoutFireLayoutUpdatedBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutFireLayoutUpdatedBegin
//
#define EventWriteWClientLayoutFireLayoutUpdatedBegin()\
        EventEnabledWClientLayoutFireLayoutUpdatedBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutFireLayoutUpdatedBegin, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutFireLayoutUpdatedEnd
//

#define EventEnabledWClientLayoutFireLayoutUpdatedEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutFireLayoutUpdatedEnd
//
#define EventWriteWClientLayoutFireLayoutUpdatedEnd()\
        EventEnabledWClientLayoutFireLayoutUpdatedEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutFireLayoutUpdatedEnd, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutFireAutomationEventsBegin
//

#define EventEnabledWClientLayoutFireAutomationEventsBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutFireAutomationEventsBegin
//
#define EventWriteWClientLayoutFireAutomationEventsBegin()\
        EventEnabledWClientLayoutFireAutomationEventsBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutFireAutomationEventsBegin, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutFireAutomationEventsEnd
//

#define EventEnabledWClientLayoutFireAutomationEventsEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutFireAutomationEventsEnd
//
#define EventWriteWClientLayoutFireAutomationEventsEnd()\
        EventEnabledWClientLayoutFireAutomationEventsEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientLayoutFireAutomationEventsEnd, &WClientLayoutId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutException
//

#define EventEnabledWClientLayoutException() ((Microsoft_Windows_WPFEnableBits[0] & 0x00002000) != 0)

//
// Event Macro for WClientLayoutException
//
#define EventWriteWClientLayoutException(Id)\
        EventEnabledWClientLayoutException() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientLayoutException, &WClientLayoutId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientLayoutInvalidated
//

#define EventEnabledWClientLayoutInvalidated() ((Microsoft_Windows_WPFEnableBits[0] & 0x00004000) != 0)

//
// Event Macro for WClientLayoutInvalidated
//
#define EventWriteWClientLayoutInvalidated(Id)\
        EventEnabledWClientLayoutInvalidated() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientLayoutInvalidated, &WClientLayoutId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_WinMainStart
//

#define EventEnabledWpfHostUm_WinMainStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_WinMainStart
//
#define EventWriteWpfHostUm_WinMainStart()\
        EventEnabledWpfHostUm_WinMainStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_WinMainStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_WinMainEnd
//

#define EventEnabledWpfHostUm_WinMainEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_WinMainEnd
//
#define EventWriteWpfHostUm_WinMainEnd(ReturnCode)\
        EventEnabledWpfHostUm_WinMainEnd() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WpfHostUm_WinMainEnd, &WpfHostUmId, ReturnCode)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_InvokingBrowser
//

#define EventEnabledWpfHostUm_InvokingBrowser() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_InvokingBrowser
//
#define EventWriteWpfHostUm_InvokingBrowser(URL)\
        EventEnabledWpfHostUm_InvokingBrowser() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_InvokingBrowser, &WpfHostUmId, URL)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_LaunchingRestrictedProcess
//

#define EventEnabledWpfHostUm_LaunchingRestrictedProcess() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_LaunchingRestrictedProcess
//
#define EventWriteWpfHostUm_LaunchingRestrictedProcess()\
        EventEnabledWpfHostUm_LaunchingRestrictedProcess() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_LaunchingRestrictedProcess, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_EnteringMessageLoop
//

#define EventEnabledWpfHostUm_EnteringMessageLoop() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_EnteringMessageLoop
//
#define EventWriteWpfHostUm_EnteringMessageLoop()\
        EventEnabledWpfHostUm_EnteringMessageLoop() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_EnteringMessageLoop, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ClassFactoryCreateInstance
//

#define EventEnabledWpfHostUm_ClassFactoryCreateInstance() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ClassFactoryCreateInstance
//
#define EventWriteWpfHostUm_ClassFactoryCreateInstance()\
        EventEnabledWpfHostUm_ClassFactoryCreateInstance() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_ClassFactoryCreateInstance, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ReadingDeplManifestStart
//

#define EventEnabledWpfHostUm_ReadingDeplManifestStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ReadingDeplManifestStart
//
#define EventWriteWpfHostUm_ReadingDeplManifestStart(URL)\
        EventEnabledWpfHostUm_ReadingDeplManifestStart() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_ReadingDeplManifestStart, &WpfHostUmId, URL)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ReadingDeplManifestEnd
//

#define EventEnabledWpfHostUm_ReadingDeplManifestEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ReadingDeplManifestEnd
//
#define EventWriteWpfHostUm_ReadingDeplManifestEnd(URL)\
        EventEnabledWpfHostUm_ReadingDeplManifestEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_ReadingDeplManifestEnd, &WpfHostUmId, URL)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ReadingAppManifestStart
//

#define EventEnabledWpfHostUm_ReadingAppManifestStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_ReadingAppManifestStart
//
#define EventWriteWpfHostUm_ReadingAppManifestStart(URL)\
        EventEnabledWpfHostUm_ReadingAppManifestStart() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_ReadingAppManifestStart, &WpfHostUmId, URL)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ReadingAppManifestEnd
//

#define EventEnabledWpfHostUm_ReadingAppManifestEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_ReadingAppManifestEnd
//
#define EventWriteWpfHostUm_ReadingAppManifestEnd()\
        EventEnabledWpfHostUm_ReadingAppManifestEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_ReadingAppManifestEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ParsingMarkupVersionStart
//

#define EventEnabledWpfHostUm_ParsingMarkupVersionStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ParsingMarkupVersionStart
//
#define EventWriteWpfHostUm_ParsingMarkupVersionStart()\
        EventEnabledWpfHostUm_ParsingMarkupVersionStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_ParsingMarkupVersionStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ParsingMarkupVersionEnd
//

#define EventEnabledWpfHostUm_ParsingMarkupVersionEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ParsingMarkupVersionEnd
//
#define EventWriteWpfHostUm_ParsingMarkupVersionEnd()\
        EventEnabledWpfHostUm_ParsingMarkupVersionEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_ParsingMarkupVersionEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_IPersistFileLoad
//

#define EventEnabledWpfHostUm_IPersistFileLoad() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_IPersistFileLoad
//
#define EventWriteWpfHostUm_IPersistFileLoad(URL)\
        EventEnabledWpfHostUm_IPersistFileLoad() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_IPersistFileLoad, &WpfHostUmId, URL)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_IPersistMonikerLoadStart
//

#define EventEnabledWpfHostUm_IPersistMonikerLoadStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_IPersistMonikerLoadStart
//
#define EventWriteWpfHostUm_IPersistMonikerLoadStart()\
        EventEnabledWpfHostUm_IPersistMonikerLoadStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_IPersistMonikerLoadStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_IPersistMonikerLoadEnd
//

#define EventEnabledWpfHostUm_IPersistMonikerLoadEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_IPersistMonikerLoadEnd
//
#define EventWriteWpfHostUm_IPersistMonikerLoadEnd(ReturnCode)\
        EventEnabledWpfHostUm_IPersistMonikerLoadEnd() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WpfHostUm_IPersistMonikerLoadEnd, &WpfHostUmId, ReturnCode)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_BindProgress
//

#define EventEnabledWpfHostUm_BindProgress() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_BindProgress
//
#define EventWriteWpfHostUm_BindProgress(Code, Text)\
        EventEnabledWpfHostUm_BindProgress() ?\
        MofTemplate_qz(Microsoft_Windows_WPFHandle, &WpfHostUm_BindProgress, &WpfHostUmId, Code, Text)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_OnStopBinding
//

#define EventEnabledWpfHostUm_OnStopBinding() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_OnStopBinding
//
#define EventWriteWpfHostUm_OnStopBinding(ReturnCode)\
        EventEnabledWpfHostUm_OnStopBinding() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WpfHostUm_OnStopBinding, &WpfHostUmId, ReturnCode)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_VersionAttach
//

#define EventEnabledWpfHostUm_VersionAttach() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_VersionAttach
//
#define EventWriteWpfHostUm_VersionAttach()\
        EventEnabledWpfHostUm_VersionAttach() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_VersionAttach, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_VersionActivateStart
//

#define EventEnabledWpfHostUm_VersionActivateStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_VersionActivateStart
//
#define EventWriteWpfHostUm_VersionActivateStart()\
        EventEnabledWpfHostUm_VersionActivateStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_VersionActivateStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_VersionActivateEnd
//

#define EventEnabledWpfHostUm_VersionActivateEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_VersionActivateEnd
//
#define EventWriteWpfHostUm_VersionActivateEnd()\
        EventEnabledWpfHostUm_VersionActivateEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_VersionActivateEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_StartingCLRStart
//

#define EventEnabledWpfHostUm_StartingCLRStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_StartingCLRStart
//
#define EventWriteWpfHostUm_StartingCLRStart()\
        EventEnabledWpfHostUm_StartingCLRStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_StartingCLRStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_StartingCLREnd
//

#define EventEnabledWpfHostUm_StartingCLREnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_StartingCLREnd
//
#define EventWriteWpfHostUm_StartingCLREnd()\
        EventEnabledWpfHostUm_StartingCLREnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_StartingCLREnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_IHlinkTargetNavigateStart
//

#define EventEnabledWpfHostUm_IHlinkTargetNavigateStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_IHlinkTargetNavigateStart
//
#define EventWriteWpfHostUm_IHlinkTargetNavigateStart(Location)\
        EventEnabledWpfHostUm_IHlinkTargetNavigateStart() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_IHlinkTargetNavigateStart, &WpfHostUmId, Location)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_IHlinkTargetNavigateEnd
//

#define EventEnabledWpfHostUm_IHlinkTargetNavigateEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_IHlinkTargetNavigateEnd
//
#define EventWriteWpfHostUm_IHlinkTargetNavigateEnd()\
        EventEnabledWpfHostUm_IHlinkTargetNavigateEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_IHlinkTargetNavigateEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ReadyStateChanged
//

#define EventEnabledWpfHostUm_ReadyStateChanged() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ReadyStateChanged
//
#define EventWriteWpfHostUm_ReadyStateChanged(State)\
        EventEnabledWpfHostUm_ReadyStateChanged() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WpfHostUm_ReadyStateChanged, &WpfHostUmId, State)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_InitDocHostStart
//

#define EventEnabledWpfHostUm_InitDocHostStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_InitDocHostStart
//
#define EventWriteWpfHostUm_InitDocHostStart()\
        EventEnabledWpfHostUm_InitDocHostStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_InitDocHostStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_InitDocHostEnd
//

#define EventEnabledWpfHostUm_InitDocHostEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_InitDocHostEnd
//
#define EventWriteWpfHostUm_InitDocHostEnd()\
        EventEnabledWpfHostUm_InitDocHostEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_InitDocHostEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_MergingMenusStart
//

#define EventEnabledWpfHostUm_MergingMenusStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_MergingMenusStart
//
#define EventWriteWpfHostUm_MergingMenusStart()\
        EventEnabledWpfHostUm_MergingMenusStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_MergingMenusStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_MergingMenusEnd
//

#define EventEnabledWpfHostUm_MergingMenusEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_MergingMenusEnd
//
#define EventWriteWpfHostUm_MergingMenusEnd()\
        EventEnabledWpfHostUm_MergingMenusEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_MergingMenusEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_UIActivationStart
//

#define EventEnabledWpfHostUm_UIActivationStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_UIActivationStart
//
#define EventWriteWpfHostUm_UIActivationStart()\
        EventEnabledWpfHostUm_UIActivationStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_UIActivationStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_UIActivationEnd
//

#define EventEnabledWpfHostUm_UIActivationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_UIActivationEnd
//
#define EventWriteWpfHostUm_UIActivationEnd()\
        EventEnabledWpfHostUm_UIActivationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_UIActivationEnd, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_LoadingResourceDLLStart
//

#define EventEnabledWpfHostUm_LoadingResourceDLLStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHostUm_LoadingResourceDLLStart
//
#define EventWriteWpfHostUm_LoadingResourceDLLStart()\
        EventEnabledWpfHostUm_LoadingResourceDLLStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_LoadingResourceDLLStart, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_LoadingResourceDLLEnd
//

#define EventEnabledWpfHostUm_LoadingResourceDLLEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHostUm_LoadingResourceDLLEnd
//
#define EventWriteWpfHostUm_LoadingResourceDLLEnd(URL)\
        EventEnabledWpfHostUm_LoadingResourceDLLEnd() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_LoadingResourceDLLEnd, &WpfHostUmId, URL)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_OleCmdQueryStatusStart
//

#define EventEnabledWpfHostUm_OleCmdQueryStatusStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_OleCmdQueryStatusStart
//
#define EventWriteWpfHostUm_OleCmdQueryStatusStart(GUID_Data1, CmdId)\
        EventEnabledWpfHostUm_OleCmdQueryStatusStart() ?\
        MofTemplate_qq(Microsoft_Windows_WPFHandle, &WpfHostUm_OleCmdQueryStatusStart, &WpfHostUmId, GUID_Data1, CmdId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_OleCmdQueryStatusEnd
//

#define EventEnabledWpfHostUm_OleCmdQueryStatusEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_OleCmdQueryStatusEnd
//
#define EventWriteWpfHostUm_OleCmdQueryStatusEnd(CmdFlags, HResult)\
        EventEnabledWpfHostUm_OleCmdQueryStatusEnd() ?\
        MofTemplate_qq(Microsoft_Windows_WPFHandle, &WpfHostUm_OleCmdQueryStatusEnd, &WpfHostUmId, CmdFlags, HResult)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_OleCmdExecStart
//

#define EventEnabledWpfHostUm_OleCmdExecStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_OleCmdExecStart
//
#define EventWriteWpfHostUm_OleCmdExecStart(GUID_Data1, CmdId)\
        EventEnabledWpfHostUm_OleCmdExecStart() ?\
        MofTemplate_qq(Microsoft_Windows_WPFHandle, &WpfHostUm_OleCmdExecStart, &WpfHostUmId, GUID_Data1, CmdId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_OleCmdExecEnd
//

#define EventEnabledWpfHostUm_OleCmdExecEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_OleCmdExecEnd
//
#define EventWriteWpfHostUm_OleCmdExecEnd(ReturnCode)\
        EventEnabledWpfHostUm_OleCmdExecEnd() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WpfHostUm_OleCmdExecEnd, &WpfHostUmId, ReturnCode)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_ProgressPageShown
//

#define EventEnabledWpfHostUm_ProgressPageShown() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_ProgressPageShown
//
#define EventWriteWpfHostUm_ProgressPageShown()\
        EventEnabledWpfHostUm_ProgressPageShown() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_ProgressPageShown, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_AdHocProfile1Start
//

#define EventEnabledWpfHostUm_AdHocProfile1Start() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_AdHocProfile1Start
//
#define EventWriteWpfHostUm_AdHocProfile1Start()\
        EventEnabledWpfHostUm_AdHocProfile1Start() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_AdHocProfile1Start, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_AdHocProfile1End
//

#define EventEnabledWpfHostUm_AdHocProfile1End() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_AdHocProfile1End
//
#define EventWriteWpfHostUm_AdHocProfile1End()\
        EventEnabledWpfHostUm_AdHocProfile1End() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_AdHocProfile1End, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_AdHocProfile2Start
//

#define EventEnabledWpfHostUm_AdHocProfile2Start() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHostUm_AdHocProfile2Start
//
#define EventWriteWpfHostUm_AdHocProfile2Start(Location)\
        EventEnabledWpfHostUm_AdHocProfile2Start() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHostUm_AdHocProfile2Start, &WpfHostUmId, Location)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHostUm_AdHocProfile2End
//

#define EventEnabledWpfHostUm_AdHocProfile2End() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHostUm_AdHocProfile2End
//
#define EventWriteWpfHostUm_AdHocProfile2End()\
        EventEnabledWpfHostUm_AdHocProfile2End() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHostUm_AdHocProfile2End, &WpfHostUmId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DocObjHostCreated
//

#define EventEnabledWpfHost_DocObjHostCreated() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_DocObjHostCreated
//
#define EventWriteWpfHost_DocObjHostCreated()\
        EventEnabledWpfHost_DocObjHostCreated() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DocObjHostCreated, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_XappLauncherAppStartup
//

#define EventEnabledWpfHost_XappLauncherAppStartup() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_XappLauncherAppStartup
//
#define EventWriteWpfHost_XappLauncherAppStartup()\
        EventEnabledWpfHost_XappLauncherAppStartup() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_XappLauncherAppStartup, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_XappLauncherAppExit
//

#define EventEnabledWpfHost_XappLauncherAppExit() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_XappLauncherAppExit
//
#define EventWriteWpfHost_XappLauncherAppExit(AttemptDownload)\
        EventEnabledWpfHost_XappLauncherAppExit() ?\
        MofTemplate_c(Microsoft_Windows_WPFHandle, &WpfHost_XappLauncherAppExit, &WpfHostId, AttemptDownload)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DocObjHostRunApplicationStart
//

#define EventEnabledWpfHost_DocObjHostRunApplicationStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_DocObjHostRunApplicationStart
//
#define EventWriteWpfHost_DocObjHostRunApplicationStart()\
        EventEnabledWpfHost_DocObjHostRunApplicationStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DocObjHostRunApplicationStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DocObjHostRunApplicationEnd
//

#define EventEnabledWpfHost_DocObjHostRunApplicationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_DocObjHostRunApplicationEnd
//
#define EventWriteWpfHost_DocObjHostRunApplicationEnd()\
        EventEnabledWpfHost_DocObjHostRunApplicationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DocObjHostRunApplicationEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_ClickOnceActivationStart
//

#define EventEnabledWpfHost_ClickOnceActivationStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_ClickOnceActivationStart
//
#define EventWriteWpfHost_ClickOnceActivationStart(Direct)\
        EventEnabledWpfHost_ClickOnceActivationStart() ?\
        MofTemplate_c(Microsoft_Windows_WPFHandle, &WpfHost_ClickOnceActivationStart, &WpfHostId, Direct)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_ClickOnceActivationEnd
//

#define EventEnabledWpfHost_ClickOnceActivationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_ClickOnceActivationEnd
//
#define EventWriteWpfHost_ClickOnceActivationEnd()\
        EventEnabledWpfHost_ClickOnceActivationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_ClickOnceActivationEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_InitAppProxyStart
//

#define EventEnabledWpfHost_InitAppProxyStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_InitAppProxyStart
//
#define EventWriteWpfHost_InitAppProxyStart()\
        EventEnabledWpfHost_InitAppProxyStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_InitAppProxyStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_InitAppProxyEnd
//

#define EventEnabledWpfHost_InitAppProxyEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_InitAppProxyEnd
//
#define EventWriteWpfHost_InitAppProxyEnd()\
        EventEnabledWpfHost_InitAppProxyEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_InitAppProxyEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AppProxyCtor
//

#define EventEnabledWpfHost_AppProxyCtor() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_AppProxyCtor
//
#define EventWriteWpfHost_AppProxyCtor()\
        EventEnabledWpfHost_AppProxyCtor() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AppProxyCtor, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_RootBrowserWindowSetupStart
//

#define EventEnabledWpfHost_RootBrowserWindowSetupStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_RootBrowserWindowSetupStart
//
#define EventWriteWpfHost_RootBrowserWindowSetupStart()\
        EventEnabledWpfHost_RootBrowserWindowSetupStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_RootBrowserWindowSetupStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_RootBrowserWindowSetupEnd
//

#define EventEnabledWpfHost_RootBrowserWindowSetupEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_RootBrowserWindowSetupEnd
//
#define EventWriteWpfHost_RootBrowserWindowSetupEnd()\
        EventEnabledWpfHost_RootBrowserWindowSetupEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_RootBrowserWindowSetupEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AppProxyRunStart
//

#define EventEnabledWpfHost_AppProxyRunStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_AppProxyRunStart
//
#define EventWriteWpfHost_AppProxyRunStart()\
        EventEnabledWpfHost_AppProxyRunStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AppProxyRunStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AppProxyRunEnd
//

#define EventEnabledWpfHost_AppProxyRunEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_AppProxyRunEnd
//
#define EventWriteWpfHost_AppProxyRunEnd()\
        EventEnabledWpfHost_AppProxyRunEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AppProxyRunEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AppDomainManagerCctor
//

#define EventEnabledWpfHost_AppDomainManagerCctor() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_AppDomainManagerCctor
//
#define EventWriteWpfHost_AppDomainManagerCctor()\
        EventEnabledWpfHost_AppDomainManagerCctor() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AppDomainManagerCctor, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_ApplicationActivatorCreateInstanceStart
//

#define EventEnabledWpfHost_ApplicationActivatorCreateInstanceStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_ApplicationActivatorCreateInstanceStart
//
#define EventWriteWpfHost_ApplicationActivatorCreateInstanceStart(URI)\
        EventEnabledWpfHost_ApplicationActivatorCreateInstanceStart() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHost_ApplicationActivatorCreateInstanceStart, &WpfHostId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_ApplicationActivatorCreateInstanceEnd
//

#define EventEnabledWpfHost_ApplicationActivatorCreateInstanceEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_ApplicationActivatorCreateInstanceEnd
//
#define EventWriteWpfHost_ApplicationActivatorCreateInstanceEnd()\
        EventEnabledWpfHost_ApplicationActivatorCreateInstanceEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_ApplicationActivatorCreateInstanceEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DetermineApplicationTrustStart
//

#define EventEnabledWpfHost_DetermineApplicationTrustStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_DetermineApplicationTrustStart
//
#define EventWriteWpfHost_DetermineApplicationTrustStart()\
        EventEnabledWpfHost_DetermineApplicationTrustStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DetermineApplicationTrustStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DetermineApplicationTrustEnd
//

#define EventEnabledWpfHost_DetermineApplicationTrustEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_DetermineApplicationTrustEnd
//
#define EventWriteWpfHost_DetermineApplicationTrustEnd()\
        EventEnabledWpfHost_DetermineApplicationTrustEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DetermineApplicationTrustEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_FirstTimeActivation
//

#define EventEnabledWpfHost_FirstTimeActivation() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_FirstTimeActivation
//
#define EventWriteWpfHost_FirstTimeActivation()\
        EventEnabledWpfHost_FirstTimeActivation() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_FirstTimeActivation, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_GetDownloadPageStart
//

#define EventEnabledWpfHost_GetDownloadPageStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00040000) != 0)

//
// Event Macro for WpfHost_GetDownloadPageStart
//
#define EventWriteWpfHost_GetDownloadPageStart(Page)\
        EventEnabledWpfHost_GetDownloadPageStart() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &WpfHost_GetDownloadPageStart, &WpfHostId, Page)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_GetDownloadPageEnd
//

#define EventEnabledWpfHost_GetDownloadPageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00040000) != 0)

//
// Event Macro for WpfHost_GetDownloadPageEnd
//
#define EventWriteWpfHost_GetDownloadPageEnd()\
        EventEnabledWpfHost_GetDownloadPageEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_GetDownloadPageEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DownloadDeplManifestStart
//

#define EventEnabledWpfHost_DownloadDeplManifestStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_DownloadDeplManifestStart
//
#define EventWriteWpfHost_DownloadDeplManifestStart()\
        EventEnabledWpfHost_DownloadDeplManifestStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DownloadDeplManifestStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DownloadDeplManifestEnd
//

#define EventEnabledWpfHost_DownloadDeplManifestEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_DownloadDeplManifestEnd
//
#define EventWriteWpfHost_DownloadDeplManifestEnd()\
        EventEnabledWpfHost_DownloadDeplManifestEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DownloadDeplManifestEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AssertAppRequirementsStart
//

#define EventEnabledWpfHost_AssertAppRequirementsStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_AssertAppRequirementsStart
//
#define EventWriteWpfHost_AssertAppRequirementsStart()\
        EventEnabledWpfHost_AssertAppRequirementsStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AssertAppRequirementsStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AssertAppRequirementsEnd
//

#define EventEnabledWpfHost_AssertAppRequirementsEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_AssertAppRequirementsEnd
//
#define EventWriteWpfHost_AssertAppRequirementsEnd()\
        EventEnabledWpfHost_AssertAppRequirementsEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AssertAppRequirementsEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DownloadApplicationStart
//

#define EventEnabledWpfHost_DownloadApplicationStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_DownloadApplicationStart
//
#define EventWriteWpfHost_DownloadApplicationStart()\
        EventEnabledWpfHost_DownloadApplicationStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DownloadApplicationStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DownloadApplicationEnd
//

#define EventEnabledWpfHost_DownloadApplicationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_DownloadApplicationEnd
//
#define EventWriteWpfHost_DownloadApplicationEnd()\
        EventEnabledWpfHost_DownloadApplicationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_DownloadApplicationEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_DownloadProgressUpdate
//

#define EventEnabledWpfHost_DownloadProgressUpdate() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_DownloadProgressUpdate
//
#define EventWriteWpfHost_DownloadProgressUpdate(Bytes, Total)\
        EventEnabledWpfHost_DownloadProgressUpdate() ?\
        MofTemplate_qq(Microsoft_Windows_WPFHandle, &WpfHost_DownloadProgressUpdate, &WpfHostId, Bytes, Total)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_XappLauncherAppNavigated
//

#define EventEnabledWpfHost_XappLauncherAppNavigated() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_XappLauncherAppNavigated
//
#define EventWriteWpfHost_XappLauncherAppNavigated()\
        EventEnabledWpfHost_XappLauncherAppNavigated() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_XappLauncherAppNavigated, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_UpdateBrowserCommandsStart
//

#define EventEnabledWpfHost_UpdateBrowserCommandsStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_UpdateBrowserCommandsStart
//
#define EventWriteWpfHost_UpdateBrowserCommandsStart()\
        EventEnabledWpfHost_UpdateBrowserCommandsStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_UpdateBrowserCommandsStart, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_UpdateBrowserCommandsEnd
//

#define EventEnabledWpfHost_UpdateBrowserCommandsEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00020000) != 0)

//
// Event Macro for WpfHost_UpdateBrowserCommandsEnd
//
#define EventWriteWpfHost_UpdateBrowserCommandsEnd()\
        EventEnabledWpfHost_UpdateBrowserCommandsEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_UpdateBrowserCommandsEnd, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_PostShutdown
//

#define EventEnabledWpfHost_PostShutdown() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHost_PostShutdown
//
#define EventWriteWpfHost_PostShutdown()\
        EventEnabledWpfHost_PostShutdown() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_PostShutdown, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_AbortingActivation
//

#define EventEnabledWpfHost_AbortingActivation() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for WpfHost_AbortingActivation
//
#define EventWriteWpfHost_AbortingActivation()\
        EventEnabledWpfHost_AbortingActivation() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WpfHost_AbortingActivation, &WpfHostId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_IBHSRunStart
//

#define EventEnabledWpfHost_IBHSRunStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_IBHSRunStart
//
#define EventWriteWpfHost_IBHSRunStart(Path, AppId)\
        EventEnabledWpfHost_IBHSRunStart() ?\
        MofTemplate_zz(Microsoft_Windows_WPFHandle, &WpfHost_IBHSRunStart, &WpfHostId, Path, AppId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WpfHost_IBHSRunEnd
//

#define EventEnabledWpfHost_IBHSRunEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for WpfHost_IBHSRunEnd
//
#define EventWriteWpfHost_IBHSRunEnd(ExitCode)\
        EventEnabledWpfHost_IBHSRunEnd() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WpfHost_IBHSRunEnd, &WpfHostId, ExitCode)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationAsyncWorkItem
//

#define EventEnabledWpf_NavigationAsyncWorkItem() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for Wpf_NavigationAsyncWorkItem
//
#define EventWriteWpf_NavigationAsyncWorkItem()\
        EventEnabledWpf_NavigationAsyncWorkItem() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &Wpf_NavigationAsyncWorkItem, &NavigationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationWebResponseReceived
//

#define EventEnabledWpf_NavigationWebResponseReceived() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for Wpf_NavigationWebResponseReceived
//
#define EventWriteWpf_NavigationWebResponseReceived()\
        EventEnabledWpf_NavigationWebResponseReceived() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &Wpf_NavigationWebResponseReceived, &NavigationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationEnd
//

#define EventEnabledWpf_NavigationEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for Wpf_NavigationEnd
//
#define EventWriteWpf_NavigationEnd()\
        EventEnabledWpf_NavigationEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &Wpf_NavigationEnd, &NavigationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationContentRendered
//

#define EventEnabledWpf_NavigationContentRendered() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for Wpf_NavigationContentRendered
//
#define EventWriteWpf_NavigationContentRendered()\
        EventEnabledWpf_NavigationContentRendered() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &Wpf_NavigationContentRendered, &NavigationId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationStart
//

#define EventEnabledWpf_NavigationStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00008000) != 0)

//
// Event Macro for Wpf_NavigationStart
//
#define EventWriteWpf_NavigationStart(NavigationMode, UriOrObject)\
        EventEnabledWpf_NavigationStart() ?\
        MofTemplate_zz(Microsoft_Windows_WPFHandle, &Wpf_NavigationStart, &NavigationId, NavigationMode, UriOrObject)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationLaunchBrowser
//

#define EventEnabledWpf_NavigationLaunchBrowser() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for Wpf_NavigationLaunchBrowser
//
#define EventWriteWpf_NavigationLaunchBrowser(URI)\
        EventEnabledWpf_NavigationLaunchBrowser() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &Wpf_NavigationLaunchBrowser, &NavigationId, URI)\
        : ERROR_SUCCESS\

//
// Enablement check macro for Wpf_NavigationPageFunctionReturn
//

#define EventEnabledWpf_NavigationPageFunctionReturn() ((Microsoft_Windows_WPFEnableBits[0] & 0x00010000) != 0)

//
// Event Macro for Wpf_NavigationPageFunctionReturn
//
#define EventWriteWpf_NavigationPageFunctionReturn(PF)\
        EventEnabledWpf_NavigationPageFunctionReturn() ?\
        MofTemplate_z(Microsoft_Windows_WPFHandle, &Wpf_NavigationPageFunctionReturn, &NavigationId, PF)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DrawBitmapInfo
//

#define EventEnabledDrawBitmapInfo() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for DrawBitmapInfo
//
#define EventWriteDrawBitmapInfo(Bitmap, width, height)\
        EventEnabledDrawBitmapInfo() ?\
        MofTemplate_pqq(Microsoft_Windows_WPFHandle, &DrawBitmapInfo, &DrawBitmapId, Bitmap, width, height)\
        : ERROR_SUCCESS\

//
// Enablement check macro for BitmapCopyInfo
//

#define EventEnabledBitmapCopyInfo() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for BitmapCopyInfo
//
#define EventWriteBitmapCopyInfo(width, height)\
        EventEnabledBitmapCopyInfo() ?\
        MofTemplate_qq(Microsoft_Windows_WPFHandle, &BitmapCopyInfo, &BitmapCopyId, width, height)\
        : ERROR_SUCCESS\

//
// Enablement check macro for SetClipInfo
//

#define EventEnabledSetClipInfo() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for SetClipInfo
//
#define EventWriteSetClipInfo(left, top, right, bottom)\
        EventEnabledSetClipInfo() ?\
        MofTemplate_qqqq(Microsoft_Windows_WPFHandle, &SetClipInfo, &SetClipId, left, top, right, bottom)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_ClearStart
//

#define EventEnabledDWMDraw_ClearStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for DWMDraw_ClearStart
//
#define EventWriteDWMDraw_ClearStart(left, top, right, bottom)\
        EventEnabledDWMDraw_ClearStart() ?\
        MofTemplate_ffff(Microsoft_Windows_WPFHandle, &DWMDraw_ClearStart, &DWMDraw_ClearId, left, top, right, bottom)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_ClearEnd
//

#define EventEnabledDWMDraw_ClearEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for DWMDraw_ClearEnd
//
#define EventWriteDWMDraw_ClearEnd()\
        EventEnabledDWMDraw_ClearEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DWMDraw_ClearEnd, &DWMDraw_ClearId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_BitmapStart
//

#define EventEnabledDWMDraw_BitmapStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_BitmapStart
//
#define EventWriteDWMDraw_BitmapStart(Z)\
        EventEnabledDWMDraw_BitmapStart() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_BitmapStart, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_BitmapEnd
//

#define EventEnabledDWMDraw_BitmapEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_BitmapEnd
//
#define EventWriteDWMDraw_BitmapEnd(Z)\
        EventEnabledDWMDraw_BitmapEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_BitmapEnd, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_RectangleStart
//

#define EventEnabledDWMDraw_RectangleStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_RectangleStart
//
#define EventWriteDWMDraw_RectangleStart(Z)\
        EventEnabledDWMDraw_RectangleStart() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_RectangleStart, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_RectangleEnd
//

#define EventEnabledDWMDraw_RectangleEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_RectangleEnd
//
#define EventWriteDWMDraw_RectangleEnd(Z)\
        EventEnabledDWMDraw_RectangleEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_RectangleEnd, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_GeometryStart
//

#define EventEnabledDWMDraw_GeometryStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_GeometryStart
//
#define EventWriteDWMDraw_GeometryStart(Z)\
        EventEnabledDWMDraw_GeometryStart() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_GeometryStart, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_GeometryEnd
//

#define EventEnabledDWMDraw_GeometryEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_GeometryEnd
//
#define EventWriteDWMDraw_GeometryEnd(Z)\
        EventEnabledDWMDraw_GeometryEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_GeometryEnd, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_ImageStart
//

#define EventEnabledDWMDraw_ImageStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_ImageStart
//
#define EventWriteDWMDraw_ImageStart(Z)\
        EventEnabledDWMDraw_ImageStart() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_ImageStart, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_ImageEnd
//

#define EventEnabledDWMDraw_ImageEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_ImageEnd
//
#define EventWriteDWMDraw_ImageEnd(Z)\
        EventEnabledDWMDraw_ImageEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_ImageEnd, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_GlyphRunStart
//

#define EventEnabledDWMDraw_GlyphRunStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_GlyphRunStart
//
#define EventWriteDWMDraw_GlyphRunStart(Z)\
        EventEnabledDWMDraw_GlyphRunStart() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_GlyphRunStart, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_GlyphRunEnd
//

#define EventEnabledDWMDraw_GlyphRunEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_GlyphRunEnd
//
#define EventWriteDWMDraw_GlyphRunEnd(Z)\
        EventEnabledDWMDraw_GlyphRunEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_GlyphRunEnd, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_BeginLayerStart
//

#define EventEnabledDWMDraw_BeginLayerStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_BeginLayerStart
//
#define EventWriteDWMDraw_BeginLayerStart(left, top, right, bottom)\
        EventEnabledDWMDraw_BeginLayerStart() ?\
        MofTemplate_ffff(Microsoft_Windows_WPFHandle, &DWMDraw_BeginLayerStart, &DWMDraw_Id, left, top, right, bottom)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_BeginLayerEnd
//

#define EventEnabledDWMDraw_BeginLayerEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_BeginLayerEnd
//
#define EventWriteDWMDraw_BeginLayerEnd(left, top, right, bottom)\
        EventEnabledDWMDraw_BeginLayerEnd() ?\
        MofTemplate_ffff(Microsoft_Windows_WPFHandle, &DWMDraw_BeginLayerEnd, &DWMDraw_Id, left, top, right, bottom)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_EndLayerStart
//

#define EventEnabledDWMDraw_EndLayerStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_EndLayerStart
//
#define EventWriteDWMDraw_EndLayerStart()\
        EventEnabledDWMDraw_EndLayerStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DWMDraw_EndLayerStart, &DWMDraw_Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_EndLayerEnd
//

#define EventEnabledDWMDraw_EndLayerEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_EndLayerEnd
//
#define EventWriteDWMDraw_EndLayerEnd()\
        EventEnabledDWMDraw_EndLayerEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &DWMDraw_EndLayerEnd, &DWMDraw_Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_ClippedBitmapStart
//

#define EventEnabledDWMDraw_ClippedBitmapStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_ClippedBitmapStart
//
#define EventWriteDWMDraw_ClippedBitmapStart(Z)\
        EventEnabledDWMDraw_ClippedBitmapStart() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_ClippedBitmapStart, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_ClippedBitmapEnd
//

#define EventEnabledDWMDraw_ClippedBitmapEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_ClippedBitmapEnd
//
#define EventWriteDWMDraw_ClippedBitmapEnd(Z)\
        EventEnabledDWMDraw_ClippedBitmapEnd() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &DWMDraw_ClippedBitmapEnd, &DWMDraw_Id, Z)\
        : ERROR_SUCCESS\

//
// Enablement check macro for DWMDraw_Info
//

#define EventEnabledDWMDraw_Info() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for DWMDraw_Info
//
#define EventWriteDWMDraw_Info(left, top, right, bottom)\
        EventEnabledDWMDraw_Info() ?\
        MofTemplate_ffff(Microsoft_Windows_WPFHandle, &DWMDraw_Info, &DWMDraw_Id, left, top, right, bottom)\
        : ERROR_SUCCESS\

//
// Enablement check macro for LayerEventStart
//

#define EventEnabledLayerEventStart() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for LayerEventStart
//
#define EventWriteLayerEventStart()\
        EventEnabledLayerEventStart() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &LayerEventStart, &LayerEventId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for LayerEventEnd
//

#define EventEnabledLayerEventEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00100000) != 0)

//
// Event Macro for LayerEventEnd
//
#define EventWriteLayerEventEnd()\
        EventEnabledLayerEventEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &LayerEventEnd, &LayerEventId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDesktopRTCreateBegin
//

#define EventEnabledWClientDesktopRTCreateBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientDesktopRTCreateBegin
//
#define EventWriteWClientDesktopRTCreateBegin(Hwnd)\
        EventEnabledWClientDesktopRTCreateBegin() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientDesktopRTCreateBegin, &WClientDesktopRTCreateId, Hwnd)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientDesktopRTCreateEnd
//

#define EventEnabledWClientDesktopRTCreateEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientDesktopRTCreateEnd
//
#define EventWriteWClientDesktopRTCreateEnd(Hwnd)\
        EventEnabledWClientDesktopRTCreateEnd() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientDesktopRTCreateEnd, &WClientDesktopRTCreateId, Hwnd)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceProcessQueueBegin
//

#define EventEnabledWClientUceProcessQueueBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUceProcessQueueBegin
//
#define EventWriteWClientUceProcessQueueBegin(Id)\
        EventEnabledWClientUceProcessQueueBegin() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUceProcessQueueBegin, &WClientUceProcessQueueId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceProcessQueueEnd
//

#define EventEnabledWClientUceProcessQueueEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUceProcessQueueEnd
//
#define EventWriteWClientUceProcessQueueEnd(Id)\
        EventEnabledWClientUceProcessQueueEnd() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUceProcessQueueEnd, &WClientUceProcessQueueId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceProcessQueueInfo
//

#define EventEnabledWClientUceProcessQueueInfo() ((Microsoft_Windows_WPFEnableBits[0] & 0x00400000) != 0)

//
// Event Macro for WClientUceProcessQueueInfo
//
#define EventWriteWClientUceProcessQueueInfo(BatchSize)\
        EventEnabledWClientUceProcessQueueInfo() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUceProcessQueueInfo, &WClientUceProcessQueueId, BatchSize)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUcePrecomputeBegin
//

#define EventEnabledWClientUcePrecomputeBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUcePrecomputeBegin
//
#define EventWriteWClientUcePrecomputeBegin(Id)\
        EventEnabledWClientUcePrecomputeBegin() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUcePrecomputeBegin, &WClientUcePrecomputeId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUcePrecomputeEnd
//

#define EventEnabledWClientUcePrecomputeEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUcePrecomputeEnd
//
#define EventWriteWClientUcePrecomputeEnd(Id)\
        EventEnabledWClientUcePrecomputeEnd() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUcePrecomputeEnd, &WClientUcePrecomputeId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceRenderBegin
//

#define EventEnabledWClientUceRenderBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUceRenderBegin
//
#define EventWriteWClientUceRenderBegin(Id)\
        EventEnabledWClientUceRenderBegin() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUceRenderBegin, &WClientUceRenderId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceRenderEnd
//

#define EventEnabledWClientUceRenderEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUceRenderEnd
//
#define EventWriteWClientUceRenderEnd(Id)\
        EventEnabledWClientUceRenderEnd() ?\
        MofTemplate_x(Microsoft_Windows_WPFHandle, &WClientUceRenderEnd, &WClientUceRenderId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUcePresentBegin
//

#define EventEnabledWClientUcePresentBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUcePresentBegin
//
#define EventWriteWClientUcePresentBegin(Id, QPCCurrentTime)\
        EventEnabledWClientUcePresentBegin() ?\
        MofTemplate_xx(Microsoft_Windows_WPFHandle, &WClientUcePresentBegin, &WClientUcePresentId, Id, QPCCurrentTime)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUcePresentEnd
//

#define EventEnabledWClientUcePresentEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUcePresentEnd
//
#define EventWriteWClientUcePresentEnd(Id, QPCCurrentTime)\
        EventEnabledWClientUcePresentEnd() ?\
        MofTemplate_xx(Microsoft_Windows_WPFHandle, &WClientUcePresentEnd, &WClientUcePresentId, Id, QPCCurrentTime)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceResponse
//

#define EventEnabledWClientUceResponse() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUceResponse
//
#define EventWriteWClientUceResponse(Id)\
        EventEnabledWClientUceResponse() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &WClientUceResponse, &WClientUceResponseId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceCheckDeviceStateInfo
//

#define EventEnabledWClientUceCheckDeviceStateInfo() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for WClientUceCheckDeviceStateInfo
//
#define EventWriteWClientUceCheckDeviceStateInfo(hwnd, hr)\
        EventEnabledWClientUceCheckDeviceStateInfo() ?\
        MofTemplate_pq(Microsoft_Windows_WPFHandle, &WClientUceCheckDeviceStateInfo, &WClientUceCheckDeviceStateId, hwnd, hr)\
        : ERROR_SUCCESS\

//
// Enablement check macro for VisualCacheAlloc
//

#define EventEnabledVisualCacheAlloc() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for VisualCacheAlloc
//
#define EventWriteVisualCacheAlloc(uX, uY, uWidth, uHeight)\
        EventEnabledVisualCacheAlloc() ?\
        MofTemplate_qqqq(Microsoft_Windows_WPFHandle, &VisualCacheAlloc, &VisualCacheAllocId, uX, uY, uWidth, uHeight)\
        : ERROR_SUCCESS\

//
// Enablement check macro for VisualCacheUpdate
//

#define EventEnabledVisualCacheUpdate() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for VisualCacheUpdate
//
#define EventWriteVisualCacheUpdate(uX, uY, uWidth, uHeight)\
        EventEnabledVisualCacheUpdate() ?\
        MofTemplate_qqqq(Microsoft_Windows_WPFHandle, &VisualCacheUpdate, &VisualCacheUpdateId, uX, uY, uWidth, uHeight)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateChannel
//

#define EventEnabledCreateChannel() ((Microsoft_Windows_WPFEnableBits[0] & 0x00800000) != 0)

//
// Event Macro for CreateChannel
//
#define EventWriteCreateChannel(ChannelPtr, ChannelHandle)\
        EventEnabledCreateChannel() ?\
        MofTemplate_pq(Microsoft_Windows_WPFHandle, &CreateChannel, &CreateChannelId, ChannelPtr, ChannelHandle)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateOrAddResourceOnChannel
//

#define EventEnabledCreateOrAddResourceOnChannel() ((Microsoft_Windows_WPFEnableBits[0] & 0x00800000) != 0)

//
// Event Macro for CreateOrAddResourceOnChannel
//
#define EventWriteCreateOrAddResourceOnChannel(PerfEltId, ChannelPtr, ResourceHandle, ResourceType)\
        EventEnabledCreateOrAddResourceOnChannel() ?\
        MofTemplate_ipqq(Microsoft_Windows_WPFHandle, &CreateOrAddResourceOnChannel, &CreateOrAddOnChnlId, PerfEltId, ChannelPtr, ResourceHandle, ResourceType)\
        : ERROR_SUCCESS\

//
// Enablement check macro for CreateWpfGfxResource
//

#define EventEnabledCreateWpfGfxResource() ((Microsoft_Windows_WPFEnableBits[0] & 0x00800000) != 0)

//
// Event Macro for CreateWpfGfxResource
//
#define EventWriteCreateWpfGfxResource(ResourcePtr, ChannelHandle, ResourceHandle, ResourceType)\
        EventEnabledCreateWpfGfxResource() ?\
        MofTemplate_pqqq(Microsoft_Windows_WPFHandle, &CreateWpfGfxResource, &CreateWpfGfxResourceId, ResourcePtr, ChannelHandle, ResourceHandle, ResourceType)\
        : ERROR_SUCCESS\

//
// Enablement check macro for ReleaseOnChannel
//

#define EventEnabledReleaseOnChannel() ((Microsoft_Windows_WPFEnableBits[0] & 0x00800000) != 0)

//
// Event Macro for ReleaseOnChannel
//
#define EventWriteReleaseOnChannel(ChannelPtr, ResourceHandle)\
        EventEnabledReleaseOnChannel() ?\
        MofTemplate_pq(Microsoft_Windows_WPFHandle, &ReleaseOnChannel, &ReleaseOnChannelId, ChannelPtr, ResourceHandle)\
        : ERROR_SUCCESS\

//
// Enablement check macro for UnexpectedSoftwareFallback
//

#define EventEnabledUnexpectedSoftwareFallback() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for UnexpectedSoftwareFallback
//
#define EventWriteUnexpectedSoftwareFallback(Reason)\
        EventEnabledUnexpectedSoftwareFallback() ?\
        MofTemplate_q(Microsoft_Windows_WPFHandle, &UnexpectedSoftwareFallback, &UnexpectedSoftwareFallbackId, Reason)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientInterlockedRenderBegin
//

#define EventEnabledWClientInterlockedRenderBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for WClientInterlockedRenderBegin
//
#define EventWriteWClientInterlockedRenderBegin()\
        EventEnabledWClientInterlockedRenderBegin() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientInterlockedRenderBegin, &WClientInterlockedRenderId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientInterlockedRenderEnd
//

#define EventEnabledWClientInterlockedRenderEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for WClientInterlockedRenderEnd
//
#define EventWriteWClientInterlockedRenderEnd()\
        EventEnabledWClientInterlockedRenderEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientInterlockedRenderEnd, &WClientInterlockedRenderId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientRenderHandlerBegin
//

#define EventEnabledWClientRenderHandlerBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientRenderHandlerBegin
//
#define EventWriteWClientRenderHandlerBegin(Id)\
        EventEnabledWClientRenderHandlerBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientRenderHandlerBegin, &WClientRenderHandlerId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientRenderHandlerEnd
//

#define EventEnabledWClientRenderHandlerEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientRenderHandlerEnd
//
#define EventWriteWClientRenderHandlerEnd()\
        EventEnabledWClientRenderHandlerEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientRenderHandlerEnd, &WClientRenderHandlerId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientAnimRenderHandlerBegin
//

#define EventEnabledWClientAnimRenderHandlerBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientAnimRenderHandlerBegin
//
#define EventWriteWClientAnimRenderHandlerBegin(Id)\
        EventEnabledWClientAnimRenderHandlerBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientAnimRenderHandlerBegin, &WClientAnimRenderHandlerId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientAnimRenderHandlerEnd
//

#define EventEnabledWClientAnimRenderHandlerEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientAnimRenderHandlerEnd
//
#define EventWriteWClientAnimRenderHandlerEnd()\
        EventEnabledWClientAnimRenderHandlerEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientAnimRenderHandlerEnd, &WClientAnimRenderHandlerId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMediaRenderBegin
//

#define EventEnabledWClientMediaRenderBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientMediaRenderBegin
//
#define EventWriteWClientMediaRenderBegin(Id, QPCExpectedPresentTime)\
        EventEnabledWClientMediaRenderBegin() ?\
        MofTemplate_di(Microsoft_Windows_WPFHandle, &WClientMediaRenderBegin, &WClientMediaRenderId, Id, QPCExpectedPresentTime)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientMediaRenderEnd
//

#define EventEnabledWClientMediaRenderEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientMediaRenderEnd
//
#define EventWriteWClientMediaRenderEnd()\
        EventEnabledWClientMediaRenderEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientMediaRenderEnd, &WClientMediaRenderId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientPostRender
//

#define EventEnabledWClientPostRender() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientPostRender
//
#define EventWriteWClientPostRender()\
        EventEnabledWClientPostRender() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientPostRender, &WClientPostRenderId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientQPCFrequency
//

#define EventEnabledWClientQPCFrequency() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for WClientQPCFrequency
//
#define EventWriteWClientQPCFrequency(QPCFrequency, QPCCurrentTime)\
        EventEnabledWClientQPCFrequency() ?\
        MofTemplate_ii(Microsoft_Windows_WPFHandle, &WClientQPCFrequency, &WClientQPCFrequencyId, QPCFrequency, QPCCurrentTime)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientPrecomputeSceneBegin
//

#define EventEnabledWClientPrecomputeSceneBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientPrecomputeSceneBegin
//
#define EventWriteWClientPrecomputeSceneBegin(Id)\
        EventEnabledWClientPrecomputeSceneBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientPrecomputeSceneBegin, &WClientPrecomputeSceneId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientPrecomputeSceneEnd
//

#define EventEnabledWClientPrecomputeSceneEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientPrecomputeSceneEnd
//
#define EventWriteWClientPrecomputeSceneEnd()\
        EventEnabledWClientPrecomputeSceneEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientPrecomputeSceneEnd, &WClientPrecomputeSceneId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientCompileSceneBegin
//

#define EventEnabledWClientCompileSceneBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientCompileSceneBegin
//
#define EventWriteWClientCompileSceneBegin(Id)\
        EventEnabledWClientCompileSceneBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientCompileSceneBegin, &WClientCompileSceneId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientCompileSceneEnd
//

#define EventEnabledWClientCompileSceneEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientCompileSceneEnd
//
#define EventWriteWClientCompileSceneEnd()\
        EventEnabledWClientCompileSceneEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientCompileSceneEnd, &WClientCompileSceneId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIResponse
//

#define EventEnabledWClientUIResponse() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUIResponse
//
#define EventWriteWClientUIResponse(ContextID, ResponseID)\
        EventEnabledWClientUIResponse() ?\
        MofTemplate_dd(Microsoft_Windows_WPFHandle, &WClientUIResponse, &WClientUIResponseId, ContextID, ResponseID)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUICommitChannel
//

#define EventEnabledWClientUICommitChannel() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUICommitChannel
//
#define EventWriteWClientUICommitChannel(Id)\
        EventEnabledWClientUICommitChannel() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientUICommitChannel, &WClientUICommitChannelId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUceNotifyPresent
//

#define EventEnabledWClientUceNotifyPresent() ((Microsoft_Windows_WPFEnableBits[0] & 0x00200000) != 0)

//
// Event Macro for WClientUceNotifyPresent
//
#define EventWriteWClientUceNotifyPresent(QPCLastPresentationTime, PresentationResults)\
        EventEnabledWClientUceNotifyPresent() ?\
        MofTemplate_ii(Microsoft_Windows_WPFHandle, &WClientUceNotifyPresent, &WClientUceNotifyPresentId, QPCLastPresentationTime, PresentationResults)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientScheduleRender
//

#define EventEnabledWClientScheduleRender() ((Microsoft_Windows_WPFEnableBits[0] & 0x00080000) != 0)

//
// Event Macro for WClientScheduleRender
//
#define EventWriteWClientScheduleRender(RenderDelay)\
        EventEnabledWClientScheduleRender() ?\
        MofTemplate_d(Microsoft_Windows_WPFHandle, &WClientScheduleRender, &WClientScheduleRenderId, RenderDelay)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientOnRenderBegin
//

#define EventEnabledWClientOnRenderBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x00400000) != 0)

//
// Event Macro for WClientOnRenderBegin
//
#define EventWriteWClientOnRenderBegin(Id)\
        EventEnabledWClientOnRenderBegin() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientOnRenderBegin, &WClientOnRenderId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientOnRenderEnd
//

#define EventEnabledWClientOnRenderEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x00400000) != 0)

//
// Event Macro for WClientOnRenderEnd
//
#define EventWriteWClientOnRenderEnd(Id)\
        EventEnabledWClientOnRenderEnd() ?\
        MofTemplate_i(Microsoft_Windows_WPFHandle, &WClientOnRenderEnd, &WClientOnRenderId, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientCreateIRT
//

#define EventEnabledWClientCreateIRT() ((Microsoft_Windows_WPFEnableBits[0] & 0x01000000) != 0)

//
// Event Macro for WClientCreateIRT
//
#define EventWriteWClientCreateIRT(ResourcePtr, ParentResourcePtr, Reason)\
        EventEnabledWClientCreateIRT() ?\
        MofTemplate_ppq(Microsoft_Windows_WPFHandle, &WClientCreateIRT, &WClientCreateIRTId, ResourcePtr, ParentResourcePtr, Reason)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientPotentialIRTResource
//

#define EventEnabledWClientPotentialIRTResource() ((Microsoft_Windows_WPFEnableBits[0] & 0x01000000) != 0)

//
// Event Macro for WClientPotentialIRTResource
//
#define EventWriteWClientPotentialIRTResource(Pointer)\
        EventEnabledWClientPotentialIRTResource() ?\
        MofTemplate_p(Microsoft_Windows_WPFHandle, &WClientPotentialIRTResource, &WClientPotentialIRTResourceId, Pointer)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIContextDispatchBegin
//

#define EventEnabledWClientUIContextDispatchBegin() ((Microsoft_Windows_WPFEnableBits[0] & 0x02000000) != 0)

//
// Event Macro for WClientUIContextDispatchBegin
//
#define EventWriteWClientUIContextDispatchBegin(Priority, Operation, Id)\
        EventEnabledWClientUIContextDispatchBegin() ?\
        MofTemplate_qzi(Microsoft_Windows_WPFHandle, &WClientUIContextDispatchBegin, &WClientUIContextDispatchId, Priority, Operation, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIContextDispatchEnd
//

#define EventEnabledWClientUIContextDispatchEnd() ((Microsoft_Windows_WPFEnableBits[0] & 0x02000000) != 0)

//
// Event Macro for WClientUIContextDispatchEnd
//
#define EventWriteWClientUIContextDispatchEnd()\
        EventEnabledWClientUIContextDispatchEnd() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientUIContextDispatchEnd, &WClientUIContextDispatchId)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIContextPost
//

#define EventEnabledWClientUIContextPost() ((Microsoft_Windows_WPFEnableBits[0] & 0x02000000) != 0)

//
// Event Macro for WClientUIContextPost
//
#define EventWriteWClientUIContextPost(Priority, Operation, Id)\
        EventEnabledWClientUIContextPost() ?\
        MofTemplate_qzi(Microsoft_Windows_WPFHandle, &WClientUIContextPost, &WClientUIContextPostId, Priority, Operation, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIContextAbort
//

#define EventEnabledWClientUIContextAbort() ((Microsoft_Windows_WPFEnableBits[0] & 0x04000000) != 0)

//
// Event Macro for WClientUIContextAbort
//
#define EventWriteWClientUIContextAbort(Priority, Operation, Id)\
        EventEnabledWClientUIContextAbort() ?\
        MofTemplate_qzi(Microsoft_Windows_WPFHandle, &WClientUIContextAbort, &WClientUIContextAbortId, Priority, Operation, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIContextPromote
//

#define EventEnabledWClientUIContextPromote() ((Microsoft_Windows_WPFEnableBits[0] & 0x04000000) != 0)

//
// Event Macro for WClientUIContextPromote
//
#define EventWriteWClientUIContextPromote(Priority, Operation, Id)\
        EventEnabledWClientUIContextPromote() ?\
        MofTemplate_qzi(Microsoft_Windows_WPFHandle, &WClientUIContextPromote, &WClientUIContextPromoteId, Priority, Operation, Id)\
        : ERROR_SUCCESS\

//
// Enablement check macro for WClientUIContextIdle
//

#define EventEnabledWClientUIContextIdle() ((Microsoft_Windows_WPFEnableBits[0] & 0x02000000) != 0)

//
// Event Macro for WClientUIContextIdle
//
#define EventWriteWClientUIContextIdle()\
        EventEnabledWClientUIContextIdle() ?\
        MofTemplateEventDescriptor(Microsoft_Windows_WPFHandle, &WClientUIContextIdle, &WClientUIContextIdleId)\
        : ERROR_SUCCESS\

#endif // MCGEN_DISABLE_PROVIDER_CODE_GENERATION


//
// Allow Diasabling of code generation
//
#ifndef MCGEN_DISABLE_PROVIDER_CODE_GENERATION

//
// Template Functions 
//
//
//Template from manifest : Template_18
//
#ifndef MofTemplate_di_def
#define MofTemplate_di_def
ETW_INLINE
ULONG
MofTemplate_di(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const signed int  _Arg0,
    _In_ signed __int64  _Arg1
    )
{
#define ARGUMENT_COUNT_di 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_di];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(signed __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_di, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_0
//
#ifndef MofTemplateEventDescriptor_def
#define MofTemplateEventDescriptor_def


ETW_INLINE
ULONG
MofTemplateEventDescriptor(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid
    )
{

  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, 0, NULL);

  } else {

    EVENT_TRACE_HEADER Header;

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    Header.GuidPtr = (ULONGLONG)EventGuid;
    Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    Header.Class.Version = (USHORT)Descriptor->Version;
    Header.Class.Level = Descriptor->Level;
    Header.Class.Type = Descriptor->Opcode;
    Header.Size = sizeof(EVENT_TRACE_HEADER);

    return TraceEvent(Context->Logger, &Header);
  }
}
#endif

//
//Template from manifest : InfoStringTemplate
//
#ifndef MofTemplate_z_def
#define MofTemplate_z_def
ETW_INLINE
ULONG
MofTemplate_z(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ PCWSTR  _Arg0
    )
{
#define ARGUMENT_COUNT_z 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_z];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], 
                        (_Arg0 != NULL) ? _Arg0 : L"NULL",
                        (_Arg0 != NULL) ? (ULONG)((wcslen(_Arg0) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_z, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_37
//
#ifndef MofTemplate_dz_def
#define MofTemplate_dz_def
ETW_INLINE
ULONG
MofTemplate_dz(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const signed int  _Arg0,
    _In_opt_ PCWSTR  _Arg1
    )
{
#define ARGUMENT_COUNT_dz 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_dz];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[1], 
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_dz, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : PerfElementName
//
#ifndef MofTemplate_izz_def
#define MofTemplate_izz_def
ETW_INLINE
ULONG
MofTemplate_izz(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_opt_ PCWSTR  _Arg1,
    _In_opt_ PCWSTR  _Arg2
    )
{
#define ARGUMENT_COUNT_izz 3
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_izz];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], 
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    EventDataDescCreate(&EventData[2], 
                        (_Arg2 != NULL) ? _Arg2 : L"NULL",
                        (_Arg2 != NULL) ? (ULONG)((wcslen(_Arg2) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_izz, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : PerfElementInfo
//
#ifndef MofTemplate_izzi_def
#define MofTemplate_izzi_def
ETW_INLINE
ULONG
MofTemplate_izzi(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_opt_ PCWSTR  _Arg1,
    _In_opt_ PCWSTR  _Arg2,
    _In_ signed __int64  _Arg3
    )
{
#define ARGUMENT_COUNT_izzi 4
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_izzi];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], 
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    EventDataDescCreate(&EventData[2], 
                        (_Arg2 != NULL) ? _Arg2 : L"NULL",
                        (_Arg2 != NULL) ? (ULONG)((wcslen(_Arg2) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(signed __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_izzi, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_19
//
#ifndef MofTemplate_diddd_def
#define MofTemplate_diddd_def
ETW_INLINE
ULONG
MofTemplate_diddd(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const signed int  _Arg0,
    _In_ signed __int64  _Arg1,
    _In_ const signed int  _Arg2,
    _In_ const signed int  _Arg3,
    _In_ const signed int  _Arg4
    )
{
#define ARGUMENT_COUNT_diddd 5
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_diddd];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[4], &_Arg4, sizeof(const signed int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_diddd, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : ID32Template
//
#ifndef MofTemplate_d_def
#define MofTemplate_d_def
ETW_INLINE
ULONG
MofTemplate_d(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const signed int  _Arg0
    )
{
#define ARGUMENT_COUNT_d 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_d];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const signed int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_d, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : WClientParseXamlBamlInfoTemplate
//
#ifndef MofTemplate_idd_def
#define MofTemplate_idd_def
ETW_INLINE
ULONG
MofTemplate_idd(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_ const signed int  _Arg1,
    _In_ const signed int  _Arg2
    )
{
#define ARGUMENT_COUNT_idd 3
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_idd];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const signed int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_idd, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_31
//
#ifndef MofTemplate_dd_def
#define MofTemplate_dd_def
ETW_INLINE
ULONG
MofTemplate_dd(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const signed int  _Arg0,
    _In_ const signed int  _Arg1
    )
{
#define ARGUMENT_COUNT_dd 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_dd];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const signed int)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const signed int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_dd, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : TimeTick
//
#ifndef MofTemplate_i_def
#define MofTemplate_i_def
ETW_INLINE
ULONG
MofTemplate_i(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0
    )
{
#define ARGUMENT_COUNT_i 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_i];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_i, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : LayoutSourceTemplate
//
#ifndef MofTemplate_ic_def
#define MofTemplate_ic_def
ETW_INLINE
ULONG
MofTemplate_ic(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_ const UCHAR  _Arg1
    )
{
#define ARGUMENT_COUNT_ic 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_ic];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const UCHAR)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_ic, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : MeasureData
//
#ifndef MofTemplate_igg_def
#define MofTemplate_igg_def
ETW_INLINE
ULONG
MofTemplate_igg(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_ const double  _Arg1,
    _In_ const double  _Arg2
    )
{
#define ARGUMENT_COUNT_igg 3
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_igg];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const double)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const double)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_igg, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : ArrangeData
//
#ifndef MofTemplate_igggg_def
#define MofTemplate_igggg_def
ETW_INLINE
ULONG
MofTemplate_igggg(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_ const double  _Arg1,
    _In_ const double  _Arg2,
    _In_ const double  _Arg3,
    _In_ const double  _Arg4
    )
{
#define ARGUMENT_COUNT_igggg 5
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_igggg];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const double)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const double)  );

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(const double)  );

    EventDataDescCreate(&EventData[4], &_Arg4, sizeof(const double)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_igggg, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_HR
//
#ifndef MofTemplate_q_def
#define MofTemplate_q_def
ETW_INLINE
ULONG
MofTemplate_q(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const unsigned int  _Arg0
    )
{
#define ARGUMENT_COUNT_q 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_q];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_q, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_44
//
#ifndef MofTemplate_qz_def
#define MofTemplate_qz_def
ETW_INLINE
ULONG
MofTemplate_qz(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const unsigned int  _Arg0,
    _In_opt_ PCWSTR  _Arg1
    )
{
#define ARGUMENT_COUNT_qz 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_qz];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[1], 
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_qz, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_47
//
#ifndef MofTemplate_qq_def
#define MofTemplate_qq_def
ETW_INLINE
ULONG
MofTemplate_qq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const unsigned int  _Arg0,
    _In_ const unsigned int  _Arg1
    )
{
#define ARGUMENT_COUNT_qq 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_qq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_qq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_53
//
#ifndef MofTemplate_c_def
#define MofTemplate_c_def
ETW_INLINE
ULONG
MofTemplate_c(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const char  _Arg0
    )
{
#define ARGUMENT_COUNT_c 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_c];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const char)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_c, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_49
//
#ifndef MofTemplate_zz_def
#define MofTemplate_zz_def
ETW_INLINE
ULONG
MofTemplate_zz(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ PCWSTR  _Arg0,
    _In_opt_ PCWSTR  _Arg1
    )
{
#define ARGUMENT_COUNT_zz 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_zz];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], 
                        (_Arg0 != NULL) ? _Arg0 : L"NULL",
                        (_Arg0 != NULL) ? (ULONG)((wcslen(_Arg0) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    EventDataDescCreate(&EventData[1], 
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_zz, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_1
//
#ifndef MofTemplate_pqq_def
#define MofTemplate_pqq_def
ETW_INLINE
ULONG
MofTemplate_pqq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ const void *  _Arg0,
    _In_ const unsigned int  _Arg1,
    _In_ const unsigned int  _Arg2
    )
{
#define ARGUMENT_COUNT_pqq 3
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_pqq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(PVOID)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_pqq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : IntBounds
//
#ifndef MofTemplate_qqqq_def
#define MofTemplate_qqqq_def
ETW_INLINE
ULONG
MofTemplate_qqqq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const unsigned int  _Arg0,
    _In_ const unsigned int  _Arg1,
    _In_ const unsigned int  _Arg2,
    _In_ const unsigned int  _Arg3
    )
{
#define ARGUMENT_COUNT_qqqq 4
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_qqqq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_qqqq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : FloatBounds
//
#ifndef MofTemplate_ffff_def
#define MofTemplate_ffff_def
ETW_INLINE
ULONG
MofTemplate_ffff(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const float  _Arg0,
    _In_ const float  _Arg1,
    _In_ const float  _Arg2,
    _In_ const float  _Arg3
    )
{
#define ARGUMENT_COUNT_ffff 4
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_ffff];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const float)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const float)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const float)  );

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(const float)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_ffff, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : HwndTemplate
//
#ifndef MofTemplate_x_def
#define MofTemplate_x_def
ETW_INLINE
ULONG
MofTemplate_x(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ unsigned __int64  _Arg0
    )
{
#define ARGUMENT_COUNT_x 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_x];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(unsigned __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_x, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_12
//
#ifndef MofTemplate_xx_def
#define MofTemplate_xx_def
ETW_INLINE
ULONG
MofTemplate_xx(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ unsigned __int64  _Arg0,
    _In_ unsigned __int64  _Arg1
    )
{
#define ARGUMENT_COUNT_xx 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_xx];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(unsigned __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(unsigned __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_xx, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_15
//
#ifndef MofTemplate_pq_def
#define MofTemplate_pq_def
ETW_INLINE
ULONG
MofTemplate_pq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ const void *  _Arg0,
    _In_ const unsigned int  _Arg1
    )
{
#define ARGUMENT_COUNT_pq 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_pq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(PVOID)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_pq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : CreateOrAddOnChnl
//
#ifndef MofTemplate_ipqq_def
#define MofTemplate_ipqq_def
ETW_INLINE
ULONG
MofTemplate_ipqq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_opt_ const void *  _Arg1,
    _In_ const unsigned int  _Arg2,
    _In_ const unsigned int  _Arg3
    )
{
#define ARGUMENT_COUNT_ipqq 4
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_ipqq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(PVOID)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_ipqq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : CreateWpfGfxResource
//
#ifndef MofTemplate_pqqq_def
#define MofTemplate_pqqq_def
ETW_INLINE
ULONG
MofTemplate_pqqq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ const void *  _Arg0,
    _In_ const unsigned int  _Arg1,
    _In_ const unsigned int  _Arg2,
    _In_ const unsigned int  _Arg3
    )
{
#define ARGUMENT_COUNT_pqqq 4
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_pqqq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(PVOID)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[3], &_Arg3, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_pqqq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : Template_21
//
#ifndef MofTemplate_ii_def
#define MofTemplate_ii_def
ETW_INLINE
ULONG
MofTemplate_ii(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ signed __int64  _Arg0,
    _In_ signed __int64  _Arg1
    )
{
#define ARGUMENT_COUNT_ii 2
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_ii];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(signed __int64)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(signed __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_ii, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : CreateIRT
//
#ifndef MofTemplate_ppq_def
#define MofTemplate_ppq_def
ETW_INLINE
ULONG
MofTemplate_ppq(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ const void *  _Arg0,
    _In_opt_ const void *  _Arg1,
    _In_ const unsigned int  _Arg2
    )
{
#define ARGUMENT_COUNT_ppq 3
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_ppq];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(PVOID)  );

    EventDataDescCreate(&EventData[1], &_Arg1, sizeof(PVOID)  );

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(const unsigned int)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_ppq, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : PtrTemplate
//
#ifndef MofTemplate_p_def
#define MofTemplate_p_def
ETW_INLINE
ULONG
MofTemplate_p(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_opt_ const void *  _Arg0
    )
{
#define ARGUMENT_COUNT_p 1
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_p];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(PVOID)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_p, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

//
//Template from manifest : DispatcherMessage
//
#ifndef MofTemplate_qzi_def
#define MofTemplate_qzi_def
ETW_INLINE
ULONG
MofTemplate_qzi(
    _In_ REGHANDLE RegHandle,
    _In_ PCEVENT_DESCRIPTOR Descriptor,
    _In_opt_ LPCGUID EventGuid,
    _In_ const unsigned int  _Arg0,
    _In_opt_ PCWSTR  _Arg1,
    _In_ signed __int64  _Arg2
    )
{
#define ARGUMENT_COUNT_qzi 3
typedef struct _MCGEN_TRACE_BUFFER {
    EVENT_TRACE_HEADER Header;
    EVENT_DATA_DESCRIPTOR EventData[ARGUMENT_COUNT_qzi];
} MCGEN_TRACE_BUFFER;

    MCGEN_TRACE_BUFFER TraceBuf;
    PEVENT_DATA_DESCRIPTOR EventData = TraceBuf.EventData;

    EventDataDescCreate(&EventData[0], &_Arg0, sizeof(const unsigned int)  );

    EventDataDescCreate(&EventData[1], 
                        (_Arg1 != NULL) ? _Arg1 : L"NULL",
                        (_Arg1 != NULL) ? (ULONG)((wcslen(_Arg1) + 1) * sizeof(WCHAR)) : (ULONG)sizeof(L"NULL"));

    EventDataDescCreate(&EventData[2], &_Arg2, sizeof(signed __int64)  );


  if (! McGenPreVista) {
    return PfnEventWrite(RegHandle, Descriptor, ARGUMENT_COUNT_qzi, EventData);

  } else {

    const MCGEN_TRACE_CONTEXT* Context = (const MCGEN_TRACE_CONTEXT*)(ULONG_PTR)RegHandle;
    //
    // Fill in header fields
    //

    TraceBuf.Header.GuidPtr = (ULONGLONG)EventGuid;
    TraceBuf.Header.Flags = WNODE_FLAG_TRACED_GUID |WNODE_FLAG_USE_GUID_PTR|WNODE_FLAG_USE_MOF_PTR;
    TraceBuf.Header.Class.Version = (USHORT)Descriptor->Version;
    TraceBuf.Header.Class.Level = Descriptor->Level;
    TraceBuf.Header.Class.Type = Descriptor->Opcode;
    TraceBuf.Header.Size = sizeof(MCGEN_TRACE_BUFFER);

    return TraceEvent(Context->Logger, &TraceBuf.Header);
  }
}
#endif

#endif // MCGEN_DISABLE_PROVIDER_CODE_GENERATION

#if defined(__cplusplus)
};
#endif

#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_0_message 0xD0000001L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_1_message 0xD0000002L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_2_message 0xD0000003L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_3_message 0xD0000004L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_4_message 0xD0000005L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_5_message 0xD0000006L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_6_message 0xD0000007L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_7_message 0xD0000008L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_8_message 0xD0000009L
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_9_message 0xD000000AL
#define MSG_Microsoft_Windows_WPF_map_DispatcherPriority_10_message 0xD000000BL
#define MSG_UnexptectedSWFallback_NoHardwareAvailable 0xD000000CL
#define MSG_UnexpectedSWFallback_ResizeFailed 0xD000000DL
#define MSG_UnexpectedSWFallback_OutOfVideoMemory 0xD000000EL
#define MSG_UnexpectedSWFallback_UnexpectedPrimitiveFallback 0xD000000FL
#define MSG_Layout_LayoutManager             0xD0000010L
#define MSG_Layout_HwndSource_SetLayoutSize  0xD0000011L
#define MSG_Layout_HwndSource_WM_SIZE        0xD0000012L
#define MSG_IRT_Clip                         0xD0000013L
#define MSG_IRT_ClipAndOpacity               0xD0000014L
#define MSG_IRT_Effect                       0xD0000015L
#define MSG_IRT_Opacity                      0xD0000016L
#define MSG_IRT_OpacityMask                  0xD0000017L
#define MSG_IRT_OpacityMask_Brush_Realization 0xD0000018L
#define MSG_IRT_ShaderEffect_Input           0xD0000019L
#define MSG_IRT_Software_Only_Effects        0xD000001AL
#define MSG_IRT_TileBrush                    0xD000001BL
