% SPDX-FileCopyrightText: 2022 James R. Barlow
% SPDX-License-Identifier: CC-BY-SA-4.0

# OCRmyPDF documentation

:::{figure} images/logo.svg
:::

OCRmyPDF adds an optical character recognition (OCR) text layer to scanned PDF
files, allowing them to be searched.

PDF is the best format for storing and exchanging scanned documents.
Unfortunately, PDFs can be difficult to modify. OCRmyPDF makes it easy to apply
image processing and OCR (recognized, searchable text) to existing PDFs.

```{toctree}
:maxdepth: 1

introduction
release_notes
installation
languages
jbig2
```

```{toctree}
:caption: Usage
:maxdepth: 2

cookbook
optimizer
docker
advanced
batch
cloud
performance
pdfsecurity
errors
```

```{toctree}
:caption: Developers
:maxdepth: 2

api
plugins
apiref
design_notes
contributing
maintainers
```

# Indices and tables

- {ref}`genindex`
- {ref}`modindex`
- {ref}`search`
