A struct pattern attempted to extract a nonexistent field from a struct.

Erroneous code example:

```compile_fail,E0026
struct Thing {
    x: u32,
    y: u32,
}

let thing = Thing { x: 0, y: 0 };

match thing {
    Thing { x, z } => {} // error: `Thing::z` field doesn't exist
}
```

If you are using shorthand field patterns but want to refer to the struct field
by a different name, you should rename it explicitly. Struct fields are
identified by the name used before the colon `:` so struct patterns should
resemble the declaration of the struct type being matched.

```
struct Thing {
    x: u32,
    y: u32,
}

let thing = Thing { x: 0, y: 0 };

match thing {
    Thing { x, y: z } => {} // we renamed `y` to `z`
}
```
