# CUSTOM_ENV_VARIABLES indicates custom changes made to get cdash running.
# We had to change this path from the original design.
IF( DEFINED ENV{CUSTOM_ENV_VARIABLES} )
  INCLUDE("${CTEST_SCRIPT_DIRECTORY}/../../TrilinosCTestDriverCore.cmake")
ELSE()
  INCLUDE("${PROJECT_SOURCE_DIR}/cmake/ctest//TrilinosCTestDriverCore.cmake")
ENDIF()

#
# Platform/compiler specific options for typhon using gcc
#

MACRO(TRILINOS_SYSTEM_SPECIFIC_CTEST_DRIVER)

  # Base of Trilinos/cmake/ctest then BUILD_DIR_NAME

  # For CUSTOM_ENV_VARIABLES we disabled this to set custom build folders
  IF( NOT DEFINED ENV{CUSTOM_ENV_VARIABLES} )
    SET( CTEST_DASHBOARD_ROOT "${TRILINOS_CMAKE_DIR}/../../${BUILD_DIR_NAME}" )
  ENDIF()

  SET( CTEST_NOTES_FILES "${CTEST_SCRIPT_DIRECTORY}/${CTEST_SCRIPT_NAME}" )

  SET( CTEST_BUILD_FLAGS "-j16 -i" )

  SET_DEFAULT( CTEST_PARALLEL_LEVEL "16" )

  SET_DEFAULT( Trilinos_ENABLE_SECONDARY_TESTED_CODE ON)

  SET_DEFAULT(Trilinos_EXCLUDE_PACKAGES ${EXTRA_EXCLUDE_PACKAGES} TriKota Optika)

  SET( EXTRA_SYSTEM_CONFIGURE_OPTIONS
    "-DCMAKE_BUILD_TYPE:STRING=${BUILD_TYPE}"
    "-DTrilinos_ENABLE_DEPENDENCY_UNIT_TESTS:BOOL=OFF"
    "-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON"

    "-DTrilinos_ENABLE_CXX11=ON"
    "-DTrilinos_CXX11_FLAGS:STRING=--std=c++11"

    "-DTPL_ENABLE_BLAS:BOOL=ON"
    "-DTPL_ENABLE_LAPACK:BOOL=ON"

    "-DSuperLU_INCLUDE_DIRS:PATH=$ENV{SEMS_SUPERLU_ROOT}/include"
    "-DSuperLU_LIBRARY_DIRS:PATH=$ENV{SEMS_SUPERLU_ROOT}/lib"
    "-DSuperLU_LIBRARY_NAMES:STRING=superlu"

    "-DBoost_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_BOOST_ROOT}/include"
    "-DBoost_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_BOOST_ROOT}/lib"

    "-DBoostLib_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_BOOST_ROOT}/include"
    "-DBoostLib_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_BOOST_ROOT}/lib"

    "-DHDF5_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_HDF5_ROOT}/include"
    "-DHDF5_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_HDF5_ROOT}/lib"

    "-DNetcdf_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_NETCDF_ROOT}/include"
    "-DNetcdf_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_NETCDF_ROOT}/lib"

    "-DZlib_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_ZLIB_ROOT}/include"
    "-DZlib_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_ZLIB_ROOT}/lib"
    )


  # Adds in the Parmetis and Scotch paths we needed
  IF( DEFINED ENV{CUSTOM_ENV_VARIABLES} )
    SET( EXTRA_SYSTEM_CONFIGURE_OPTIONS
      ${EXTRA_SYSTEM_CONFIGURE_OPTIONS}
      "-DParMETIS_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_PARMETIS_ROOT}/include"
      "-DParMETIS_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_PARMETIS_ROOT}/lib"
      "-DParMETIS_LIBRARY_NAMES:STRING=$ENV{SEMS_PARMETIS_LIBRARY_NAMES}"
      "-DScotch_INCLUDE_DIRS:FILEPATH=$ENV{SEMS_SCOTCH_ROOT}/include"
      "-DScotch_LIBRARY_DIRS:FILEPATH=$ENV{SEMS_SCOTCH_ROOT}/lib"
      "-DScotch_LIBRARY_NAMES:STRING=$ENV{SEMS_SCOTCH_LIBRARY_NAMES}"
    )
  ENDIF()

  SET_DEFAULT(COMPILER_VERSION "$ENV{SEMS_COMPILER_NAME}-$ENV{SEMS_COMPILER_VERSION}")

  #Ensuring that MPI is on for all parallel builds that might be run.
  IF(COMM_TYPE STREQUAL MPI)
    SET( EXTRA_SYSTEM_CONFIGURE_OPTIONS
        ${EXTRA_SYSTEM_CONFIGURE_OPTIONS}
        "-DTPL_ENABLE_MPI=ON"
        "-DMPI_BASE_DIR=$ENV{SEMS_OPENMPI_ROOT}"
       )
  ELSE()
    SET( EXTRA_SYSTEM_CONFIGURE_OPTIONS
        ${EXTRA_SYSTEM_CONFIGURE_OPTIONS}
        "-DCMAKE_CXX_COMPILER:FILEPATH=$ENV{CXX}"
        "-DCMAKE_C_COMPILER:FILEPATH=$ENV{CC}"
        "-DCMAKE_Fortran_COMPILER:FILEPATH=$ENV{FC}"
       )
  ENDIF()

  TRILINOS_CTEST_DRIVER()

ENDMACRO()
