/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.Global;
import rene.gui.MyChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.HelpCloseDialog;

public class ExportScaler
extends HelpCloseDialog
implements ItemListener {
    TextFieldAction W;
    TextFieldAction H;
    TextFieldAction Scale;
    TextFieldAction Width;
    TextFieldAction Height;
    TextFieldAction DPI;
    TextFieldAction LineWidth;
    TextFieldAction TextSize;
    TextFieldAction PointSize;
    Checkbox Middle;
    Checkbox Sizes;
    Checkbox Aspect;
    Checkbox Latex;
    ZirkelFrame F;
    boolean AbsCoord;
    MyChoice Presets;
    String[] Pres = new String[]{"printscaler.preset", "printscaler.preset.300dpi", "printscaler.preset.300dpi12", "printscaler.preset.window", "printscaler.preset.clip50", "printscaler.preset.latex10"};
    String[] PresVect = new String[]{"printscaler.preset", "printscaler.preset.300dpi", "printscaler.preset.300dpi12"};

    public ExportScaler(ZirkelFrame zirkelFrame, boolean bl) {
        super(zirkelFrame, Global.name("printscaler.title"), true);
        int n;
        this.F = zirkelFrame;
        this.AbsCoord = bl;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(1, 2));
        myPanel.add(new MyLabel(Zirkel.name("printscaler.presets")));
        this.Presets = new MyChoice();
        myPanel.add(this.Presets);
        if (bl) {
            for (n = 0; n < this.Pres.length; ++n) {
                this.Presets.add(Zirkel.name(this.Pres[n]));
            }
        } else {
            for (n = 0; n < this.PresVect.length; ++n) {
                this.Presets.add(Zirkel.name(this.PresVect[n]));
            }
        }
        this.Presets.addItemListener(this);
        this.add("North", new Panel3D(myPanel));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.setLayout(new BorderLayout());
        MyPanel myPanel3 = new MyPanel();
        myPanel3.setLayout(new BorderLayout());
        MyPanel myPanel4 = new MyPanel();
        myPanel4.setLayout(new GridLayout(0, 2));
        double d2 = Global.getParameter("printscale.scale", 1.0);
        int n2 = (int)((double)this.F.ZC.IW * d2);
        int n3 = (int)((double)this.F.ZC.IH * d2);
        myPanel4.add(new MyLabel(Zirkel.name("printscaler.w")));
        this.W = new TextFieldAction(this, "w");
        myPanel4.add(this.W);
        this.W.setText("" + Global.getParameter("printscale.w", n2));
        myPanel4.add(new MyLabel(Zirkel.name("printscaler.h")));
        this.H = new TextFieldAction(this, "h");
        myPanel4.add(this.H);
        this.H.setText("" + Global.getParameter("printscale.h", n3));
        myPanel4.add(new MyLabel(Zirkel.name("printscaler.scale")));
        this.Scale = new TextFieldAction(this, "scale");
        myPanel4.add(this.Scale);
        this.Scale.setText("" + Global.getParameter("printscale.scale", 1.0));
        myPanel4.add(new MyLabel(Zirkel.name("printscaler.aspect")));
        this.Aspect = new CheckboxAction(this, "", "aspect");
        myPanel4.add(this.Aspect);
        this.Aspect.setState(Global.getParameter("printscale.aspect", false));
        myPanel4.add(new MyLabel(Zirkel.name("printscaler.middle")));
        this.Middle = new CheckboxAction(this, "", "middle");
        myPanel4.add(this.Middle);
        this.Middle.setState(Global.getParameter("printscale.middle", false));
        if (bl) {
            myPanel2.add("North", new Panel3D(myPanel4));
        }
        myPanel3.add("Center", new Panel3D(myPanel4));
        MyPanel myPanel5 = new MyPanel();
        myPanel5.setLayout(new GridLayout(0, 2));
        myPanel5.add(new MyLabel(Zirkel.name("printscaler.latex")));
        this.Latex = new CheckboxAction(this, "", "latex");
        myPanel5.add(this.Latex);
        this.Latex.setState(Global.getParameter("printscale.latex", false));
        myPanel3.add("South", new Panel3D(myPanel5));
        if (bl) {
            myPanel2.add("North", myPanel3);
        }
        MyPanel myPanel6 = new MyPanel();
        myPanel6.setLayout(new GridLayout(0, 2));
        myPanel6.add(new MyLabel(Zirkel.name("printscaler.width")));
        this.Width = new TextFieldAction(this, "width");
        myPanel6.add(this.Width);
        this.Width.setText("" + Global.getParameter("printscale.width", 5.0));
        myPanel6.add(new MyLabel(Zirkel.name("printscaler.height")));
        this.Height = new TextFieldAction(this, "height");
        myPanel6.add(this.Height);
        this.Height.setText("" + Global.getParameter("printscale.height", 5.0));
        myPanel6.add(new MyLabel(Zirkel.name("printscaler.dpi")));
        this.DPI = new TextFieldAction(this, "dpi");
        myPanel6.add(this.DPI);
        this.DPI.setText("" + Global.getParameter("printscale.dpi", 300));
        myPanel2.add("Center", new Panel3D(myPanel6));
        MyPanel myPanel7 = new MyPanel();
        myPanel7.setLayout(new GridLayout(0, 2));
        myPanel7.add(new MyLabel(Zirkel.name("printscaler.sizes")));
        this.Sizes = new CheckboxAction(this, "", "sizes");
        myPanel7.add(this.Sizes);
        this.Sizes.setState(Global.getParameter("printscale.sizes", true));
        myPanel7.add(new MyLabel(Zirkel.name("printscaler.linewidth")));
        this.LineWidth = new TextFieldAction(this, "linewidth");
        myPanel7.add(this.LineWidth);
        this.LineWidth.setText("" + Global.getParameter("printscale.linewidth", 0.02));
        myPanel7.add(new MyLabel(Zirkel.name("printscaler.pointsize")));
        this.PointSize = new TextFieldAction(this, "pointsize");
        myPanel7.add(this.PointSize);
        this.PointSize.setText("" + Global.getParameter("printscale.pointsize", 0.07));
        myPanel7.add(new MyLabel(Zirkel.name("printscaler.textsize")));
        this.TextSize = new TextFieldAction(this, "textsize");
        myPanel7.add(this.TextSize);
        this.TextSize.setText("" + Global.getParameter("printscale.textsize", 0.3));
        myPanel2.add("South", new Panel3D(myPanel7));
        this.add("Center", myPanel2);
        MyPanel myPanel8 = new MyPanel();
        myPanel8.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        myPanel8.add(new ButtonAction(this, Zirkel.name("cancel"), "Close"));
        this.addHelp(myPanel8, "print");
        this.add("South", new Panel3D(myPanel8));
        String string = Global.getParameter("printscaler.changed", "");
        if (string.equals("scale")) {
            this.doAction("scale");
        } else if (string.equals("widthheight")) {
            this.doAction("width");
        } else {
            this.doAction("w");
        }
        if (this.Middle.getState()) {
            this.Sizes.setState(false);
        }
        this.pack();
        this.center(zirkelFrame);
        this.setVisible(true);
    }

    public double round(double d2) {
        return (double)Math.round(d2 * 100.0) / 100.0;
    }

    public void doAction(String string) {
        if (string.equals("width") || string.equals("height")) {
            double d2 = this.getValue(this.Width, 5.0, 1.0, 100.0);
            double d3 = this.getValue(this.Height, 5.0, 1.0, 100.0);
            this.Width.setText("" + this.round(d2));
            this.Height.setText("" + this.round(d3));
            if (this.Aspect.getState()) {
                if (string.equals("width")) {
                    this.Height.setText("" + this.round(d2 * (double)this.F.ZC.IH / (double)this.F.ZC.IW));
                } else if (string.equals("height")) {
                    this.Width.setText("" + this.round(d3 * (double)this.F.ZC.IW / (double)this.F.ZC.IH));
                }
            }
            this.setWHS();
            Global.setParameter("printscaler.changed", "widthheight");
        } else {
            if (string.equals("dpi")) {
                String string2 = Global.getParameter("printscaler.changed", "");
                if (string2.equals("wh") || string2.equals("scale")) {
                    this.doAction("w");
                } else {
                    this.doAction("width");
                }
                return;
            }
            if (string.equals("w") || string.equals("h")) {
                double d4 = this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0);
                double d5 = this.getValue(this.H, this.F.ZC.IW, 50.0, 5000.0);
                this.W.setText("" + (int)d4);
                this.H.setText("" + (int)d5);
                if (this.Aspect.getState()) {
                    if (string.equals("w")) {
                        this.H.setText("" + (int)(d4 * (double)this.F.ZC.IH / (double)this.F.ZC.IW));
                    } else if (string.equals("h")) {
                        this.W.setText("" + (int)(d5 * (double)this.F.ZC.IW / (double)this.F.ZC.IH));
                    }
                }
                this.Scale.setText("" + d4 / (double)this.F.ZC.IW);
                Global.setParameter("printscaler.changed", "wh");
                this.setWidthHeight();
            } else if (string.equals("scale")) {
                double d6 = this.getValue(this.Scale, 1.0, 0.1, 100.0);
                this.W.setText("" + (int)((double)this.F.ZC.IW * d6));
                this.H.setText("" + (int)((double)this.F.ZC.IH * d6));
                if (Global.getParameter("printscaler.changed", "").equals("scaled")) {
                    double d7 = this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0) / (this.getValue(this.Width, 5.0, 1.0, 100.0) / 2.54);
                    this.DPI.setText("" + this.round(d7));
                    System.out.println(d7);
                }
                Global.setParameter("printscaler.changed", "scale");
                this.setWidthHeight();
            } else if (string.equals("OK")) {
                if (this.Width.isChanged() || this.Height.isChanged() || this.DPI.isChanged()) {
                    this.setWHS();
                    Global.setParameter("printscaler.changed", "widthheight");
                } else if (this.W.isChanged() || this.H.isChanged()) {
                    this.setWidthHeight();
                    Global.setParameter("printscaler.changed", "wh");
                } else if (this.Scale.isChanged()) {
                    double d8 = this.getValue(this.Scale, 1.0, 0.1, 100.0);
                    this.W.setText("" + (int)((double)this.F.ZC.IW * d8));
                    this.H.setText("" + (int)((double)this.F.ZC.IH * d8));
                    Global.setParameter("printscaler.changed", "scale");
                    this.setWidthHeight();
                }
                Global.setParameter("printscale.w", this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0));
                Global.setParameter("printscale.h", this.getValue(this.H, this.F.ZC.IW, 50.0, 5000.0));
                Global.setParameter("printscale.scale", this.getValue(this.Scale, 1.0, 0.1, 100.0));
                Global.setParameter("printscale.width", this.getValue(this.Width, 5.0, 1.0, 100.0));
                Global.setParameter("printscale.height", this.getValue(this.Height, 5.0, 1.0, 100.0));
                Global.setParameter("printscale.dpi", this.getValue(this.DPI, 300.0, 50.0, 1200.0));
                Global.setParameter("printscale.linewidth", this.getValue(this.LineWidth, 0.02, 0.005, 0.5));
                Global.setParameter("printscale.pointsize", this.getValue(this.PointSize, 0.07, 0.01, 2.0));
                Global.setParameter("printscale.textsize", this.getValue(this.TextSize, 0.3, 0.05, 2.0));
                Global.setParameter("printscale.middle", this.Middle.getState());
                Global.setParameter("printscale.sizes", this.Sizes.getState());
                Global.setParameter("printscale.aspect", this.Aspect.getState());
                Global.setParameter("printscale.latex", this.Latex.getState());
                this.doclose();
            } else {
                super.doAction(string);
            }
        }
    }

    public void itemAction(String string, boolean bl) {
        if (string.equals("middle")) {
            this.Sizes.setState(false);
        } else if (string.equals("sizes")) {
            this.Middle.setState(false);
        }
    }

    public void setWHS() {
        double d2 = this.getValue(this.Width, 5.0, 1.0, 100.0);
        double d3 = this.getValue(this.Height, 5.0, 1.0, 100.0);
        double d4 = this.getValue(this.DPI, 300.0, 50.0, 4800.0);
        this.W.setText("" + (int)(d2 / 2.54 * d4));
        this.H.setText("" + (int)(d3 / 2.54 * d4));
        this.Scale.setText("" + d2 / 2.54 * d4 / (double)this.F.ZC.IW);
    }

    public void setWidthHeight() {
        int n = (int)this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0);
        int n2 = (int)this.getValue(this.H, this.F.ZC.IW, 50.0, 5000.0);
        double d2 = this.getValue(this.DPI, 300.0, 50.0, 4800.0);
        this.Width.setText("" + this.round((double)n / d2 * 2.54));
        this.Height.setText("" + this.round((double)n2 / d2 * 2.54));
    }

    double getValue(TextField textField, double d2, double d3, double d4) {
        try {
            String string = textField.getText();
            double d5 = 1.0;
            if (string.endsWith("pt")) {
                d5 = 0.035;
                string = string.substring(0, string.length() - 2);
            } else if (string.endsWith("cm")) {
                d5 = 1.0;
                string = string.substring(0, string.length() - 2);
            } else if (string.endsWith("mm")) {
                d5 = 0.1;
                string = string.substring(0, string.length() - 2);
            } else if (string.endsWith("cm")) {
                d5 = 1.0;
                string = string.substring(0, string.length() - 2);
            } else if (string.endsWith("''")) {
                d5 = 0.39370078740157477;
                string = string.substring(0, string.length() - 2);
            } else if (string.endsWith("cm")) {
                d5 = 1.0;
                string = string.substring(0, string.length() - 2);
            } else if (string.endsWith("in")) {
                d5 = 0.39370078740157477;
                string = string.substring(0, string.length() - 2);
            }
            double d6 = new Double(string) * d5;
            if (d6 > d4) {
                d6 = d4;
            }
            if (d6 < d3) {
                d6 = d3;
            }
            return d6;
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        switch (this.Presets.getSelectedIndex()) {
            case 1: {
                this.DPI.setText("300");
                this.Width.setText("" + this.round(this.F.ZC.DX));
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(true);
                this.LineWidth.setText("0.02");
                this.PointSize.setText("0.07");
                this.TextSize.setText("0.3");
                this.Latex.setState(false);
                this.doAction("width");
                Global.setParameter("printscaler.changed", "scaled");
                break;
            }
            case 2: {
                this.DPI.setText("300");
                this.Width.setText("12.0");
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(true);
                this.LineWidth.setText("0.02");
                this.PointSize.setText("0.07");
                this.TextSize.setText("0.3");
                this.Latex.setState(false);
                this.doAction("width");
                break;
            }
            case 3: {
                this.Scale.setText("1.0");
                this.DPI.setText("100");
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(false);
                this.Latex.setState(false);
                this.doAction("scale");
                break;
            }
            case 4: {
                this.Scale.setText("0.5");
                this.DPI.setText("100");
                this.Middle.setState(true);
                this.Aspect.setState(false);
                this.Sizes.setState(false);
                this.Latex.setState(false);
                this.doAction("scale");
                break;
            }
            case 5: {
                this.DPI.setText("300");
                this.Width.setText("12.0");
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(true);
                this.LineWidth.setText("0.02");
                this.PointSize.setText("0.07");
                this.TextSize.setText("0.35");
                this.Latex.setState(true);
                this.doAction("width");
            }
        }
    }
}

