/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DrawString;
import edu.hws.jcm.draw.Graph1D;
import edu.hws.jcm.draw.RiemannSumRects;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RiemannSums
extends GenericGraphApplet {
    private Variable intervals;
    private VariableInput intCtInput;
    private Choice methodChoice;
    private Function func;
    private Graph1D graph;
    private RiemannSumRects sums;

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.methodChoice) {
            this.sums.setMethod(this.methodChoice.getSelectedIndex());
            this.mainController.compute();
        } else {
            super.itemStateChanged(itemEvent);
        }
    }

    @Override
    protected void setUpParameterDefaults() {
        this.parameterDefaults = new Hashtable();
        String string = " 3 / (1 + " + this.getParameter("Variable", "x") + "^2)";
        this.parameterDefaults.put("Function", string);
        this.parameterDefaults.put("ComputeButtonName", "Compute!");
    }

    @Override
    protected void setUpCanvas() {
        Object object;
        Object object2;
        if (this.functionInput != null) {
            this.func = this.functionInput.getFunction(this.xVar);
        } else {
            object2 = this.getParameter("Function", " abs(" + this.xVar.getName() + ") ^ " + this.xVar.getName());
            object = new SimpleFunction((Expression)this.parser.parse((String)object2), this.xVar);
            this.func = new WrapperFunction((Function)object);
        }
        this.graph = new Graph1D(this.func);
        object2 = this.getColorParam("GraphColor");
        if (object2 != null) {
            this.graph.setColor((Color)object2);
        }
        if ((object = this.getNumericParam("IntervalCount")) == null || ((double[])object).length < 1) {
            object = new double[]{5.0};
        } else if (Double.isNaN(object[0]) || object[0] < 1.0 || object[0] > 5000.0) {
            object[0] = 5.0;
        }
        int n = (int)(object[0] + 0.5);
        if ("yes".equalsIgnoreCase(this.getParameter("UseIntervalInput", "yes"))) {
            this.intCtInput = new VariableInput(null, "" + n);
            this.intCtInput.setInputStyle(2);
            this.intCtInput.setMin(1.0);
            this.intCtInput.setMax(5000.0);
            this.intervals = this.intCtInput.getVariable();
        } else {
            this.intervals = new Variable(null, n);
        }
        int n2 = 0;
        String string = this.getParameter("Method");
        if (string != null && string.trim().length() > 0) {
            switch (string.trim().charAt(0)) {
                case 'L': 
                case 'l': {
                    n2 = 0;
                    break;
                }
                case 'R': 
                case 'r': {
                    n2 = 1;
                    break;
                }
                case 'M': 
                case 'm': {
                    n2 = 2;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = 3;
                    break;
                }
                case 'I': 
                case 'i': {
                    n2 = 4;
                    break;
                }
                case 'T': 
                case 't': {
                    n2 = 5;
                }
            }
        }
        if ("yes".equalsIgnoreCase(this.getParameter("UseMethodInput", "yes"))) {
            this.methodChoice = new Choice();
            this.methodChoice.add("Left Endpoint");
            this.methodChoice.add("Right Endpoint");
            this.methodChoice.add("Midpoint");
            this.methodChoice.add("~Circumscribed");
            this.methodChoice.add("~Inscribed");
            this.methodChoice.add("Trapezoid");
            this.methodChoice.select(n2);
            this.methodChoice.addItemListener(this);
        }
        this.sums = new RiemannSumRects(this.func, this.intervals);
        this.sums.setMethod(n2);
        this.canvas.add(this.sums);
        Color color = this.getColorParam("RectColor");
        if (color != null) {
            this.sums.setColor(color);
        }
        if ((color = this.getColorParam("OutlineColor")) != null) {
            this.sums.setOutlineColor(color);
        }
        super.setUpCanvas();
        this.canvas.getCoordinateRect().setGap(10);
        this.canvas.add(this.graph);
        DrawString drawString = new DrawString("sum = #", 0, new Value[]{this.sums.getValueObject(-1)});
        drawString.setBackgroundColor(this.getColorParam("TextBackground", Color.white));
        drawString.setColor(this.getColorParam("TextColor", Color.black));
        drawString.setFrameWidth(1);
        this.canvas.add(drawString);
        this.mainController.add(drawString);
        this.mainController.add(this.sums);
        if (this.intCtInput != null) {
            this.intCtInput.setOnUserAction(this.mainController);
        }
        this.canvas.getCoordinateRect().setOnChange(this.mainController);
    }

    @Override
    protected void setUpMainPanel() {
        super.setUpMainPanel();
        if (this.methodChoice == null && this.intCtInput == null) {
            return;
        }
        JCMPanel jCMPanel = new JCMPanel();
        jCMPanel.setLayout(new FlowLayout());
        jCMPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
        if (this.intCtInput != null) {
            jCMPanel.add(new Label("Intervals:"));
            jCMPanel.add(this.intCtInput);
        }
        if (this.methodChoice != null) {
            jCMPanel.add(new Label("Method:"));
            jCMPanel.add(this.methodChoice);
        }
        if (this.inputPanel == null) {
            this.mainPanel.add((Component)jCMPanel, "South");
        } else {
            this.inputPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
            this.inputPanel.add((Component)jCMPanel, "South");
        }
    }

    @Override
    protected void doLoadExample(String string) {
        Object object;
        int n = string.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            int n2;
            Object object2;
            object = string.substring(n + 1);
            string = string.substring(0, n);
            n = ((String)object).indexOf(";");
            if (n > 0) {
                object2 = ((String)object).substring(n + 1).trim();
                object = ((String)object).substring(0, n);
                if (((String)object2).length() > 0) {
                    switch (((String)object2).charAt(0)) {
                        case 'L': 
                        case 'l': {
                            n2 = 0;
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            n2 = 1;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            n2 = 2;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            n2 = 3;
                            break;
                        }
                        case 'I': 
                        case 'i': {
                            n2 = 4;
                            break;
                        }
                        case 'T': 
                        case 't': {
                            n2 = 5;
                            break;
                        }
                        default: {
                            n2 = -1;
                        }
                    }
                    if (n2 >= 0) {
                        this.sums.setMethod(n2);
                        if (this.methodChoice != null) {
                            this.methodChoice.select(n2);
                        }
                    }
                }
            }
            if (((StringTokenizer)(object2 = new StringTokenizer((String)object, " ,"))).countTokens() >= 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    try {
                        Double d = new Double(((StringTokenizer)object2).nextToken());
                        dArray[n2] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (((StringTokenizer)object2).countTokens() > 0) {
                    try {
                        Double d = new Double(((StringTokenizer)object2).nextToken());
                        double d2 = d;
                        if (d2 < 1.0) {
                            d2 = 1.0;
                        } else if (d2 > 5000.0) {
                            d2 = 5000.0;
                        }
                        this.intervals.setVal((int)(d2 + 0.5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
        } else {
            try {
                object = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                ((WrapperFunction)this.func).setFunction((Function)object);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object).setLimits(dArray);
        ((CoordinateRect)object).setRestoreBuffer();
        this.mainController.compute();
    }
}

