/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.MathObject;

public class StandardFunction
implements MathObject {
    private String name;
    private int code;

    public StandardFunction(int n) {
        this(StandardFunction.standardFunctionName(n), n);
    }

    public StandardFunction(String string, int n) {
        this.setName(string);
        this.code = n;
    }

    public int getOpCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public static String standardFunctionName(int n) {
        switch (n) {
            case -17: {
                return "sin";
            }
            case -18: {
                return "cos";
            }
            case -19: {
                return "tan";
            }
            case -20: {
                return "cot";
            }
            case -21: {
                return "sec";
            }
            case -22: {
                return "csc";
            }
            case -23: {
                return "arcsin";
            }
            case -24: {
                return "arccos";
            }
            case -25: {
                return "arctan";
            }
            case -26: {
                return "abs";
            }
            case -27: {
                return "sqrt";
            }
            case -28: {
                return "exp";
            }
            case -29: {
                return "ln";
            }
            case -30: {
                return "log2";
            }
            case -31: {
                return "log10";
            }
            case -32: {
                return "trunc";
            }
            case -33: {
                return "round";
            }
            case -34: {
                return "floor";
            }
            case -35: {
                return "ceiling";
            }
            case -36: {
                return "cubert";
            }
        }
        throw new IllegalArgumentException("Internal Error: Unknown standard function code.");
    }
}

