/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2024 Intel Corporation
 */

#ifndef __INTEL_CRT_REGS_H__
#define __INTEL_CRT_REGS_H__

#include "intel_display_reg_defs.h"

#define ADPA			_MMIO(0x61100)
#define PCH_ADPA		_MMIO(0xe1100)
#define VLV_ADPA		_MMIO(VLV_DISPLAY_BASE + 0x61100)
#define   ADPA_DAC_ENABLE			REG_BIT(31)
#define   ADPA_PIPE_SEL_MASK			REG_BIT(30)
#define   ADPA_PIPE_SEL(pipe)			REG_FIELD_PREP(ADPA_PIPE_SEL_MASK, (pipe))
#define   ADPA_PIPE_SEL_MASK_CPT		REG_GENMASK(30, 29)
#define   ADPA_PIPE_SEL_CPT(pipe)		REG_FIELD_PREP(ADPA_PIPE_SEL_MASK_CPT, (pipe))
#define   ADPA_CRT_HOTPLUG_MONITOR_MASK		REG_GENMASK(25, 24)
#define   ADPA_CRT_HOTPLUG_MONITOR_NONE		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_MONITOR_MASK, 0)
#define   ADPA_CRT_HOTPLUG_MONITOR_COLOR	REG_FIELD_PREP(ADPA_CRT_HOTPLUG_MONITOR_MASK, 3)
#define   ADPA_CRT_HOTPLUG_MONITOR_MONO		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_MONITOR_MASK, 2)
#define   ADPA_CRT_HOTPLUG_ENABLE		REG_BIT(23)
#define   ADPA_CRT_HOTPLUG_PERIOD_MASK		REG_BIT(22)
#define   ADPA_CRT_HOTPLUG_PERIOD_64		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_PERIOD_MASK, 0)
#define   ADPA_CRT_HOTPLUG_PERIOD_128		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_PERIOD_MASK, 1)
#define   ADPA_CRT_HOTPLUG_WARMUP_MASK		REG_BIT(21)
#define   ADPA_CRT_HOTPLUG_WARMUP_5MS		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_WARMUP_MASK, 0)
#define   ADPA_CRT_HOTPLUG_WARMUP_10MS		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_WARMUP_MASK, 1)
#define   ADPA_CRT_HOTPLUG_SAMPLE_MASK		REG_BIT(20)
#define   ADPA_CRT_HOTPLUG_SAMPLE_2S		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_SAMPLE_MASK, 0)
#define   ADPA_CRT_HOTPLUG_SAMPLE_4S		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_SAMPLE_MASK, 1)
#define   ADPA_CRT_HOTPLUG_VOLTAGE_MASK		REG_GENMASK(19, 18)
#define   ADPA_CRT_HOTPLUG_VOLTAGE_40		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_VOLTAGE_MASK, 0)
#define   ADPA_CRT_HOTPLUG_VOLTAGE_50		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_VOLTAGE_MASK, 1)
#define   ADPA_CRT_HOTPLUG_VOLTAGE_60		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_VOLTAGE_MASK, 2)
#define   ADPA_CRT_HOTPLUG_VOLTAGE_70		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_VOLTAGE_MASK, 3)
#define   ADPA_CRT_HOTPLUG_VOLREF_MASK		REG_BIT(17)
#define   ADPA_CRT_HOTPLUG_VOLREF_325MV		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_VOLREF_MASK, 0)
#define   ADPA_CRT_HOTPLUG_VOLREF_475MV		REG_FIELD_PREP(ADPA_CRT_HOTPLUG_VOLREF_MASK, 1)
#define   ADPA_CRT_HOTPLUG_FORCE_TRIGGER	REG_BIT(16)
#define   ADPA_USE_VGA_HVPOLARITY		REG_BIT(15)
#define   ADPA_HSYNC_CNTL_DISABLE		REG_BIT(11)
#define   ADPA_VSYNC_CNTL_DISABLE		REG_BIT(10)
#define   ADPA_VSYNC_ACTIVE_HIGH		REG_BIT(4)
#define   ADPA_HSYNC_ACTIVE_HIGH		REG_BIT(3)

#define _VGA_MSR_WRITE _MMIO(0x3c2)

#endif /* __INTEL_CRT_REGS_H__ */
