﻿' Definition of syntax model.
' DO NOT HAND EDIT

Imports System.Collections.Generic
Imports System.Collections.Immutable
Imports System.Runtime.CompilerServices
Imports Microsoft.CodeAnalysis.Syntax.InternalSyntax
Imports Microsoft.CodeAnalysis.VisualBasic.Syntax
Imports Roslyn.Utilities

Namespace Microsoft.CodeAnalysis.VisualBasic.Syntax.InternalSyntax

    ''' <summary>
    ''' The base class for all nodes in the VB syntax tree.
    ''' </summary>
    Partial Friend MustInherit Class VisualBasicSyntaxNode


        Public Overridable Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitVisualBasicSyntaxNode(Me)
        End Function


    End Class

    ''' <summary>
    ''' The base class for all nodes that represent statements. This includes both
    ''' declaration statements, such as class declarations as well as executable
    ''' statements.
    ''' </summary>
    Friend MustInherit Class StatementSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' The base class for all nodes that represent executable statements.
    ''' </summary>
    Friend MustInherit Class ExecutableStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' The base class for all nodes that represent statements that declare options,
    ''' imports, members, etc.
    ''' </summary>
    Friend MustInherit Class DeclarationStatementSyntax
        Inherits StatementSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' A class to represent an empty statement. This can occur when a colon is on a
    ''' line without anything else.
    ''' </summary>
    Friend NotInheritable Class EmptyStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _empty as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EmptyStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' An empty token because all non terminals must have a token.
        ''' </summary>
        Friend ReadOnly Property Empty As InternalSyntax.PunctuationSyntax
            Get
                Return Me._empty
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._empty
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EmptyStatementSyntax(Me.Kind, newErrors, GetAnnotations, _empty)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EmptyStatementSyntax(Me.Kind, GetDiagnostics, annotations, _empty)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEmptyStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "End XXX" statement, where XXX is a single keyword.
    ''' </summary>
    Friend NotInheritable Class EndBlockStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _endKeyword as KeywordSyntax
        Friend ReadOnly _blockKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(endKeyword)
            Me._endKeyword = endKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(endKeyword)
            Me._endKeyword = endKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), endKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(endKeyword)
            Me._endKeyword = endKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EndBlockStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "End" keyword
        ''' </summary>
        Friend ReadOnly Property EndKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._endKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword that ends the block. Must be one of: "If", "Using", "With",
        ''' "Select", "Structure", "Enum", "Interface", "Class", "Module", "Namespace",
        ''' "Sub", "Function", "Get, "Set", "Property", "Operator", "Event", "AddHandler",
        ''' "RemoveHandler", "RaiseEvent", "While", "Try" or "SyncLock".
        ''' </summary>
        Friend ReadOnly Property BlockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._blockKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._endKeyword
                Case 1
                    Return Me._blockKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EndBlockStatementSyntax(Me.Kind, newErrors, GetAnnotations, _endKeyword, _blockKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EndBlockStatementSyntax(Me.Kind, GetDiagnostics, annotations, _endKeyword, _blockKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEndBlockStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an entire source file of VB code.
    ''' </summary>
    Partial Friend NotInheritable Class CompilationUnitSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _options as GreenNode
        Friend ReadOnly _imports as GreenNode
        Friend ReadOnly _attributes as GreenNode
        Friend ReadOnly _members as GreenNode
        Friend ReadOnly _endOfFileToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, options As GreenNode, [imports] As GreenNode, attributes As GreenNode, members As GreenNode, endOfFileToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            If options IsNot Nothing Then
                AdjustFlagsAndWidth(options)
                Me._options = options
            End If
            If [imports] IsNot Nothing Then
                AdjustFlagsAndWidth([imports])
                Me._imports = [imports]
            End If
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endOfFileToken)
            Me._endOfFileToken = endOfFileToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, options As GreenNode, [imports] As GreenNode, attributes As GreenNode, members As GreenNode, endOfFileToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            If options IsNot Nothing Then
                AdjustFlagsAndWidth(options)
                Me._options = options
            End If
            If [imports] IsNot Nothing Then
                AdjustFlagsAndWidth([imports])
                Me._imports = [imports]
            End If
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endOfFileToken)
            Me._endOfFileToken = endOfFileToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), options As GreenNode, [imports] As GreenNode, attributes As GreenNode, members As GreenNode, endOfFileToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            If options IsNot Nothing Then
                AdjustFlagsAndWidth(options)
                Me._options = options
            End If
            If [imports] IsNot Nothing Then
                AdjustFlagsAndWidth([imports])
                Me._imports = [imports]
            End If
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endOfFileToken)
            Me._endOfFileToken = endOfFileToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CompilationUnitSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' Represents the list of Option statements at the beginning of a source file.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Options As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of OptionStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of OptionStatementSyntax)(Me._options)
            End Get
        End Property

        ''' <summary>
        ''' Represents the list of Imports statements at the beginning of a source file.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property [Imports] As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImportsStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImportsStatementSyntax)(Me._imports)
            End Get
        End Property

        ''' <summary>
        ''' Represents the list of AttributeStatements at the beginning of a source file
        ''' that contain the Assembly and Module attributes.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Attributes As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributesStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributesStatementSyntax)(Me._attributes)
            End Get
        End Property

        ''' <summary>
        ''' Represents the members of the default namespace for this source file: all the
        ''' top-level type and namespace declarations in the file. May also contain
        ''' Statements that are not valid
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

        ''' <summary>
        ''' Represents the end of the source file. This token may have trivia (whitespace,
        ''' comments, ...) attached to it.
        ''' </summary>
        Friend ReadOnly Property EndOfFileToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._endOfFileToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._options
                Case 1
                    Return Me._imports
                Case 2
                    Return Me._attributes
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endOfFileToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CompilationUnitSyntax(Me.Kind, newErrors, GetAnnotations, _options, _imports, _attributes, _members, _endOfFileToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CompilationUnitSyntax(Me.Kind, GetDiagnostics, annotations, _options, _imports, _attributes, _members, _endOfFileToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCompilationUnit(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Option statement, such as "Option Strict On".
    ''' </summary>
    Friend NotInheritable Class OptionStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _optionKeyword as KeywordSyntax
        Friend ReadOnly _nameKeyword as KeywordSyntax
        Friend ReadOnly _valueKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(optionKeyword)
            Me._optionKeyword = optionKeyword
            AdjustFlagsAndWidth(nameKeyword)
            Me._nameKeyword = nameKeyword
            If valueKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(valueKeyword)
                Me._valueKeyword = valueKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(optionKeyword)
            Me._optionKeyword = optionKeyword
            AdjustFlagsAndWidth(nameKeyword)
            Me._nameKeyword = nameKeyword
            If valueKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(valueKeyword)
                Me._valueKeyword = valueKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), optionKeyword As InternalSyntax.KeywordSyntax, nameKeyword As InternalSyntax.KeywordSyntax, valueKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(optionKeyword)
            Me._optionKeyword = optionKeyword
            AdjustFlagsAndWidth(nameKeyword)
            Me._nameKeyword = nameKeyword
            If valueKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(valueKeyword)
                Me._valueKeyword = valueKeyword
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OptionStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Option" keyword.
        ''' </summary>
        Friend ReadOnly Property OptionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._optionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword that identifies the option being set: Explicit, Strict, Compare or
        ''' Infer.
        ''' </summary>
        Friend ReadOnly Property NameKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._nameKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword that identifiers the value being set for the option: On, Off, Text
        ''' or Binary.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ValueKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._valueKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._optionKeyword
                Case 1
                    Return Me._nameKeyword
                Case 2
                    Return Me._valueKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OptionStatementSyntax(Me.Kind, newErrors, GetAnnotations, _optionKeyword, _nameKeyword, _valueKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OptionStatementSyntax(Me.Kind, GetDiagnostics, annotations, _optionKeyword, _nameKeyword, _valueKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOptionStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Imports statement, which has one or more imports clauses.
    ''' </summary>
    Friend NotInheritable Class ImportsStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _importsKeyword as KeywordSyntax
        Friend ReadOnly _importsClauses as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(importsKeyword)
            Me._importsKeyword = importsKeyword
            If importsClauses IsNot Nothing Then
                AdjustFlagsAndWidth(importsClauses)
                Me._importsClauses = importsClauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(importsKeyword)
            Me._importsKeyword = importsKeyword
            If importsClauses IsNot Nothing Then
                AdjustFlagsAndWidth(importsClauses)
                Me._importsClauses = importsClauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), importsKeyword As InternalSyntax.KeywordSyntax, importsClauses As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(importsKeyword)
            Me._importsKeyword = importsKeyword
            If importsClauses IsNot Nothing Then
                AdjustFlagsAndWidth(importsClauses)
                Me._importsClauses = importsClauses
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImportsStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Imports" keyword.
        ''' </summary>
        Friend ReadOnly Property ImportsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._importsKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of one or more import clauses. Each clause is either an alias, namespace
        ''' or XML namespace import.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property ImportsClauses As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ImportsClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ImportsClauseSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ImportsClauseSyntax)(Me._importsClauses))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._importsKeyword
                Case 1
                    Return Me._importsClauses
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImportsStatementSyntax(Me.Kind, newErrors, GetAnnotations, _importsKeyword, _importsClauses)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImportsStatementSyntax(Me.Kind, GetDiagnostics, annotations, _importsKeyword, _importsClauses)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImportsStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The base class for the possible clauses of an Imports statement.
    ''' </summary>
    Friend MustInherit Class ImportsClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents the clause of an Imports statement that imports all members of a
    ''' type or namespace or aliases a type or namespace.
    ''' </summary>
    Friend NotInheritable Class SimpleImportsClauseSyntax
        Inherits ImportsClauseSyntax

        Friend ReadOnly _alias as ImportAliasClauseSyntax
        Friend ReadOnly _name as NameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, [alias] As ImportAliasClauseSyntax, name As NameSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            If [alias] IsNot Nothing Then
                AdjustFlagsAndWidth([alias])
                Me._alias = [alias]
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, [alias] As ImportAliasClauseSyntax, name As NameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If [alias] IsNot Nothing Then
                AdjustFlagsAndWidth([alias])
                Me._alias = [alias]
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), [alias] As ImportAliasClauseSyntax, name As NameSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If [alias] IsNot Nothing Then
                AdjustFlagsAndWidth([alias])
                Me._alias = [alias]
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleImportsClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' An optional alias for the namespace or type being imported.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property [Alias] As InternalSyntax.ImportAliasClauseSyntax
            Get
                Return Me._alias
            End Get
        End Property

        ''' <summary>
        ''' The namespace or type being imported.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.NameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._alias
                Case 1
                    Return Me._name
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleImportsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _alias, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleImportsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _alias, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleImportsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an alias identifier followed by an "=" token in an Imports clause.
    ''' </summary>
    Friend NotInheritable Class ImportAliasClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _equalsToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImportAliasClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The identifier being introduced.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._equalsToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImportAliasClauseSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _equalsToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImportAliasClauseSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _equalsToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImportAliasClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Defines a XML namespace for XML expressions.
    ''' </summary>
    Friend NotInheritable Class XmlNamespaceImportsClauseSyntax
        Inherits ImportsClauseSyntax

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _xmlNamespace as XmlAttributeSyntax
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(xmlNamespace)
            Me._xmlNamespace = xmlNamespace
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(xmlNamespace)
            Me._xmlNamespace = xmlNamespace
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, xmlNamespace As XmlAttributeSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(xmlNamespace)
            Me._xmlNamespace = xmlNamespace
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlNamespaceImportsClauseSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        ''' <summary>
        ''' Identifies the XML namespace alias and URI.
        ''' </summary>
        Friend ReadOnly Property XmlNamespace As InternalSyntax.XmlAttributeSyntax
            Get
                Return Me._xmlNamespace
            End Get
        End Property

        Friend ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._xmlNamespace
                Case 2
                    Return Me._greaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlNamespaceImportsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _xmlNamespace, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlNamespaceImportsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _xmlNamespace, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlNamespaceImportsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Namespace statement, its contents and the End Namespace statement.
    ''' </summary>
    Friend NotInheritable Class NamespaceBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _namespaceStatement as NamespaceStatementSyntax
        Friend ReadOnly _members as GreenNode
        Friend ReadOnly _endNamespaceStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, namespaceStatement As NamespaceStatementSyntax, members As GreenNode, endNamespaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(namespaceStatement)
            Me._namespaceStatement = namespaceStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endNamespaceStatement)
            Me._endNamespaceStatement = endNamespaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, namespaceStatement As NamespaceStatementSyntax, members As GreenNode, endNamespaceStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(namespaceStatement)
            Me._namespaceStatement = namespaceStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endNamespaceStatement)
            Me._endNamespaceStatement = endNamespaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), namespaceStatement As NamespaceStatementSyntax, members As GreenNode, endNamespaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(namespaceStatement)
            Me._namespaceStatement = namespaceStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endNamespaceStatement)
            Me._endNamespaceStatement = endNamespaceStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamespaceBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The statement that begins the NamespaceBlock.
        ''' </summary>
        Friend ReadOnly Property NamespaceStatement As InternalSyntax.NamespaceStatementSyntax
            Get
                Return Me._namespaceStatement
            End Get
        End Property

        ''' <summary>
        ''' The declarations contained in the namespace statement.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

        ''' <summary>
        ''' The End Namespace statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndNamespaceStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endNamespaceStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._namespaceStatement
                Case 1
                    Return Me._members
                Case 2
                    Return Me._endNamespaceStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamespaceBlockSyntax(Me.Kind, newErrors, GetAnnotations, _namespaceStatement, _members, _endNamespaceStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamespaceBlockSyntax(Me.Kind, GetDiagnostics, annotations, _namespaceStatement, _members, _endNamespaceStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamespaceBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a namespace declaration. This node always
    ''' appears as the Begin of a BlockStatement with Kind=NamespaceBlock.
    ''' </summary>
    Friend NotInheritable Class NamespaceStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _namespaceKeyword as KeywordSyntax
        Friend ReadOnly _name as NameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(namespaceKeyword)
            Me._namespaceKeyword = namespaceKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(namespaceKeyword)
            Me._namespaceKeyword = namespaceKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), namespaceKeyword As InternalSyntax.KeywordSyntax, name As NameSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(namespaceKeyword)
            Me._namespaceKeyword = namespaceKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamespaceStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Namespace" keyword.
        ''' </summary>
        Friend ReadOnly Property NamespaceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._namespaceKeyword
            End Get
        End Property

        ''' <summary>
        ''' A (possibly dotted) name denoting the namespace being declared.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.NameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._namespaceKeyword
                Case 1
                    Return Me._name
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamespaceStatementSyntax(Me.Kind, newErrors, GetAnnotations, _namespaceKeyword, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamespaceStatementSyntax(Me.Kind, GetDiagnostics, annotations, _namespaceKeyword, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamespaceStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Class, Interface, Structure, Module, its contents
    ''' and the End statement that ends it.
    ''' </summary>
    Friend MustInherit Class TypeBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _inherits as GreenNode
        Friend ReadOnly _implements as GreenNode
        Friend ReadOnly _members as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode)
            MyBase.New(kind)

            If [inherits] IsNot Nothing Then
                AdjustFlagsAndWidth([inherits])
                Me._inherits = [inherits]
            End If
            If [implements] IsNot Nothing Then
                AdjustFlagsAndWidth([implements])
                Me._implements = [implements]
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If [inherits] IsNot Nothing Then
                AdjustFlagsAndWidth([inherits])
                Me._inherits = [inherits]
            End If
            If [implements] IsNot Nothing Then
                AdjustFlagsAndWidth([implements])
                Me._implements = [implements]
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode)
            MyBase.New(kind, errors, annotations)

            If [inherits] IsNot Nothing Then
                AdjustFlagsAndWidth([inherits])
                Me._inherits = [inherits]
            End If
            If [implements] IsNot Nothing Then
                AdjustFlagsAndWidth([implements])
                Me._implements = [implements]
            End If
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If

        End Sub

        ''' <summary>
        ''' A list of the Inherits declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property [Inherits] As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of InheritsStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of InheritsStatementSyntax)(Me._inherits)
            End Get
        End Property

        ''' <summary>
        ''' A list of the Implements declarations for the type.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property [Implements] As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImplementsStatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ImplementsStatementSyntax)(Me._implements)
            End Get
        End Property

        ''' <summary>
        ''' The declarations contained in the type or module.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a declaration of Module, its contents and the End statement that
    ''' ends it.
    ''' </summary>
    Friend NotInheritable Class ModuleBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _moduleStatement as ModuleStatementSyntax
        Friend ReadOnly _endModuleStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, moduleStatement As ModuleStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endModuleStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(moduleStatement)
            Me._moduleStatement = moduleStatement
            AdjustFlagsAndWidth(endModuleStatement)
            Me._endModuleStatement = endModuleStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, moduleStatement As ModuleStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endModuleStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(moduleStatement)
            Me._moduleStatement = moduleStatement
            AdjustFlagsAndWidth(endModuleStatement)
            Me._endModuleStatement = endModuleStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), moduleStatement As ModuleStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endModuleStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(moduleStatement)
            Me._moduleStatement = moduleStatement
            AdjustFlagsAndWidth(endModuleStatement)
            Me._endModuleStatement = endModuleStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ModuleBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Module" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property ModuleStatement As InternalSyntax.ModuleStatementSyntax
            Get
                Return Me._moduleStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Module" statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndModuleStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endModuleStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._moduleStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endModuleStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ModuleBlockSyntax(Me.Kind, newErrors, GetAnnotations, _moduleStatement, _inherits, _implements, _members, _endModuleStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ModuleBlockSyntax(Me.Kind, GetDiagnostics, annotations, _moduleStatement, _inherits, _implements, _members, _endModuleStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitModuleBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Structure, its contents and the End statement
    ''' that ends it.
    ''' </summary>
    Friend NotInheritable Class StructureBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _structureStatement as StructureStatementSyntax
        Friend ReadOnly _endStructureStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, structureStatement As StructureStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endStructureStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(structureStatement)
            Me._structureStatement = structureStatement
            AdjustFlagsAndWidth(endStructureStatement)
            Me._endStructureStatement = endStructureStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, structureStatement As StructureStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endStructureStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(structureStatement)
            Me._structureStatement = structureStatement
            AdjustFlagsAndWidth(endStructureStatement)
            Me._endStructureStatement = endStructureStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), structureStatement As StructureStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endStructureStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(structureStatement)
            Me._structureStatement = structureStatement
            AdjustFlagsAndWidth(endStructureStatement)
            Me._endStructureStatement = endStructureStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.StructureBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Structure" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property StructureStatement As InternalSyntax.StructureStatementSyntax
            Get
                Return Me._structureStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Structure" statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndStructureStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endStructureStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._structureStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endStructureStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new StructureBlockSyntax(Me.Kind, newErrors, GetAnnotations, _structureStatement, _inherits, _implements, _members, _endStructureStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new StructureBlockSyntax(Me.Kind, GetDiagnostics, annotations, _structureStatement, _inherits, _implements, _members, _endStructureStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitStructureBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Interface, its contents and the End statement
    ''' that ends it.
    ''' </summary>
    Friend NotInheritable Class InterfaceBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _interfaceStatement as InterfaceStatementSyntax
        Friend ReadOnly _endInterfaceStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, interfaceStatement As InterfaceStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endInterfaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(interfaceStatement)
            Me._interfaceStatement = interfaceStatement
            AdjustFlagsAndWidth(endInterfaceStatement)
            Me._endInterfaceStatement = endInterfaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, interfaceStatement As InterfaceStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endInterfaceStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(interfaceStatement)
            Me._interfaceStatement = interfaceStatement
            AdjustFlagsAndWidth(endInterfaceStatement)
            Me._endInterfaceStatement = endInterfaceStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), interfaceStatement As InterfaceStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endInterfaceStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(interfaceStatement)
            Me._interfaceStatement = interfaceStatement
            AdjustFlagsAndWidth(endInterfaceStatement)
            Me._endInterfaceStatement = endInterfaceStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InterfaceBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Interface" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property InterfaceStatement As InternalSyntax.InterfaceStatementSyntax
            Get
                Return Me._interfaceStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Interface" statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndInterfaceStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endInterfaceStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._interfaceStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endInterfaceStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InterfaceBlockSyntax(Me.Kind, newErrors, GetAnnotations, _interfaceStatement, _inherits, _implements, _members, _endInterfaceStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InterfaceBlockSyntax(Me.Kind, GetDiagnostics, annotations, _interfaceStatement, _inherits, _implements, _members, _endInterfaceStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInterfaceBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of a Class its contents and the End statement that
    ''' ends it.
    ''' </summary>
    Friend NotInheritable Class ClassBlockSyntax
        Inherits TypeBlockSyntax

        Friend ReadOnly _classStatement as ClassStatementSyntax
        Friend ReadOnly _endClassStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, classStatement As ClassStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endClassStatement As EndBlockStatementSyntax)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(classStatement)
            Me._classStatement = classStatement
            AdjustFlagsAndWidth(endClassStatement)
            Me._endClassStatement = endClassStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, classStatement As ClassStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endClassStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, [inherits], [implements], members)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(classStatement)
            Me._classStatement = classStatement
            AdjustFlagsAndWidth(endClassStatement)
            Me._endClassStatement = endClassStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), classStatement As ClassStatementSyntax, [inherits] As GreenNode, [implements] As GreenNode, members As GreenNode, endClassStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, [inherits], [implements], members)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(classStatement)
            Me._classStatement = classStatement
            AdjustFlagsAndWidth(endClassStatement)
            Me._endClassStatement = endClassStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ClassBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Class" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property ClassStatement As InternalSyntax.ClassStatementSyntax
            Get
                Return Me._classStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Class" statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndClassStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endClassStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._classStatement
                Case 1
                    Return Me._inherits
                Case 2
                    Return Me._implements
                Case 3
                    Return Me._members
                Case 4
                    Return Me._endClassStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ClassBlockSyntax(Me.Kind, newErrors, GetAnnotations, _classStatement, _inherits, _implements, _members, _endClassStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ClassBlockSyntax(Me.Kind, GetDiagnostics, annotations, _classStatement, _inherits, _implements, _members, _endClassStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitClassBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a declaration of an Enum, its contents and the End Enum statement
    ''' that ends it.
    ''' </summary>
    Friend NotInheritable Class EnumBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _enumStatement as EnumStatementSyntax
        Friend ReadOnly _members as GreenNode
        Friend ReadOnly _endEnumStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, enumStatement As EnumStatementSyntax, members As GreenNode, endEnumStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(enumStatement)
            Me._enumStatement = enumStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endEnumStatement)
            Me._endEnumStatement = endEnumStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, enumStatement As EnumStatementSyntax, members As GreenNode, endEnumStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(enumStatement)
            Me._enumStatement = enumStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endEnumStatement)
            Me._endEnumStatement = endEnumStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), enumStatement As EnumStatementSyntax, members As GreenNode, endEnumStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(enumStatement)
            Me._enumStatement = enumStatement
            If members IsNot Nothing Then
                AdjustFlagsAndWidth(members)
                Me._members = members
            End If
            AdjustFlagsAndWidth(endEnumStatement)
            Me._endEnumStatement = endEnumStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EnumBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The statement that begins the type or module.
        ''' </summary>
        Friend ReadOnly Property EnumStatement As InternalSyntax.EnumStatementSyntax
            Get
                Return Me._enumStatement
            End Get
        End Property

        ''' <summary>
        ''' The declarations contained in the enumeration.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Members As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._members)
            End Get
        End Property

        ''' <summary>
        ''' The End XXX statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndEnumStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endEnumStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._enumStatement
                Case 1
                    Return Me._members
                Case 2
                    Return Me._endEnumStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EnumBlockSyntax(Me.Kind, newErrors, GetAnnotations, _enumStatement, _members, _endEnumStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EnumBlockSyntax(Me.Kind, GetDiagnostics, annotations, _enumStatement, _members, _endEnumStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEnumBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Inherits or Implements statement in a Class, Structure or
    ''' Interface.
    ''' </summary>
    Friend MustInherit Class InheritsOrImplementsStatementSyntax
        Inherits DeclarationStatementSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an Inherits statement in a Class, Structure or Interface.
    ''' </summary>
    Friend NotInheritable Class InheritsStatementSyntax
        Inherits InheritsOrImplementsStatementSyntax

        Friend ReadOnly _inheritsKeyword as KeywordSyntax
        Friend ReadOnly _types as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, inheritsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(inheritsKeyword)
            Me._inheritsKeyword = inheritsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, inheritsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(inheritsKeyword)
            Me._inheritsKeyword = inheritsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), inheritsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(inheritsKeyword)
            Me._inheritsKeyword = inheritsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InheritsStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Inherits" keyword.
        ''' </summary>
        Friend ReadOnly Property InheritsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._inheritsKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the types being inherited.
        ''' </summary>
        Friend ReadOnly Property Types As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TypeSyntax)(Me._types))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._inheritsKeyword
                Case 1
                    Return Me._types
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InheritsStatementSyntax(Me.Kind, newErrors, GetAnnotations, _inheritsKeyword, _types)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InheritsStatementSyntax(Me.Kind, GetDiagnostics, annotations, _inheritsKeyword, _types)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInheritsStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Implements statement in a Class or Structure.
    ''' </summary>
    Friend NotInheritable Class ImplementsStatementSyntax
        Inherits InheritsOrImplementsStatementSyntax

        Friend ReadOnly _implementsKeyword as KeywordSyntax
        Friend ReadOnly _types as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), implementsKeyword As InternalSyntax.KeywordSyntax, types As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If types IsNot Nothing Then
                AdjustFlagsAndWidth(types)
                Me._types = types
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImplementsStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Implements" keyword.
        ''' </summary>
        Friend ReadOnly Property ImplementsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._implementsKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the types being implemented.
        ''' </summary>
        Friend ReadOnly Property Types As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TypeSyntax)(Me._types))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._implementsKeyword
                Case 1
                    Return Me._types
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImplementsStatementSyntax(Me.Kind, newErrors, GetAnnotations, _implementsKeyword, _types)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImplementsStatementSyntax(Me.Kind, GetDiagnostics, annotations, _implementsKeyword, _types)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImplementsStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract class for the beginning statement of a Module, Class, Interface or
    ''' Structure declaration. This node always appears as the Begin of a TypeBlock
    ''' with Kind=ModuleDeclarationBlock, ClassDeclarationBlock,
    ''' InterfaceDeclarationBlock or StructureDeclarationBlock.
    ''' </summary>
    Friend MustInherit Class TypeStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterList as TypeParameterListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If

        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The name of the type being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, a type parameter list with generic parameters for this type. If no
        ''' generic parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property TypeParameterList As InternalSyntax.TypeParameterListSyntax
            Get
                Return Me._typeParameterList
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Module declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=ModuleDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class ModuleStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _moduleKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(moduleKeyword)
            Me._moduleKeyword = moduleKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(moduleKeyword)
            Me._moduleKeyword = moduleKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, moduleKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(moduleKeyword)
            Me._moduleKeyword = moduleKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ModuleStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Module" keyword.
        ''' </summary>
        Friend ReadOnly Property ModuleKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._moduleKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._moduleKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ModuleStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _moduleKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ModuleStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _moduleKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitModuleStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Structure declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=StructureDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class StructureStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _structureKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(structureKeyword)
            Me._structureKeyword = structureKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(structureKeyword)
            Me._structureKeyword = structureKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, structureKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(structureKeyword)
            Me._structureKeyword = structureKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.StructureStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Structure" keyword.
        ''' </summary>
        Friend ReadOnly Property StructureKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._structureKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._structureKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new StructureStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _structureKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new StructureStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _structureKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitStructureStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Interface declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=InterfaceDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class InterfaceStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _interfaceKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(interfaceKeyword)
            Me._interfaceKeyword = interfaceKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(interfaceKeyword)
            Me._interfaceKeyword = interfaceKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, interfaceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(interfaceKeyword)
            Me._interfaceKeyword = interfaceKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InterfaceStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Interface" keyword.
        ''' </summary>
        Friend ReadOnly Property InterfaceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._interfaceKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._interfaceKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InterfaceStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _interfaceKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InterfaceStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _interfaceKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInterfaceStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of a Class declaration. This node always
    ''' appears as the Begin of a TypeBlock with Kind=ClassDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class ClassStatementSyntax
        Inherits TypeStatementSyntax

        Friend ReadOnly _classKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(classKeyword)
            Me._classKeyword = classKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(classKeyword)
            Me._classKeyword = classKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, classKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, identifier, typeParameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(classKeyword)
            Me._classKeyword = classKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ClassStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Class" keyword.
        ''' </summary>
        Friend ReadOnly Property ClassKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._classKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._classKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ClassStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _classKeyword, _identifier, _typeParameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ClassStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _classKeyword, _identifier, _typeParameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitClassStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning statement of an Enum declaration. This node always
    ''' appears as the Begin of an EnumBlock with Kind=EnumDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class EnumStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _enumKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _underlyingType as AsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(enumKeyword)
            Me._enumKeyword = enumKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If underlyingType IsNot Nothing Then
                AdjustFlagsAndWidth(underlyingType)
                Me._underlyingType = underlyingType
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(enumKeyword)
            Me._enumKeyword = enumKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If underlyingType IsNot Nothing Then
                AdjustFlagsAndWidth(underlyingType)
                Me._underlyingType = underlyingType
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, enumKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, underlyingType As AsClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(enumKeyword)
            Me._enumKeyword = enumKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If underlyingType IsNot Nothing Then
                AdjustFlagsAndWidth(underlyingType)
                Me._underlyingType = underlyingType
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EnumStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The "Enum" keyword.
        ''' </summary>
        Friend ReadOnly Property EnumKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._enumKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the enum being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' Optional "As XXX" clause describing the underlying type of the enumeration. If
        ''' no As clause was specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property UnderlyingType As InternalSyntax.AsClauseSyntax
            Get
                Return Me._underlyingType
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._enumKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._underlyingType
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EnumStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _enumKeyword, _identifier, _underlyingType)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EnumStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _enumKeyword, _identifier, _underlyingType)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEnumStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the type parameter list in a declaration.
    ''' </summary>
    Friend NotInheritable Class TypeParameterListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _ofKeyword as KeywordSyntax
        Friend ReadOnly _parameters as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The "Of" keyword.
        ''' </summary>
        Friend ReadOnly Property OfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ofKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the type parameters. There must be at least one type parameter in the
        ''' list.
        ''' </summary>
        Friend ReadOnly Property Parameters As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeParameterSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TypeParameterSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TypeParameterSyntax)(Me._parameters))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._ofKeyword
                Case 2
                    Return Me._parameters
                Case 3
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterListSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _ofKeyword, _parameters, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterListSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _ofKeyword, _parameters, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameterList(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a type parameter on a generic type declaration.
    ''' </summary>
    Friend NotInheritable Class TypeParameterSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _varianceKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterConstraintClause as TypeParameterConstraintClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If varianceKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(varianceKeyword)
                Me._varianceKeyword = varianceKeyword
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterConstraintClause IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterConstraintClause)
                Me._typeParameterConstraintClause = typeParameterConstraintClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If varianceKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(varianceKeyword)
                Me._varianceKeyword = varianceKeyword
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterConstraintClause IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterConstraintClause)
                Me._typeParameterConstraintClause = typeParameterConstraintClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), varianceKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterConstraintClause As TypeParameterConstraintClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If varianceKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(varianceKeyword)
                Me._varianceKeyword = varianceKeyword
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterConstraintClause IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterConstraintClause)
                Me._typeParameterConstraintClause = typeParameterConstraintClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' Represents the "In" or "Out" variance keyword on a type parameter, if present.
        ''' If no variance modifier was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property VarianceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._varianceKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the type parameter
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "As" keyword, if any type constraints were supplied. If no type constraints
        ''' were supplied, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property TypeParameterConstraintClause As InternalSyntax.TypeParameterConstraintClauseSyntax
            Get
                Return Me._typeParameterConstraintClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._varianceKeyword
                Case 1
                    Return Me._identifier
                Case 2
                    Return Me._typeParameterConstraintClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterSyntax(Me.Kind, newErrors, GetAnnotations, _varianceKeyword, _identifier, _typeParameterConstraintClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterSyntax(Me.Kind, GetDiagnostics, annotations, _varianceKeyword, _identifier, _typeParameterConstraintClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameter(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent of classes that describe type
    ''' parameter constraint clauses.
    ''' </summary>
    Friend MustInherit Class TypeParameterConstraintClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' One of the type parameter constraints clauses. This represents a constraint
    ''' clause in the form of "As Constraint".
    ''' </summary>
    Friend NotInheritable Class TypeParameterSingleConstraintClauseSyntax
        Inherits TypeParameterConstraintClauseSyntax

        Friend ReadOnly _asKeyword as KeywordSyntax
        Friend ReadOnly _constraint as ConstraintSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(constraint)
            Me._constraint = constraint

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(constraint)
            Me._constraint = constraint

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, constraint As ConstraintSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(constraint)
            Me._constraint = constraint

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterSingleConstraintClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "As" keyword, if any type constraints were supplied. If no type constraints
        ''' were supplied, Nothing is returned.
        ''' </summary>
        Friend ReadOnly Property AsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._asKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of the supplied constraints. If no constraints were supplied, Nothing is
        ''' returned.
        ''' </summary>
        Friend ReadOnly Property Constraint As InternalSyntax.ConstraintSyntax
            Get
                Return Me._constraint
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._constraint
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterSingleConstraintClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _constraint)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterSingleConstraintClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _constraint)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameterSingleConstraintClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' One of the type parameter constraints clauses. This represents a constraint
    ''' clause in the form of "As { Constraints }".
    ''' </summary>
    Friend NotInheritable Class TypeParameterMultipleConstraintClauseSyntax
        Inherits TypeParameterConstraintClauseSyntax

        Friend ReadOnly _asKeyword as KeywordSyntax
        Friend ReadOnly _openBraceToken as PunctuationSyntax
        Friend ReadOnly _constraints as GreenNode
        Friend ReadOnly _closeBraceToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If constraints IsNot Nothing Then
                AdjustFlagsAndWidth(constraints)
                Me._constraints = constraints
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If constraints IsNot Nothing Then
                AdjustFlagsAndWidth(constraints)
                Me._constraints = constraints
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, constraints As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If constraints IsNot Nothing Then
                AdjustFlagsAndWidth(constraints)
                Me._constraints = constraints
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeParameterMultipleConstraintClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Friend ReadOnly Property AsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._asKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Friend ReadOnly Property OpenBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openBraceToken
            End Get
        End Property

        ''' <summary>
        ''' A list of the supplied constraints. If no constraints were supplied, an empty
        ''' list is returned.
        ''' </summary>
        Friend ReadOnly Property Constraints As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ConstraintSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ConstraintSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ConstraintSyntax)(Me._constraints))
            End Get
        End Property

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Friend ReadOnly Property CloseBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeBraceToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._openBraceToken
                Case 2
                    Return Me._constraints
                Case 3
                    Return Me._closeBraceToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeParameterMultipleConstraintClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _openBraceToken, _constraints, _closeBraceToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeParameterMultipleConstraintClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _openBraceToken, _constraints, _closeBraceToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeParameterMultipleConstraintClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent of classes that describe type
    ''' parameter constraints.
    ''' </summary>
    Friend MustInherit Class ConstraintSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' One of the special type parameter constraints: New, Class or Structure. Which
    ''' kind of special constraint it is can be obtained from the Kind property and is
    ''' one of: NewConstraint, ReferenceConstraint or ValueConstraint.
    ''' </summary>
    Friend NotInheritable Class SpecialConstraintSyntax
        Inherits ConstraintSyntax

        Friend ReadOnly _constraintKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, constraintKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(constraintKeyword)
            Me._constraintKeyword = constraintKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, constraintKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(constraintKeyword)
            Me._constraintKeyword = constraintKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), constraintKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(constraintKeyword)
            Me._constraintKeyword = constraintKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SpecialConstraintSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "New", "Class" or "Structure" keyword that denotes the kind of special
        ''' constraint.
        ''' </summary>
        Friend ReadOnly Property ConstraintKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._constraintKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._constraintKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SpecialConstraintSyntax(Me.Kind, newErrors, GetAnnotations, _constraintKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SpecialConstraintSyntax(Me.Kind, GetDiagnostics, annotations, _constraintKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSpecialConstraint(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a type parameter constraint that is a type.
    ''' </summary>
    Friend NotInheritable Class TypeConstraintSyntax
        Inherits ConstraintSyntax

        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), type As TypeSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeConstraintSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type describing the constraint.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._type
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeConstraintSyntax(Me.Kind, newErrors, GetAnnotations, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeConstraintSyntax(Me.Kind, GetDiagnostics, annotations, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeConstraint(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a name and value in an EnumDeclarationBlock.
    ''' </summary>
    Friend NotInheritable Class EnumMemberDeclarationSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _initializer as EqualsValueSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, identifier As InternalSyntax.IdentifierTokenSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EnumMemberDeclarationSyntax(Me, parent, startLocation)
        End Function

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' An optional value for the enum member.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Initializer As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._identifier
                Case 2
                    Return Me._initializer
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EnumMemberDeclarationSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _identifier, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EnumMemberDeclarationSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _identifier, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEnumMemberDeclaration(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a block member declaration: A declaration that has a beginning
    ''' declaration, a body of executable statements and an end statement. Examples
    ''' include methods, constructors, operators, property accessors and custom event
    ''' accessors.
    ''' </summary>
    Friend MustInherit Class MethodBlockBaseSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode)
            MyBase.New(kind)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), statements As GreenNode)
            MyBase.New(kind, errors, annotations)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a Function or Sub block declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' </summary>
    Friend NotInheritable Class MethodBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _subOrFunctionStatement as MethodStatementSyntax
        Friend ReadOnly _endSubOrFunctionStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionStatement As MethodStatementSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(subOrFunctionStatement)
            Me._subOrFunctionStatement = subOrFunctionStatement
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionStatement As MethodStatementSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionStatement)
            Me._subOrFunctionStatement = subOrFunctionStatement
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionStatement As MethodStatementSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(subOrFunctionStatement)
            Me._subOrFunctionStatement = subOrFunctionStatement
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MethodBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property SubOrFunctionStatement As InternalSyntax.MethodStatementSyntax
            Get
                Return Me._subOrFunctionStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Sub" or "End Function" statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndSubOrFunctionStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSubOrFunctionStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subOrFunctionStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubOrFunctionStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MethodBlockSyntax(Me.Kind, newErrors, GetAnnotations, _subOrFunctionStatement, _statements, _endSubOrFunctionStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MethodBlockSyntax(Me.Kind, GetDiagnostics, annotations, _subOrFunctionStatement, _statements, _endSubOrFunctionStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMethodBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a constructor block declaration: A declaration that has a beginning
    ''' declaration, a body of executable statements and an end statement.
    ''' </summary>
    Friend NotInheritable Class ConstructorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _subNewStatement as SubNewStatementSyntax
        Friend ReadOnly _endSubStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subNewStatement As SubNewStatementSyntax, statements As GreenNode, endSubStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(subNewStatement)
            Me._subNewStatement = subNewStatement
            AdjustFlagsAndWidth(endSubStatement)
            Me._endSubStatement = endSubStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subNewStatement As SubNewStatementSyntax, statements As GreenNode, endSubStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subNewStatement)
            Me._subNewStatement = subNewStatement
            AdjustFlagsAndWidth(endSubStatement)
            Me._endSubStatement = endSubStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subNewStatement As SubNewStatementSyntax, statements As GreenNode, endSubStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(subNewStatement)
            Me._subNewStatement = subNewStatement
            AdjustFlagsAndWidth(endSubStatement)
            Me._endSubStatement = endSubStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ConstructorBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub New" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property SubNewStatement As InternalSyntax.SubNewStatementSyntax
            Get
                Return Me._subNewStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Sub" statement that ends the block declaration.
        ''' </summary>
        Friend ReadOnly Property EndSubStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSubStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subNewStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ConstructorBlockSyntax(Me.Kind, newErrors, GetAnnotations, _subNewStatement, _statements, _endSubStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ConstructorBlockSyntax(Me.Kind, GetDiagnostics, annotations, _subNewStatement, _statements, _endSubStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitConstructorBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Operator block member declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' </summary>
    Friend NotInheritable Class OperatorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _operatorStatement as OperatorStatementSyntax
        Friend ReadOnly _endOperatorStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, operatorStatement As OperatorStatementSyntax, statements As GreenNode, endOperatorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(operatorStatement)
            Me._operatorStatement = operatorStatement
            AdjustFlagsAndWidth(endOperatorStatement)
            Me._endOperatorStatement = endOperatorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, operatorStatement As OperatorStatementSyntax, statements As GreenNode, endOperatorStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(operatorStatement)
            Me._operatorStatement = operatorStatement
            AdjustFlagsAndWidth(endOperatorStatement)
            Me._endOperatorStatement = endOperatorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), operatorStatement As OperatorStatementSyntax, statements As GreenNode, endOperatorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(operatorStatement)
            Me._operatorStatement = operatorStatement
            AdjustFlagsAndWidth(endOperatorStatement)
            Me._endOperatorStatement = endOperatorStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OperatorBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Operator" statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property OperatorStatement As InternalSyntax.OperatorStatementSyntax
            Get
                Return Me._operatorStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Operator" statement that ends the block declaration.
        ''' </summary>
        Friend ReadOnly Property EndOperatorStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endOperatorStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._operatorStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endOperatorStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OperatorBlockSyntax(Me.Kind, newErrors, GetAnnotations, _operatorStatement, _statements, _endOperatorStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OperatorBlockSyntax(Me.Kind, GetDiagnostics, annotations, _operatorStatement, _statements, _endOperatorStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOperatorBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an accessor block member declaration: A declaration that has a
    ''' beginning declaration, a body of executable statements and an end statement.
    ''' Examples include property accessors and custom event accessors.
    ''' </summary>
    Friend NotInheritable Class AccessorBlockSyntax
        Inherits MethodBlockBaseSyntax

        Friend ReadOnly _accessorStatement as AccessorStatementSyntax
        Friend ReadOnly _endAccessorStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, accessorStatement As AccessorStatementSyntax, statements As GreenNode, endAccessorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(accessorStatement)
            Me._accessorStatement = accessorStatement
            AdjustFlagsAndWidth(endAccessorStatement)
            Me._endAccessorStatement = endAccessorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, accessorStatement As AccessorStatementSyntax, statements As GreenNode, endAccessorStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(accessorStatement)
            Me._accessorStatement = accessorStatement
            AdjustFlagsAndWidth(endAccessorStatement)
            Me._endAccessorStatement = endAccessorStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), accessorStatement As AccessorStatementSyntax, statements As GreenNode, endAccessorStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, statements)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(accessorStatement)
            Me._accessorStatement = accessorStatement
            AdjustFlagsAndWidth(endAccessorStatement)
            Me._endAccessorStatement = endAccessorStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AccessorBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Get", "Set", "AddHandler", "RemoveHandler", or "RaiseEvent" statement that
        ''' begins the accessor block.
        ''' </summary>
        Friend ReadOnly Property AccessorStatement As InternalSyntax.AccessorStatementSyntax
            Get
                Return Me._accessorStatement
            End Get
        End Property

        ''' <summary>
        ''' The "End Get", "End Set", "End AddHandler", "End RemoveHandler", or "End
        ''' RaiseEvent" statement that ends the accessor block.
        ''' </summary>
        Friend ReadOnly Property EndAccessorStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endAccessorStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._accessorStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endAccessorStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AccessorBlockSyntax(Me.Kind, newErrors, GetAnnotations, _accessorStatement, _statements, _endAccessorStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AccessorBlockSyntax(Me.Kind, GetDiagnostics, annotations, _accessorStatement, _statements, _endAccessorStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAccessorBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a block property declaration: A declaration that has a beginning
    ''' declaration, some get or set accessor blocks and an end statement.
    ''' </summary>
    Friend NotInheritable Class PropertyBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _propertyStatement as PropertyStatementSyntax
        Friend ReadOnly _accessors as GreenNode
        Friend ReadOnly _endPropertyStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, propertyStatement As PropertyStatementSyntax, accessors As GreenNode, endPropertyStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(propertyStatement)
            Me._propertyStatement = propertyStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endPropertyStatement)
            Me._endPropertyStatement = endPropertyStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, propertyStatement As PropertyStatementSyntax, accessors As GreenNode, endPropertyStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(propertyStatement)
            Me._propertyStatement = propertyStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endPropertyStatement)
            Me._endPropertyStatement = endPropertyStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), propertyStatement As PropertyStatementSyntax, accessors As GreenNode, endPropertyStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(propertyStatement)
            Me._propertyStatement = propertyStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endPropertyStatement)
            Me._endPropertyStatement = endPropertyStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PropertyBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The property declaration that begins the block.
        ''' </summary>
        Friend ReadOnly Property PropertyStatement As InternalSyntax.PropertyStatementSyntax
            Get
                Return Me._propertyStatement
            End Get
        End Property

        ''' <summary>
        ''' The accessor blocks contained in the property, between the Property and the End
        ''' Property statements.
        ''' </summary>
        Friend ReadOnly Property Accessors As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)(Me._accessors)
            End Get
        End Property

        ''' <summary>
        ''' The End Property statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndPropertyStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endPropertyStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._propertyStatement
                Case 1
                    Return Me._accessors
                Case 2
                    Return Me._endPropertyStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PropertyBlockSyntax(Me.Kind, newErrors, GetAnnotations, _propertyStatement, _accessors, _endPropertyStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PropertyBlockSyntax(Me.Kind, GetDiagnostics, annotations, _propertyStatement, _accessors, _endPropertyStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPropertyBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a custom event declaration: A declaration that has a beginning event
    ''' declaration, some accessor blocks and an end statement.
    ''' </summary>
    Friend NotInheritable Class EventBlockSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _eventStatement as EventStatementSyntax
        Friend ReadOnly _accessors as GreenNode
        Friend ReadOnly _endEventStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, eventStatement As EventStatementSyntax, accessors As GreenNode, endEventStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(eventStatement)
            Me._eventStatement = eventStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endEventStatement)
            Me._endEventStatement = endEventStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, eventStatement As EventStatementSyntax, accessors As GreenNode, endEventStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eventStatement)
            Me._eventStatement = eventStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endEventStatement)
            Me._endEventStatement = endEventStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eventStatement As EventStatementSyntax, accessors As GreenNode, endEventStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(eventStatement)
            Me._eventStatement = eventStatement
            If accessors IsNot Nothing Then
                AdjustFlagsAndWidth(accessors)
                Me._accessors = accessors
            End If
            AdjustFlagsAndWidth(endEventStatement)
            Me._endEventStatement = endEventStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EventBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The event declaration that begins the block.
        ''' </summary>
        Friend ReadOnly Property EventStatement As InternalSyntax.EventStatementSyntax
            Get
                Return Me._eventStatement
            End Get
        End Property

        ''' <summary>
        ''' The accessor blocks contained in the custom event declaration, between the
        ''' Event statement and the End Event statement.
        ''' </summary>
        Friend ReadOnly Property Accessors As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AccessorBlockSyntax)(Me._accessors)
            End Get
        End Property

        ''' <summary>
        ''' The End Event statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndEventStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endEventStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._eventStatement
                Case 1
                    Return Me._accessors
                Case 2
                    Return Me._endEventStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EventBlockSyntax(Me.Kind, newErrors, GetAnnotations, _eventStatement, _accessors, _endEventStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EventBlockSyntax(Me.Kind, GetDiagnostics, annotations, _eventStatement, _accessors, _endEventStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEventBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that is the parent for declarations that are
    ''' "method-like"; i.e., that have a parameter list and return type. This includes
    ''' methods, constructors, properties, events, operators, declares, delegates,
    ''' property accessors and custom event accessors.
    ''' </summary>
    Friend MustInherit Class MethodBaseSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _parameterList as ParameterListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, parameterList As ParameterListSyntax)
            MyBase.New(kind)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If parameterList IsNot Nothing Then
                AdjustFlagsAndWidth(parameterList)
                Me._parameterList = parameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, parameterList As ParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If parameterList IsNot Nothing Then
                AdjustFlagsAndWidth(parameterList)
                Me._parameterList = parameterList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, parameterList As ParameterListSyntax)
            MyBase.New(kind, errors, annotations)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If parameterList IsNot Nothing Then
                AdjustFlagsAndWidth(parameterList)
                Me._parameterList = parameterList
            End If

        End Sub

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned. A bitfield version of all
        ''' the modifiers ORed together, which is in many cases easier to use, can be
        ''' obtained with the Modifiers property.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The method's parameter list including the parentheses. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ParameterList As InternalSyntax.ParameterListSyntax
            Get
                Return Me._parameterList
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents the parameter list in a method declaration.
    ''' </summary>
    Friend NotInheritable Class ParameterListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _parameters as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, parameters As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If parameters IsNot Nothing Then
                AdjustFlagsAndWidth(parameters)
                Me._parameters = parameters
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ParameterListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token that introduces the parameter list. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of parameters. If no parameter list was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Parameters As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ParameterSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ParameterSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ParameterSyntax)(Me._parameters))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token that concludes the parameter list. If no parameter list was
        ''' present, Nothing is returned.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._parameters
                Case 2
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ParameterListSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _parameters, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ParameterListSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _parameters, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitParameterList(Me)
        End Function

    End Class

    ''' <summary>
    ''' The statement that declares a Sub or Function. If this method has a body, this
    ''' statement will be the Begin of a BlockStatement with
    ''' Kind=MethodDeclarationBlock, and the body of the method will be the Body of
    ''' that BlockStatement.
    ''' </summary>
    Friend NotInheritable Class MethodStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterList as TypeParameterListSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _handlesClause as HandlesClauseSyntax
        Friend ReadOnly _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 9

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If handlesClause IsNot Nothing Then
                AdjustFlagsAndWidth(handlesClause)
                Me._handlesClause = handlesClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 9
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If handlesClause IsNot Nothing Then
                AdjustFlagsAndWidth(handlesClause)
                Me._handlesClause = handlesClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, handlesClause As HandlesClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 9

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If handlesClause IsNot Nothing Then
                AdjustFlagsAndWidth(handlesClause)
                Me._handlesClause = handlesClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MethodStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword that introduces this method declaration.
        ''' </summary>
        Friend ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the method being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, a type parameter list with generic type parameters for this method.
        ''' If no generic type parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property TypeParameterList As InternalSyntax.TypeParameterListSyntax
            Get
                Return Me._typeParameterList
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, a Handles clause indicated the events that this method handles.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property HandlesClause As InternalSyntax.HandlesClauseSyntax
            Get
                Return Me._handlesClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an Implements clause indicated the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ImplementsClause As InternalSyntax.ImplementsClauseSyntax
            Get
                Return Me._implementsClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._subOrFunctionKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._typeParameterList
                Case 5
                    Return Me._parameterList
                Case 6
                    Return Me._asClause
                Case 7
                    Return Me._handlesClause
                Case 8
                    Return Me._implementsClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MethodStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause, _handlesClause, _implementsClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MethodStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause, _handlesClause, _implementsClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMethodStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares a constructor. This statement will be the Begin of a
    ''' BlockStatement with Kind=MethodDeclarationBlock, and the body of the method
    ''' will be the Body of that BlockStatement.
    ''' </summary>
    Friend NotInheritable Class SubNewStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _subKeyword as KeywordSyntax
        Friend ReadOnly _newKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(subKeyword)
            Me._subKeyword = subKeyword
            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subKeyword)
            Me._subKeyword = subKeyword
            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, subKeyword As InternalSyntax.KeywordSyntax, newKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(subKeyword)
            Me._subKeyword = subKeyword
            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SubNewStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" keyword.
        ''' </summary>
        Friend ReadOnly Property SubKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "New" keyword in the constructor declaration.
        ''' </summary>
        Friend ReadOnly Property NewKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._newKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._subKeyword
                Case 3
                    Return Me._newKeyword
                Case 4
                    Return Me._parameterList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SubNewStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _subKeyword, _newKeyword, _parameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SubNewStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _subKeyword, _newKeyword, _parameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSubNewStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A Declare statement that declares an external DLL method.
    ''' </summary>
    Friend NotInheritable Class DeclareStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _declareKeyword as KeywordSyntax
        Friend ReadOnly _charsetKeyword as KeywordSyntax
        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _libKeyword as KeywordSyntax
        Friend ReadOnly _libraryName as LiteralExpressionSyntax
        Friend ReadOnly _aliasKeyword as KeywordSyntax
        Friend ReadOnly _aliasName as LiteralExpressionSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 12

            AdjustFlagsAndWidth(declareKeyword)
            Me._declareKeyword = declareKeyword
            If charsetKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(charsetKeyword)
                Me._charsetKeyword = charsetKeyword
            End If
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(libKeyword)
            Me._libKeyword = libKeyword
            AdjustFlagsAndWidth(libraryName)
            Me._libraryName = libraryName
            If aliasKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(aliasKeyword)
                Me._aliasKeyword = aliasKeyword
            End If
            If aliasName IsNot Nothing Then
                AdjustFlagsAndWidth(aliasName)
                Me._aliasName = aliasName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 12
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(declareKeyword)
            Me._declareKeyword = declareKeyword
            If charsetKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(charsetKeyword)
                Me._charsetKeyword = charsetKeyword
            End If
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(libKeyword)
            Me._libKeyword = libKeyword
            AdjustFlagsAndWidth(libraryName)
            Me._libraryName = libraryName
            If aliasKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(aliasKeyword)
                Me._aliasKeyword = aliasKeyword
            End If
            If aliasName IsNot Nothing Then
                AdjustFlagsAndWidth(aliasName)
                Me._aliasName = aliasName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, declareKeyword As InternalSyntax.KeywordSyntax, charsetKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, libKeyword As InternalSyntax.KeywordSyntax, libraryName As LiteralExpressionSyntax, aliasKeyword As InternalSyntax.KeywordSyntax, aliasName As LiteralExpressionSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 12

            AdjustFlagsAndWidth(declareKeyword)
            Me._declareKeyword = declareKeyword
            If charsetKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(charsetKeyword)
                Me._charsetKeyword = charsetKeyword
            End If
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            AdjustFlagsAndWidth(libKeyword)
            Me._libKeyword = libKeyword
            AdjustFlagsAndWidth(libraryName)
            Me._libraryName = libraryName
            If aliasKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(aliasKeyword)
                Me._aliasKeyword = aliasKeyword
            End If
            If aliasName IsNot Nothing Then
                AdjustFlagsAndWidth(aliasName)
                Me._aliasName = aliasName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DeclareStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Declare" keyword.
        ''' </summary>
        Friend ReadOnly Property DeclareKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._declareKeyword
            End Get
        End Property

        ''' <summary>
        ''' If present, the keyword that defines the string translation semantics of the
        ''' external method.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property CharsetKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._charsetKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Sub" or "Function" keyword.
        ''' </summary>
        Friend ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the method being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "Lib" keyword.
        ''' </summary>
        Friend ReadOnly Property LibKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._libKeyword
            End Get
        End Property

        ''' <summary>
        ''' The string literal with the library name.
        ''' </summary>
        Friend ReadOnly Property LibraryName As InternalSyntax.LiteralExpressionSyntax
            Get
                Return Me._libraryName
            End Get
        End Property

        ''' <summary>
        ''' If present, the "Alias" keyword. If not present, returns Nothing.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AliasKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._aliasKeyword
            End Get
        End Property

        ''' <summary>
        ''' The string literal with the alias. If not present, returns Nothing.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AliasName As InternalSyntax.LiteralExpressionSyntax
            Get
                Return Me._aliasName
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._declareKeyword
                Case 3
                    Return Me._charsetKeyword
                Case 4
                    Return Me._subOrFunctionKeyword
                Case 5
                    Return Me._identifier
                Case 6
                    Return Me._libKeyword
                Case 7
                    Return Me._libraryName
                Case 8
                    Return Me._aliasKeyword
                Case 9
                    Return Me._aliasName
                Case 10
                    Return Me._parameterList
                Case 11
                    Return Me._asClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DeclareStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _declareKeyword, _charsetKeyword, _subOrFunctionKeyword, _identifier, _libKeyword, _libraryName, _aliasKeyword, _aliasName, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DeclareStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _declareKeyword, _charsetKeyword, _subOrFunctionKeyword, _identifier, _libKeyword, _libraryName, _aliasKeyword, _aliasName, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDeclareStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares a delegate type.
    ''' </summary>
    Friend NotInheritable Class DelegateStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _delegateKeyword as KeywordSyntax
        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _typeParameterList as TypeParameterListSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(delegateKeyword)
            Me._delegateKeyword = delegateKeyword
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(delegateKeyword)
            Me._delegateKeyword = delegateKeyword
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, delegateKeyword As InternalSyntax.KeywordSyntax, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, typeParameterList As TypeParameterListSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(delegateKeyword)
            Me._delegateKeyword = delegateKeyword
            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If typeParameterList IsNot Nothing Then
                AdjustFlagsAndWidth(typeParameterList)
                Me._typeParameterList = typeParameterList
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DelegateStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Delegate" keyword.
        ''' </summary>
        Friend ReadOnly Property DelegateKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._delegateKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Sub" or "Function" keyword.
        ''' </summary>
        Friend ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the delegate being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, a type parameter list with generic type parameters for this
        ''' delegate. If no generic type parameters were present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property TypeParameterList As InternalSyntax.TypeParameterListSyntax
            Get
                Return Me._typeParameterList
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._delegateKeyword
                Case 3
                    Return Me._subOrFunctionKeyword
                Case 4
                    Return Me._identifier
                Case 5
                    Return Me._typeParameterList
                Case 6
                    Return Me._parameterList
                Case 7
                    Return Me._asClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DelegateStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _delegateKeyword, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DelegateStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _delegateKeyword, _subOrFunctionKeyword, _identifier, _typeParameterList, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDelegateStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares an event. If the event being declared is a custom
    ''' event, this statement will be the Begin of a PropertyOrEventBlock, and the
    ''' accessors will be part of the Accessors of that node.
    ''' </summary>
    Friend NotInheritable Class EventStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _customKeyword as KeywordSyntax
        Friend ReadOnly _eventKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8

            If customKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(customKeyword)
                Me._customKeyword = customKeyword
            End If
            AdjustFlagsAndWidth(eventKeyword)
            Me._eventKeyword = eventKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8
            Me.SetFactoryContext(context)

            If customKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(customKeyword)
                Me._customKeyword = customKeyword
            End If
            AdjustFlagsAndWidth(eventKeyword)
            Me._eventKeyword = eventKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, customKeyword As InternalSyntax.KeywordSyntax, eventKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8

            If customKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(customKeyword)
                Me._customKeyword = customKeyword
            End If
            AdjustFlagsAndWidth(eventKeyword)
            Me._eventKeyword = eventKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EventStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The optional Custom keyword for custom event declarations.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property CustomKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._customKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Event" keyword that introduces this event declaration.
        ''' </summary>
        Friend ReadOnly Property EventKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._eventKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the event being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an Implements clause indicates the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ImplementsClause As InternalSyntax.ImplementsClauseSyntax
            Get
                Return Me._implementsClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._customKeyword
                Case 3
                    Return Me._eventKeyword
                Case 4
                    Return Me._identifier
                Case 5
                    Return Me._parameterList
                Case 6
                    Return Me._asClause
                Case 7
                    Return Me._implementsClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EventStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _customKeyword, _eventKeyword, _identifier, _parameterList, _asClause, _implementsClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EventStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _customKeyword, _eventKeyword, _identifier, _parameterList, _asClause, _implementsClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEventStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A statement that declares an operator. If this operator has a body, this
    ''' statement will be the Begin of a BlockStatement with
    ''' Kind=MethodDeclarationBlock, and the body of the method will be the Body of
    ''' that BlockStatement.
    ''' </summary>
    Friend NotInheritable Class OperatorStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _operatorKeyword as KeywordSyntax
        Friend ReadOnly _operatorToken as SyntaxToken
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(operatorKeyword)
            Me._operatorKeyword = operatorKeyword
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(operatorKeyword)
            Me._operatorKeyword = operatorKeyword
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, operatorKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.SyntaxToken, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(operatorKeyword)
            Me._operatorKeyword = operatorKeyword
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OperatorStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Operator" keyword that introduces this operator declaration.
        ''' </summary>
        Friend ReadOnly Property OperatorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._operatorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The operator being defined.
        ''' </summary>
        Friend ReadOnly Property OperatorToken As InternalSyntax.SyntaxToken
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._operatorKeyword
                Case 3
                    Return Me._operatorToken
                Case 4
                    Return Me._parameterList
                Case 5
                    Return Me._asClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OperatorStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _operatorKeyword, _operatorToken, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OperatorStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _operatorKeyword, _operatorToken, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOperatorStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Statement that declares a property. If this property has accessors declared,
    ''' this statement will be the Begin of a BlockNode, and the accessors will be the
    ''' Body of that node. Auto properties are property declarations without a
    ''' PropertyBlock.
    ''' </summary>
    Friend NotInheritable Class PropertyStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _propertyKeyword as KeywordSyntax
        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _asClause as AsClauseSyntax
        Friend ReadOnly _initializer as EqualsValueSyntax
        Friend ReadOnly _implementsClause as ImplementsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(propertyKeyword)
            Me._propertyKeyword = propertyKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(propertyKeyword)
            Me._propertyKeyword = propertyKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, propertyKeyword As InternalSyntax.KeywordSyntax, identifier As InternalSyntax.IdentifierTokenSyntax, parameterList As ParameterListSyntax, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, implementsClause As ImplementsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(propertyKeyword)
            Me._propertyKeyword = propertyKeyword
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If
            If implementsClause IsNot Nothing Then
                AdjustFlagsAndWidth(implementsClause)
                Me._implementsClause = implementsClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PropertyStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Property" keyword that introduces this property declaration.
        ''' </summary>
        Friend ReadOnly Property PropertyKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._propertyKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the property being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.AsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an "= initial-value" clause describing the initial value of the
        ''' property.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Initializer As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        ''' <summary>
        ''' If present, an Implements clause indicated the interface methods that this
        ''' method implements.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ImplementsClause As InternalSyntax.ImplementsClauseSyntax
            Get
                Return Me._implementsClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._propertyKeyword
                Case 3
                    Return Me._identifier
                Case 4
                    Return Me._parameterList
                Case 5
                    Return Me._asClause
                Case 6
                    Return Me._initializer
                Case 7
                    Return Me._implementsClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PropertyStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _propertyKeyword, _identifier, _parameterList, _asClause, _initializer, _implementsClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PropertyStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _propertyKeyword, _identifier, _parameterList, _asClause, _initializer, _implementsClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPropertyStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Get or Set accessor on a property declaration or an AddHandler,
    ''' RemoveHandler or RaiseEvent accessor on a custom event declaration. The Kind of
    ''' the node determines what kind of accessor this is. This statement is always the
    ''' Begin of a BlockNode, and the body of the accessor is the Body of that node.
    ''' </summary>
    Friend NotInheritable Class AccessorStatementSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _accessorKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(accessorKeyword)
            Me._accessorKeyword = accessorKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(accessorKeyword)
            Me._accessorKeyword = accessorKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, accessorKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(accessorKeyword)
            Me._accessorKeyword = accessorKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AccessorStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Get", "Set", "AddHandler", "RemoveHandler", or "RaiseEvent" keyword that
        ''' introduces this accessor declaration.
        ''' </summary>
        Friend ReadOnly Property AccessorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._accessorKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._accessorKeyword
                Case 3
                    Return Me._parameterList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AccessorStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _accessorKeyword, _parameterList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AccessorStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _accessorKeyword, _parameterList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAccessorStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Implements ..." clause on a type member, which describes which
    ''' interface members this member implements.
    ''' </summary>
    Friend NotInheritable Class ImplementsClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _implementsKeyword as KeywordSyntax
        Friend ReadOnly _interfaceMembers as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If interfaceMembers IsNot Nothing Then
                AdjustFlagsAndWidth(interfaceMembers)
                Me._interfaceMembers = interfaceMembers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If interfaceMembers IsNot Nothing Then
                AdjustFlagsAndWidth(interfaceMembers)
                Me._interfaceMembers = interfaceMembers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), implementsKeyword As InternalSyntax.KeywordSyntax, interfaceMembers As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(implementsKeyword)
            Me._implementsKeyword = implementsKeyword
            If interfaceMembers IsNot Nothing Then
                AdjustFlagsAndWidth(interfaceMembers)
                Me._interfaceMembers = interfaceMembers
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ImplementsClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Implements" keyword.
        ''' </summary>
        Friend ReadOnly Property ImplementsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._implementsKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of interface members being implemented.
        ''' </summary>
        Friend ReadOnly Property InterfaceMembers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of QualifiedNameSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of QualifiedNameSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of QualifiedNameSyntax)(Me._interfaceMembers))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._implementsKeyword
                Case 1
                    Return Me._interfaceMembers
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ImplementsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _implementsKeyword, _interfaceMembers)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ImplementsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _implementsKeyword, _interfaceMembers)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitImplementsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Handles ..." clause on a method declaration that describes
    ''' which events this method handles.
    ''' </summary>
    Friend NotInheritable Class HandlesClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _handlesKeyword as KeywordSyntax
        Friend ReadOnly _events as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, handlesKeyword As InternalSyntax.KeywordSyntax, events As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(handlesKeyword)
            Me._handlesKeyword = handlesKeyword
            If events IsNot Nothing Then
                AdjustFlagsAndWidth(events)
                Me._events = events
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, handlesKeyword As InternalSyntax.KeywordSyntax, events As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(handlesKeyword)
            Me._handlesKeyword = handlesKeyword
            If events IsNot Nothing Then
                AdjustFlagsAndWidth(events)
                Me._events = events
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), handlesKeyword As InternalSyntax.KeywordSyntax, events As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(handlesKeyword)
            Me._handlesKeyword = handlesKeyword
            If events IsNot Nothing Then
                AdjustFlagsAndWidth(events)
                Me._events = events
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.HandlesClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Handles" keyword.
        ''' </summary>
        Friend ReadOnly Property HandlesKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._handlesKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of event members being handled.
        ''' </summary>
        Friend ReadOnly Property Events As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of HandlesClauseItemSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of HandlesClauseItemSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of HandlesClauseItemSyntax)(Me._events))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._handlesKeyword
                Case 1
                    Return Me._events
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new HandlesClauseSyntax(Me.Kind, newErrors, GetAnnotations, _handlesKeyword, _events)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new HandlesClauseSyntax(Me.Kind, GetDiagnostics, annotations, _handlesKeyword, _events)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitHandlesClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents container of an event in a Handles clause item.
    ''' </summary>
    Friend MustInherit Class EventContainerSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents event container specified through special keywords "Me", "MyBase" or
    ''' "MyClass"..
    ''' </summary>
    Friend NotInheritable Class KeywordEventContainerSyntax
        Inherits EventContainerSyntax

        Friend ReadOnly _keyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.KeywordEventContainerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event. This can be one of the special keywords: "Me",
        ''' "MyBase" or "MyClass".
        ''' </summary>
        Friend ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new KeywordEventContainerSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new KeywordEventContainerSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitKeywordEventContainer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents event container that refers to a WithEvents member.
    ''' </summary>
    Friend NotInheritable Class WithEventsEventContainerSyntax
        Inherits EventContainerSyntax

        Friend ReadOnly _identifier as IdentifierTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithEventsEventContainerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event. It is a simple identifier that refers to a
        ''' WithEvents member of the containing type.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._identifier
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithEventsEventContainerSyntax(Me.Kind, newErrors, GetAnnotations, _identifier)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithEventsEventContainerSyntax(Me.Kind, GetDiagnostics, annotations, _identifier)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithEventsEventContainer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents event container that refers to a WithEvents member's property.
    ''' </summary>
    Friend NotInheritable Class WithEventsPropertyEventContainerSyntax
        Inherits EventContainerSyntax

        Friend ReadOnly _withEventsContainer as WithEventsEventContainerSyntax
        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _property as IdentifierNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(withEventsContainer)
            Me._withEventsContainer = withEventsContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth([property])
            Me._property = [property]

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withEventsContainer)
            Me._withEventsContainer = withEventsContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth([property])
            Me._property = [property]

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withEventsContainer As WithEventsEventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, [property] As IdentifierNameSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(withEventsContainer)
            Me._withEventsContainer = withEventsContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth([property])
            Me._property = [property]

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithEventsPropertyEventContainerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event.
        ''' </summary>
        Friend ReadOnly Property WithEventsContainer As InternalSyntax.WithEventsEventContainerSyntax
            Get
                Return Me._withEventsContainer
            End Get
        End Property

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Friend ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The provider of the event. It is a property of a WithEvents member of the
        ''' containing type.
        ''' </summary>
        Friend ReadOnly Property [Property] As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._property
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withEventsContainer
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._property
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithEventsPropertyEventContainerSyntax(Me.Kind, newErrors, GetAnnotations, _withEventsContainer, _dotToken, _property)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithEventsPropertyEventContainerSyntax(Me.Kind, GetDiagnostics, annotations, _withEventsContainer, _dotToken, _property)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithEventsPropertyEventContainer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single handled event in a "Handles ..." clause.
    ''' </summary>
    Friend NotInheritable Class HandlesClauseItemSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _eventContainer as EventContainerSyntax
        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _eventMember as IdentifierNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(eventContainer)
            Me._eventContainer = eventContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(eventMember)
            Me._eventMember = eventMember

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eventContainer)
            Me._eventContainer = eventContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(eventMember)
            Me._eventMember = eventMember

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eventContainer As EventContainerSyntax, dotToken As InternalSyntax.PunctuationSyntax, eventMember As IdentifierNameSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(eventContainer)
            Me._eventContainer = eventContainer
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(eventMember)
            Me._eventMember = eventMember

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.HandlesClauseItemSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The container of the event. This can either be a simple identifier (identifying
        ''' a members of the containing type) or one of the special keywords "Me", "MyBase"
        ''' or "MyClass".
        ''' </summary>
        Friend ReadOnly Property EventContainer As InternalSyntax.EventContainerSyntax
            Get
                Return Me._eventContainer
            End Get
        End Property

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Friend ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The event being handled. This must be a simple identifier.
        ''' </summary>
        Friend ReadOnly Property EventMember As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._eventMember
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._eventContainer
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._eventMember
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new HandlesClauseItemSyntax(Me.Kind, newErrors, GetAnnotations, _eventContainer, _dotToken, _eventMember)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new HandlesClauseItemSyntax(Me.Kind, GetDiagnostics, annotations, _eventContainer, _dotToken, _eventMember)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitHandlesClauseItem(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the beginning of a declaration. However, not enough syntax is
    ''' detected to classify this as a field, method, property or event. This is node
    ''' always represents a syntax error.
    ''' </summary>
    Friend NotInheritable Class IncompleteMemberSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _missingIdentifier as IdentifierTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If missingIdentifier IsNot Nothing Then
                AdjustFlagsAndWidth(missingIdentifier)
                Me._missingIdentifier = missingIdentifier
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If missingIdentifier IsNot Nothing Then
                AdjustFlagsAndWidth(missingIdentifier)
                Me._missingIdentifier = missingIdentifier
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, missingIdentifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If missingIdentifier IsNot Nothing Then
                AdjustFlagsAndWidth(missingIdentifier)
                Me._missingIdentifier = missingIdentifier
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.IncompleteMemberSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The missing identifier token for this incomplete member. Should only be used to
        ''' have a location for error reporting.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property MissingIdentifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._missingIdentifier
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._missingIdentifier
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new IncompleteMemberSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _missingIdentifier)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new IncompleteMemberSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _missingIdentifier)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitIncompleteMember(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the declaration of one or more variables or constants, either as
    ''' local variables or as class/structure members. In the case of a constant, it is
    ''' represented by having "Const" in the Modifiers (although technically "Const" is
    ''' not a modifier, it is represented as one in the parse trees.)
    ''' </summary>
    Friend NotInheritable Class FieldDeclarationSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _declarators as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, declarators As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FieldDeclarationSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this declaration. If no attributes were
        ''' specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of all the modifier tokens that were present on this declaration. If no
        ''' modifiers were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The list of variable declarator. Each declarator specifies one or more variable
        ''' names along with a type and/or initializer.
        ''' </summary>
        Friend ReadOnly Property Declarators As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of VariableDeclaratorSyntax)(Me._declarators))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._declarators
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FieldDeclarationSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _declarators)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FieldDeclarationSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _declarators)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFieldDeclaration(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the part of a variable or constant declaration statement that
    ''' associated one or more variable names with a type.
    ''' </summary>
    Friend NotInheritable Class VariableDeclaratorSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _names as GreenNode
        Friend ReadOnly _asClause as AsClauseSyntax
        Friend ReadOnly _initializer as EqualsValueSyntax

        Friend Sub New(ByVal kind As SyntaxKind, names As GreenNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If names IsNot Nothing Then
                AdjustFlagsAndWidth(names)
                Me._names = names
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, names As GreenNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If names IsNot Nothing Then
                AdjustFlagsAndWidth(names)
                Me._names = names
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), names As GreenNode, asClause As AsClauseSyntax, initializer As EqualsValueSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If names IsNot Nothing Then
                AdjustFlagsAndWidth(names)
                Me._names = names
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.VariableDeclaratorSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The names of the variables being declared. Each name might have a "?" or "()"
        ''' modifier(s) attached.
        ''' </summary>
        Friend ReadOnly Property Names As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ModifiedIdentifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ModifiedIdentifierSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ModifiedIdentifierSyntax)(Me._names))
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type, and possibly includes "New",
        ''' "With" or "From". If no As clause was present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.AsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an "= initial-value" clause describing the initial value of the
        ''' variable or the value of the constant.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Initializer As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._names
                Case 1
                    Return Me._asClause
                Case 2
                    Return Me._initializer
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new VariableDeclaratorSyntax(Me.Kind, newErrors, GetAnnotations, _names, _asClause, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new VariableDeclaratorSyntax(Me.Kind, GetDiagnostics, annotations, _names, _asClause, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitVariableDeclarator(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract node class that represents the different kinds of "As {type-name}"
    ''' clauses in a declaration: simple "As" clauses and "As New" clauses. The type
    ''' has optional attributes associated with it, although attributes are not
    ''' permitted in all possible places where this node occurs.
    ''' </summary>
    Friend MustInherit Class AsClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _asKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(asKeyword)
            Me._asKeyword = asKeyword

        End Sub

        ''' <summary>
        ''' The "As" keyword.
        ''' </summary>
        Friend ReadOnly Property AsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._asKeyword
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents an "As {type-name}" clause that does not have an initializer or
    ''' "New". The type has optional attributes associated with it, although attributes
    ''' are not permitted in all possible places where this node occurs.
    ''' </summary>
    Friend NotInheritable Class SimpleAsClauseSyntax
        Inherits AsClauseSyntax

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax)
            MyBase.New(kind, asKeyword)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, asKeyword)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax)
            MyBase.New(kind, errors, annotations, asKeyword)
            Me.SlotCount = 3

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleAsClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' The type-name part of the As clause.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleAsClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _attributeLists, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleAsClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _attributeLists, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleAsClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "As New {type-name} [arguments] [initializers]" clause in a
    ''' declaration. The type has optional attributes associated with it, although
    ''' attributes are not permitted in many places where this node occurs (they are
    ''' permitted, for example, on automatically implemented properties.)
    ''' </summary>
    Friend NotInheritable Class AsNewClauseSyntax
        Inherits AsClauseSyntax

        Friend ReadOnly _newExpression as NewExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax)
            MyBase.New(kind, asKeyword)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(newExpression)
            Me._newExpression = newExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, asKeyword)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(newExpression)
            Me._newExpression = newExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), asKeyword As InternalSyntax.KeywordSyntax, newExpression As NewExpressionSyntax)
            MyBase.New(kind, errors, annotations, asKeyword)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(newExpression)
            Me._newExpression = newExpression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AsNewClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The New expression
        ''' </summary>
        Friend ReadOnly Property NewExpression As InternalSyntax.NewExpressionSyntax
            Get
                Return Me._newExpression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._asKeyword
                Case 1
                    Return Me._newExpression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AsNewClauseSyntax(Me.Kind, newErrors, GetAnnotations, _asKeyword, _newExpression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AsNewClauseSyntax(Me.Kind, GetDiagnostics, annotations, _asKeyword, _newExpression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAsNewClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract node class that represents a "With" or "From" clause used to
    ''' initialize a new object.
    ''' </summary>
    Friend MustInherit Class ObjectCreationInitializerSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a "With {...} clause used to initialize a new object's members.
    ''' </summary>
    Friend NotInheritable Class ObjectMemberInitializerSyntax
        Inherits ObjectCreationInitializerSyntax

        Friend ReadOnly _withKeyword as KeywordSyntax
        Friend ReadOnly _openBraceToken as PunctuationSyntax
        Friend ReadOnly _initializers as GreenNode
        Friend ReadOnly _closeBraceToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withKeyword As InternalSyntax.KeywordSyntax, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ObjectMemberInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "With" keyword.
        ''' </summary>
        Friend ReadOnly Property WithKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._withKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Friend ReadOnly Property OpenBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openBraceToken
            End Get
        End Property

        ''' <summary>
        ''' The comma-separated list of field initializers.
        ''' </summary>
        Friend ReadOnly Property Initializers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of FieldInitializerSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of FieldInitializerSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of FieldInitializerSyntax)(Me._initializers))
            End Get
        End Property

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Friend ReadOnly Property CloseBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeBraceToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withKeyword
                Case 1
                    Return Me._openBraceToken
                Case 2
                    Return Me._initializers
                Case 3
                    Return Me._closeBraceToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ObjectMemberInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _withKeyword, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ObjectMemberInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _withKeyword, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitObjectMemberInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "From {...} clause used to initialize a new collection object's
    ''' elements.
    ''' </summary>
    Friend NotInheritable Class ObjectCollectionInitializerSyntax
        Inherits ObjectCreationInitializerSyntax

        Friend ReadOnly _fromKeyword as KeywordSyntax
        Friend ReadOnly _initializer as CollectionInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), fromKeyword As InternalSyntax.KeywordSyntax, initializer As CollectionInitializerSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ObjectCollectionInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "From" keyword.
        ''' </summary>
        Friend ReadOnly Property FromKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._fromKeyword
            End Get
        End Property

        ''' <summary>
        ''' The initializer including the braces.
        ''' </summary>
        Friend ReadOnly Property Initializer As InternalSyntax.CollectionInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._fromKeyword
                Case 1
                    Return Me._initializer
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ObjectCollectionInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _fromKeyword, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ObjectCollectionInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _fromKeyword, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitObjectCollectionInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract class that represent a single field initializer used in a "With {...}"
    ''' field initializer list.
    ''' </summary>
    Friend MustInherit Class FieldInitializerSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _keyKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)

            If keyKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(keyKeyword)
                Me._keyKeyword = keyKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If keyKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(keyKeyword)
                Me._keyKeyword = keyKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)

            If keyKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(keyKeyword)
                Me._keyKeyword = keyKeyword
            End If

        End Sub

        ''' <summary>
        ''' The optional "Key" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property KeyKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyKeyword
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represent a field initializer in a With {...} initializer where the field name
    ''' is inferred from the initializer expression.
    ''' </summary>
    Friend NotInheritable Class InferredFieldInitializerSyntax
        Inherits FieldInitializerSyntax

        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, keyKeyword)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyKeyword)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations, keyKeyword)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InferredFieldInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The value being assigned.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyKeyword
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InferredFieldInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _keyKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InferredFieldInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _keyKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInferredFieldInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a named field initializer in a With {...} initializer, such as ".x =
    ''' expr".
    ''' </summary>
    Friend NotInheritable Class NamedFieldInitializerSyntax
        Inherits FieldInitializerSyntax

        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _name as IdentifierNameSyntax
        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, keyKeyword)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyKeyword)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyKeyword As InternalSyntax.KeywordSyntax, dotToken As InternalSyntax.PunctuationSyntax, name As IdentifierNameSyntax, equalsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations, keyKeyword)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamedFieldInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "." token.
        ''' </summary>
        Friend ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The name of the field being initialized.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        ''' <summary>
        ''' The value being assigned to the field.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyKeyword
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._name
                Case 3
                    Return Me._equalsToken
                Case 4
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamedFieldInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _keyKeyword, _dotToken, _name, _equalsToken, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamedFieldInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _keyKeyword, _dotToken, _name, _equalsToken, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamedFieldInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "= initializer" clause in a declaration for a variable, parameter
    ''' or automatic property.
    ''' </summary>
    Friend NotInheritable Class EqualsValueSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _value as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), equalsToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EqualsValueSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        ''' <summary>
        ''' The expression used as the initial value.
        ''' </summary>
        Friend ReadOnly Property Value As InternalSyntax.ExpressionSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._equalsToken
                Case 1
                    Return Me._value
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EqualsValueSyntax(Me.Kind, newErrors, GetAnnotations, _equalsToken, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EqualsValueSyntax(Me.Kind, GetDiagnostics, annotations, _equalsToken, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEqualsValue(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a parameter to a method, property, constructor, etc.
    ''' </summary>
    Friend NotInheritable Class ParameterSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _attributeLists as GreenNode
        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _identifier as ModifiedIdentifierSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _default as EqualsValueSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If [default] IsNot Nothing Then
                AdjustFlagsAndWidth([default])
                Me._default = [default]
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If [default] IsNot Nothing Then
                AdjustFlagsAndWidth([default])
                Me._default = [default]
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, [default] As EqualsValueSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If
            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If [default] IsNot Nothing Then
                AdjustFlagsAndWidth([default])
                Me._default = [default]
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ParameterSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all attribute lists on this parameter. If no attributes were
        ''' specified, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        ''' <summary>
        ''' A list of the modifier tokens "ByVal", "ByRef", "Optional" or "ParamArray" that
        ''' modify this parameter.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The name of the parameter, including any "?" or "()" modifiers.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.ModifiedIdentifierSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' If present, the "As type-name" clause describing the type of the parameter. If
        ''' no As clause is present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' If present, an initializer with the default value of the parameter. If no
        ''' default value is present, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property [Default] As InternalSyntax.EqualsValueSyntax
            Get
                Return Me._default
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._identifier
                Case 3
                    Return Me._asClause
                Case 4
                    Return Me._default
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ParameterSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _identifier, _asClause, _default)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ParameterSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _identifier, _asClause, _default)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitParameter(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an identifier with optional "?" or "()" or "(,,,)" modifiers, as
    ''' used in parameter declarations and variable declarations.
    ''' </summary>
    Friend NotInheritable Class ModifiedIdentifierSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _nullable as PunctuationSyntax
        Friend ReadOnly _arrayBounds as ArgumentListSyntax
        Friend ReadOnly _arrayRankSpecifiers as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If nullable IsNot Nothing Then
                AdjustFlagsAndWidth(nullable)
                Me._nullable = nullable
            End If
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If arrayRankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(arrayRankSpecifiers)
                Me._arrayRankSpecifiers = arrayRankSpecifiers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If nullable IsNot Nothing Then
                AdjustFlagsAndWidth(nullable)
                Me._nullable = nullable
            End If
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If arrayRankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(arrayRankSpecifiers)
                Me._arrayRankSpecifiers = arrayRankSpecifiers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, nullable As InternalSyntax.PunctuationSyntax, arrayBounds As ArgumentListSyntax, arrayRankSpecifiers As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If nullable IsNot Nothing Then
                AdjustFlagsAndWidth(nullable)
                Me._nullable = nullable
            End If
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If arrayRankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(arrayRankSpecifiers)
                Me._arrayRankSpecifiers = arrayRankSpecifiers
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ModifiedIdentifierSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The identifier that names the item being declared.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' The "?" token that indicates a nullable type.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Nullable As InternalSyntax.PunctuationSyntax
            Get
                Return Me._nullable
            End Get
        End Property

        ''' <summary>
        ''' The optional array bounds, such as "(4)" or "(0 to 5, 0 To 6)".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ArrayBounds As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._arrayBounds
            End Get
        End Property

        ''' <summary>
        ''' A list of array modifiers for the type. If no array modifiers were present, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property ArrayRankSpecifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)(Me._arrayRankSpecifiers)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._nullable
                Case 2
                    Return Me._arrayBounds
                Case 3
                    Return Me._arrayRankSpecifiers
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ModifiedIdentifierSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _nullable, _arrayBounds, _arrayRankSpecifiers)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ModifiedIdentifierSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _nullable, _arrayBounds, _arrayRankSpecifiers)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitModifiedIdentifier(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a modifier that describes an array type, without bounds, such as
    ''' "()" or "(,)".
    ''' </summary>
    Friend NotInheritable Class ArrayRankSpecifierSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _commaTokens as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If commaTokens IsNot Nothing Then
                AdjustFlagsAndWidth(commaTokens)
                Me._commaTokens = commaTokens
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If commaTokens IsNot Nothing Then
                AdjustFlagsAndWidth(commaTokens)
                Me._commaTokens = commaTokens
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, commaTokens As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If commaTokens IsNot Nothing Then
                AdjustFlagsAndWidth(commaTokens)
                Me._commaTokens = commaTokens
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArrayRankSpecifierSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The comma tokens in the array type. There is one less comma than the rank.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property CommaTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of PunctuationSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._commaTokens)
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._commaTokens
                Case 2
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArrayRankSpecifierSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _commaTokens, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArrayRankSpecifierSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _commaTokens, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArrayRankSpecifier(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a group of attributes within "&lt;" and "&gt;" brackets.
    ''' </summary>
    Friend NotInheritable Class AttributeListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _attributes as GreenNode
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributeListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "&lt;" token.
        ''' </summary>
        Friend ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        ''' <summary>
        ''' A comma separated list of attribute declarations in this attribute list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Attributes As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AttributeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AttributeSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of AttributeSyntax)(Me._attributes))
            End Get
        End Property

        ''' <summary>
        ''' The "&gt;" token.
        ''' </summary>
        Friend ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._attributes
                Case 2
                    Return Me._greaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributeListSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _attributes, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributeListSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _attributes, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttributeList(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single attribute declaration within an attribute list.
    ''' </summary>
    Friend NotInheritable Class AttributeSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _target as AttributeTargetSyntax
        Friend ReadOnly _name as TypeSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If target IsNot Nothing Then
                AdjustFlagsAndWidth(target)
                Me._target = target
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

            SetFlags(NodeFlags.ContainsAttributes)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If target IsNot Nothing Then
                AdjustFlagsAndWidth(target)
                Me._target = target
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

            SetFlags(NodeFlags.ContainsAttributes)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), target As AttributeTargetSyntax, name As TypeSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If target IsNot Nothing Then
                AdjustFlagsAndWidth(target)
                Me._target = target
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

            SetFlags(NodeFlags.ContainsAttributes)
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' Optional attribute target. Assembly|Module :
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Target As InternalSyntax.AttributeTargetSyntax
            Get
                Return Me._target
            End Get
        End Property

        ''' <summary>
        ''' The name of the attribute.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.TypeSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The argument list, if present. If no argument list was supplied, Nothing is
        ''' returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._target
                Case 1
                    Return Me._name
                Case 2
                    Return Me._argumentList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributeSyntax(Me.Kind, newErrors, GetAnnotations, _target, _name, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributeSyntax(Me.Kind, GetDiagnostics, annotations, _target, _name, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttribute(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single attribute declaration within an attribute list.
    ''' </summary>
    Friend NotInheritable Class AttributeTargetSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _attributeModifier as KeywordSyntax
        Friend ReadOnly _colonToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(attributeModifier)
            Me._attributeModifier = attributeModifier
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(attributeModifier)
            Me._attributeModifier = attributeModifier
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeModifier As InternalSyntax.KeywordSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(attributeModifier)
            Me._attributeModifier = attributeModifier
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributeTargetSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Assembly" or "Module" attribute modifier, is present. If no attribute
        ''' modifier is present, Nothing is returned.
        ''' </summary>
        Friend ReadOnly Property AttributeModifier As InternalSyntax.KeywordSyntax
            Get
                Return Me._attributeModifier
            End Get
        End Property

        ''' <summary>
        ''' The ":" token, if an attribute modifier is present. If no attribute modifier is
        ''' present, Nothing is returned.
        ''' </summary>
        Friend ReadOnly Property ColonToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeModifier
                Case 1
                    Return Me._colonToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributeTargetSyntax(Me.Kind, newErrors, GetAnnotations, _attributeModifier, _colonToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributeTargetSyntax(Me.Kind, GetDiagnostics, annotations, _attributeModifier, _colonToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttributeTarget(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a file-level attribute, in which the attributes have no other
    ''' syntactic element they are attached to.
    ''' </summary>
    Friend NotInheritable Class AttributesStatementSyntax
        Inherits DeclarationStatementSyntax

        Friend ReadOnly _attributeLists as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 1

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AttributesStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The list of attribute lists.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._attributeLists
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AttributesStatementSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AttributesStatementSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAttributesStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent an expression in a statement context. This may only be a invocation
    ''' or await expression in standard code but may be any expression in VB
    ''' Interactive code.
    ''' </summary>
    Friend NotInheritable Class ExpressionStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ExpressionStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._expression
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ExpressionStatementSyntax(Me.Kind, newErrors, GetAnnotations, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ExpressionStatementSyntax(Me.Kind, GetDiagnostics, annotations, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitExpressionStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a "? expression" "Print" statement in VB Interactive code.
    ''' </summary>
    Friend NotInheritable Class PrintStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _questionToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(questionToken)
            Me._questionToken = questionToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(questionToken)
            Me._questionToken = questionToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), questionToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(questionToken)
            Me._questionToken = questionToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PrintStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' "?" token.
        ''' </summary>
        Friend ReadOnly Property QuestionToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._questionToken
            End Get
        End Property

        ''' <summary>
        ''' The expression whose value is being output.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._questionToken
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PrintStatementSyntax(Me.Kind, newErrors, GetAnnotations, _questionToken, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PrintStatementSyntax(Me.Kind, GetDiagnostics, annotations, _questionToken, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPrintStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a While...End While statement, including the While, body and End
    ''' While.
    ''' </summary>
    Friend NotInheritable Class WhileBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _whileStatement as WhileStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endWhileStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whileStatement As WhileStatementSyntax, statements As GreenNode, endWhileStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(whileStatement)
            Me._whileStatement = whileStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWhileStatement)
            Me._endWhileStatement = endWhileStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whileStatement As WhileStatementSyntax, statements As GreenNode, endWhileStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whileStatement)
            Me._whileStatement = whileStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWhileStatement)
            Me._endWhileStatement = endWhileStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileStatement As WhileStatementSyntax, statements As GreenNode, endWhileStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(whileStatement)
            Me._whileStatement = whileStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWhileStatement)
            Me._endWhileStatement = endWhileStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhileBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The While statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property WhileStatement As InternalSyntax.WhileStatementSyntax
            Get
                Return Me._whileStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the While...End While. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End While statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndWhileStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endWhileStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whileStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endWhileStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhileBlockSyntax(Me.Kind, newErrors, GetAnnotations, _whileStatement, _statements, _endWhileStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhileBlockSyntax(Me.Kind, GetDiagnostics, annotations, _whileStatement, _statements, _endWhileStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhileBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an entire Using...End Using statement, including the Using, body and
    ''' End Using statements.
    ''' </summary>
    Friend NotInheritable Class UsingBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _usingStatement as UsingStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endUsingStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, usingStatement As UsingStatementSyntax, statements As GreenNode, endUsingStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(usingStatement)
            Me._usingStatement = usingStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endUsingStatement)
            Me._endUsingStatement = endUsingStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, usingStatement As UsingStatementSyntax, statements As GreenNode, endUsingStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(usingStatement)
            Me._usingStatement = usingStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endUsingStatement)
            Me._endUsingStatement = endUsingStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), usingStatement As UsingStatementSyntax, statements As GreenNode, endUsingStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(usingStatement)
            Me._usingStatement = usingStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endUsingStatement)
            Me._endUsingStatement = endUsingStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.UsingBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The UsingStatement that begins the Using...End Using block.
        ''' </summary>
        Friend ReadOnly Property UsingStatement As InternalSyntax.UsingStatementSyntax
            Get
                Return Me._usingStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the Using...End Using block. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End Using statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndUsingStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endUsingStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._usingStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endUsingStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new UsingBlockSyntax(Me.Kind, newErrors, GetAnnotations, _usingStatement, _statements, _endUsingStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new UsingBlockSyntax(Me.Kind, GetDiagnostics, annotations, _usingStatement, _statements, _endUsingStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitUsingBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a entire SyncLock...End SyncLock block, including the SyncLock
    ''' statement, the enclosed statements, and the End SyncLock statement.
    ''' </summary>
    Friend NotInheritable Class SyncLockBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _syncLockStatement as SyncLockStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endSyncLockStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, syncLockStatement As SyncLockStatementSyntax, statements As GreenNode, endSyncLockStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(syncLockStatement)
            Me._syncLockStatement = syncLockStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSyncLockStatement)
            Me._endSyncLockStatement = endSyncLockStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, syncLockStatement As SyncLockStatementSyntax, statements As GreenNode, endSyncLockStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(syncLockStatement)
            Me._syncLockStatement = syncLockStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSyncLockStatement)
            Me._endSyncLockStatement = endSyncLockStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), syncLockStatement As SyncLockStatementSyntax, statements As GreenNode, endSyncLockStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(syncLockStatement)
            Me._syncLockStatement = syncLockStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSyncLockStatement)
            Me._endSyncLockStatement = endSyncLockStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SyncLockBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The SyncLock statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property SyncLockStatement As InternalSyntax.SyncLockStatementSyntax
            Get
                Return Me._syncLockStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the SyncLock...End SyncLock statement. This might
        ''' be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End SyncLock statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndSyncLockStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSyncLockStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._syncLockStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSyncLockStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SyncLockBlockSyntax(Me.Kind, newErrors, GetAnnotations, _syncLockStatement, _statements, _endSyncLockStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SyncLockBlockSyntax(Me.Kind, GetDiagnostics, annotations, _syncLockStatement, _statements, _endSyncLockStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSyncLockBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a With...End With block, include the With statement, the body of the
    ''' block and the End With statement.
    ''' </summary>
    Friend NotInheritable Class WithBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _withStatement as WithStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endWithStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withStatement As WithStatementSyntax, statements As GreenNode, endWithStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(withStatement)
            Me._withStatement = withStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWithStatement)
            Me._endWithStatement = endWithStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withStatement As WithStatementSyntax, statements As GreenNode, endWithStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withStatement)
            Me._withStatement = withStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWithStatement)
            Me._endWithStatement = endWithStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withStatement As WithStatementSyntax, statements As GreenNode, endWithStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(withStatement)
            Me._withStatement = withStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endWithStatement)
            Me._endWithStatement = endWithStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The WithStatement that begins the With...End With block.
        ''' </summary>
        Friend ReadOnly Property WithStatement As InternalSyntax.WithStatementSyntax
            Get
                Return Me._withStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the With...End With block. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The End With statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndWithStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endWithStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endWithStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithBlockSyntax(Me.Kind, newErrors, GetAnnotations, _withStatement, _statements, _endWithStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithBlockSyntax(Me.Kind, GetDiagnostics, annotations, _withStatement, _statements, _endWithStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the declaration of one or more local variables or constants.
    ''' </summary>
    Friend NotInheritable Class LocalDeclarationStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _modifiers as GreenNode
        Friend ReadOnly _declarators as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, modifiers As GreenNode, declarators As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), modifiers As GreenNode, declarators As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If modifiers IsNot Nothing Then
                AdjustFlagsAndWidth(modifiers)
                Me._modifiers = modifiers
            End If
            If declarators IsNot Nothing Then
                AdjustFlagsAndWidth(declarators)
                Me._declarators = declarators
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LocalDeclarationStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The modifier token (Static, Dim or Const) that introduces this local variable
        ''' declaration.
        ''' </summary>
        Friend ReadOnly Property Modifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of KeywordSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._modifiers)
            End Get
        End Property

        ''' <summary>
        ''' The list of variable declarator. Each declarator specifies one or more variable
        ''' names along with a type and/or initializer.
        ''' </summary>
        Friend ReadOnly Property Declarators As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of VariableDeclaratorSyntax)(Me._declarators))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._modifiers
                Case 1
                    Return Me._declarators
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LocalDeclarationStatementSyntax(Me.Kind, newErrors, GetAnnotations, _modifiers, _declarators)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LocalDeclarationStatementSyntax(Me.Kind, GetDiagnostics, annotations, _modifiers, _declarators)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLocalDeclarationStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a label statement.
    ''' </summary>
    Friend NotInheritable Class LabelStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _labelToken as SyntaxToken
        Friend ReadOnly _colonToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), labelToken As InternalSyntax.SyntaxToken, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LabelStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the label. If the label is a line number, returns an IntegerLiteral
        ''' that is the line number, otherwise, returns an Identifier.
        ''' </summary>
        Friend ReadOnly Property LabelToken As InternalSyntax.SyntaxToken
            Get
                Return Me._labelToken
            End Get
        End Property

        ''' <summary>
        ''' The ":" token of the label statement.
        ''' </summary>
        Friend ReadOnly Property ColonToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._labelToken
                Case 1
                    Return Me._colonToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LabelStatementSyntax(Me.Kind, newErrors, GetAnnotations, _labelToken, _colonToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LabelStatementSyntax(Me.Kind, GetDiagnostics, annotations, _labelToken, _colonToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLabelStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "GoTo" statement.
    ''' </summary>
    Friend NotInheritable Class GoToStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _goToKeyword as KeywordSyntax
        Friend ReadOnly _label as LabelSyntax

        Friend Sub New(ByVal kind As SyntaxKind, goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), goToKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GoToStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "GoTo" keyword.
        ''' </summary>
        Friend ReadOnly Property GoToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._goToKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the label. If the label is a line number, wraps an IntegerLiteral
        ''' that is the line number, otherwise, wraps an Identifier.
        ''' </summary>
        Friend ReadOnly Property Label As InternalSyntax.LabelSyntax
            Get
                Return Me._label
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._goToKeyword
                Case 1
                    Return Me._label
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GoToStatementSyntax(Me.Kind, newErrors, GetAnnotations, _goToKeyword, _label)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GoToStatementSyntax(Me.Kind, GetDiagnostics, annotations, _goToKeyword, _label)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGoToStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' A label for a GoTo, Resume, or On Error statement. An identifier, line number,
    ''' or next keyword.
    ''' </summary>
    Friend NotInheritable Class LabelSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _labelToken as SyntaxToken

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, labelToken As InternalSyntax.SyntaxToken, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), labelToken As InternalSyntax.SyntaxToken)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(labelToken)
            Me._labelToken = labelToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LabelSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The label name (identifier), line number (integer literal), or next keyword
        ''' token.
        ''' </summary>
        Friend ReadOnly Property LabelToken As InternalSyntax.SyntaxToken
            Get
                Return Me._labelToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._labelToken
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LabelSyntax(Me.Kind, newErrors, GetAnnotations, _labelToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LabelSyntax(Me.Kind, GetDiagnostics, annotations, _labelToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLabel(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Stop" or "End" statement. The Kind can be used to determine which
    ''' kind of statement this is.
    ''' </summary>
    Friend NotInheritable Class StopOrEndStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _stopOrEndKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, stopOrEndKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(stopOrEndKeyword)
            Me._stopOrEndKeyword = stopOrEndKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, stopOrEndKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(stopOrEndKeyword)
            Me._stopOrEndKeyword = stopOrEndKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), stopOrEndKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(stopOrEndKeyword)
            Me._stopOrEndKeyword = stopOrEndKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.StopOrEndStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Stop" or "End" keyword.
        ''' </summary>
        Friend ReadOnly Property StopOrEndKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._stopOrEndKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._stopOrEndKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new StopOrEndStatementSyntax(Me.Kind, newErrors, GetAnnotations, _stopOrEndKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new StopOrEndStatementSyntax(Me.Kind, GetDiagnostics, annotations, _stopOrEndKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitStopOrEndStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' An exit statement. The kind of block being exited can be found by examining the
    ''' Kind.
    ''' </summary>
    Friend NotInheritable Class ExitStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _exitKeyword as KeywordSyntax
        Friend ReadOnly _blockKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(exitKeyword)
            Me._exitKeyword = exitKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(exitKeyword)
            Me._exitKeyword = exitKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), exitKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(exitKeyword)
            Me._exitKeyword = exitKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ExitStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Exit" keyword.
        ''' </summary>
        Friend ReadOnly Property ExitKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._exitKeyword
            End Get
        End Property

        ''' <summary>
        ''' The keyword describing the block to exit.
        ''' </summary>
        Friend ReadOnly Property BlockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._blockKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._exitKeyword
                Case 1
                    Return Me._blockKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ExitStatementSyntax(Me.Kind, newErrors, GetAnnotations, _exitKeyword, _blockKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ExitStatementSyntax(Me.Kind, GetDiagnostics, annotations, _exitKeyword, _blockKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitExitStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Continue (block)" statement. THe kind of block referenced can be
    ''' determined by examining the Kind.
    ''' </summary>
    Friend NotInheritable Class ContinueStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _continueKeyword as KeywordSyntax
        Friend ReadOnly _blockKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(continueKeyword)
            Me._continueKeyword = continueKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(continueKeyword)
            Me._continueKeyword = continueKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), continueKeyword As InternalSyntax.KeywordSyntax, blockKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(continueKeyword)
            Me._continueKeyword = continueKeyword
            AdjustFlagsAndWidth(blockKeyword)
            Me._blockKeyword = blockKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ContinueStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Continue" keyword.
        ''' </summary>
        Friend ReadOnly Property ContinueKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._continueKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Do", "For" or "While" keyword that identifies the kind of loop being
        ''' continued.
        ''' </summary>
        Friend ReadOnly Property BlockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._blockKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._continueKeyword
                Case 1
                    Return Me._blockKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ContinueStatementSyntax(Me.Kind, newErrors, GetAnnotations, _continueKeyword, _blockKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ContinueStatementSyntax(Me.Kind, GetDiagnostics, annotations, _continueKeyword, _blockKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitContinueStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Return" statement.
    ''' </summary>
    Friend NotInheritable Class ReturnStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _returnKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(returnKeyword)
            Me._returnKeyword = returnKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(returnKeyword)
            Me._returnKeyword = returnKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), returnKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(returnKeyword)
            Me._returnKeyword = returnKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ReturnStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Return" keyword.
        ''' </summary>
        Friend ReadOnly Property ReturnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._returnKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression being returned, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._returnKeyword
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ReturnStatementSyntax(Me.Kind, newErrors, GetAnnotations, _returnKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ReturnStatementSyntax(Me.Kind, GetDiagnostics, annotations, _returnKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitReturnStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single-line "If ... Then ... Else ..." statement.
    ''' </summary>
    Friend NotInheritable Class SingleLineIfStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _thenKeyword as KeywordSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _elseClause as SingleLineElseClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, elseClause As SingleLineElseClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(thenKeyword)
            Me._thenKeyword = thenKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseClause IsNot Nothing Then
                AdjustFlagsAndWidth(elseClause)
                Me._elseClause = elseClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, elseClause As SingleLineElseClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(thenKeyword)
            Me._thenKeyword = thenKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseClause IsNot Nothing Then
                AdjustFlagsAndWidth(elseClause)
                Me._elseClause = elseClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, elseClause As SingleLineElseClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(thenKeyword)
            Me._thenKeyword = thenKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseClause IsNot Nothing Then
                AdjustFlagsAndWidth(elseClause)
                Me._elseClause = elseClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SingleLineIfStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword.
        ''' </summary>
        Friend ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        Friend ReadOnly Property ThenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._thenKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if the condition expression evaluates as
        ''' true. Multiple statements must be separated by colons.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' An "Else" clause to be executed if the condition expression evaluates as false.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ElseClause As InternalSyntax.SingleLineElseClauseSyntax
            Get
                Return Me._elseClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._condition
                Case 2
                    Return Me._thenKeyword
                Case 3
                    Return Me._statements
                Case 4
                    Return Me._elseClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SingleLineIfStatementSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _condition, _thenKeyword, _statements, _elseClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SingleLineIfStatementSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _condition, _thenKeyword, _statements, _elseClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSingleLineIfStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Else ..." clause of a single-line "If" statement.
    ''' </summary>
    Friend NotInheritable Class SingleLineElseClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _elseKeyword as KeywordSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SingleLineElseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Friend ReadOnly Property ElseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed. Multiple statements must be separated by
        ''' colons.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseKeyword
                Case 1
                    Return Me._statements
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SingleLineElseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _elseKeyword, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SingleLineElseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _elseKeyword, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSingleLineElseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a multi-line "If ... Then ... ElseIf ... Then ... Else ... End If"
    ''' block.
    ''' </summary>
    Friend NotInheritable Class MultiLineIfBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _ifStatement as IfStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _elseIfBlocks as GreenNode
        Friend ReadOnly _elseBlock as ElseBlockSyntax
        Friend ReadOnly _endIfStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifStatement As IfStatementSyntax, statements As GreenNode, elseIfBlocks As GreenNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(ifStatement)
            Me._ifStatement = ifStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseIfBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(elseIfBlocks)
                Me._elseIfBlocks = elseIfBlocks
            End If
            If elseBlock IsNot Nothing Then
                AdjustFlagsAndWidth(elseBlock)
                Me._elseBlock = elseBlock
            End If
            AdjustFlagsAndWidth(endIfStatement)
            Me._endIfStatement = endIfStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifStatement As IfStatementSyntax, statements As GreenNode, elseIfBlocks As GreenNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifStatement)
            Me._ifStatement = ifStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseIfBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(elseIfBlocks)
                Me._elseIfBlocks = elseIfBlocks
            End If
            If elseBlock IsNot Nothing Then
                AdjustFlagsAndWidth(elseBlock)
                Me._elseBlock = elseBlock
            End If
            AdjustFlagsAndWidth(endIfStatement)
            Me._endIfStatement = endIfStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifStatement As IfStatementSyntax, statements As GreenNode, elseIfBlocks As GreenNode, elseBlock As ElseBlockSyntax, endIfStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(ifStatement)
            Me._ifStatement = ifStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If elseIfBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(elseIfBlocks)
                Me._elseIfBlocks = elseIfBlocks
            End If
            If elseBlock IsNot Nothing Then
                AdjustFlagsAndWidth(elseBlock)
                Me._elseBlock = elseBlock
            End If
            AdjustFlagsAndWidth(endIfStatement)
            Me._endIfStatement = endIfStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MultiLineIfBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" statement that begins the "If" block.
        ''' </summary>
        Friend ReadOnly Property IfStatement As InternalSyntax.IfStatementSyntax
            Get
                Return Me._ifStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if the condition expression evaluates as
        ''' true.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' A list of "ElseIf" blocks to be evaluated, in order, if the condition
        ''' expression of the "If" statement evaluates as false.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property ElseIfBlocks As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ElseIfBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ElseIfBlockSyntax)(Me._elseIfBlocks)
            End Get
        End Property

        ''' <summary>
        ''' An "Else" block to be executed if the condition expression of the "If"
        ''' statement and all "ElseIf" blocks evaluate as false.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ElseBlock As InternalSyntax.ElseBlockSyntax
            Get
                Return Me._elseBlock
            End Get
        End Property

        ''' <summary>
        ''' Then "End If" statement.
        ''' </summary>
        Friend ReadOnly Property EndIfStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endIfStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._elseIfBlocks
                Case 3
                    Return Me._elseBlock
                Case 4
                    Return Me._endIfStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MultiLineIfBlockSyntax(Me.Kind, newErrors, GetAnnotations, _ifStatement, _statements, _elseIfBlocks, _elseBlock, _endIfStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MultiLineIfBlockSyntax(Me.Kind, GetDiagnostics, annotations, _ifStatement, _statements, _elseIfBlocks, _elseBlock, _endIfStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMultiLineIfBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "If ... Then" statement that begins a multi-line "If" block.
    ''' </summary>
    Friend NotInheritable Class IfStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _thenKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.IfStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword.
        ''' </summary>
        Friend ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ThenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._thenKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._condition
                Case 2
                    Return Me._thenKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new IfStatementSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _condition, _thenKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new IfStatementSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _condition, _thenKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitIfStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "ElseIf ... Then ..." block.
    ''' </summary>
    Friend NotInheritable Class ElseIfBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _elseIfStatement as ElseIfStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elseIfStatement As ElseIfStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elseIfStatement)
            Me._elseIfStatement = elseIfStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseIfStatement As ElseIfStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseIfStatement)
            Me._elseIfStatement = elseIfStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseIfStatement As ElseIfStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elseIfStatement)
            Me._elseIfStatement = elseIfStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseIfBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "ElseIf ... Then" statement the begins the "ElseIf" block.
        ''' </summary>
        Friend ReadOnly Property ElseIfStatement As InternalSyntax.ElseIfStatementSyntax
            Get
                Return Me._elseIfStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if the condition expression of the "ElseIf"
        ''' statement evaluates as true.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseIfStatement
                Case 1
                    Return Me._statements
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseIfBlockSyntax(Me.Kind, newErrors, GetAnnotations, _elseIfStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseIfBlockSyntax(Me.Kind, GetDiagnostics, annotations, _elseIfStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseIfBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "ElseIf ... Then" statement that begins an "ElseIf" block.
    ''' </summary>
    Friend NotInheritable Class ElseIfStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _elseIfKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _thenKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(elseIfKeyword)
            Me._elseIfKeyword = elseIfKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseIfKeyword)
            Me._elseIfKeyword = elseIfKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseIfKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, thenKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(elseIfKeyword)
            Me._elseIfKeyword = elseIfKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            If thenKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(thenKeyword)
                Me._thenKeyword = thenKeyword
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseIfStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "ElseIf" keyword.
        ''' </summary>
        Friend ReadOnly Property ElseIfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseIfKeyword
            End Get
        End Property

        ''' <summary>
        ''' The condition expression to be evaluated.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "Then" keyword.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ThenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._thenKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseIfKeyword
                Case 1
                    Return Me._condition
                Case 2
                    Return Me._thenKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseIfStatementSyntax(Me.Kind, newErrors, GetAnnotations, _elseIfKeyword, _condition, _thenKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseIfStatementSyntax(Me.Kind, GetDiagnostics, annotations, _elseIfKeyword, _condition, _thenKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseIfStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "Else ..." block.
    ''' </summary>
    Friend NotInheritable Class ElseBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _elseStatement as ElseStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elseStatement As ElseStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elseStatement)
            Me._elseStatement = elseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseStatement As ElseStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseStatement)
            Me._elseStatement = elseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseStatement As ElseStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elseStatement)
            Me._elseStatement = elseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" statement that begins the "Else" block.
        ''' </summary>
        Friend ReadOnly Property ElseStatement As InternalSyntax.ElseStatementSyntax
            Get
                Return Me._elseStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elseStatement
                Case 1
                    Return Me._statements
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseBlockSyntax(Me.Kind, newErrors, GetAnnotations, _elseStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseBlockSyntax(Me.Kind, GetDiagnostics, annotations, _elseStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Else" statement that begins an "Else" block.
    ''' </summary>
    Friend NotInheritable Class ElseStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _elseKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Friend ReadOnly Property ElseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._elseKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseStatementSyntax(Me.Kind, newErrors, GetAnnotations, _elseKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseStatementSyntax(Me.Kind, GetDiagnostics, annotations, _elseKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Try ... Catch ... Finally ... End Try" block.
    ''' </summary>
    Friend NotInheritable Class TryBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _tryStatement as TryStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _catchBlocks as GreenNode
        Friend ReadOnly _finallyBlock as FinallyBlockSyntax
        Friend ReadOnly _endTryStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, tryStatement As TryStatementSyntax, statements As GreenNode, catchBlocks As GreenNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(tryStatement)
            Me._tryStatement = tryStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If catchBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(catchBlocks)
                Me._catchBlocks = catchBlocks
            End If
            If finallyBlock IsNot Nothing Then
                AdjustFlagsAndWidth(finallyBlock)
                Me._finallyBlock = finallyBlock
            End If
            AdjustFlagsAndWidth(endTryStatement)
            Me._endTryStatement = endTryStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, tryStatement As TryStatementSyntax, statements As GreenNode, catchBlocks As GreenNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(tryStatement)
            Me._tryStatement = tryStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If catchBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(catchBlocks)
                Me._catchBlocks = catchBlocks
            End If
            If finallyBlock IsNot Nothing Then
                AdjustFlagsAndWidth(finallyBlock)
                Me._finallyBlock = finallyBlock
            End If
            AdjustFlagsAndWidth(endTryStatement)
            Me._endTryStatement = endTryStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), tryStatement As TryStatementSyntax, statements As GreenNode, catchBlocks As GreenNode, finallyBlock As FinallyBlockSyntax, endTryStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(tryStatement)
            Me._tryStatement = tryStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If catchBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(catchBlocks)
                Me._catchBlocks = catchBlocks
            End If
            If finallyBlock IsNot Nothing Then
                AdjustFlagsAndWidth(finallyBlock)
                Me._finallyBlock = finallyBlock
            End If
            AdjustFlagsAndWidth(endTryStatement)
            Me._endTryStatement = endTryStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TryBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Try" statement that begins the "Try" block.
        ''' </summary>
        Friend ReadOnly Property TryStatement As InternalSyntax.TryStatementSyntax
            Get
                Return Me._tryStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' A list of "Catch" blocks which may be executed if an exception is thrown while
        ''' executing the statements in the "Try" block.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property CatchBlocks As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CatchBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CatchBlockSyntax)(Me._catchBlocks)
            End Get
        End Property

        ''' <summary>
        ''' A "Finally" block to be executed before execution leaves the "Try" block.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property FinallyBlock As InternalSyntax.FinallyBlockSyntax
            Get
                Return Me._finallyBlock
            End Get
        End Property

        ''' <summary>
        ''' The "End Try" statement.
        ''' </summary>
        Friend ReadOnly Property EndTryStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endTryStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._tryStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._catchBlocks
                Case 3
                    Return Me._finallyBlock
                Case 4
                    Return Me._endTryStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TryBlockSyntax(Me.Kind, newErrors, GetAnnotations, _tryStatement, _statements, _catchBlocks, _finallyBlock, _endTryStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TryBlockSyntax(Me.Kind, GetDiagnostics, annotations, _tryStatement, _statements, _catchBlocks, _finallyBlock, _endTryStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTryBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Try" statement that begins a "Try" block.
    ''' </summary>
    Friend NotInheritable Class TryStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _tryKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, tryKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(tryKeyword)
            Me._tryKeyword = tryKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, tryKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(tryKeyword)
            Me._tryKeyword = tryKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), tryKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(tryKeyword)
            Me._tryKeyword = tryKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TryStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Try" keyword.
        ''' </summary>
        Friend ReadOnly Property TryKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._tryKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._tryKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TryStatementSyntax(Me.Kind, newErrors, GetAnnotations, _tryKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TryStatementSyntax(Me.Kind, GetDiagnostics, annotations, _tryKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTryStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Catch ..." block.
    ''' </summary>
    Friend NotInheritable Class CatchBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _catchStatement as CatchStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, catchStatement As CatchStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(catchStatement)
            Me._catchStatement = catchStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, catchStatement As CatchStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(catchStatement)
            Me._catchStatement = catchStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), catchStatement As CatchStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(catchStatement)
            Me._catchStatement = catchStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CatchBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Catch" statement that begins the "Catch" block.
        ''' </summary>
        Friend ReadOnly Property CatchStatement As InternalSyntax.CatchStatementSyntax
            Get
                Return Me._catchStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed if an exception is caught by the "Catch"
        ''' block.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._catchStatement
                Case 1
                    Return Me._statements
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CatchBlockSyntax(Me.Kind, newErrors, GetAnnotations, _catchStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CatchBlockSyntax(Me.Kind, GetDiagnostics, annotations, _catchStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCatchBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Catch ... When ..." statement that begins a "Catch" block.
    ''' </summary>
    Friend NotInheritable Class CatchStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _catchKeyword as KeywordSyntax
        Friend ReadOnly _identifierName as IdentifierNameSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _whenClause as CatchFilterClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(catchKeyword)
            Me._catchKeyword = catchKeyword
            If identifierName IsNot Nothing Then
                AdjustFlagsAndWidth(identifierName)
                Me._identifierName = identifierName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If whenClause IsNot Nothing Then
                AdjustFlagsAndWidth(whenClause)
                Me._whenClause = whenClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(catchKeyword)
            Me._catchKeyword = catchKeyword
            If identifierName IsNot Nothing Then
                AdjustFlagsAndWidth(identifierName)
                Me._identifierName = identifierName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If whenClause IsNot Nothing Then
                AdjustFlagsAndWidth(whenClause)
                Me._whenClause = whenClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), catchKeyword As InternalSyntax.KeywordSyntax, identifierName As IdentifierNameSyntax, asClause As SimpleAsClauseSyntax, whenClause As CatchFilterClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(catchKeyword)
            Me._catchKeyword = catchKeyword
            If identifierName IsNot Nothing Then
                AdjustFlagsAndWidth(identifierName)
                Me._identifierName = identifierName
            End If
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            If whenClause IsNot Nothing Then
                AdjustFlagsAndWidth(whenClause)
                Me._whenClause = whenClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CatchStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Catch" keyword.
        ''' </summary>
        Friend ReadOnly Property CatchKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._catchKeyword
            End Get
        End Property

        ''' <summary>
        ''' An identifier declaring a new variable or naming an existing variable to store
        ''' the exception caught by the "Catch" statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property IdentifierName As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._identifierName
            End Get
        End Property

        ''' <summary>
        ''' A simple "As" clause specifying the type of exception to catch.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' A "When" clause to filter exceptions before catching.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property WhenClause As InternalSyntax.CatchFilterClauseSyntax
            Get
                Return Me._whenClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._catchKeyword
                Case 1
                    Return Me._identifierName
                Case 2
                    Return Me._asClause
                Case 3
                    Return Me._whenClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CatchStatementSyntax(Me.Kind, newErrors, GetAnnotations, _catchKeyword, _identifierName, _asClause, _whenClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CatchStatementSyntax(Me.Kind, GetDiagnostics, annotations, _catchKeyword, _identifierName, _asClause, _whenClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCatchStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "When ..." clause of a "Catch" statement.
    ''' </summary>
    Friend NotInheritable Class CatchFilterClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _whenKeyword as KeywordSyntax
        Friend ReadOnly _filter as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whenKeyword)
            Me._whenKeyword = whenKeyword
            AdjustFlagsAndWidth(filter)
            Me._filter = filter

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whenKeyword)
            Me._whenKeyword = whenKeyword
            AdjustFlagsAndWidth(filter)
            Me._filter = filter

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whenKeyword As InternalSyntax.KeywordSyntax, filter As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whenKeyword)
            Me._whenKeyword = whenKeyword
            AdjustFlagsAndWidth(filter)
            Me._filter = filter

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CatchFilterClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "When" keyword.
        ''' </summary>
        Friend ReadOnly Property WhenKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whenKeyword
            End Get
        End Property

        ''' <summary>
        ''' The filter expression to be evaluated.
        ''' </summary>
        Friend ReadOnly Property Filter As InternalSyntax.ExpressionSyntax
            Get
                Return Me._filter
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whenKeyword
                Case 1
                    Return Me._filter
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CatchFilterClauseSyntax(Me.Kind, newErrors, GetAnnotations, _whenKeyword, _filter)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CatchFilterClauseSyntax(Me.Kind, GetDiagnostics, annotations, _whenKeyword, _filter)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCatchFilterClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Finally ..." block of a "Try" block.
    ''' </summary>
    Friend NotInheritable Class FinallyBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _finallyStatement as FinallyStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, finallyStatement As FinallyStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(finallyStatement)
            Me._finallyStatement = finallyStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, finallyStatement As FinallyStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(finallyStatement)
            Me._finallyStatement = finallyStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), finallyStatement As FinallyStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(finallyStatement)
            Me._finallyStatement = finallyStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FinallyBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Finally" statement that begins the "Finally" block.
        ''' </summary>
        Friend ReadOnly Property FinallyStatement As InternalSyntax.FinallyStatementSyntax
            Get
                Return Me._finallyStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of statements to be executed.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._finallyStatement
                Case 1
                    Return Me._statements
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FinallyBlockSyntax(Me.Kind, newErrors, GetAnnotations, _finallyStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FinallyBlockSyntax(Me.Kind, GetDiagnostics, annotations, _finallyStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFinallyBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Finally" statement that begins a "Finally" block.
    ''' </summary>
    Friend NotInheritable Class FinallyStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _finallyKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, finallyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(finallyKeyword)
            Me._finallyKeyword = finallyKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, finallyKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(finallyKeyword)
            Me._finallyKeyword = finallyKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), finallyKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(finallyKeyword)
            Me._finallyKeyword = finallyKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FinallyStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Finally" keyword.
        ''' </summary>
        Friend ReadOnly Property FinallyKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._finallyKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._finallyKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FinallyStatementSyntax(Me.Kind, newErrors, GetAnnotations, _finallyKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FinallyStatementSyntax(Me.Kind, GetDiagnostics, annotations, _finallyKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFinallyStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Error" statement.
    ''' </summary>
    Friend NotInheritable Class ErrorStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _errorKeyword as KeywordSyntax
        Friend ReadOnly _errorNumber as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(errorNumber)
            Me._errorNumber = errorNumber

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(errorNumber)
            Me._errorNumber = errorNumber

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), errorKeyword As InternalSyntax.KeywordSyntax, errorNumber As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(errorNumber)
            Me._errorNumber = errorNumber

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ErrorStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Friend ReadOnly Property ErrorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._errorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression that represents the error number.
        ''' </summary>
        Friend ReadOnly Property ErrorNumber As InternalSyntax.ExpressionSyntax
            Get
                Return Me._errorNumber
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._errorKeyword
                Case 1
                    Return Me._errorNumber
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ErrorStatementSyntax(Me.Kind, newErrors, GetAnnotations, _errorKeyword, _errorNumber)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ErrorStatementSyntax(Me.Kind, GetDiagnostics, annotations, _errorKeyword, _errorNumber)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitErrorStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an OnError Goto statement.
    ''' </summary>
    Friend NotInheritable Class OnErrorGoToStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _onKeyword as KeywordSyntax
        Friend ReadOnly _errorKeyword as KeywordSyntax
        Friend ReadOnly _goToKeyword as KeywordSyntax
        Friend ReadOnly _minus as PunctuationSyntax
        Friend ReadOnly _label as LabelSyntax

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            If minus IsNot Nothing Then
                AdjustFlagsAndWidth(minus)
                Me._minus = minus
            End If
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            If minus IsNot Nothing Then
                AdjustFlagsAndWidth(minus)
                Me._minus = minus
            End If
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, goToKeyword As InternalSyntax.KeywordSyntax, minus As InternalSyntax.PunctuationSyntax, label As LabelSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(goToKeyword)
            Me._goToKeyword = goToKeyword
            If minus IsNot Nothing Then
                AdjustFlagsAndWidth(minus)
                Me._minus = minus
            End If
            AdjustFlagsAndWidth(label)
            Me._label = label

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OnErrorGoToStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "On" keyword
        ''' </summary>
        Friend ReadOnly Property OnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._onKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Friend ReadOnly Property ErrorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._errorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "GoTo" keyword
        ''' </summary>
        Friend ReadOnly Property GoToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._goToKeyword
            End Get
        End Property

        ''' <summary>
        ''' An optional minus for On Error Goto -1
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Minus As InternalSyntax.PunctuationSyntax
            Get
                Return Me._minus
            End Get
        End Property

        ''' <summary>
        ''' The name of the label. If the label is a line number, 0 or -1, wraps an
        ''' IntegerLiteralToken that is the line number, otherwise, wraps an Identifier.
        ''' </summary>
        Friend ReadOnly Property Label As InternalSyntax.LabelSyntax
            Get
                Return Me._label
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._onKeyword
                Case 1
                    Return Me._errorKeyword
                Case 2
                    Return Me._goToKeyword
                Case 3
                    Return Me._minus
                Case 4
                    Return Me._label
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OnErrorGoToStatementSyntax(Me.Kind, newErrors, GetAnnotations, _onKeyword, _errorKeyword, _goToKeyword, _minus, _label)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OnErrorGoToStatementSyntax(Me.Kind, GetDiagnostics, annotations, _onKeyword, _errorKeyword, _goToKeyword, _minus, _label)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOnErrorGoToStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an OnError Resume Next statement.
    ''' </summary>
    Friend NotInheritable Class OnErrorResumeNextStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _onKeyword as KeywordSyntax
        Friend ReadOnly _errorKeyword as KeywordSyntax
        Friend ReadOnly _resumeKeyword as KeywordSyntax
        Friend ReadOnly _nextKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), onKeyword As InternalSyntax.KeywordSyntax, errorKeyword As InternalSyntax.KeywordSyntax, resumeKeyword As InternalSyntax.KeywordSyntax, nextKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            AdjustFlagsAndWidth(errorKeyword)
            Me._errorKeyword = errorKeyword
            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OnErrorResumeNextStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "On" keyword
        ''' </summary>
        Friend ReadOnly Property OnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._onKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Error" keyword.
        ''' </summary>
        Friend ReadOnly Property ErrorKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._errorKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Resume" keyword.
        ''' </summary>
        Friend ReadOnly Property ResumeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._resumeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Next"
        ''' </summary>
        Friend ReadOnly Property NextKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._nextKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._onKeyword
                Case 1
                    Return Me._errorKeyword
                Case 2
                    Return Me._resumeKeyword
                Case 3
                    Return Me._nextKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OnErrorResumeNextStatementSyntax(Me.Kind, newErrors, GetAnnotations, _onKeyword, _errorKeyword, _resumeKeyword, _nextKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OnErrorResumeNextStatementSyntax(Me.Kind, GetDiagnostics, annotations, _onKeyword, _errorKeyword, _resumeKeyword, _nextKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOnErrorResumeNextStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Resume" statement. The Kind property can be used to determine if
    ''' this is a "Resume", "Resume Next" or "Resume label" statement.
    ''' </summary>
    Friend NotInheritable Class ResumeStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _resumeKeyword as KeywordSyntax
        Friend ReadOnly _label as LabelSyntax

        Friend Sub New(ByVal kind As SyntaxKind, resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            If label IsNot Nothing Then
                AdjustFlagsAndWidth(label)
                Me._label = label
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            If label IsNot Nothing Then
                AdjustFlagsAndWidth(label)
                Me._label = label
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), resumeKeyword As InternalSyntax.KeywordSyntax, label As LabelSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(resumeKeyword)
            Me._resumeKeyword = resumeKeyword
            If label IsNot Nothing Then
                AdjustFlagsAndWidth(label)
                Me._label = label
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ResumeStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Resume" keyword.
        ''' </summary>
        Friend ReadOnly Property ResumeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._resumeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The label. The value of this depends on the Kind. If Kind=Resume, returns
        ''' Nothing. If Kind=ResumeNext, wraps the keyword "Next", If Kind=ResumeLabel,
        ''' wraps an Identifier or IntegerLiteralToken with the label or line number.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Label As InternalSyntax.LabelSyntax
            Get
                Return Me._label
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._resumeKeyword
                Case 1
                    Return Me._label
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ResumeStatementSyntax(Me.Kind, newErrors, GetAnnotations, _resumeKeyword, _label)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ResumeStatementSyntax(Me.Kind, GetDiagnostics, annotations, _resumeKeyword, _label)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitResumeStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Select Case block, including the Select Case that begins it, the
    ''' contains Case blocks and the End Select.
    ''' </summary>
    Friend NotInheritable Class SelectBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _selectStatement as SelectStatementSyntax
        Friend ReadOnly _caseBlocks as GreenNode
        Friend ReadOnly _endSelectStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, selectStatement As SelectStatementSyntax, caseBlocks As GreenNode, endSelectStatement As EndBlockStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(selectStatement)
            Me._selectStatement = selectStatement
            If caseBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(caseBlocks)
                Me._caseBlocks = caseBlocks
            End If
            AdjustFlagsAndWidth(endSelectStatement)
            Me._endSelectStatement = endSelectStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, selectStatement As SelectStatementSyntax, caseBlocks As GreenNode, endSelectStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(selectStatement)
            Me._selectStatement = selectStatement
            If caseBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(caseBlocks)
                Me._caseBlocks = caseBlocks
            End If
            AdjustFlagsAndWidth(endSelectStatement)
            Me._endSelectStatement = endSelectStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectStatement As SelectStatementSyntax, caseBlocks As GreenNode, endSelectStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(selectStatement)
            Me._selectStatement = selectStatement
            If caseBlocks IsNot Nothing Then
                AdjustFlagsAndWidth(caseBlocks)
                Me._caseBlocks = caseBlocks
            End If
            AdjustFlagsAndWidth(endSelectStatement)
            Me._endSelectStatement = endSelectStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SelectBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The Select Case statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property SelectStatement As InternalSyntax.SelectStatementSyntax
            Get
                Return Me._selectStatement
            End Get
        End Property

        ''' <summary>
        ''' A list of the contained Case blocks.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property CaseBlocks As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CaseBlockSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of CaseBlockSyntax)(Me._caseBlocks)
            End Get
        End Property

        ''' <summary>
        ''' The End Select statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property EndSelectStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSelectStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._selectStatement
                Case 1
                    Return Me._caseBlocks
                Case 2
                    Return Me._endSelectStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SelectBlockSyntax(Me.Kind, newErrors, GetAnnotations, _selectStatement, _caseBlocks, _endSelectStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SelectBlockSyntax(Me.Kind, GetDiagnostics, annotations, _selectStatement, _caseBlocks, _endSelectStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSelectBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Select Case statement. This statement always occurs as the Begin
    ''' of a SelectBlock.
    ''' </summary>
    Friend NotInheritable Class SelectStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _selectKeyword as KeywordSyntax
        Friend ReadOnly _caseKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If caseKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(caseKeyword)
                Me._caseKeyword = caseKeyword
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If caseKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(caseKeyword)
                Me._caseKeyword = caseKeyword
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectKeyword As InternalSyntax.KeywordSyntax, caseKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If caseKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(caseKeyword)
                Me._caseKeyword = caseKeyword
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SelectStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Select" keyword.
        ''' </summary>
        Friend ReadOnly Property SelectKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._selectKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Case" keyword, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property CaseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._caseKeyword
            End Get
        End Property

        ''' <summary>
        ''' The value that branching is based on.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._selectKeyword
                Case 1
                    Return Me._caseKeyword
                Case 2
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SelectStatementSyntax(Me.Kind, newErrors, GetAnnotations, _selectKeyword, _caseKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SelectStatementSyntax(Me.Kind, GetDiagnostics, annotations, _selectKeyword, _caseKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSelectStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a case statement and its subsequent block.
    ''' </summary>
    Friend NotInheritable Class CaseBlockSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _caseStatement as CaseStatementSyntax
        Friend ReadOnly _statements as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, caseStatement As CaseStatementSyntax, statements As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(caseStatement)
            Me._caseStatement = caseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, caseStatement As CaseStatementSyntax, statements As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(caseStatement)
            Me._caseStatement = caseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), caseStatement As CaseStatementSyntax, statements As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(caseStatement)
            Me._caseStatement = caseStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CaseBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The statement that begins the case block.
        ''' </summary>
        Friend ReadOnly Property CaseStatement As InternalSyntax.CaseStatementSyntax
            Get
                Return Me._caseStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the case block. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._caseStatement
                Case 1
                    Return Me._statements
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CaseBlockSyntax(Me.Kind, newErrors, GetAnnotations, _caseStatement, _statements)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CaseBlockSyntax(Me.Kind, GetDiagnostics, annotations, _caseStatement, _statements)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCaseBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Case or Case Else statement. This statement is always the Begin of
    ''' a CaseBlock. If this is a Case Else statement, the Kind=CaseElse, otherwise the
    ''' Kind=Case.
    ''' </summary>
    Friend NotInheritable Class CaseStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _caseKeyword as KeywordSyntax
        Friend ReadOnly _cases as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, caseKeyword As InternalSyntax.KeywordSyntax, cases As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(caseKeyword)
            Me._caseKeyword = caseKeyword
            If cases IsNot Nothing Then
                AdjustFlagsAndWidth(cases)
                Me._cases = cases
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, caseKeyword As InternalSyntax.KeywordSyntax, cases As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(caseKeyword)
            Me._caseKeyword = caseKeyword
            If cases IsNot Nothing Then
                AdjustFlagsAndWidth(cases)
                Me._cases = cases
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), caseKeyword As InternalSyntax.KeywordSyntax, cases As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(caseKeyword)
            Me._caseKeyword = caseKeyword
            If cases IsNot Nothing Then
                AdjustFlagsAndWidth(cases)
                Me._cases = cases
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CaseStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Case" keyword
        ''' </summary>
        Friend ReadOnly Property CaseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._caseKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of clauses associated with this Case. If Kind=CaseElse, then this list
        ''' has exactly one child, which is a ElseCaseClause.
        ''' </summary>
        Friend ReadOnly Property Cases As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CaseClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CaseClauseSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of CaseClauseSyntax)(Me._cases))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._caseKeyword
                Case 1
                    Return Me._cases
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CaseStatementSyntax(Me.Kind, newErrors, GetAnnotations, _caseKeyword, _cases)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CaseStatementSyntax(Me.Kind, GetDiagnostics, annotations, _caseKeyword, _cases)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCaseStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single clause in a case statement. An abstract node that is the
    ''' parent of different kinds of Case clauses.
    ''' </summary>
    Friend MustInherit Class CaseClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' The "Else" part in a Case Else statement.
    ''' </summary>
    Friend NotInheritable Class ElseCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _elseKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elseKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elseKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(elseKeyword)
            Me._elseKeyword = elseKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ElseCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Else" keyword.
        ''' </summary>
        Friend ReadOnly Property ElseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._elseKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._elseKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ElseCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _elseKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ElseCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _elseKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitElseCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single value in a Case.
    ''' </summary>
    Friend NotInheritable Class SimpleCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _value as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, value As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, value As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), value As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression that denotes the value being tested against.
        ''' </summary>
        Friend ReadOnly Property Value As InternalSyntax.ExpressionSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._value
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a range "expression To expression" in a Case.
    ''' </summary>
    Friend NotInheritable Class RangeCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _lowerBound as ExpressionSyntax
        Friend ReadOnly _toKeyword as KeywordSyntax
        Friend ReadOnly _upperBound as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RangeCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The lower bound of the range.
        ''' </summary>
        Friend ReadOnly Property LowerBound As InternalSyntax.ExpressionSyntax
            Get
                Return Me._lowerBound
            End Get
        End Property

        ''' <summary>
        ''' The "To" keyword
        ''' </summary>
        Friend ReadOnly Property ToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._toKeyword
            End Get
        End Property

        ''' <summary>
        ''' The upper bound of the range.
        ''' </summary>
        Friend ReadOnly Property UpperBound As InternalSyntax.ExpressionSyntax
            Get
                Return Me._upperBound
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lowerBound
                Case 1
                    Return Me._toKeyword
                Case 2
                    Return Me._upperBound
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RangeCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _lowerBound, _toKeyword, _upperBound)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RangeCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _lowerBound, _toKeyword, _upperBound)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRangeCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a relation clause in a Case statement, such as "Is &gt; expression".
    ''' </summary>
    Friend NotInheritable Class RelationalCaseClauseSyntax
        Inherits CaseClauseSyntax

        Friend ReadOnly _isKeyword as KeywordSyntax
        Friend ReadOnly _operatorToken as PunctuationSyntax
        Friend ReadOnly _value as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If isKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(isKeyword)
                Me._isKeyword = isKeyword
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If isKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(isKeyword)
                Me._isKeyword = isKeyword
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), isKeyword As InternalSyntax.KeywordSyntax, operatorToken As InternalSyntax.PunctuationSyntax, value As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If isKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(isKeyword)
                Me._isKeyword = isKeyword
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RelationalCaseClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Is" keyword, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property IsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._isKeyword
            End Get
        End Property

        ''' <summary>
        ''' The operator in the relational clause. One of "=", "&lt;", "&gt;", "&lt;=" or
        ''' "&gt;=".
        ''' </summary>
        Friend ReadOnly Property OperatorToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The expression that denotes the value being tested against.
        ''' </summary>
        Friend ReadOnly Property Value As InternalSyntax.ExpressionSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._isKeyword
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._value
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RelationalCaseClauseSyntax(Me.Kind, newErrors, GetAnnotations, _isKeyword, _operatorToken, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RelationalCaseClauseSyntax(Me.Kind, GetDiagnostics, annotations, _isKeyword, _operatorToken, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRelationalCaseClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "SyncLock" statement. This statement always occurs as the Begin
    ''' of a SyncLockBlock.
    ''' </summary>
    Friend NotInheritable Class SyncLockStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _syncLockKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(syncLockKeyword)
            Me._syncLockKeyword = syncLockKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(syncLockKeyword)
            Me._syncLockKeyword = syncLockKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), syncLockKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(syncLockKeyword)
            Me._syncLockKeyword = syncLockKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SyncLockStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "SyncLock" keyword.
        ''' </summary>
        Friend ReadOnly Property SyncLockKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._syncLockKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression being synchronized on.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._syncLockKeyword
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SyncLockStatementSyntax(Me.Kind, newErrors, GetAnnotations, _syncLockKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SyncLockStatementSyntax(Me.Kind, GetDiagnostics, annotations, _syncLockKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSyncLockStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Do-Loop block. The Kind property can be used to determine if this
    ''' is a Do While, Do Until, Do Loop While, Do Loop Until, or infinite Do Loop.
    ''' </summary>
    Friend NotInheritable Class DoLoopBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _doStatement as DoStatementSyntax
        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _loopStatement as LoopStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, doStatement As DoStatementSyntax, statements As GreenNode, loopStatement As LoopStatementSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(doStatement)
            Me._doStatement = doStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(loopStatement)
            Me._loopStatement = loopStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, doStatement As DoStatementSyntax, statements As GreenNode, loopStatement As LoopStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(doStatement)
            Me._doStatement = doStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(loopStatement)
            Me._loopStatement = loopStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), doStatement As DoStatementSyntax, statements As GreenNode, loopStatement As LoopStatementSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(doStatement)
            Me._doStatement = doStatement
            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(loopStatement)
            Me._loopStatement = loopStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DoLoopBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The Do statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property DoStatement As InternalSyntax.DoStatementSyntax
            Get
                Return Me._doStatement
            End Get
        End Property

        ''' <summary>
        ''' The statements contained in the block statement. This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The Loop statement that ends the block.
        ''' </summary>
        Friend ReadOnly Property LoopStatement As InternalSyntax.LoopStatementSyntax
            Get
                Return Me._loopStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._doStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._loopStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DoLoopBlockSyntax(Me.Kind, newErrors, GetAnnotations, _doStatement, _statements, _loopStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DoLoopBlockSyntax(Me.Kind, GetDiagnostics, annotations, _doStatement, _statements, _loopStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDoLoopBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Do statement that begins a Do-Loop block.
    ''' </summary>
    Friend NotInheritable Class DoStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _doKeyword as KeywordSyntax
        Friend ReadOnly _whileOrUntilClause as WhileOrUntilClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(doKeyword)
            Me._doKeyword = doKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(doKeyword)
            Me._doKeyword = doKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), doKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(doKeyword)
            Me._doKeyword = doKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DoStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Do" keyword.
        ''' </summary>
        Friend ReadOnly Property DoKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._doKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "While expression" or "Until expression" clause of the Do statement, if
        ''' present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property WhileOrUntilClause As InternalSyntax.WhileOrUntilClauseSyntax
            Get
                Return Me._whileOrUntilClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._doKeyword
                Case 1
                    Return Me._whileOrUntilClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DoStatementSyntax(Me.Kind, newErrors, GetAnnotations, _doKeyword, _whileOrUntilClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DoStatementSyntax(Me.Kind, GetDiagnostics, annotations, _doKeyword, _whileOrUntilClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDoStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Loop statement that begins a Do-Loop block.
    ''' </summary>
    Friend NotInheritable Class LoopStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _loopKeyword as KeywordSyntax
        Friend ReadOnly _whileOrUntilClause as WhileOrUntilClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(loopKeyword)
            Me._loopKeyword = loopKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(loopKeyword)
            Me._loopKeyword = loopKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), loopKeyword As InternalSyntax.KeywordSyntax, whileOrUntilClause As WhileOrUntilClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(loopKeyword)
            Me._loopKeyword = loopKeyword
            If whileOrUntilClause IsNot Nothing Then
                AdjustFlagsAndWidth(whileOrUntilClause)
                Me._whileOrUntilClause = whileOrUntilClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LoopStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Loop" keyword.
        ''' </summary>
        Friend ReadOnly Property LoopKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._loopKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "While expression" or "Until expression" clause of the Loop statement, if
        ''' present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property WhileOrUntilClause As InternalSyntax.WhileOrUntilClauseSyntax
            Get
                Return Me._whileOrUntilClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._loopKeyword
                Case 1
                    Return Me._whileOrUntilClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LoopStatementSyntax(Me.Kind, newErrors, GetAnnotations, _loopKeyword, _whileOrUntilClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LoopStatementSyntax(Me.Kind, GetDiagnostics, annotations, _loopKeyword, _whileOrUntilClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLoopStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "While expression" or "Until expression" in a Do or Loop
    ''' statement. The Kind of the clause can be "WhileClause" or "UntilClause" to
    ''' indicate which kind of clause.
    ''' </summary>
    Friend NotInheritable Class WhileOrUntilClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _whileOrUntilKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whileOrUntilKeyword)
            Me._whileOrUntilKeyword = whileOrUntilKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whileOrUntilKeyword)
            Me._whileOrUntilKeyword = whileOrUntilKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileOrUntilKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whileOrUntilKeyword)
            Me._whileOrUntilKeyword = whileOrUntilKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhileOrUntilClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "While" or "Until" keyword.
        ''' </summary>
        Friend ReadOnly Property WhileOrUntilKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whileOrUntilKeyword
            End Get
        End Property

        ''' <summary>
        ''' The boolean expression after the While or Until.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whileOrUntilKeyword
                Case 1
                    Return Me._condition
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhileOrUntilClauseSyntax(Me.Kind, newErrors, GetAnnotations, _whileOrUntilKeyword, _condition)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhileOrUntilClauseSyntax(Me.Kind, GetDiagnostics, annotations, _whileOrUntilKeyword, _condition)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhileOrUntilClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' The While statement that begins a While...End While block. This statement
    ''' always occurs as the Begin of a WhileBlock.
    ''' </summary>
    Friend NotInheritable Class WhileStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _whileKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhileStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "While" keyword.
        ''' </summary>
        Friend ReadOnly Property WhileKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whileKeyword
            End Get
        End Property

        ''' <summary>
        ''' The boolean expression that controls the While loop.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whileKeyword
                Case 1
                    Return Me._condition
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhileStatementSyntax(Me.Kind, newErrors, GetAnnotations, _whileKeyword, _condition)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhileStatementSyntax(Me.Kind, GetDiagnostics, annotations, _whileKeyword, _condition)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhileStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a For or For Each block.
    ''' </summary>
    Friend MustInherit Class ForOrForEachBlockSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _nextStatement as NextStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If nextStatement IsNot Nothing Then
                AdjustFlagsAndWidth(nextStatement)
                Me._nextStatement = nextStatement
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, statements As GreenNode, nextStatement As NextStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If nextStatement IsNot Nothing Then
                AdjustFlagsAndWidth(nextStatement)
                Me._nextStatement = nextStatement
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, errors, annotations)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            If nextStatement IsNot Nothing Then
                AdjustFlagsAndWidth(nextStatement)
                Me._nextStatement = nextStatement
            End If

        End Sub

        ''' <summary>
        ''' The statements contained in the For or For Each loop. This might be an empty
        ''' list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' The Next statement that ends the block. If two For or For Each statements are
        ''' ended by a single Next statement, the inner For will not have a Next statement.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property NextStatement As InternalSyntax.NextStatementSyntax
            Get
                Return Me._nextStatement
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a For block, including the introducing statement, the body and the
    ''' "Next" (which can be omitted if a containing For has a Next with multiple
    ''' variables).
    ''' </summary>
    Friend NotInheritable Class ForBlockSyntax
        Inherits ForOrForEachBlockSyntax

        Friend ReadOnly _forStatement as ForStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forStatement As ForStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, statements, nextStatement)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(forStatement)
            Me._forStatement = forStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forStatement As ForStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements, nextStatement)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(forStatement)
            Me._forStatement = forStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forStatement As ForStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, errors, annotations, statements, nextStatement)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(forStatement)
            Me._forStatement = forStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The For statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property ForStatement As InternalSyntax.ForStatementSyntax
            Get
                Return Me._forStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._nextStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForBlockSyntax(Me.Kind, newErrors, GetAnnotations, _forStatement, _statements, _nextStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForBlockSyntax(Me.Kind, GetDiagnostics, annotations, _forStatement, _statements, _nextStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a For Each block, including the introducing statement, the body and
    ''' the "Next" (which can be omitted if a containing For has a Next with multiple
    ''' variables).
    ''' </summary>
    Friend NotInheritable Class ForEachBlockSyntax
        Inherits ForOrForEachBlockSyntax

        Friend ReadOnly _forEachStatement as ForEachStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forEachStatement As ForEachStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, statements, nextStatement)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(forEachStatement)
            Me._forEachStatement = forEachStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forEachStatement As ForEachStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, statements, nextStatement)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(forEachStatement)
            Me._forEachStatement = forEachStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forEachStatement As ForEachStatementSyntax, statements As GreenNode, nextStatement As NextStatementSyntax)
            MyBase.New(kind, errors, annotations, statements, nextStatement)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(forEachStatement)
            Me._forEachStatement = forEachStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForEachBlockSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The For Each statement that begins the block.
        ''' </summary>
        Friend ReadOnly Property ForEachStatement As InternalSyntax.ForEachStatementSyntax
            Get
                Return Me._forEachStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forEachStatement
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._nextStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForEachBlockSyntax(Me.Kind, newErrors, GetAnnotations, _forEachStatement, _statements, _nextStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForEachBlockSyntax(Me.Kind, GetDiagnostics, annotations, _forEachStatement, _statements, _nextStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForEachBlock(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a For or For Each statement.
    ''' </summary>
    Friend MustInherit Class ForOrForEachStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _forKeyword as KeywordSyntax
        Friend ReadOnly _controlVariable as VisualBasicSyntaxNode

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode)
            MyBase.New(kind)

            AdjustFlagsAndWidth(forKeyword)
            Me._forKeyword = forKeyword
            AdjustFlagsAndWidth(controlVariable)
            Me._controlVariable = controlVariable

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(forKeyword)
            Me._forKeyword = forKeyword
            AdjustFlagsAndWidth(controlVariable)
            Me._controlVariable = controlVariable

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(forKeyword)
            Me._forKeyword = forKeyword
            AdjustFlagsAndWidth(controlVariable)
            Me._controlVariable = controlVariable

        End Sub

        ''' <summary>
        ''' The "For" keyword.
        ''' </summary>
        Friend ReadOnly Property ForKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._forKeyword
            End Get
        End Property

        ''' <summary>
        ''' If the For or For Each statement is of a form that does not declare a new loop
        ''' control variable, this is the expression that denotes the loop control
        ''' variable. If this loop is of a form that does declare a new control variable,
        ''' this is a VariableDeclarator that has the variable being declared.
        ''' </summary>
        Friend ReadOnly Property ControlVariable As InternalSyntax.VisualBasicSyntaxNode
            Get
                Return Me._controlVariable
            End Get
        End Property

    End Class

    ''' <summary>
    ''' The For statement that begins a For-Next block. This statement always occurs as
    ''' the Begin of a ForBlock. Most of the time, the End of that ForBlock is the
    ''' corresponding Next statement. However, multiple nested For statements are ended
    ''' by a single Next statement with multiple variables, then the inner For
    ''' statements will have End set to Nothing, and the Next statement is the End of
    ''' the outermost For statement that is being ended.
    ''' </summary>
    Friend NotInheritable Class ForStatementSyntax
        Inherits ForOrForEachStatementSyntax

        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _fromValue as ExpressionSyntax
        Friend ReadOnly _toKeyword as KeywordSyntax
        Friend ReadOnly _toValue as ExpressionSyntax
        Friend ReadOnly _stepClause as ForStepClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax)
            MyBase.New(kind, forKeyword, controlVariable)
            Me.SlotCount = 7

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(fromValue)
            Me._fromValue = fromValue
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(toValue)
            Me._toValue = toValue
            If stepClause IsNot Nothing Then
                AdjustFlagsAndWidth(stepClause)
                Me._stepClause = stepClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, forKeyword, controlVariable)
            Me.SlotCount = 7
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(fromValue)
            Me._fromValue = fromValue
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(toValue)
            Me._toValue = toValue
            If stepClause IsNot Nothing Then
                AdjustFlagsAndWidth(stepClause)
                Me._stepClause = stepClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, equalsToken As InternalSyntax.PunctuationSyntax, fromValue As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, toValue As ExpressionSyntax, stepClause As ForStepClauseSyntax)
            MyBase.New(kind, errors, annotations, forKeyword, controlVariable)
            Me.SlotCount = 7

            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(fromValue)
            Me._fromValue = fromValue
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(toValue)
            Me._toValue = toValue
            If stepClause IsNot Nothing Then
                AdjustFlagsAndWidth(stepClause)
                Me._stepClause = stepClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the initial value of the iteration.
        ''' </summary>
        Friend ReadOnly Property FromValue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._fromValue
            End Get
        End Property

        ''' <summary>
        ''' The "To" keyword.
        ''' </summary>
        Friend ReadOnly Property ToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._toKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the final value of the iteration.
        ''' </summary>
        Friend ReadOnly Property ToValue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._toValue
            End Get
        End Property

        ''' <summary>
        ''' The optional Step clause.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property StepClause As InternalSyntax.ForStepClauseSyntax
            Get
                Return Me._stepClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forKeyword
                Case 1
                    Return Me._controlVariable
                Case 2
                    Return Me._equalsToken
                Case 3
                    Return Me._fromValue
                Case 4
                    Return Me._toKeyword
                Case 5
                    Return Me._toValue
                Case 6
                    Return Me._stepClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForStatementSyntax(Me.Kind, newErrors, GetAnnotations, _forKeyword, _controlVariable, _equalsToken, _fromValue, _toKeyword, _toValue, _stepClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForStatementSyntax(Me.Kind, GetDiagnostics, annotations, _forKeyword, _controlVariable, _equalsToken, _fromValue, _toKeyword, _toValue, _stepClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Step clause in a For Statement.
    ''' </summary>
    Friend NotInheritable Class ForStepClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _stepKeyword as KeywordSyntax
        Friend ReadOnly _stepValue as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(stepKeyword)
            Me._stepKeyword = stepKeyword
            AdjustFlagsAndWidth(stepValue)
            Me._stepValue = stepValue

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(stepKeyword)
            Me._stepKeyword = stepKeyword
            AdjustFlagsAndWidth(stepValue)
            Me._stepValue = stepValue

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), stepKeyword As InternalSyntax.KeywordSyntax, stepValue As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(stepKeyword)
            Me._stepKeyword = stepKeyword
            AdjustFlagsAndWidth(stepValue)
            Me._stepValue = stepValue

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForStepClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Step" keyword.
        ''' </summary>
        Friend ReadOnly Property StepKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._stepKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the step increment.
        ''' </summary>
        Friend ReadOnly Property StepValue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._stepValue
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._stepKeyword
                Case 1
                    Return Me._stepValue
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForStepClauseSyntax(Me.Kind, newErrors, GetAnnotations, _stepKeyword, _stepValue)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForStepClauseSyntax(Me.Kind, GetDiagnostics, annotations, _stepKeyword, _stepValue)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForStepClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' The For Each statement that begins a For Each-Next block. This statement always
    ''' occurs as the Begin of a ForBlock, and the body of the For Each-Next is the
    ''' Body of that ForBlock. Most of the time, the End of that ForBlock is the
    ''' corresponding Next statement. However, multiple nested For statements are ended
    ''' by a single Next statement with multiple variables, then the inner For
    ''' statements will have End set to Nothing, and the Next statement is the End of
    ''' the outermost For statement that is being ended.
    ''' </summary>
    Friend NotInheritable Class ForEachStatementSyntax
        Inherits ForOrForEachStatementSyntax

        Friend ReadOnly _eachKeyword as KeywordSyntax
        Friend ReadOnly _inKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, forKeyword, controlVariable)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(eachKeyword)
            Me._eachKeyword = eachKeyword
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, forKeyword, controlVariable)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eachKeyword)
            Me._eachKeyword = eachKeyword
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), forKeyword As InternalSyntax.KeywordSyntax, eachKeyword As InternalSyntax.KeywordSyntax, controlVariable As VisualBasicSyntaxNode, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations, forKeyword, controlVariable)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(eachKeyword)
            Me._eachKeyword = eachKeyword
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ForEachStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Each" keyword.
        ''' </summary>
        Friend ReadOnly Property EachKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._eachKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "In" keyword.
        ''' </summary>
        Friend ReadOnly Property InKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._inKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the collection to iterate over.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._forKeyword
                Case 1
                    Return Me._eachKeyword
                Case 2
                    Return Me._controlVariable
                Case 3
                    Return Me._inKeyword
                Case 4
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ForEachStatementSyntax(Me.Kind, newErrors, GetAnnotations, _forKeyword, _eachKeyword, _controlVariable, _inKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ForEachStatementSyntax(Me.Kind, GetDiagnostics, annotations, _forKeyword, _eachKeyword, _controlVariable, _inKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitForEachStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Next statement that ends a For-Next or For Each-Next block. This statement
    ''' always occurs as the End of a ForBlock (with Kind=ForBlock or ForEachBlock),
    ''' and the body of the For-Next is the Body of that ForBlock. The Begin of that
    ''' ForBlock has the corresponding For or For Each statement.
    ''' </summary>
    Friend NotInheritable Class NextStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _nextKeyword as KeywordSyntax
        Friend ReadOnly _controlVariables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword
            If controlVariables IsNot Nothing Then
                AdjustFlagsAndWidth(controlVariables)
                Me._controlVariables = controlVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword
            If controlVariables IsNot Nothing Then
                AdjustFlagsAndWidth(controlVariables)
                Me._controlVariables = controlVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nextKeyword As InternalSyntax.KeywordSyntax, controlVariables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(nextKeyword)
            Me._nextKeyword = nextKeyword
            If controlVariables IsNot Nothing Then
                AdjustFlagsAndWidth(controlVariables)
                Me._controlVariables = controlVariables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NextStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Next" keyword.
        ''' </summary>
        Friend ReadOnly Property NextKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._nextKeyword
            End Get
        End Property

        ''' <summary>
        ''' The variables in the Next statement, if present
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property ControlVariables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionSyntax)(Me._controlVariables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._nextKeyword
                Case 1
                    Return Me._controlVariables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NextStatementSyntax(Me.Kind, newErrors, GetAnnotations, _nextKeyword, _controlVariables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NextStatementSyntax(Me.Kind, GetDiagnostics, annotations, _nextKeyword, _controlVariables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNextStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' The Using statement that begins a Using block. This statement always occurs as
    ''' the Begin of a UsingBlock, and the body of the Using is the Body of that
    ''' UsingBlock.
    ''' </summary>
    Friend NotInheritable Class UsingStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _usingKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _variables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(usingKeyword)
            Me._usingKeyword = usingKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(usingKeyword)
            Me._usingKeyword = usingKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), usingKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, variables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(usingKeyword)
            Me._usingKeyword = usingKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.UsingStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Using" keyword.
        ''' </summary>
        Friend ReadOnly Property UsingKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._usingKeyword
            End Get
        End Property

        ''' <summary>
        ''' If the Using statement is of a form that does not declare a new variable, this
        ''' is the expression used in the using. Otherwise, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' If the Using statement is of a form that declares one or more new variables,
        ''' this is the list of variable declarations. Otherwise, Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Variables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of VariableDeclaratorSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of VariableDeclaratorSyntax)(Me._variables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._usingKeyword
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._variables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new UsingStatementSyntax(Me.Kind, newErrors, GetAnnotations, _usingKeyword, _expression, _variables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new UsingStatementSyntax(Me.Kind, GetDiagnostics, annotations, _usingKeyword, _expression, _variables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitUsingStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Throw statement.
    ''' </summary>
    Friend NotInheritable Class ThrowStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _throwKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(throwKeyword)
            Me._throwKeyword = throwKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(throwKeyword)
            Me._throwKeyword = throwKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), throwKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(throwKeyword)
            Me._throwKeyword = throwKeyword
            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ThrowStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Throw" keyword
        ''' </summary>
        Friend ReadOnly Property ThrowKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._throwKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the value being thrown.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._throwKeyword
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ThrowStatementSyntax(Me.Kind, newErrors, GetAnnotations, _throwKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ThrowStatementSyntax(Me.Kind, GetDiagnostics, annotations, _throwKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitThrowStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a simple, compound, or Mid assignment statement. Which one can be
    ''' determined by checking the Kind.
    ''' </summary>
    Friend NotInheritable Class AssignmentStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _left as ExpressionSyntax
        Friend ReadOnly _operatorToken as PunctuationSyntax
        Friend ReadOnly _right as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, right As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AssignmentStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The target (left hand side) of the assignment.
        ''' </summary>
        Friend ReadOnly Property Left As InternalSyntax.ExpressionSyntax
            Get
                Return Me._left
            End Get
        End Property

        ''' <summary>
        ''' The operator used in the assignment statement. One of "=", "+=", "-=", "*=",
        ''' "/=", "\=", "^=", "&amp;=", "&lt;&lt;=" or "&gt;&gt;=".
        ''' </summary>
        Friend ReadOnly Property OperatorToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The source (right hand side) of the assignment.
        ''' </summary>
        Friend ReadOnly Property Right As InternalSyntax.ExpressionSyntax
            Get
                Return Me._right
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._left
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._right
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AssignmentStatementSyntax(Me.Kind, newErrors, GetAnnotations, _left, _operatorToken, _right)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AssignmentStatementSyntax(Me.Kind, GetDiagnostics, annotations, _left, _operatorToken, _right)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAssignmentStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a left-hand side of a MidAssignment statement.
    ''' </summary>
    Friend NotInheritable Class MidExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _mid as IdentifierTokenSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(mid)
            Me._mid = mid
            AdjustFlagsAndWidth(argumentList)
            Me._argumentList = argumentList

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(mid)
            Me._mid = mid
            AdjustFlagsAndWidth(argumentList)
            Me._argumentList = argumentList

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), mid As InternalSyntax.IdentifierTokenSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(mid)
            Me._mid = mid
            AdjustFlagsAndWidth(argumentList)
            Me._argumentList = argumentList

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MidExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Mid" possibly followed by a type character.
        ''' </summary>
        Friend ReadOnly Property Mid As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._mid
            End Get
        End Property

        ''' <summary>
        ''' The argument list.
        ''' </summary>
        Friend ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._mid
                Case 1
                    Return Me._argumentList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MidExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _mid, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MidExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _mid, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMidExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a call statement (also known as a invocation statement).
    ''' </summary>
    Friend NotInheritable Class CallStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _callKeyword as KeywordSyntax
        Friend ReadOnly _invocation as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(callKeyword)
            Me._callKeyword = callKeyword
            AdjustFlagsAndWidth(invocation)
            Me._invocation = invocation

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(callKeyword)
            Me._callKeyword = callKeyword
            AdjustFlagsAndWidth(invocation)
            Me._invocation = invocation

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), callKeyword As InternalSyntax.KeywordSyntax, invocation As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(callKeyword)
            Me._callKeyword = callKeyword
            AdjustFlagsAndWidth(invocation)
            Me._invocation = invocation

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CallStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Call" keyword.
        ''' </summary>
        Friend ReadOnly Property CallKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._callKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression denoting the call. This could be an Invocation or a MemberAccess
        ''' (in the case where no parentheses were supplied.)
        ''' </summary>
        Friend ReadOnly Property Invocation As InternalSyntax.ExpressionSyntax
            Get
                Return Me._invocation
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._callKeyword
                Case 1
                    Return Me._invocation
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CallStatementSyntax(Me.Kind, newErrors, GetAnnotations, _callKeyword, _invocation)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CallStatementSyntax(Me.Kind, GetDiagnostics, annotations, _callKeyword, _invocation)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCallStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an AddHandler or RemoveHandler statement. The Kind property
    ''' determines which one.
    ''' </summary>
    Friend NotInheritable Class AddRemoveHandlerStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _addHandlerOrRemoveHandlerKeyword as KeywordSyntax
        Friend ReadOnly _eventExpression as ExpressionSyntax
        Friend ReadOnly _commaToken as PunctuationSyntax
        Friend ReadOnly _delegateExpression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(addHandlerOrRemoveHandlerKeyword)
            Me._addHandlerOrRemoveHandlerKeyword = addHandlerOrRemoveHandlerKeyword
            AdjustFlagsAndWidth(eventExpression)
            Me._eventExpression = eventExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(delegateExpression)
            Me._delegateExpression = delegateExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(addHandlerOrRemoveHandlerKeyword)
            Me._addHandlerOrRemoveHandlerKeyword = addHandlerOrRemoveHandlerKeyword
            AdjustFlagsAndWidth(eventExpression)
            Me._eventExpression = eventExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(delegateExpression)
            Me._delegateExpression = delegateExpression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), addHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax, eventExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, delegateExpression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(addHandlerOrRemoveHandlerKeyword)
            Me._addHandlerOrRemoveHandlerKeyword = addHandlerOrRemoveHandlerKeyword
            AdjustFlagsAndWidth(eventExpression)
            Me._eventExpression = eventExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(delegateExpression)
            Me._delegateExpression = delegateExpression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AddRemoveHandlerStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "AddHandler" or "RemoveHandler" keyword.
        ''' </summary>
        Friend ReadOnly Property AddHandlerOrRemoveHandlerKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._addHandlerOrRemoveHandlerKeyword
            End Get
        End Property

        ''' <summary>
        ''' The event being accessed.
        ''' </summary>
        Friend ReadOnly Property EventExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._eventExpression
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend ReadOnly Property CommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._commaToken
            End Get
        End Property

        ''' <summary>
        ''' The delegate being added or removed.
        ''' </summary>
        Friend ReadOnly Property DelegateExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._delegateExpression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._addHandlerOrRemoveHandlerKeyword
                Case 1
                    Return Me._eventExpression
                Case 2
                    Return Me._commaToken
                Case 3
                    Return Me._delegateExpression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AddRemoveHandlerStatementSyntax(Me.Kind, newErrors, GetAnnotations, _addHandlerOrRemoveHandlerKeyword, _eventExpression, _commaToken, _delegateExpression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AddRemoveHandlerStatementSyntax(Me.Kind, GetDiagnostics, annotations, _addHandlerOrRemoveHandlerKeyword, _eventExpression, _commaToken, _delegateExpression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAddRemoveHandlerStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represent a RaiseEvent statement.
    ''' </summary>
    Friend NotInheritable Class RaiseEventStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _raiseEventKeyword as KeywordSyntax
        Friend ReadOnly _name as IdentifierNameSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(raiseEventKeyword)
            Me._raiseEventKeyword = raiseEventKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(raiseEventKeyword)
            Me._raiseEventKeyword = raiseEventKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), raiseEventKeyword As InternalSyntax.KeywordSyntax, name As IdentifierNameSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(raiseEventKeyword)
            Me._raiseEventKeyword = raiseEventKeyword
            AdjustFlagsAndWidth(name)
            Me._name = name
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RaiseEventStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "RaiseEvent" keyword
        ''' </summary>
        Friend ReadOnly Property RaiseEventKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._raiseEventKeyword
            End Get
        End Property

        ''' <summary>
        ''' The name of the event being raised.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The argument list, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._raiseEventKeyword
                Case 1
                    Return Me._name
                Case 2
                    Return Me._argumentList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RaiseEventStatementSyntax(Me.Kind, newErrors, GetAnnotations, _raiseEventKeyword, _name, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RaiseEventStatementSyntax(Me.Kind, GetDiagnostics, annotations, _raiseEventKeyword, _name, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRaiseEventStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "With" statement. This statement always occurs as the
    ''' BeginStatement of a WithBlock, and the body of the With is the Body of that
    ''' WithBlock.
    ''' </summary>
    Friend NotInheritable Class WithStatementSyntax
        Inherits StatementSyntax

        Friend ReadOnly _withKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), withKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(withKeyword)
            Me._withKeyword = withKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WithStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "With" keyword.
        ''' </summary>
        Friend ReadOnly Property WithKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._withKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression that is the operand of the With statement.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._withKeyword
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WithStatementSyntax(Me.Kind, newErrors, GetAnnotations, _withKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WithStatementSyntax(Me.Kind, GetDiagnostics, annotations, _withKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWithStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a ReDim statement.
    ''' </summary>
    Friend NotInheritable Class ReDimStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _reDimKeyword as KeywordSyntax
        Friend ReadOnly _preserveKeyword as KeywordSyntax
        Friend ReadOnly _clauses as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(reDimKeyword)
            Me._reDimKeyword = reDimKeyword
            If preserveKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(preserveKeyword)
                Me._preserveKeyword = preserveKeyword
            End If
            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(reDimKeyword)
            Me._reDimKeyword = reDimKeyword
            If preserveKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(preserveKeyword)
                Me._preserveKeyword = preserveKeyword
            End If
            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), reDimKeyword As InternalSyntax.KeywordSyntax, preserveKeyword As InternalSyntax.KeywordSyntax, clauses As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(reDimKeyword)
            Me._reDimKeyword = reDimKeyword
            If preserveKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(preserveKeyword)
                Me._preserveKeyword = preserveKeyword
            End If
            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ReDimStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "ReDim" keyword.
        ''' </summary>
        Friend ReadOnly Property ReDimKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._reDimKeyword
            End Get
        End Property

        ''' <summary>
        ''' Returns Nothing if Kind=ReDim, returns the "Preserve" keyword if
        ''' Kind=RedimPreserve.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property PreserveKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._preserveKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of ReDim clauses.
        ''' </summary>
        Friend ReadOnly Property Clauses As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of RedimClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of RedimClauseSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of RedimClauseSyntax)(Me._clauses))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._reDimKeyword
                Case 1
                    Return Me._preserveKeyword
                Case 2
                    Return Me._clauses
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ReDimStatementSyntax(Me.Kind, newErrors, GetAnnotations, _reDimKeyword, _preserveKeyword, _clauses)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ReDimStatementSyntax(Me.Kind, GetDiagnostics, annotations, _reDimKeyword, _preserveKeyword, _clauses)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitReDimStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a ReDim statement clause.
    ''' </summary>
    Friend NotInheritable Class RedimClauseSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _arrayBounds as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(arrayBounds)
            Me._arrayBounds = arrayBounds

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(arrayBounds)
            Me._arrayBounds = arrayBounds

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, arrayBounds As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(arrayBounds)
            Me._arrayBounds = arrayBounds

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RedimClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The target of the ReDim statement.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The ArraySizeInitializationModifier.
        ''' </summary>
        Friend ReadOnly Property ArrayBounds As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._arrayBounds
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._arrayBounds
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RedimClauseSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _arrayBounds)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RedimClauseSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _arrayBounds)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRedimClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an "Erase" statement.
    ''' </summary>
    Friend NotInheritable Class EraseStatementSyntax
        Inherits ExecutableStatementSyntax

        Friend ReadOnly _eraseKeyword as KeywordSyntax
        Friend ReadOnly _expressions as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, eraseKeyword As InternalSyntax.KeywordSyntax, expressions As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(eraseKeyword)
            Me._eraseKeyword = eraseKeyword
            If expressions IsNot Nothing Then
                AdjustFlagsAndWidth(expressions)
                Me._expressions = expressions
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, eraseKeyword As InternalSyntax.KeywordSyntax, expressions As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(eraseKeyword)
            Me._eraseKeyword = eraseKeyword
            If expressions IsNot Nothing Then
                AdjustFlagsAndWidth(expressions)
                Me._expressions = expressions
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), eraseKeyword As InternalSyntax.KeywordSyntax, expressions As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(eraseKeyword)
            Me._eraseKeyword = eraseKeyword
            If expressions IsNot Nothing Then
                AdjustFlagsAndWidth(expressions)
                Me._expressions = expressions
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.EraseStatementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Erase" keyword.
        ''' </summary>
        Friend ReadOnly Property EraseKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._eraseKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of expressions denoting the arrays to erase.
        ''' </summary>
        Friend ReadOnly Property Expressions As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionSyntax)(Me._expressions))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._eraseKeyword
                Case 1
                    Return Me._expressions
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new EraseStatementSyntax(Me.Kind, newErrors, GetAnnotations, _eraseKeyword, _expressions)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new EraseStatementSyntax(Me.Kind, GetDiagnostics, annotations, _eraseKeyword, _expressions)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitEraseStatement(Me)
        End Function

    End Class

    ''' <summary>
    ''' An abstract base class for all node classes that define expressions.
    ''' </summary>
    Friend MustInherit Class ExpressionSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a literal. The kind of literal is determined by the Kind property:
    ''' IntegerLiteral, CharacterLiteral, BooleanLiteral, DecimalLiteral,
    ''' FloatingLiteral, DateLiteral or StringLiteral. The value of the literal can be
    ''' determined by casting the associated Token to the correct type and getting the
    ''' value from the token.
    ''' </summary>
    Friend NotInheritable Class LiteralExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _token as SyntaxToken

        Friend Sub New(ByVal kind As SyntaxKind, token As InternalSyntax.SyntaxToken)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(token)
            Me._token = token

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, token As InternalSyntax.SyntaxToken, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(token)
            Me._token = token

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), token As InternalSyntax.SyntaxToken)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(token)
            Me._token = token

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LiteralExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The token that represents the literal. The Kind property determines what type
        ''' this property returns: Kind=IntegerLiteral ==&gt; Returns IntegerLiteralToken.
        ''' Kind=CharacterLiteral ==&gt; Returns CharacterLiteralToken. Kind=DecimalLiteral
        ''' ==&gt; Returns DecimalLiteralToken Kind=FloatingLiteral ==&gt; Returns
        ''' FloatingLiteralToken Kind=DateLiteral ==&gt; Returns DateLiteralToken
        ''' Kind=StringLiteral ==&gt; Returns StringLiteralToken Kind=BooleanLiteral ==&gt;
        ''' Returns Keyword (with it's kind being TrueKeyword or FalseKeyword)
        ''' Kind=NothingLiteral ==&gt; Returns Keyword (with it's kind being
        ''' NothingKeyword)
        ''' </summary>
        Friend ReadOnly Property Token As InternalSyntax.SyntaxToken
            Get
                Return Me._token
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._token
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LiteralExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _token)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LiteralExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _token)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLiteralExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a parenthesized expression.
    ''' </summary>
    Friend NotInheritable Class ParenthesizedExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ParenthesizedExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The expression inside the parentheses.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ParenthesizedExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _expression, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ParenthesizedExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _expression, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitParenthesizedExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a tuple literal expression.
    ''' </summary>
    Friend NotInheritable Class TupleExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _arguments as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TupleExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of tuple arguments.
        ''' </summary>
        Friend ReadOnly Property Arguments As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of SimpleArgumentSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of SimpleArgumentSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of SimpleArgumentSyntax)(Me._arguments))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._arguments
                Case 2
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TupleExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TupleExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTupleExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a tuple type expression.
    ''' </summary>
    Friend NotInheritable Class TupleTypeSyntax
        Inherits TypeSyntax

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _elements as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, elements As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If elements IsNot Nothing Then
                AdjustFlagsAndWidth(elements)
                Me._elements = elements
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, elements As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If elements IsNot Nothing Then
                AdjustFlagsAndWidth(elements)
                Me._elements = elements
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, elements As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If elements IsNot Nothing Then
                AdjustFlagsAndWidth(elements)
                Me._elements = elements
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TupleTypeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of tuple elements.
        ''' </summary>
        Friend ReadOnly Property Elements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TupleElementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of TupleElementSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of TupleElementSyntax)(Me._elements))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._elements
                Case 2
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TupleTypeSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _elements, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TupleTypeSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _elements, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTupleType(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element.
    ''' </summary>
    Friend MustInherit Class TupleElementSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element supplying only the type.
    ''' </summary>
    Friend NotInheritable Class TypedTupleElementSyntax
        Inherits TupleElementSyntax

        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), type As TypeSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypedTupleElementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type-name part of the tuple element syntax.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._type
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypedTupleElementSyntax(Me.Kind, newErrors, GetAnnotations, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypedTupleElementSyntax(Me.Kind, GetDiagnostics, annotations, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypedTupleElement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a single declaration of a tuple element supplying element name and
    ''' optionally a type.
    ''' </summary>
    Friend NotInheritable Class NamedTupleElementSyntax
        Inherits TupleElementSyntax

        Friend ReadOnly _identifier as IdentifierTokenSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NamedTupleElementSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the element.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' A simple "As" clause specifying the type of the tuple element.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._asClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NamedTupleElementSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NamedTupleElementSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNamedTupleElement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Identifies one of the special instances "Me", "MyClass" or "MyBase". The Kind
    ''' property identifies which.
    ''' </summary>
    Friend MustInherit Class InstanceExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _keyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        ''' <summary>
        ''' The "Me", "MyClass" or "MyBase" keyword.
        ''' </summary>
        Friend ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Identifies the special instance "Me"
    ''' </summary>
    Friend NotInheritable Class MeExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, keyword)
            Me.SlotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations, keyword)
            Me.SlotCount = 1
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MeExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MeExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MeExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMeExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Identifies the special instance "MyBase"
    ''' </summary>
    Friend NotInheritable Class MyBaseExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, keyword)
            Me.SlotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations, keyword)
            Me.SlotCount = 1
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MyBaseExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MyBaseExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MyBaseExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMyBaseExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Identifies the special instance "MyClass"
    ''' </summary>
    Friend NotInheritable Class MyClassExpressionSyntax
        Inherits InstanceExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, keyword)
            Me.SlotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations, keyword)
            Me.SlotCount = 1
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MyClassExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MyClassExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MyClassExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMyClassExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a GetType expression.
    ''' </summary>
    Friend NotInheritable Class GetTypeExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _getTypeKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(getTypeKeyword)
            Me._getTypeKeyword = getTypeKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(getTypeKeyword)
            Me._getTypeKeyword = getTypeKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), getTypeKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(getTypeKeyword)
            Me._getTypeKeyword = getTypeKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GetTypeExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "GetType" keyword.
        ''' </summary>
        Friend ReadOnly Property GetTypeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._getTypeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The type to get the Type object for. This can be an open generic type.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._getTypeKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._type
                Case 3
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GetTypeExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _getTypeKeyword, _openParenToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GetTypeExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _getTypeKeyword, _openParenToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGetTypeExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a TypeOf...Is or IsNot expression.
    ''' </summary>
    Friend NotInheritable Class TypeOfExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _typeOfKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _operatorToken as KeywordSyntax
        Friend ReadOnly _type as TypeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(typeOfKeyword)
            Me._typeOfKeyword = typeOfKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(typeOfKeyword)
            Me._typeOfKeyword = typeOfKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), typeOfKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, operatorToken As InternalSyntax.KeywordSyntax, type As TypeSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(typeOfKeyword)
            Me._typeOfKeyword = typeOfKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(type)
            Me._type = type

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TypeOfExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "TypeOf" keyword.
        ''' </summary>
        Friend ReadOnly Property TypeOfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._typeOfKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression being tested.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "Is" or "IsNot" keyword.
        ''' </summary>
        Friend ReadOnly Property OperatorToken As InternalSyntax.KeywordSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The name of the type being tested against.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._typeOfKeyword
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._operatorToken
                Case 3
                    Return Me._type
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TypeOfExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _typeOfKeyword, _expression, _operatorToken, _type)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TypeOfExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _typeOfKeyword, _expression, _operatorToken, _type)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTypeOfExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a GetXmlNamespace expression.
    ''' </summary>
    Friend NotInheritable Class GetXmlNamespaceExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _getXmlNamespaceKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _name as XmlPrefixNameSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(getXmlNamespaceKeyword)
            Me._getXmlNamespaceKeyword = getXmlNamespaceKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(getXmlNamespaceKeyword)
            Me._getXmlNamespaceKeyword = getXmlNamespaceKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), getXmlNamespaceKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, name As XmlPrefixNameSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(getXmlNamespaceKeyword)
            Me._getXmlNamespaceKeyword = getXmlNamespaceKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GetXmlNamespaceExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "GetXmlNamespace" keyword.
        ''' </summary>
        Friend ReadOnly Property GetXmlNamespaceKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._getXmlNamespaceKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The Xml namespace name being referenced.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Name As InternalSyntax.XmlPrefixNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._getXmlNamespaceKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._name
                Case 3
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GetXmlNamespaceExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _getXmlNamespaceKeyword, _openParenToken, _name, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GetXmlNamespaceExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _getXmlNamespaceKeyword, _openParenToken, _name, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGetXmlNamespaceExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents member access (.name) or dictionary access (!name). The Kind
    ''' property determines which kind of access.
    ''' </summary>
    Friend NotInheritable Class MemberAccessExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _operatorToken as PunctuationSyntax
        Friend ReadOnly _name as SimpleNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, operatorToken As InternalSyntax.PunctuationSyntax, name As SimpleNameSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MemberAccessExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression on the left-hand-side of the "." or "!" token.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "." or "!" token.
        ''' </summary>
        Friend ReadOnly Property OperatorToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The identifier after the "." or "!" token.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.SimpleNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._name
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MemberAccessExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _operatorToken, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MemberAccessExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _operatorToken, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMemberAccessExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML member element access (node.&lt;Element&gt;), attribute
    ''' access (node.@Attribute) or descendants access (node...&lt;Descendant&gt;). The
    ''' Kind property determines which kind of access.
    ''' </summary>
    Friend NotInheritable Class XmlMemberAccessExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _base as ExpressionSyntax
        Friend ReadOnly _token1 as PunctuationSyntax
        Friend ReadOnly _token2 as PunctuationSyntax
        Friend ReadOnly _token3 as PunctuationSyntax
        Friend ReadOnly _name as XmlNodeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax)
            MyBase.New(kind)
            Me.SlotCount = 5

            If base IsNot Nothing Then
                AdjustFlagsAndWidth(base)
                Me._base = base
            End If
            AdjustFlagsAndWidth(token1)
            Me._token1 = token1
            If token2 IsNot Nothing Then
                AdjustFlagsAndWidth(token2)
                Me._token2 = token2
            End If
            If token3 IsNot Nothing Then
                AdjustFlagsAndWidth(token3)
                Me._token3 = token3
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            If base IsNot Nothing Then
                AdjustFlagsAndWidth(base)
                Me._base = base
            End If
            AdjustFlagsAndWidth(token1)
            Me._token1 = token1
            If token2 IsNot Nothing Then
                AdjustFlagsAndWidth(token2)
                Me._token2 = token2
            End If
            If token3 IsNot Nothing Then
                AdjustFlagsAndWidth(token3)
                Me._token3 = token3
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), base As ExpressionSyntax, token1 As InternalSyntax.PunctuationSyntax, token2 As InternalSyntax.PunctuationSyntax, token3 As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            If base IsNot Nothing Then
                AdjustFlagsAndWidth(base)
                Me._base = base
            End If
            AdjustFlagsAndWidth(token1)
            Me._token1 = token1
            If token2 IsNot Nothing Then
                AdjustFlagsAndWidth(token2)
                Me._token2 = token2
            End If
            If token3 IsNot Nothing Then
                AdjustFlagsAndWidth(token3)
                Me._token3 = token3
            End If
            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlMemberAccessExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression on the left-hand-side of the ".", ".@" or "..." .
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Base As InternalSyntax.ExpressionSyntax
            Get
                Return Me._base
            End Get
        End Property

        ''' <summary>
        ''' The initial dot "." part of the separator.
        ''' </summary>
        Friend ReadOnly Property Token1 As InternalSyntax.PunctuationSyntax
            Get
                Return Me._token1
            End Get
        End Property

        ''' <summary>
        ''' The "@" part of .@ or the second "." of "...".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Token2 As InternalSyntax.PunctuationSyntax
            Get
                Return Me._token2
            End Get
        End Property

        ''' <summary>
        ''' The third "." in a "..." separator.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Token3 As InternalSyntax.PunctuationSyntax
            Get
                Return Me._token3
            End Get
        End Property

        ''' <summary>
        ''' The identifier after the ".", ".@" or "..."
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._base
                Case 1
                    Return Me._token1
                Case 2
                    Return Me._token2
                Case 3
                    Return Me._token3
                Case 4
                    Return Me._name
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlMemberAccessExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _base, _token1, _token2, _token3, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlMemberAccessExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _base, _token1, _token2, _token3, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlMemberAccessExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an invocation expression consisting of an invocation target and an
    ''' optional argument list or an array, parameterized property or object default
    ''' property index.
    ''' </summary>
    Friend NotInheritable Class InvocationExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, argumentList As ArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, argumentList As ArgumentListSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If expression IsNot Nothing Then
                AdjustFlagsAndWidth(expression)
                Me._expression = expression
            End If
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.InvocationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The target of the call or index expression.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The argument list.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._argumentList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new InvocationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _argumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new InvocationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _argumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitInvocationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Base class for object, array and anonymous object creation expressions
    ''' </summary>
    Partial Friend MustInherit Class NewExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _newKeyword as KeywordSyntax
        Friend ReadOnly _attributeLists as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode)
            MyBase.New(kind)

            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword
            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword
            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(newKeyword)
            Me._newKeyword = newKeyword
            If attributeLists IsNot Nothing Then
                AdjustFlagsAndWidth(attributeLists)
                Me._attributeLists = attributeLists
            End If

        End Sub

        ''' <summary>
        ''' The "New" keyword.
        ''' </summary>
        Friend ReadOnly Property NewKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._newKeyword
            End Get
        End Property

        ''' <summary>
        ''' A list of all attribute lists on the type. If no attributes were specified, an
        ''' empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AttributeLists As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of AttributeListSyntax)(Me._attributeLists)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a New expression that creates a new non-array object, possibly with
    ''' a "With" or "From" clause.
    ''' </summary>
    Friend NotInheritable Class ObjectCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _argumentList as ArgumentListSyntax
        Friend ReadOnly _initializer as ObjectCreationInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax)
            MyBase.New(kind, newKeyword, attributeLists)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(type)
            Me._type = type
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, newKeyword, attributeLists)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, argumentList As ArgumentListSyntax, initializer As ObjectCreationInitializerSyntax)
            MyBase.New(kind, errors, annotations, newKeyword, attributeLists)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(type)
            Me._type = type
            If argumentList IsNot Nothing Then
                AdjustFlagsAndWidth(argumentList)
                Me._argumentList = argumentList
            End If
            If initializer IsNot Nothing Then
                AdjustFlagsAndWidth(initializer)
                Me._initializer = initializer
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ObjectCreationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type of the object being initialized.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The argument list, if present. If no argument list was supplied, Nothing is
        ''' returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ArgumentList As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._argumentList
            End Get
        End Property

        ''' <summary>
        ''' An optional From or With clause to initialize the new object.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Initializer As InternalSyntax.ObjectCreationInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._newKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case 3
                    Return Me._argumentList
                Case 4
                    Return Me._initializer
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ObjectCreationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _newKeyword, _attributeLists, _type, _argumentList, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ObjectCreationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _newKeyword, _attributeLists, _type, _argumentList, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitObjectCreationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a New expression that create an object of anonymous type.
    ''' </summary>
    Friend NotInheritable Class AnonymousObjectCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend ReadOnly _initializer as ObjectMemberInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, initializer As ObjectMemberInitializerSyntax)
            MyBase.New(kind, newKeyword, attributeLists)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, initializer As ObjectMemberInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, newKeyword, attributeLists)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, initializer As ObjectMemberInitializerSyntax)
            MyBase.New(kind, errors, annotations, newKeyword, attributeLists)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AnonymousObjectCreationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The With clause to initialize the new object.
        ''' </summary>
        Friend ReadOnly Property Initializer As InternalSyntax.ObjectMemberInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._newKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._initializer
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AnonymousObjectCreationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _newKeyword, _attributeLists, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AnonymousObjectCreationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _newKeyword, _attributeLists, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAnonymousObjectCreationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an expression that creates a new array.
    ''' </summary>
    Friend NotInheritable Class ArrayCreationExpressionSyntax
        Inherits NewExpressionSyntax

        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _arrayBounds as ArgumentListSyntax
        Friend ReadOnly _rankSpecifiers as GreenNode
        Friend ReadOnly _initializer as CollectionInitializerSyntax

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As GreenNode, initializer As CollectionInitializerSyntax)
            MyBase.New(kind, newKeyword, attributeLists)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(type)
            Me._type = type
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As GreenNode, initializer As CollectionInitializerSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, newKeyword, attributeLists)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(type)
            Me._type = type
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), newKeyword As InternalSyntax.KeywordSyntax, attributeLists As GreenNode, type As TypeSyntax, arrayBounds As ArgumentListSyntax, rankSpecifiers As GreenNode, initializer As CollectionInitializerSyntax)
            MyBase.New(kind, errors, annotations, newKeyword, attributeLists)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(type)
            Me._type = type
            If arrayBounds IsNot Nothing Then
                AdjustFlagsAndWidth(arrayBounds)
                Me._arrayBounds = arrayBounds
            End If
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If
            AdjustFlagsAndWidth(initializer)
            Me._initializer = initializer

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArrayCreationExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The element type of the array being created.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The optional array bounds, such as "(4)" or "(0 to 5, 0 To 6)".
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property ArrayBounds As InternalSyntax.ArgumentListSyntax
            Get
                Return Me._arrayBounds
            End Get
        End Property

        ''' <summary>
        ''' A list of array modifiers such as "()" or "(,)". If no array modifiers were
        ''' present, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property RankSpecifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)(Me._rankSpecifiers)
            End Get
        End Property

        ''' <summary>
        ''' The initializer including the braces.
        ''' </summary>
        Friend ReadOnly Property Initializer As InternalSyntax.CollectionInitializerSyntax
            Get
                Return Me._initializer
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._newKeyword
                Case 1
                    Return Me._attributeLists
                Case 2
                    Return Me._type
                Case 3
                    Return Me._arrayBounds
                Case 4
                    Return Me._rankSpecifiers
                Case 5
                    Return Me._initializer
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArrayCreationExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _newKeyword, _attributeLists, _type, _arrayBounds, _rankSpecifiers, _initializer)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArrayCreationExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _newKeyword, _attributeLists, _type, _arrayBounds, _rankSpecifiers, _initializer)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArrayCreationExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an expression that creates a new array without naming the element
    ''' type.
    ''' </summary>
    Friend NotInheritable Class CollectionInitializerSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _openBraceToken as PunctuationSyntax
        Friend ReadOnly _initializers as GreenNode
        Friend ReadOnly _closeBraceToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openBraceToken As InternalSyntax.PunctuationSyntax, initializers As GreenNode, closeBraceToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openBraceToken)
            Me._openBraceToken = openBraceToken
            If initializers IsNot Nothing Then
                AdjustFlagsAndWidth(initializers)
                Me._initializers = initializers
            End If
            AdjustFlagsAndWidth(closeBraceToken)
            Me._closeBraceToken = closeBraceToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CollectionInitializerSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "{" token.
        ''' </summary>
        Friend ReadOnly Property OpenBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openBraceToken
            End Get
        End Property

        ''' <summary>
        ''' The list of initializers between the braces.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Initializers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionSyntax)(Me._initializers))
            End Get
        End Property

        ''' <summary>
        ''' The "}" token.
        ''' </summary>
        Friend ReadOnly Property CloseBraceToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeBraceToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openBraceToken
                Case 1
                    Return Me._initializers
                Case 2
                    Return Me._closeBraceToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CollectionInitializerSyntax(Me.Kind, newErrors, GetAnnotations, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CollectionInitializerSyntax(Me.Kind, GetDiagnostics, annotations, _openBraceToken, _initializers, _closeBraceToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCollectionInitializer(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a CType, DirectCast or TryCast conversion expression. The Kind
    ''' property determines which kind of cast it is.
    ''' </summary>
    Friend MustInherit Class CastExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _keyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _commaToken as PunctuationSyntax
        Friend ReadOnly _type as TypeSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(type)
            Me._type = type
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        ''' <summary>
        ''' The "CType", "DirectCast" or "TryCast" keyword.
        ''' </summary>
        Friend ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The expression being cast.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend ReadOnly Property CommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._commaToken
            End Get
        End Property

        ''' <summary>
        ''' The type the expression is being cast to.
        ''' </summary>
        Friend ReadOnly Property Type As InternalSyntax.TypeSyntax
            Get
                Return Me._type
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

    End Class

    Friend NotInheritable Class CTypeExpressionSyntax
        Inherits CastExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CTypeExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._type
                Case 5
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CTypeExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CTypeExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCTypeExpression(Me)
        End Function

    End Class

    Friend NotInheritable Class DirectCastExpressionSyntax
        Inherits CastExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DirectCastExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._type
                Case 5
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DirectCastExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DirectCastExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDirectCastExpression(Me)
        End Function

    End Class

    Friend NotInheritable Class TryCastExpressionSyntax
        Inherits CastExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, type As TypeSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations, keyword, openParenToken, expression, commaToken, type, closeParenToken)
            Me.SlotCount = 6
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TryCastExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._type
                Case 5
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TryCastExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TryCastExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _commaToken, _type, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTryCastExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a cast to a pre-defined type using a pre-defined cast expression,
    ''' such as CInt or CLng.
    ''' </summary>
    Friend NotInheritable Class PredefinedCastExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _keyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PredefinedCastExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The keyword that was used in the cast operation.
        ''' </summary>
        Friend ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The expression being cast.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._keyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._expression
                Case 3
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PredefinedCastExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _keyword, _openParenToken, _expression, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PredefinedCastExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _keyword, _openParenToken, _expression, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPredefinedCastExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a binary operator. The Kind property classifies the operators into
    ''' similar kind of operators (arithmetic, relational, logical or string); the
    ''' exact operation being performed is determined by the Operator property.
    ''' </summary>
    Friend NotInheritable Class BinaryExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _left as ExpressionSyntax
        Friend ReadOnly _operatorToken as SyntaxToken
        Friend ReadOnly _right as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.SyntaxToken, right As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, operatorToken As InternalSyntax.SyntaxToken, right As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As ExpressionSyntax, operatorToken As InternalSyntax.SyntaxToken, right As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.BinaryExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The left operand.
        ''' </summary>
        Friend ReadOnly Property Left As InternalSyntax.ExpressionSyntax
            Get
                Return Me._left
            End Get
        End Property

        Friend ReadOnly Property OperatorToken As InternalSyntax.SyntaxToken
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The right operand.
        ''' </summary>
        Friend ReadOnly Property Right As InternalSyntax.ExpressionSyntax
            Get
                Return Me._right
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._left
                Case 1
                    Return Me._operatorToken
                Case 2
                    Return Me._right
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new BinaryExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _left, _operatorToken, _right)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new BinaryExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _left, _operatorToken, _right)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitBinaryExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Describes a unary operator: Plus, Negate, Not or AddressOf.
    ''' </summary>
    Friend NotInheritable Class UnaryExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _operatorToken as SyntaxToken
        Friend ReadOnly _operand as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, operatorToken As InternalSyntax.SyntaxToken, operand As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(operand)
            Me._operand = operand

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, operatorToken As InternalSyntax.SyntaxToken, operand As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(operand)
            Me._operand = operand

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), operatorToken As InternalSyntax.SyntaxToken, operand As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(operatorToken)
            Me._operatorToken = operatorToken
            AdjustFlagsAndWidth(operand)
            Me._operand = operand

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.UnaryExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The token that is the operator.
        ''' </summary>
        Friend ReadOnly Property OperatorToken As InternalSyntax.SyntaxToken
            Get
                Return Me._operatorToken
            End Get
        End Property

        ''' <summary>
        ''' The expression being operated on.
        ''' </summary>
        Friend ReadOnly Property Operand As InternalSyntax.ExpressionSyntax
            Get
                Return Me._operand
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._operatorToken
                Case 1
                    Return Me._operand
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new UnaryExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _operatorToken, _operand)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new UnaryExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _operatorToken, _operand)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitUnaryExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a conditional expression, If(condition, true-expr, false-expr) or
    ''' If(expr, nothing-expr).
    ''' </summary>
    Friend NotInheritable Class BinaryConditionalExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _firstExpression as ExpressionSyntax
        Friend ReadOnly _commaToken as PunctuationSyntax
        Friend ReadOnly _secondExpression as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, firstExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, secondExpression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(firstExpression)
            Me._firstExpression = firstExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(secondExpression)
            Me._secondExpression = secondExpression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, firstExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, secondExpression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(firstExpression)
            Me._firstExpression = firstExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(secondExpression)
            Me._secondExpression = secondExpression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, firstExpression As ExpressionSyntax, commaToken As InternalSyntax.PunctuationSyntax, secondExpression As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(firstExpression)
            Me._firstExpression = firstExpression
            AdjustFlagsAndWidth(commaToken)
            Me._commaToken = commaToken
            AdjustFlagsAndWidth(secondExpression)
            Me._secondExpression = secondExpression
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.BinaryConditionalExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword
        ''' </summary>
        Friend ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The first expression inside the parentheses.
        ''' </summary>
        Friend ReadOnly Property FirstExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._firstExpression
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend ReadOnly Property CommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._commaToken
            End Get
        End Property

        ''' <summary>
        ''' The second expression inside the parentheses.
        ''' </summary>
        Friend ReadOnly Property SecondExpression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._secondExpression
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._firstExpression
                Case 3
                    Return Me._commaToken
                Case 4
                    Return Me._secondExpression
                Case 5
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new BinaryConditionalExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _openParenToken, _firstExpression, _commaToken, _secondExpression, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new BinaryConditionalExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _openParenToken, _firstExpression, _commaToken, _secondExpression, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitBinaryConditionalExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a conditional expression, If(condition, true-expr, false-expr) or
    ''' If(expr, nothing-expr).
    ''' </summary>
    Friend NotInheritable Class TernaryConditionalExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _ifKeyword as KeywordSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _condition as ExpressionSyntax
        Friend ReadOnly _firstCommaToken as PunctuationSyntax
        Friend ReadOnly _whenTrue as ExpressionSyntax
        Friend ReadOnly _secondCommaToken as PunctuationSyntax
        Friend ReadOnly _whenFalse as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, condition As ExpressionSyntax, firstCommaToken As InternalSyntax.PunctuationSyntax, whenTrue As ExpressionSyntax, secondCommaToken As InternalSyntax.PunctuationSyntax, whenFalse As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(firstCommaToken)
            Me._firstCommaToken = firstCommaToken
            AdjustFlagsAndWidth(whenTrue)
            Me._whenTrue = whenTrue
            AdjustFlagsAndWidth(secondCommaToken)
            Me._secondCommaToken = secondCommaToken
            AdjustFlagsAndWidth(whenFalse)
            Me._whenFalse = whenFalse
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, condition As ExpressionSyntax, firstCommaToken As InternalSyntax.PunctuationSyntax, whenTrue As ExpressionSyntax, secondCommaToken As InternalSyntax.PunctuationSyntax, whenFalse As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(firstCommaToken)
            Me._firstCommaToken = firstCommaToken
            AdjustFlagsAndWidth(whenTrue)
            Me._whenTrue = whenTrue
            AdjustFlagsAndWidth(secondCommaToken)
            Me._secondCommaToken = secondCommaToken
            AdjustFlagsAndWidth(whenFalse)
            Me._whenFalse = whenFalse
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), ifKeyword As InternalSyntax.KeywordSyntax, openParenToken As InternalSyntax.PunctuationSyntax, condition As ExpressionSyntax, firstCommaToken As InternalSyntax.PunctuationSyntax, whenTrue As ExpressionSyntax, secondCommaToken As InternalSyntax.PunctuationSyntax, whenFalse As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(ifKeyword)
            Me._ifKeyword = ifKeyword
            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(condition)
            Me._condition = condition
            AdjustFlagsAndWidth(firstCommaToken)
            Me._firstCommaToken = firstCommaToken
            AdjustFlagsAndWidth(whenTrue)
            Me._whenTrue = whenTrue
            AdjustFlagsAndWidth(secondCommaToken)
            Me._secondCommaToken = secondCommaToken
            AdjustFlagsAndWidth(whenFalse)
            Me._whenFalse = whenFalse
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.TernaryConditionalExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "If" keyword
        ''' </summary>
        Friend ReadOnly Property IfKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ifKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "(" token
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The first expression inside the parentheses.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend ReadOnly Property FirstCommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._firstCommaToken
            End Get
        End Property

        ''' <summary>
        ''' The second expression inside the parentheses.
        ''' </summary>
        Friend ReadOnly Property WhenTrue As InternalSyntax.ExpressionSyntax
            Get
                Return Me._whenTrue
            End Get
        End Property

        ''' <summary>
        ''' The "," token.
        ''' </summary>
        Friend ReadOnly Property SecondCommaToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._secondCommaToken
            End Get
        End Property

        ''' <summary>
        ''' The second expression inside the parentheses.
        ''' </summary>
        Friend ReadOnly Property WhenFalse As InternalSyntax.ExpressionSyntax
            Get
                Return Me._whenFalse
            End Get
        End Property

        ''' <summary>
        ''' The ")" token
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._ifKeyword
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._condition
                Case 3
                    Return Me._firstCommaToken
                Case 4
                    Return Me._whenTrue
                Case 5
                    Return Me._secondCommaToken
                Case 6
                    Return Me._whenFalse
                Case 7
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new TernaryConditionalExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _ifKeyword, _openParenToken, _condition, _firstCommaToken, _whenTrue, _secondCommaToken, _whenFalse, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new TernaryConditionalExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _ifKeyword, _openParenToken, _condition, _firstCommaToken, _whenTrue, _secondCommaToken, _whenFalse, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitTernaryConditionalExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a lambda expression, either single line or multi-line.
    ''' </summary>
    Friend MustInherit Class LambdaExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _subOrFunctionHeader as LambdaHeaderSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(subOrFunctionHeader)
            Me._subOrFunctionHeader = subOrFunctionHeader

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionHeader)
            Me._subOrFunctionHeader = subOrFunctionHeader

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionHeader As LambdaHeaderSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(subOrFunctionHeader)
            Me._subOrFunctionHeader = subOrFunctionHeader

        End Sub

        ''' <summary>
        ''' The header part of the lambda that includes the "Sub" or "Function" keyword,
        ''' the argument list and return type.
        ''' </summary>
        Friend ReadOnly Property SubOrFunctionHeader As InternalSyntax.LambdaHeaderSyntax
            Get
                Return Me._subOrFunctionHeader
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a single line lambda expression.
    ''' </summary>
    Friend NotInheritable Class SingleLineLambdaExpressionSyntax
        Inherits LambdaExpressionSyntax

        Friend ReadOnly _body as VisualBasicSyntaxNode

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, body As VisualBasicSyntaxNode)
            MyBase.New(kind, subOrFunctionHeader)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(body)
            Me._body = body

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, body As VisualBasicSyntaxNode, context As ISyntaxFactoryContext)
            MyBase.New(kind, subOrFunctionHeader)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(body)
            Me._body = body

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionHeader As LambdaHeaderSyntax, body As VisualBasicSyntaxNode)
            MyBase.New(kind, errors, annotations, subOrFunctionHeader)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(body)
            Me._body = body

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SingleLineLambdaExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The body of the lambda. Depending on the kind of lambda, this is either a
        ''' Statement (single-line Sub lambda) or Expression (single-line Function).
        ''' </summary>
        Friend ReadOnly Property Body As InternalSyntax.VisualBasicSyntaxNode
            Get
                Return Me._body
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subOrFunctionHeader
                Case 1
                    Return Me._body
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SingleLineLambdaExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _subOrFunctionHeader, _body)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SingleLineLambdaExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _subOrFunctionHeader, _body)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSingleLineLambdaExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a multi-line lambda expression.
    ''' </summary>
    Friend NotInheritable Class MultiLineLambdaExpressionSyntax
        Inherits LambdaExpressionSyntax

        Friend ReadOnly _statements as GreenNode
        Friend ReadOnly _endSubOrFunctionStatement as EndBlockStatementSyntax

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, subOrFunctionHeader)
            Me.SlotCount = 3

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, subOrFunctionHeader As LambdaHeaderSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, subOrFunctionHeader)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), subOrFunctionHeader As LambdaHeaderSyntax, statements As GreenNode, endSubOrFunctionStatement As EndBlockStatementSyntax)
            MyBase.New(kind, errors, annotations, subOrFunctionHeader)
            Me.SlotCount = 3

            If statements IsNot Nothing Then
                AdjustFlagsAndWidth(statements)
                Me._statements = statements
            End If
            AdjustFlagsAndWidth(endSubOrFunctionStatement)
            Me._endSubOrFunctionStatement = endSubOrFunctionStatement

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.MultiLineLambdaExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The body of the lambda. Depending on the kind of lambda, this is either a
        ''' StatementBody (multi-line lambda), Statement (single-line Sub lambda) or
        ''' Expression (single-line Function). This might be an empty list.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Statements As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of StatementSyntax)(Me._statements)
            End Get
        End Property

        ''' <summary>
        ''' Returns the "End Sub" or "End Function" statement if this is a multi-line
        ''' lambda.
        ''' </summary>
        Friend ReadOnly Property EndSubOrFunctionStatement As InternalSyntax.EndBlockStatementSyntax
            Get
                Return Me._endSubOrFunctionStatement
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._subOrFunctionHeader
                Case 1
                    Return Me._statements
                Case 2
                    Return Me._endSubOrFunctionStatement
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new MultiLineLambdaExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _subOrFunctionHeader, _statements, _endSubOrFunctionStatement)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new MultiLineLambdaExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _subOrFunctionHeader, _statements, _endSubOrFunctionStatement)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitMultiLineLambdaExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the header part of a lambda expression
    ''' </summary>
    Friend NotInheritable Class LambdaHeaderSyntax
        Inherits MethodBaseSyntax

        Friend ReadOnly _subOrFunctionKeyword as KeywordSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, attributeLists, modifiers, parameterList)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), attributeLists As GreenNode, modifiers As GreenNode, subOrFunctionKeyword As InternalSyntax.KeywordSyntax, parameterList As ParameterListSyntax, asClause As SimpleAsClauseSyntax)
            MyBase.New(kind, errors, annotations, attributeLists, modifiers, parameterList)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(subOrFunctionKeyword)
            Me._subOrFunctionKeyword = subOrFunctionKeyword
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LambdaHeaderSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Sub" or "Function" keyword that introduces this lambda expression.
        ''' </summary>
        Friend ReadOnly Property SubOrFunctionKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._subOrFunctionKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "As" clause that describes the return type. If no As clause was present,
        ''' Nothing is returned.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._attributeLists
                Case 1
                    Return Me._modifiers
                Case 2
                    Return Me._subOrFunctionKeyword
                Case 3
                    Return Me._parameterList
                Case 4
                    Return Me._asClause
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LambdaHeaderSyntax(Me.Kind, newErrors, GetAnnotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _parameterList, _asClause)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LambdaHeaderSyntax(Me.Kind, GetDiagnostics, annotations, _attributeLists, _modifiers, _subOrFunctionKeyword, _parameterList, _asClause)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLambdaHeader(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a parenthesized argument list.
    ''' </summary>
    Friend NotInheritable Class ArgumentListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _arguments as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArgumentListSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "(" token.
        ''' </summary>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The list of arguments. This may be empty. Omitted argument are represented by
        ''' an OmittedArgumentSyntax node.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Arguments As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ArgumentSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ArgumentSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ArgumentSyntax)(Me._arguments))
            End Get
        End Property

        ''' <summary>
        ''' The ")" token.
        ''' </summary>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._openParenToken
                Case 1
                    Return Me._arguments
                Case 2
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArgumentListSyntax(Me.Kind, newErrors, GetAnnotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArgumentListSyntax(Me.Kind, GetDiagnostics, annotations, _openParenToken, _arguments, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArgumentList(Me)
        End Function

    End Class

    ''' <summary>
    ''' Base class for the possible kinds of arguments that can appear in an argument
    ''' list.
    ''' </summary>
    Friend MustInherit Class ArgumentSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an omitted argument in an argument list. An omitted argument is not
    ''' considered a syntax error but a valid case when no argument is required.
    ''' </summary>
    Friend NotInheritable Class OmittedArgumentSyntax
        Inherits ArgumentSyntax

        Friend ReadOnly _empty as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, empty As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), empty As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(empty)
            Me._empty = empty

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OmittedArgumentSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' An empty token because all non terminals must have a token.
        ''' </summary>
        Friend ReadOnly Property Empty As InternalSyntax.PunctuationSyntax
            Get
                Return Me._empty
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._empty
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OmittedArgumentSyntax(Me.Kind, newErrors, GetAnnotations, _empty)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OmittedArgumentSyntax(Me.Kind, GetDiagnostics, annotations, _empty)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOmittedArgument(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an argument that is just an optional argument name and an
    ''' expression.
    ''' </summary>
    Friend NotInheritable Class SimpleArgumentSyntax
        Inherits ArgumentSyntax

        Friend ReadOnly _nameColonEquals as NameColonEqualsSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, nameColonEquals As NameColonEqualsSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            If nameColonEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameColonEquals)
                Me._nameColonEquals = nameColonEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, nameColonEquals As NameColonEqualsSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If nameColonEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameColonEquals)
                Me._nameColonEquals = nameColonEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nameColonEquals As NameColonEqualsSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If nameColonEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameColonEquals)
                Me._nameColonEquals = nameColonEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleArgumentSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The optional name and ":=" prefix of a named argument.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property NameColonEquals As InternalSyntax.NameColonEqualsSyntax
            Get
                Return Me._nameColonEquals
            End Get
        End Property

        ''' <summary>
        ''' The expression that is the argument.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._nameColonEquals
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleArgumentSyntax(Me.Kind, newErrors, GetAnnotations, _nameColonEquals, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleArgumentSyntax(Me.Kind, GetDiagnostics, annotations, _nameColonEquals, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleArgument(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an identifier name followed by a ":=" token in a named argument.
    ''' </summary>
    Friend NotInheritable Class NameColonEqualsSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _name as IdentifierNameSyntax
        Friend ReadOnly _colonEqualsToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, name As IdentifierNameSyntax, colonEqualsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonEqualsToken)
            Me._colonEqualsToken = colonEqualsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, name As IdentifierNameSyntax, colonEqualsToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonEqualsToken)
            Me._colonEqualsToken = colonEqualsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), name As IdentifierNameSyntax, colonEqualsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonEqualsToken)
            Me._colonEqualsToken = colonEqualsToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NameColonEqualsSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name used to identify the named argument.
        ''' </summary>
        Friend ReadOnly Property Name As InternalSyntax.IdentifierNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <summary>
        ''' The ":=" token.
        ''' </summary>
        Friend ReadOnly Property ColonEqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonEqualsToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._name
                Case 1
                    Return Me._colonEqualsToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NameColonEqualsSyntax(Me.Kind, newErrors, GetAnnotations, _name, _colonEqualsToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NameColonEqualsSyntax(Me.Kind, GetDiagnostics, annotations, _name, _colonEqualsToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNameColonEquals(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a range argument, such as "0 to 5", used in array bounds. The
    ''' "Value" property represents the upper bound of the range.
    ''' </summary>
    Friend NotInheritable Class RangeArgumentSyntax
        Inherits ArgumentSyntax

        Friend ReadOnly _lowerBound as ExpressionSyntax
        Friend ReadOnly _toKeyword as KeywordSyntax
        Friend ReadOnly _upperBound as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lowerBound As ExpressionSyntax, toKeyword As InternalSyntax.KeywordSyntax, upperBound As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lowerBound)
            Me._lowerBound = lowerBound
            AdjustFlagsAndWidth(toKeyword)
            Me._toKeyword = toKeyword
            AdjustFlagsAndWidth(upperBound)
            Me._upperBound = upperBound

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.RangeArgumentSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The lower bound of the range. This is typically the integer constant zero.
        ''' </summary>
        Friend ReadOnly Property LowerBound As InternalSyntax.ExpressionSyntax
            Get
                Return Me._lowerBound
            End Get
        End Property

        ''' <summary>
        ''' The "To" keyword.
        ''' </summary>
        Friend ReadOnly Property ToKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._toKeyword
            End Get
        End Property

        ''' <summary>
        ''' The upper bound of the range.
        ''' </summary>
        Friend ReadOnly Property UpperBound As InternalSyntax.ExpressionSyntax
            Get
                Return Me._upperBound
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lowerBound
                Case 1
                    Return Me._toKeyword
                Case 2
                    Return Me._upperBound
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new RangeArgumentSyntax(Me.Kind, newErrors, GetAnnotations, _lowerBound, _toKeyword, _upperBound)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new RangeArgumentSyntax(Me.Kind, GetDiagnostics, annotations, _lowerBound, _toKeyword, _upperBound)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitRangeArgument(Me)
        End Function

    End Class

    ''' <summary>
    ''' This class represents a query expression. A query expression is composed of one
    ''' or more query operators in a row. The first query operator must be a From or
    ''' Aggregate.
    ''' </summary>
    Friend NotInheritable Class QueryExpressionSyntax
        Inherits ExpressionSyntax

        Friend ReadOnly _clauses as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, clauses As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 1

            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, clauses As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), clauses As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            If clauses IsNot Nothing Then
                AdjustFlagsAndWidth(clauses)
                Me._clauses = clauses
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.QueryExpressionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all the query operators in this query expression. This list always
        ''' contains at least one operator.
        ''' </summary>
        Friend ReadOnly Property Clauses As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of QueryClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of QueryClauseSyntax)(Me._clauses)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._clauses
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new QueryExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _clauses)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new QueryExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _clauses)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitQueryExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' This is a base class for all query operators.
    ''' </summary>
    Friend MustInherit Class QueryClauseSyntax
        Inherits VisualBasicSyntaxNode


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Describes a single variable of the form "x [As Type] In expression" for use in
    ''' query expressions.
    ''' </summary>
    Friend NotInheritable Class CollectionRangeVariableSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _identifier as ModifiedIdentifierSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _inKeyword as KeywordSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, inKeyword As InternalSyntax.KeywordSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            AdjustFlagsAndWidth(inKeyword)
            Me._inKeyword = inKeyword
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.CollectionRangeVariableSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the range variable being defined.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.ModifiedIdentifierSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' Describes the type of the variable being defined.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' The "In" keyword.
        ''' </summary>
        Friend ReadOnly Property InKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._inKeyword
            End Get
        End Property

        ''' <summary>
        ''' The expression that serves as the source of items for the range variable.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._asClause
                Case 2
                    Return Me._inKeyword
                Case 3
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new CollectionRangeVariableSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _asClause, _inKeyword, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new CollectionRangeVariableSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _asClause, _inKeyword, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitCollectionRangeVariable(Me)
        End Function

    End Class

    ''' <summary>
    ''' Describes a single variable of the form "[x [As Type] =] expression" for use in
    ''' query expressions.
    ''' </summary>
    Friend NotInheritable Class ExpressionRangeVariableSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _nameEquals as VariableNameEqualsSyntax
        Friend ReadOnly _expression as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, nameEquals As VariableNameEqualsSyntax, expression As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            If nameEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameEquals)
                Me._nameEquals = nameEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, nameEquals As VariableNameEqualsSyntax, expression As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If nameEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameEquals)
                Me._nameEquals = nameEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nameEquals As VariableNameEqualsSyntax, expression As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If nameEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameEquals)
                Me._nameEquals = nameEquals
            End If
            AdjustFlagsAndWidth(expression)
            Me._expression = expression

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ExpressionRangeVariableSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The optional name and type of the expression range variable. If omitted, the
        ''' name of the expression range variable is inferred from the expression.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property NameEquals As InternalSyntax.VariableNameEqualsSyntax
            Get
                Return Me._nameEquals
            End Get
        End Property

        ''' <summary>
        ''' The expression used to initialize the expression variable.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._nameEquals
                Case 1
                    Return Me._expression
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ExpressionRangeVariableSyntax(Me.Kind, newErrors, GetAnnotations, _nameEquals, _expression)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ExpressionRangeVariableSyntax(Me.Kind, GetDiagnostics, annotations, _nameEquals, _expression)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitExpressionRangeVariable(Me)
        End Function

    End Class

    ''' <summary>
    ''' Describes a single variable of the form "[x [As Type] =] aggregation-function"
    ''' for use in the Into clause of Aggregate or Group By or Group Join query
    ''' operators.
    ''' </summary>
    Friend NotInheritable Class AggregationRangeVariableSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _nameEquals as VariableNameEqualsSyntax
        Friend ReadOnly _aggregation as AggregationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, nameEquals As VariableNameEqualsSyntax, aggregation As AggregationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            If nameEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameEquals)
                Me._nameEquals = nameEquals
            End If
            AdjustFlagsAndWidth(aggregation)
            Me._aggregation = aggregation

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, nameEquals As VariableNameEqualsSyntax, aggregation As AggregationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If nameEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameEquals)
                Me._nameEquals = nameEquals
            End If
            AdjustFlagsAndWidth(aggregation)
            Me._aggregation = aggregation

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), nameEquals As VariableNameEqualsSyntax, aggregation As AggregationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If nameEquals IsNot Nothing Then
                AdjustFlagsAndWidth(nameEquals)
                Me._nameEquals = nameEquals
            End If
            AdjustFlagsAndWidth(aggregation)
            Me._aggregation = aggregation

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AggregationRangeVariableSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The optional name and type of the expression range variable. If omitted, the
        ''' name of the expression range variable is inferred from the aggregation
        ''' expression.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property NameEquals As InternalSyntax.VariableNameEqualsSyntax
            Get
                Return Me._nameEquals
            End Get
        End Property

        ''' <summary>
        ''' The name of the aggregation function. The "Group" aggregation function is
        ''' represented by the identifier "Group".
        ''' </summary>
        Friend ReadOnly Property Aggregation As InternalSyntax.AggregationSyntax
            Get
                Return Me._aggregation
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._nameEquals
                Case 1
                    Return Me._aggregation
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AggregationRangeVariableSyntax(Me.Kind, newErrors, GetAnnotations, _nameEquals, _aggregation)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AggregationRangeVariableSyntax(Me.Kind, GetDiagnostics, annotations, _nameEquals, _aggregation)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAggregationRangeVariable(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the name and optional type of an expression range variable.
    ''' </summary>
    Friend NotInheritable Class VariableNameEqualsSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _identifier as ModifiedIdentifierSyntax
        Friend ReadOnly _asClause as SimpleAsClauseSyntax
        Friend ReadOnly _equalsToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, equalsToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As ModifiedIdentifierSyntax, asClause As SimpleAsClauseSyntax, equalsToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier
            If asClause IsNot Nothing Then
                AdjustFlagsAndWidth(asClause)
                Me._asClause = asClause
            End If
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.VariableNameEqualsSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the variable being defined.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.ModifiedIdentifierSyntax
            Get
                Return Me._identifier
            End Get
        End Property

        ''' <summary>
        ''' Describes the type of the variable being defined.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AsClause As InternalSyntax.SimpleAsClauseSyntax
            Get
                Return Me._asClause
            End Get
        End Property

        ''' <summary>
        ''' The "=" token.
        ''' </summary>
        Friend ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._asClause
                Case 2
                    Return Me._equalsToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new VariableNameEqualsSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _asClause, _equalsToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new VariableNameEqualsSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _asClause, _equalsToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitVariableNameEquals(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents aggregation in aggregation range variable declaration of a Group By,
    ''' Group Join or Aggregate query operator.
    ''' </summary>
    Friend MustInherit Class AggregationSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an invocation of an Aggregation function in the aggregation range
    ''' variable declaration of a Group By, Group Join or Aggregate query operator.
    ''' </summary>
    Friend NotInheritable Class FunctionAggregationSyntax
        Inherits AggregationSyntax

        Friend ReadOnly _functionName as IdentifierTokenSyntax
        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _argument as ExpressionSyntax
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, functionName As InternalSyntax.IdentifierTokenSyntax, openParenToken As InternalSyntax.PunctuationSyntax, argument As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(functionName)
            Me._functionName = functionName
            If openParenToken IsNot Nothing Then
                AdjustFlagsAndWidth(openParenToken)
                Me._openParenToken = openParenToken
            End If
            If argument IsNot Nothing Then
                AdjustFlagsAndWidth(argument)
                Me._argument = argument
            End If
            If closeParenToken IsNot Nothing Then
                AdjustFlagsAndWidth(closeParenToken)
                Me._closeParenToken = closeParenToken
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, functionName As InternalSyntax.IdentifierTokenSyntax, openParenToken As InternalSyntax.PunctuationSyntax, argument As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(functionName)
            Me._functionName = functionName
            If openParenToken IsNot Nothing Then
                AdjustFlagsAndWidth(openParenToken)
                Me._openParenToken = openParenToken
            End If
            If argument IsNot Nothing Then
                AdjustFlagsAndWidth(argument)
                Me._argument = argument
            End If
            If closeParenToken IsNot Nothing Then
                AdjustFlagsAndWidth(closeParenToken)
                Me._closeParenToken = closeParenToken
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), functionName As InternalSyntax.IdentifierTokenSyntax, openParenToken As InternalSyntax.PunctuationSyntax, argument As ExpressionSyntax, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(functionName)
            Me._functionName = functionName
            If openParenToken IsNot Nothing Then
                AdjustFlagsAndWidth(openParenToken)
                Me._openParenToken = openParenToken
            End If
            If argument IsNot Nothing Then
                AdjustFlagsAndWidth(argument)
                Me._argument = argument
            End If
            If closeParenToken IsNot Nothing Then
                AdjustFlagsAndWidth(closeParenToken)
                Me._closeParenToken = closeParenToken
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FunctionAggregationSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The name of the aggregation function.
        ''' </summary>
        Friend ReadOnly Property FunctionName As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._functionName
            End Get
        End Property

        ''' <summary>
        ''' The "(" token if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property OpenParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._openParenToken
            End Get
        End Property

        ''' <summary>
        ''' The argument to the aggregation function.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Argument As InternalSyntax.ExpressionSyntax
            Get
                Return Me._argument
            End Get
        End Property

        ''' <summary>
        ''' The ")" token, if present.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property CloseParenToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._closeParenToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._functionName
                Case 1
                    Return Me._openParenToken
                Case 2
                    Return Me._argument
                Case 3
                    Return Me._closeParenToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FunctionAggregationSyntax(Me.Kind, newErrors, GetAnnotations, _functionName, _openParenToken, _argument, _closeParenToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FunctionAggregationSyntax(Me.Kind, GetDiagnostics, annotations, _functionName, _openParenToken, _argument, _closeParenToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFunctionAggregation(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the use of "Group" as the aggregation function in the in the
    ''' aggregation range variable declaration of a Group By or Group Join query
    ''' operator.
    ''' </summary>
    Friend NotInheritable Class GroupAggregationSyntax
        Inherits AggregationSyntax

        Friend ReadOnly _groupKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, groupKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, groupKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), groupKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GroupAggregationSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Group" keyword.
        ''' </summary>
        Friend ReadOnly Property GroupKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._groupKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._groupKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GroupAggregationSyntax(Me.Kind, newErrors, GetAnnotations, _groupKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GroupAggregationSyntax(Me.Kind, GetDiagnostics, annotations, _groupKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGroupAggregation(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "From" query operator. If this is the beginning of a query, the
    ''' Source will be Nothing. Otherwise, the Source will be the part of the query to
    ''' the left of the From.
    ''' </summary>
    Friend NotInheritable Class FromClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _fromKeyword as KeywordSyntax
        Friend ReadOnly _variables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, fromKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, fromKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), fromKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(fromKeyword)
            Me._fromKeyword = fromKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.FromClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "From" keyword.
        ''' </summary>
        Friend ReadOnly Property FromKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._fromKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of collection variables declared by this From operator.
        ''' </summary>
        Friend ReadOnly Property Variables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CollectionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CollectionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of CollectionRangeVariableSyntax)(Me._variables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._fromKeyword
                Case 1
                    Return Me._variables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new FromClauseSyntax(Me.Kind, newErrors, GetAnnotations, _fromKeyword, _variables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new FromClauseSyntax(Me.Kind, GetDiagnostics, annotations, _fromKeyword, _variables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitFromClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Let" query operator.
    ''' </summary>
    Friend NotInheritable Class LetClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _letKeyword as KeywordSyntax
        Friend ReadOnly _variables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, letKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(letKeyword)
            Me._letKeyword = letKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, letKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(letKeyword)
            Me._letKeyword = letKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), letKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(letKeyword)
            Me._letKeyword = letKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.LetClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Let" keyword.
        ''' </summary>
        Friend ReadOnly Property LetKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._letKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of expression range variable being defined by the Let operator.
        ''' </summary>
        Friend ReadOnly Property Variables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionRangeVariableSyntax)(Me._variables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._letKeyword
                Case 1
                    Return Me._variables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new LetClauseSyntax(Me.Kind, newErrors, GetAnnotations, _letKeyword, _variables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new LetClauseSyntax(Me.Kind, GetDiagnostics, annotations, _letKeyword, _variables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitLetClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an Aggregate query operator.
    ''' </summary>
    Friend NotInheritable Class AggregateClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _aggregateKeyword as KeywordSyntax
        Friend ReadOnly _variables as GreenNode
        Friend ReadOnly _additionalQueryOperators as GreenNode
        Friend ReadOnly _intoKeyword as KeywordSyntax
        Friend ReadOnly _aggregationVariables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, aggregateKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode, additionalQueryOperators As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(aggregateKeyword)
            Me._aggregateKeyword = aggregateKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If
            If additionalQueryOperators IsNot Nothing Then
                AdjustFlagsAndWidth(additionalQueryOperators)
                Me._additionalQueryOperators = additionalQueryOperators
            End If
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, aggregateKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode, additionalQueryOperators As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(aggregateKeyword)
            Me._aggregateKeyword = aggregateKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If
            If additionalQueryOperators IsNot Nothing Then
                AdjustFlagsAndWidth(additionalQueryOperators)
                Me._additionalQueryOperators = additionalQueryOperators
            End If
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), aggregateKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode, additionalQueryOperators As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 5

            AdjustFlagsAndWidth(aggregateKeyword)
            Me._aggregateKeyword = aggregateKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If
            If additionalQueryOperators IsNot Nothing Then
                AdjustFlagsAndWidth(additionalQueryOperators)
                Me._additionalQueryOperators = additionalQueryOperators
            End If
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.AggregateClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Aggregate" keyword.
        ''' </summary>
        Friend ReadOnly Property AggregateKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._aggregateKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of collection range variables declared by this Aggregate operator.
        ''' </summary>
        Friend ReadOnly Property Variables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CollectionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CollectionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of CollectionRangeVariableSyntax)(Me._variables))
            End Get
        End Property

        ''' <summary>
        ''' A list of additional query operators. It may be empty.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AdditionalQueryOperators As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of QueryClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of QueryClauseSyntax)(Me._additionalQueryOperators)
            End Get
        End Property

        ''' <summary>
        ''' The "Into" keyword.
        ''' </summary>
        Friend ReadOnly Property IntoKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._intoKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of new variables being defined by the aggregation.
        ''' </summary>
        Friend ReadOnly Property AggregationVariables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AggregationRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AggregationRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of AggregationRangeVariableSyntax)(Me._aggregationVariables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._aggregateKeyword
                Case 1
                    Return Me._variables
                Case 2
                    Return Me._additionalQueryOperators
                Case 3
                    Return Me._intoKeyword
                Case 4
                    Return Me._aggregationVariables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new AggregateClauseSyntax(Me.Kind, newErrors, GetAnnotations, _aggregateKeyword, _variables, _additionalQueryOperators, _intoKeyword, _aggregationVariables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new AggregateClauseSyntax(Me.Kind, GetDiagnostics, annotations, _aggregateKeyword, _variables, _additionalQueryOperators, _intoKeyword, _aggregationVariables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitAggregateClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Distinct" query operator.
    ''' </summary>
    Friend NotInheritable Class DistinctClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _distinctKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, distinctKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(distinctKeyword)
            Me._distinctKeyword = distinctKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, distinctKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(distinctKeyword)
            Me._distinctKeyword = distinctKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), distinctKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(distinctKeyword)
            Me._distinctKeyword = distinctKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.DistinctClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Distinct" keyword.
        ''' </summary>
        Friend ReadOnly Property DistinctKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._distinctKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._distinctKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new DistinctClauseSyntax(Me.Kind, newErrors, GetAnnotations, _distinctKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new DistinctClauseSyntax(Me.Kind, GetDiagnostics, annotations, _distinctKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitDistinctClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Where" query operator.
    ''' </summary>
    Friend NotInheritable Class WhereClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _whereKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, whereKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whereKeyword)
            Me._whereKeyword = whereKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, whereKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(whereKeyword)
            Me._whereKeyword = whereKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), whereKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(whereKeyword)
            Me._whereKeyword = whereKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.WhereClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Where" keyword.
        ''' </summary>
        Friend ReadOnly Property WhereKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whereKeyword
            End Get
        End Property

        ''' <summary>
        ''' The boolean expression used for filtering.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._whereKeyword
                Case 1
                    Return Me._condition
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new WhereClauseSyntax(Me.Kind, newErrors, GetAnnotations, _whereKeyword, _condition)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new WhereClauseSyntax(Me.Kind, GetDiagnostics, annotations, _whereKeyword, _condition)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitWhereClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Skip While" or "Take While" query operator. The Kind property
    ''' tells which.
    ''' </summary>
    Friend NotInheritable Class PartitionWhileClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _skipOrTakeKeyword as KeywordSyntax
        Friend ReadOnly _whileKeyword as KeywordSyntax
        Friend ReadOnly _condition as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, skipOrTakeKeyword As InternalSyntax.KeywordSyntax, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(skipOrTakeKeyword)
            Me._skipOrTakeKeyword = skipOrTakeKeyword
            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, skipOrTakeKeyword As InternalSyntax.KeywordSyntax, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(skipOrTakeKeyword)
            Me._skipOrTakeKeyword = skipOrTakeKeyword
            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), skipOrTakeKeyword As InternalSyntax.KeywordSyntax, whileKeyword As InternalSyntax.KeywordSyntax, condition As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(skipOrTakeKeyword)
            Me._skipOrTakeKeyword = skipOrTakeKeyword
            AdjustFlagsAndWidth(whileKeyword)
            Me._whileKeyword = whileKeyword
            AdjustFlagsAndWidth(condition)
            Me._condition = condition

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PartitionWhileClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Skip" or "Take" keyword.
        ''' </summary>
        Friend ReadOnly Property SkipOrTakeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._skipOrTakeKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "While" keyword.
        ''' </summary>
        Friend ReadOnly Property WhileKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._whileKeyword
            End Get
        End Property

        ''' <summary>
        ''' The boolean expression used for partitioning.
        ''' </summary>
        Friend ReadOnly Property Condition As InternalSyntax.ExpressionSyntax
            Get
                Return Me._condition
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._skipOrTakeKeyword
                Case 1
                    Return Me._whileKeyword
                Case 2
                    Return Me._condition
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PartitionWhileClauseSyntax(Me.Kind, newErrors, GetAnnotations, _skipOrTakeKeyword, _whileKeyword, _condition)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PartitionWhileClauseSyntax(Me.Kind, GetDiagnostics, annotations, _skipOrTakeKeyword, _whileKeyword, _condition)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPartitionWhileClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a "Skip" or "Take" query operator. The Kind property tells which.
    ''' </summary>
    Friend NotInheritable Class PartitionClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _skipOrTakeKeyword as KeywordSyntax
        Friend ReadOnly _count as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, skipOrTakeKeyword As InternalSyntax.KeywordSyntax, count As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(skipOrTakeKeyword)
            Me._skipOrTakeKeyword = skipOrTakeKeyword
            AdjustFlagsAndWidth(count)
            Me._count = count

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, skipOrTakeKeyword As InternalSyntax.KeywordSyntax, count As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(skipOrTakeKeyword)
            Me._skipOrTakeKeyword = skipOrTakeKeyword
            AdjustFlagsAndWidth(count)
            Me._count = count

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), skipOrTakeKeyword As InternalSyntax.KeywordSyntax, count As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(skipOrTakeKeyword)
            Me._skipOrTakeKeyword = skipOrTakeKeyword
            AdjustFlagsAndWidth(count)
            Me._count = count

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PartitionClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Skip" or "Take" keyword.
        ''' </summary>
        Friend ReadOnly Property SkipOrTakeKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._skipOrTakeKeyword
            End Get
        End Property

        ''' <summary>
        ''' Represents the expression with the number of items to take or skip.
        ''' </summary>
        Friend ReadOnly Property Count As InternalSyntax.ExpressionSyntax
            Get
                Return Me._count
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._skipOrTakeKeyword
                Case 1
                    Return Me._count
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PartitionClauseSyntax(Me.Kind, newErrors, GetAnnotations, _skipOrTakeKeyword, _count)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PartitionClauseSyntax(Me.Kind, GetDiagnostics, annotations, _skipOrTakeKeyword, _count)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPartitionClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Group By" query operator.
    ''' </summary>
    Friend NotInheritable Class GroupByClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _groupKeyword as KeywordSyntax
        Friend ReadOnly _items as GreenNode
        Friend ReadOnly _byKeyword as KeywordSyntax
        Friend ReadOnly _keys as GreenNode
        Friend ReadOnly _intoKeyword as KeywordSyntax
        Friend ReadOnly _aggregationVariables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, groupKeyword As InternalSyntax.KeywordSyntax, items As GreenNode, byKeyword As InternalSyntax.KeywordSyntax, keys As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword
            If items IsNot Nothing Then
                AdjustFlagsAndWidth(items)
                Me._items = items
            End If
            AdjustFlagsAndWidth(byKeyword)
            Me._byKeyword = byKeyword
            If keys IsNot Nothing Then
                AdjustFlagsAndWidth(keys)
                Me._keys = keys
            End If
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, groupKeyword As InternalSyntax.KeywordSyntax, items As GreenNode, byKeyword As InternalSyntax.KeywordSyntax, keys As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword
            If items IsNot Nothing Then
                AdjustFlagsAndWidth(items)
                Me._items = items
            End If
            AdjustFlagsAndWidth(byKeyword)
            Me._byKeyword = byKeyword
            If keys IsNot Nothing Then
                AdjustFlagsAndWidth(keys)
                Me._keys = keys
            End If
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), groupKeyword As InternalSyntax.KeywordSyntax, items As GreenNode, byKeyword As InternalSyntax.KeywordSyntax, keys As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword
            If items IsNot Nothing Then
                AdjustFlagsAndWidth(items)
                Me._items = items
            End If
            AdjustFlagsAndWidth(byKeyword)
            Me._byKeyword = byKeyword
            If keys IsNot Nothing Then
                AdjustFlagsAndWidth(keys)
                Me._keys = keys
            End If
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GroupByClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Group" keyword.
        ''' </summary>
        Friend ReadOnly Property GroupKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._groupKeyword
            End Get
        End Property

        ''' <summary>
        ''' The optional list of variables being grouped; the contents of the Group clause.
        ''' If none were specified, an empty list is returned.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Items As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionRangeVariableSyntax)(Me._items))
            End Get
        End Property

        ''' <summary>
        ''' The "By" keyword.
        ''' </summary>
        Friend ReadOnly Property ByKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._byKeyword
            End Get
        End Property

        ''' <summary>
        ''' The key values being used for grouping.
        ''' </summary>
        Friend ReadOnly Property Keys As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionRangeVariableSyntax)(Me._keys))
            End Get
        End Property

        Friend ReadOnly Property IntoKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._intoKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of new variables that calculate aggregations.
        ''' </summary>
        Friend ReadOnly Property AggregationVariables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AggregationRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AggregationRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of AggregationRangeVariableSyntax)(Me._aggregationVariables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._groupKeyword
                Case 1
                    Return Me._items
                Case 2
                    Return Me._byKeyword
                Case 3
                    Return Me._keys
                Case 4
                    Return Me._intoKeyword
                Case 5
                    Return Me._aggregationVariables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GroupByClauseSyntax(Me.Kind, newErrors, GetAnnotations, _groupKeyword, _items, _byKeyword, _keys, _intoKeyword, _aggregationVariables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GroupByClauseSyntax(Me.Kind, GetDiagnostics, annotations, _groupKeyword, _items, _byKeyword, _keys, _intoKeyword, _aggregationVariables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGroupByClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Join or a Group Join query operator.
    ''' </summary>
    Friend MustInherit Class JoinClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _joinKeyword as KeywordSyntax
        Friend ReadOnly _joinedVariables as GreenNode
        Friend ReadOnly _additionalJoins as GreenNode
        Friend ReadOnly _onKeyword as KeywordSyntax
        Friend ReadOnly _joinConditions as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode)
            MyBase.New(kind)

            AdjustFlagsAndWidth(joinKeyword)
            Me._joinKeyword = joinKeyword
            If joinedVariables IsNot Nothing Then
                AdjustFlagsAndWidth(joinedVariables)
                Me._joinedVariables = joinedVariables
            End If
            If additionalJoins IsNot Nothing Then
                AdjustFlagsAndWidth(additionalJoins)
                Me._additionalJoins = additionalJoins
            End If
            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            If joinConditions IsNot Nothing Then
                AdjustFlagsAndWidth(joinConditions)
                Me._joinConditions = joinConditions
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(joinKeyword)
            Me._joinKeyword = joinKeyword
            If joinedVariables IsNot Nothing Then
                AdjustFlagsAndWidth(joinedVariables)
                Me._joinedVariables = joinedVariables
            End If
            If additionalJoins IsNot Nothing Then
                AdjustFlagsAndWidth(additionalJoins)
                Me._additionalJoins = additionalJoins
            End If
            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            If joinConditions IsNot Nothing Then
                AdjustFlagsAndWidth(joinConditions)
                Me._joinConditions = joinConditions
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(joinKeyword)
            Me._joinKeyword = joinKeyword
            If joinedVariables IsNot Nothing Then
                AdjustFlagsAndWidth(joinedVariables)
                Me._joinedVariables = joinedVariables
            End If
            If additionalJoins IsNot Nothing Then
                AdjustFlagsAndWidth(additionalJoins)
                Me._additionalJoins = additionalJoins
            End If
            AdjustFlagsAndWidth(onKeyword)
            Me._onKeyword = onKeyword
            If joinConditions IsNot Nothing Then
                AdjustFlagsAndWidth(joinConditions)
                Me._joinConditions = joinConditions
            End If

        End Sub

        ''' <summary>
        ''' The "Join" keyword.
        ''' </summary>
        Friend ReadOnly Property JoinKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._joinKeyword
            End Get
        End Property

        ''' <summary>
        ''' Defines the collection range variables being joined to.
        ''' </summary>
        Friend ReadOnly Property JoinedVariables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CollectionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of CollectionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of CollectionRangeVariableSyntax)(Me._joinedVariables))
            End Get
        End Property

        ''' <summary>
        ''' An additional Join or Group Join query operator.
        ''' </summary>
        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property AdditionalJoins As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of JoinClauseSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of JoinClauseSyntax)(Me._additionalJoins)
            End Get
        End Property

        ''' <summary>
        ''' The "On" keyword.
        ''' </summary>
        Friend ReadOnly Property OnKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._onKeyword
            End Get
        End Property

        ''' <summary>
        ''' The conditions indicating what expressions to compare during the join. Each
        ''' condition is a JoinCondition, and the separators are "And" keywords.
        ''' </summary>
        Friend ReadOnly Property JoinConditions As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of JoinConditionSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of JoinConditionSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of JoinConditionSyntax)(Me._joinConditions))
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents the "expression Equals expression" condition in a Join.
    ''' </summary>
    Friend NotInheritable Class JoinConditionSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _left as ExpressionSyntax
        Friend ReadOnly _equalsKeyword as KeywordSyntax
        Friend ReadOnly _right as ExpressionSyntax

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, equalsKeyword As InternalSyntax.KeywordSyntax, right As ExpressionSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(equalsKeyword)
            Me._equalsKeyword = equalsKeyword
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, left As ExpressionSyntax, equalsKeyword As InternalSyntax.KeywordSyntax, right As ExpressionSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(equalsKeyword)
            Me._equalsKeyword = equalsKeyword
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As ExpressionSyntax, equalsKeyword As InternalSyntax.KeywordSyntax, right As ExpressionSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(equalsKeyword)
            Me._equalsKeyword = equalsKeyword
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.JoinConditionSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The left expression in the Join condition.
        ''' </summary>
        Friend ReadOnly Property Left As InternalSyntax.ExpressionSyntax
            Get
                Return Me._left
            End Get
        End Property

        ''' <summary>
        ''' The "Equals" keyword.
        ''' </summary>
        Friend ReadOnly Property EqualsKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._equalsKeyword
            End Get
        End Property

        ''' <summary>
        ''' The right expression in the Join condition.
        ''' </summary>
        Friend ReadOnly Property Right As InternalSyntax.ExpressionSyntax
            Get
                Return Me._right
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._left
                Case 1
                    Return Me._equalsKeyword
                Case 2
                    Return Me._right
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new JoinConditionSyntax(Me.Kind, newErrors, GetAnnotations, _left, _equalsKeyword, _right)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new JoinConditionSyntax(Me.Kind, GetDiagnostics, annotations, _left, _equalsKeyword, _right)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitJoinCondition(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a Join query operator.
    ''' </summary>
    Friend NotInheritable Class SimpleJoinClauseSyntax
        Inherits JoinClauseSyntax


        Friend Sub New(ByVal kind As SyntaxKind, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode)
            MyBase.New(kind, joinKeyword, joinedVariables, additionalJoins, onKeyword, joinConditions)
            Me.SlotCount = 5
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind, joinKeyword, joinedVariables, additionalJoins, onKeyword, joinConditions)
            Me.SlotCount = 5
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode)
            MyBase.New(kind, errors, annotations, joinKeyword, joinedVariables, additionalJoins, onKeyword, joinConditions)
            Me.SlotCount = 5
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SimpleJoinClauseSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._joinKeyword
                Case 1
                    Return Me._joinedVariables
                Case 2
                    Return Me._additionalJoins
                Case 3
                    Return Me._onKeyword
                Case 4
                    Return Me._joinConditions
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SimpleJoinClauseSyntax(Me.Kind, newErrors, GetAnnotations, _joinKeyword, _joinedVariables, _additionalJoins, _onKeyword, _joinConditions)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SimpleJoinClauseSyntax(Me.Kind, GetDiagnostics, annotations, _joinKeyword, _joinedVariables, _additionalJoins, _onKeyword, _joinConditions)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSimpleJoinClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Group Join" query operator.
    ''' </summary>
    Friend NotInheritable Class GroupJoinClauseSyntax
        Inherits JoinClauseSyntax

        Friend ReadOnly _groupKeyword as KeywordSyntax
        Friend ReadOnly _intoKeyword as KeywordSyntax
        Friend ReadOnly _aggregationVariables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, groupKeyword As InternalSyntax.KeywordSyntax, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode)
            MyBase.New(kind, joinKeyword, joinedVariables, additionalJoins, onKeyword, joinConditions)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, groupKeyword As InternalSyntax.KeywordSyntax, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind, joinKeyword, joinedVariables, additionalJoins, onKeyword, joinConditions)
            Me.SlotCount = 8
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), groupKeyword As InternalSyntax.KeywordSyntax, joinKeyword As InternalSyntax.KeywordSyntax, joinedVariables As GreenNode, additionalJoins As GreenNode, onKeyword As InternalSyntax.KeywordSyntax, joinConditions As GreenNode, intoKeyword As InternalSyntax.KeywordSyntax, aggregationVariables As GreenNode)
            MyBase.New(kind, errors, annotations, joinKeyword, joinedVariables, additionalJoins, onKeyword, joinConditions)
            Me.SlotCount = 8

            AdjustFlagsAndWidth(groupKeyword)
            Me._groupKeyword = groupKeyword
            AdjustFlagsAndWidth(intoKeyword)
            Me._intoKeyword = intoKeyword
            If aggregationVariables IsNot Nothing Then
                AdjustFlagsAndWidth(aggregationVariables)
                Me._aggregationVariables = aggregationVariables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GroupJoinClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Group" keyword.
        ''' </summary>
        Friend ReadOnly Property GroupKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._groupKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "Into" keyword.
        ''' </summary>
        Friend ReadOnly Property IntoKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._intoKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of new variables that calculate aggregations.
        ''' </summary>
        Friend ReadOnly Property AggregationVariables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AggregationRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of AggregationRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of AggregationRangeVariableSyntax)(Me._aggregationVariables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._groupKeyword
                Case 1
                    Return Me._joinKeyword
                Case 2
                    Return Me._joinedVariables
                Case 3
                    Return Me._additionalJoins
                Case 4
                    Return Me._onKeyword
                Case 5
                    Return Me._joinConditions
                Case 6
                    Return Me._intoKeyword
                Case 7
                    Return Me._aggregationVariables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GroupJoinClauseSyntax(Me.Kind, newErrors, GetAnnotations, _groupKeyword, _joinKeyword, _joinedVariables, _additionalJoins, _onKeyword, _joinConditions, _intoKeyword, _aggregationVariables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GroupJoinClauseSyntax(Me.Kind, GetDiagnostics, annotations, _groupKeyword, _joinKeyword, _joinedVariables, _additionalJoins, _onKeyword, _joinConditions, _intoKeyword, _aggregationVariables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGroupJoinClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Order By" query operator.
    ''' </summary>
    Friend NotInheritable Class OrderByClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _orderKeyword as KeywordSyntax
        Friend ReadOnly _byKeyword as KeywordSyntax
        Friend ReadOnly _orderings as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, orderKeyword As InternalSyntax.KeywordSyntax, byKeyword As InternalSyntax.KeywordSyntax, orderings As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(orderKeyword)
            Me._orderKeyword = orderKeyword
            AdjustFlagsAndWidth(byKeyword)
            Me._byKeyword = byKeyword
            If orderings IsNot Nothing Then
                AdjustFlagsAndWidth(orderings)
                Me._orderings = orderings
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, orderKeyword As InternalSyntax.KeywordSyntax, byKeyword As InternalSyntax.KeywordSyntax, orderings As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(orderKeyword)
            Me._orderKeyword = orderKeyword
            AdjustFlagsAndWidth(byKeyword)
            Me._byKeyword = byKeyword
            If orderings IsNot Nothing Then
                AdjustFlagsAndWidth(orderings)
                Me._orderings = orderings
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), orderKeyword As InternalSyntax.KeywordSyntax, byKeyword As InternalSyntax.KeywordSyntax, orderings As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(orderKeyword)
            Me._orderKeyword = orderKeyword
            AdjustFlagsAndWidth(byKeyword)
            Me._byKeyword = byKeyword
            If orderings IsNot Nothing Then
                AdjustFlagsAndWidth(orderings)
                Me._orderings = orderings
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OrderByClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Order" keyword
        ''' </summary>
        Friend ReadOnly Property OrderKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._orderKeyword
            End Get
        End Property

        ''' <summary>
        ''' The "By" keyword.
        ''' </summary>
        Friend ReadOnly Property ByKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._byKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of OrderExpression's to sort by.
        ''' </summary>
        Friend ReadOnly Property Orderings As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of OrderingSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of OrderingSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of OrderingSyntax)(Me._orderings))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._orderKeyword
                Case 1
                    Return Me._byKeyword
                Case 2
                    Return Me._orderings
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OrderByClauseSyntax(Me.Kind, newErrors, GetAnnotations, _orderKeyword, _byKeyword, _orderings)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OrderByClauseSyntax(Me.Kind, GetDiagnostics, annotations, _orderKeyword, _byKeyword, _orderings)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOrderByClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' An expression to order by, plus an optional ordering. The Kind indicates
    ''' whether to order in ascending or descending order.
    ''' </summary>
    Friend NotInheritable Class OrderingSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _ascendingOrDescendingKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, ascendingOrDescendingKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            If ascendingOrDescendingKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(ascendingOrDescendingKeyword)
                Me._ascendingOrDescendingKeyword = ascendingOrDescendingKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, expression As ExpressionSyntax, ascendingOrDescendingKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            If ascendingOrDescendingKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(ascendingOrDescendingKeyword)
                Me._ascendingOrDescendingKeyword = ascendingOrDescendingKeyword
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), expression As ExpressionSyntax, ascendingOrDescendingKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            If ascendingOrDescendingKeyword IsNot Nothing Then
                AdjustFlagsAndWidth(ascendingOrDescendingKeyword)
                Me._ascendingOrDescendingKeyword = ascendingOrDescendingKeyword
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.OrderingSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The expression to sort by.
        ''' </summary>
        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        ''' <summary>
        ''' The "Ascending" or "Descending" keyword, if present. To determine whether to
        ''' sort in ascending or descending order, checking the Kind property is easier.
        ''' </summary>
        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property AscendingOrDescendingKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._ascendingOrDescendingKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._expression
                Case 1
                    Return Me._ascendingOrDescendingKeyword
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new OrderingSyntax(Me.Kind, newErrors, GetAnnotations, _expression, _ascendingOrDescendingKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new OrderingSyntax(Me.Kind, GetDiagnostics, annotations, _expression, _ascendingOrDescendingKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitOrdering(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the "Select" query operator.
    ''' </summary>
    Friend NotInheritable Class SelectClauseSyntax
        Inherits QueryClauseSyntax

        Friend ReadOnly _selectKeyword as KeywordSyntax
        Friend ReadOnly _variables as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, selectKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, selectKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), selectKeyword As InternalSyntax.KeywordSyntax, variables As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(selectKeyword)
            Me._selectKeyword = selectKeyword
            If variables IsNot Nothing Then
                AdjustFlagsAndWidth(variables)
                Me._variables = variables
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.SelectClauseSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Select" keyword.
        ''' </summary>
        Friend ReadOnly Property SelectKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._selectKeyword
            End Get
        End Property

        ''' <summary>
        ''' The list of expression range variables being defined by the Select query
        ''' operator.
        ''' </summary>
        Friend ReadOnly Property Variables As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList(Of ExpressionRangeVariableSyntax)(New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of ExpressionRangeVariableSyntax)(Me._variables))
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._selectKeyword
                Case 1
                    Return Me._variables
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new SelectClauseSyntax(Me.Kind, newErrors, GetAnnotations, _selectKeyword, _variables)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new SelectClauseSyntax(Me.Kind, GetDiagnostics, annotations, _selectKeyword, _variables)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitSelectClause(Me)
        End Function

    End Class

    ''' <summary>
    ''' This is the base class for all XML expression syntax nodes (XmlDocument and
    ''' XmlElement).
    ''' </summary>
    Friend MustInherit Class XmlNodeSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an XML Document literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlDocumentSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _declaration as XmlDeclarationSyntax
        Friend ReadOnly _precedingMisc as GreenNode
        Friend ReadOnly _root as XmlNodeSyntax
        Friend ReadOnly _followingMisc as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, declaration As XmlDeclarationSyntax, precedingMisc As GreenNode, root As XmlNodeSyntax, followingMisc As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(declaration)
            Me._declaration = declaration
            If precedingMisc IsNot Nothing Then
                AdjustFlagsAndWidth(precedingMisc)
                Me._precedingMisc = precedingMisc
            End If
            AdjustFlagsAndWidth(root)
            Me._root = root
            If followingMisc IsNot Nothing Then
                AdjustFlagsAndWidth(followingMisc)
                Me._followingMisc = followingMisc
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, declaration As XmlDeclarationSyntax, precedingMisc As GreenNode, root As XmlNodeSyntax, followingMisc As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(declaration)
            Me._declaration = declaration
            If precedingMisc IsNot Nothing Then
                AdjustFlagsAndWidth(precedingMisc)
                Me._precedingMisc = precedingMisc
            End If
            AdjustFlagsAndWidth(root)
            Me._root = root
            If followingMisc IsNot Nothing Then
                AdjustFlagsAndWidth(followingMisc)
                Me._followingMisc = followingMisc
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), declaration As XmlDeclarationSyntax, precedingMisc As GreenNode, root As XmlNodeSyntax, followingMisc As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(declaration)
            Me._declaration = declaration
            If precedingMisc IsNot Nothing Then
                AdjustFlagsAndWidth(precedingMisc)
                Me._precedingMisc = precedingMisc
            End If
            AdjustFlagsAndWidth(root)
            Me._root = root
            If followingMisc IsNot Nothing Then
                AdjustFlagsAndWidth(followingMisc)
                Me._followingMisc = followingMisc
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlDocumentSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property Declaration As InternalSyntax.XmlDeclarationSyntax
            Get
                Return Me._declaration
            End Get
        End Property

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property PrecedingMisc As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)(Me._precedingMisc)
            End Get
        End Property

        Friend ReadOnly Property Root As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._root
            End Get
        End Property

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property FollowingMisc As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)(Me._followingMisc)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._declaration
                Case 1
                    Return Me._precedingMisc
                Case 2
                    Return Me._root
                Case 3
                    Return Me._followingMisc
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlDocumentSyntax(Me.Kind, newErrors, GetAnnotations, _declaration, _precedingMisc, _root, _followingMisc)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlDocumentSyntax(Me.Kind, GetDiagnostics, annotations, _declaration, _precedingMisc, _root, _followingMisc)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlDocument(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the XML declaration prologue in an XML literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlDeclarationSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _lessThanQuestionToken as PunctuationSyntax
        Friend ReadOnly _xmlKeyword as KeywordSyntax
        Friend ReadOnly _version as XmlDeclarationOptionSyntax
        Friend ReadOnly _encoding as XmlDeclarationOptionSyntax
        Friend ReadOnly _standalone as XmlDeclarationOptionSyntax
        Friend ReadOnly _questionGreaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanQuestionToken As InternalSyntax.PunctuationSyntax, xmlKeyword As InternalSyntax.KeywordSyntax, version As XmlDeclarationOptionSyntax, encoding As XmlDeclarationOptionSyntax, standalone As XmlDeclarationOptionSyntax, questionGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(lessThanQuestionToken)
            Me._lessThanQuestionToken = lessThanQuestionToken
            AdjustFlagsAndWidth(xmlKeyword)
            Me._xmlKeyword = xmlKeyword
            AdjustFlagsAndWidth(version)
            Me._version = version
            If encoding IsNot Nothing Then
                AdjustFlagsAndWidth(encoding)
                Me._encoding = encoding
            End If
            If standalone IsNot Nothing Then
                AdjustFlagsAndWidth(standalone)
                Me._standalone = standalone
            End If
            AdjustFlagsAndWidth(questionGreaterThanToken)
            Me._questionGreaterThanToken = questionGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanQuestionToken As InternalSyntax.PunctuationSyntax, xmlKeyword As InternalSyntax.KeywordSyntax, version As XmlDeclarationOptionSyntax, encoding As XmlDeclarationOptionSyntax, standalone As XmlDeclarationOptionSyntax, questionGreaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 6
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanQuestionToken)
            Me._lessThanQuestionToken = lessThanQuestionToken
            AdjustFlagsAndWidth(xmlKeyword)
            Me._xmlKeyword = xmlKeyword
            AdjustFlagsAndWidth(version)
            Me._version = version
            If encoding IsNot Nothing Then
                AdjustFlagsAndWidth(encoding)
                Me._encoding = encoding
            End If
            If standalone IsNot Nothing Then
                AdjustFlagsAndWidth(standalone)
                Me._standalone = standalone
            End If
            AdjustFlagsAndWidth(questionGreaterThanToken)
            Me._questionGreaterThanToken = questionGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanQuestionToken As InternalSyntax.PunctuationSyntax, xmlKeyword As InternalSyntax.KeywordSyntax, version As XmlDeclarationOptionSyntax, encoding As XmlDeclarationOptionSyntax, standalone As XmlDeclarationOptionSyntax, questionGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 6

            AdjustFlagsAndWidth(lessThanQuestionToken)
            Me._lessThanQuestionToken = lessThanQuestionToken
            AdjustFlagsAndWidth(xmlKeyword)
            Me._xmlKeyword = xmlKeyword
            AdjustFlagsAndWidth(version)
            Me._version = version
            If encoding IsNot Nothing Then
                AdjustFlagsAndWidth(encoding)
                Me._encoding = encoding
            End If
            If standalone IsNot Nothing Then
                AdjustFlagsAndWidth(standalone)
                Me._standalone = standalone
            End If
            AdjustFlagsAndWidth(questionGreaterThanToken)
            Me._questionGreaterThanToken = questionGreaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlDeclarationSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanQuestionToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanQuestionToken
            End Get
        End Property

        Friend ReadOnly Property XmlKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._xmlKeyword
            End Get
        End Property

        Friend ReadOnly Property Version As InternalSyntax.XmlDeclarationOptionSyntax
            Get
                Return Me._version
            End Get
        End Property

        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Encoding As InternalSyntax.XmlDeclarationOptionSyntax
            Get
                Return Me._encoding
            End Get
        End Property

        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Standalone As InternalSyntax.XmlDeclarationOptionSyntax
            Get
                Return Me._standalone
            End Get
        End Property

        Friend ReadOnly Property QuestionGreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._questionGreaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanQuestionToken
                Case 1
                    Return Me._xmlKeyword
                Case 2
                    Return Me._version
                Case 3
                    Return Me._encoding
                Case 4
                    Return Me._standalone
                Case 5
                    Return Me._questionGreaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlDeclarationSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanQuestionToken, _xmlKeyword, _version, _encoding, _standalone, _questionGreaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlDeclarationSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanQuestionToken, _xmlKeyword, _version, _encoding, _standalone, _questionGreaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlDeclaration(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML document prologue option - version, encoding, standalone or
    ''' whitespace in an XML literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlDeclarationOptionSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _name as XmlNameTokenSyntax
        Friend ReadOnly _equals as PunctuationSyntax
        Friend ReadOnly _value as XmlStringSyntax

        Friend Sub New(ByVal kind As SyntaxKind, name As InternalSyntax.XmlNameTokenSyntax, equals As InternalSyntax.PunctuationSyntax, value As XmlStringSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equals)
            Me._equals = equals
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, name As InternalSyntax.XmlNameTokenSyntax, equals As InternalSyntax.PunctuationSyntax, value As XmlStringSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equals)
            Me._equals = equals
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), name As InternalSyntax.XmlNameTokenSyntax, equals As InternalSyntax.PunctuationSyntax, value As XmlStringSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equals)
            Me._equals = equals
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlDeclarationOptionSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property Name As InternalSyntax.XmlNameTokenSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Shadows ReadOnly Property Equals As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equals
            End Get
        End Property

        Friend ReadOnly Property Value As InternalSyntax.XmlStringSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._name
                Case 1
                    Return Me._equals
                Case 2
                    Return Me._value
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlDeclarationOptionSyntax(Me.Kind, newErrors, GetAnnotations, _name, _equals, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlDeclarationOptionSyntax(Me.Kind, GetDiagnostics, annotations, _name, _equals, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlDeclarationOption(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML element with content in an XML literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlElementSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _startTag as XmlElementStartTagSyntax
        Friend ReadOnly _content as GreenNode
        Friend ReadOnly _endTag as XmlElementEndTagSyntax

        Friend Sub New(ByVal kind As SyntaxKind, startTag As XmlElementStartTagSyntax, content As GreenNode, endTag As XmlElementEndTagSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(startTag)
            Me._startTag = startTag
            If content IsNot Nothing Then
                AdjustFlagsAndWidth(content)
                Me._content = content
            End If
            AdjustFlagsAndWidth(endTag)
            Me._endTag = endTag

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, startTag As XmlElementStartTagSyntax, content As GreenNode, endTag As XmlElementEndTagSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(startTag)
            Me._startTag = startTag
            If content IsNot Nothing Then
                AdjustFlagsAndWidth(content)
                Me._content = content
            End If
            AdjustFlagsAndWidth(endTag)
            Me._endTag = endTag

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), startTag As XmlElementStartTagSyntax, content As GreenNode, endTag As XmlElementEndTagSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(startTag)
            Me._startTag = startTag
            If content IsNot Nothing Then
                AdjustFlagsAndWidth(content)
                Me._content = content
            End If
            AdjustFlagsAndWidth(endTag)
            Me._endTag = endTag

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlElementSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property StartTag As InternalSyntax.XmlElementStartTagSyntax
            Get
                Return Me._startTag
            End Get
        End Property

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Content As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)(Me._content)
            End Get
        End Property

        Friend ReadOnly Property EndTag As InternalSyntax.XmlElementEndTagSyntax
            Get
                Return Me._endTag
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._startTag
                Case 1
                    Return Me._content
                Case 2
                    Return Me._endTag
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlElementSyntax(Me.Kind, newErrors, GetAnnotations, _startTag, _content, _endTag)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlElementSyntax(Me.Kind, GetDiagnostics, annotations, _startTag, _content, _endTag)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlElement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents Xml text.
    ''' </summary>
    Friend NotInheritable Class XmlTextSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _textTokens as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, textTokens As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 1

            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, textTokens As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), textTokens As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlTextSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' A list of all the text tokens in the Xml text. This list always contains at
        ''' least one token.
        ''' </summary>
        Friend ReadOnly Property TextTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlTextTokenSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._textTokens)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._textTokens
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlTextSyntax(Me.Kind, newErrors, GetAnnotations, _textTokens)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlTextSyntax(Me.Kind, GetDiagnostics, annotations, _textTokens)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlText(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the start tag of an XML element of the form &lt;element&gt;.
    ''' </summary>
    Friend NotInheritable Class XmlElementStartTagSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _name as XmlNodeSyntax
        Friend ReadOnly _attributes as GreenNode
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, attributes As GreenNode, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlElementStartTagSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        Friend ReadOnly Property Name As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Attributes As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)(Me._attributes)
            End Get
        End Property

        Friend ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._name
                Case 2
                    Return Me._attributes
                Case 3
                    Return Me._greaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlElementStartTagSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _name, _attributes, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlElementStartTagSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _name, _attributes, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlElementStartTag(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents the end tag of an XML element of the form &lt;/element&gt;.
    ''' </summary>
    Friend NotInheritable Class XmlElementEndTagSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanSlashToken as PunctuationSyntax
        Friend ReadOnly _name as XmlNameSyntax
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanSlashToken As InternalSyntax.PunctuationSyntax, name As XmlNameSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanSlashToken)
            Me._lessThanSlashToken = lessThanSlashToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanSlashToken As InternalSyntax.PunctuationSyntax, name As XmlNameSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanSlashToken)
            Me._lessThanSlashToken = lessThanSlashToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanSlashToken As InternalSyntax.PunctuationSyntax, name As XmlNameSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanSlashToken)
            Me._lessThanSlashToken = lessThanSlashToken
            If name IsNot Nothing Then
                AdjustFlagsAndWidth(name)
                Me._name = name
            End If
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlElementEndTagSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanSlashToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanSlashToken
            End Get
        End Property

        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Name As InternalSyntax.XmlNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanSlashToken
                Case 1
                    Return Me._name
                Case 2
                    Return Me._greaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlElementEndTagSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanSlashToken, _name, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlElementEndTagSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanSlashToken, _name, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlElementEndTag(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an empty XML element of the form &lt;element /&gt;
    ''' </summary>
    Friend NotInheritable Class XmlEmptyElementSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _name as XmlNodeSyntax
        Friend ReadOnly _attributes as GreenNode
        Friend ReadOnly _slashGreaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, attributes As GreenNode, slashGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(slashGreaterThanToken)
            Me._slashGreaterThanToken = slashGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, attributes As GreenNode, slashGreaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(slashGreaterThanToken)
            Me._slashGreaterThanToken = slashGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNodeSyntax, attributes As GreenNode, slashGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If attributes IsNot Nothing Then
                AdjustFlagsAndWidth(attributes)
                Me._attributes = attributes
            End If
            AdjustFlagsAndWidth(slashGreaterThanToken)
            Me._slashGreaterThanToken = slashGreaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlEmptyElementSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        Friend ReadOnly Property Name As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._name
            End Get
        End Property

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property Attributes As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlNodeSyntax)(Me._attributes)
            End Get
        End Property

        Friend ReadOnly Property SlashGreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._slashGreaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._name
                Case 2
                    Return Me._attributes
                Case 3
                    Return Me._slashGreaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlEmptyElementSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _name, _attributes, _slashGreaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlEmptyElementSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _name, _attributes, _slashGreaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlEmptyElement(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML attribute in an XML literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlAttributeSyntax
        Inherits BaseXmlAttributeSyntax

        Friend ReadOnly _name as XmlNodeSyntax
        Friend ReadOnly _equalsToken as PunctuationSyntax
        Friend ReadOnly _value as XmlNodeSyntax

        Friend Sub New(ByVal kind As SyntaxKind, name As XmlNodeSyntax, equalsToken As InternalSyntax.PunctuationSyntax, value As XmlNodeSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, name As XmlNodeSyntax, equalsToken As InternalSyntax.PunctuationSyntax, value As XmlNodeSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), name As XmlNodeSyntax, equalsToken As InternalSyntax.PunctuationSyntax, value As XmlNodeSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(equalsToken)
            Me._equalsToken = equalsToken
            AdjustFlagsAndWidth(value)
            Me._value = value

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlAttributeSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property Name As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend ReadOnly Property EqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._equalsToken
            End Get
        End Property

        Friend ReadOnly Property Value As InternalSyntax.XmlNodeSyntax
            Get
                Return Me._value
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._name
                Case 1
                    Return Me._equalsToken
                Case 2
                    Return Me._value
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlAttributeSyntax(Me.Kind, newErrors, GetAnnotations, _name, _equalsToken, _value)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlAttributeSyntax(Me.Kind, GetDiagnostics, annotations, _name, _equalsToken, _value)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlAttribute(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML attribute in an XML literal expression.
    ''' </summary>
    Friend MustInherit Class BaseXmlAttributeSyntax
        Inherits XmlNodeSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents a string of XML characters embedded as the content of an XML
    ''' element.
    ''' </summary>
    Friend NotInheritable Class XmlStringSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _startQuoteToken as PunctuationSyntax
        Friend ReadOnly _textTokens as GreenNode
        Friend ReadOnly _endQuoteToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, startQuoteToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, endQuoteToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(startQuoteToken)
            Me._startQuoteToken = startQuoteToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(endQuoteToken)
            Me._endQuoteToken = endQuoteToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, startQuoteToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, endQuoteToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(startQuoteToken)
            Me._startQuoteToken = startQuoteToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(endQuoteToken)
            Me._endQuoteToken = endQuoteToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), startQuoteToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, endQuoteToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(startQuoteToken)
            Me._startQuoteToken = startQuoteToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(endQuoteToken)
            Me._endQuoteToken = endQuoteToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlStringSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property StartQuoteToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._startQuoteToken
            End Get
        End Property

        ''' <remarks>
        ''' If nothing is present, an empty list is returned.
        ''' </remarks>
        Friend ReadOnly Property TextTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlTextTokenSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._textTokens)
            End Get
        End Property

        Friend ReadOnly Property EndQuoteToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._endQuoteToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._startQuoteToken
                Case 1
                    Return Me._textTokens
                Case 2
                    Return Me._endQuoteToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlStringSyntax(Me.Kind, newErrors, GetAnnotations, _startQuoteToken, _textTokens, _endQuoteToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlStringSyntax(Me.Kind, GetDiagnostics, annotations, _startQuoteToken, _textTokens, _endQuoteToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlString(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML name of the form 'name' appearing in GetXmlNamespace().
    ''' </summary>
    Friend NotInheritable Class XmlPrefixNameSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _name as XmlNameTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, name As InternalSyntax.XmlNameTokenSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, name As InternalSyntax.XmlNameTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), name As InternalSyntax.XmlNameTokenSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(name)
            Me._name = name

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlPrefixNameSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property Name As InternalSyntax.XmlNameTokenSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._name
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlPrefixNameSyntax(Me.Kind, newErrors, GetAnnotations, _name)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlPrefixNameSyntax(Me.Kind, GetDiagnostics, annotations, _name)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlPrefixName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML name of the form 'name' or 'namespace:name' appearing in
    ''' source as part of an XML literal or member access expression or an XML
    ''' namespace import clause.
    ''' </summary>
    Friend NotInheritable Class XmlNameSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _prefix as XmlPrefixSyntax
        Friend ReadOnly _localName as XmlNameTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, prefix As XmlPrefixSyntax, localName As InternalSyntax.XmlNameTokenSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            If prefix IsNot Nothing Then
                AdjustFlagsAndWidth(prefix)
                Me._prefix = prefix
            End If
            AdjustFlagsAndWidth(localName)
            Me._localName = localName

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, prefix As XmlPrefixSyntax, localName As InternalSyntax.XmlNameTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            If prefix IsNot Nothing Then
                AdjustFlagsAndWidth(prefix)
                Me._prefix = prefix
            End If
            AdjustFlagsAndWidth(localName)
            Me._localName = localName

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), prefix As XmlPrefixSyntax, localName As InternalSyntax.XmlNameTokenSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            If prefix IsNot Nothing Then
                AdjustFlagsAndWidth(prefix)
                Me._prefix = prefix
            End If
            AdjustFlagsAndWidth(localName)
            Me._localName = localName

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlNameSyntax(Me, parent, startLocation)
        End Function

        ''' <remarks>
        ''' This child is optional. If it is not present, then Nothing is returned.
        ''' </remarks>
        Friend ReadOnly Property Prefix As InternalSyntax.XmlPrefixSyntax
            Get
                Return Me._prefix
            End Get
        End Property

        Friend ReadOnly Property LocalName As InternalSyntax.XmlNameTokenSyntax
            Get
                Return Me._localName
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._prefix
                Case 1
                    Return Me._localName
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlNameSyntax(Me.Kind, newErrors, GetAnnotations, _prefix, _localName)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlNameSyntax(Me.Kind, GetDiagnostics, annotations, _prefix, _localName)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML name of the form &lt;xml-name&gt; appearing in source as part
    ''' of an XML literal or member access expression or an XML namespace import
    ''' clause.
    ''' </summary>
    Friend NotInheritable Class XmlBracketedNameSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanToken as PunctuationSyntax
        Friend ReadOnly _name as XmlNameSyntax
        Friend ReadOnly _greaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNameSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNameSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanToken As InternalSyntax.PunctuationSyntax, name As XmlNameSyntax, greaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanToken)
            Me._lessThanToken = lessThanToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(greaterThanToken)
            Me._greaterThanToken = greaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlBracketedNameSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanToken
            End Get
        End Property

        Friend ReadOnly Property Name As InternalSyntax.XmlNameSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend ReadOnly Property GreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._greaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanToken
                Case 1
                    Return Me._name
                Case 2
                    Return Me._greaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlBracketedNameSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanToken, _name, _greaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlBracketedNameSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanToken, _name, _greaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlBracketedName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML namespace prefix of the form 'prefix:' as in xml:ns="".
    ''' </summary>
    Friend NotInheritable Class XmlPrefixSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _name as XmlNameTokenSyntax
        Friend ReadOnly _colonToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, name As InternalSyntax.XmlNameTokenSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, name As InternalSyntax.XmlNameTokenSyntax, colonToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), name As InternalSyntax.XmlNameTokenSyntax, colonToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(name)
            Me._name = name
            AdjustFlagsAndWidth(colonToken)
            Me._colonToken = colonToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlPrefixSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property Name As InternalSyntax.XmlNameTokenSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend ReadOnly Property ColonToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._colonToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._name
                Case 1
                    Return Me._colonToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlPrefixSyntax(Me.Kind, newErrors, GetAnnotations, _name, _colonToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlPrefixSyntax(Me.Kind, GetDiagnostics, annotations, _name, _colonToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlPrefix(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML comment of the form &lt;!-- Comment --&gt; appearing in an
    ''' XML literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlCommentSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanExclamationMinusMinusToken as PunctuationSyntax
        Friend ReadOnly _textTokens as GreenNode
        Friend ReadOnly _minusMinusGreaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanExclamationMinusMinusToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, minusMinusGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanExclamationMinusMinusToken)
            Me._lessThanExclamationMinusMinusToken = lessThanExclamationMinusMinusToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(minusMinusGreaterThanToken)
            Me._minusMinusGreaterThanToken = minusMinusGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanExclamationMinusMinusToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, minusMinusGreaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanExclamationMinusMinusToken)
            Me._lessThanExclamationMinusMinusToken = lessThanExclamationMinusMinusToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(minusMinusGreaterThanToken)
            Me._minusMinusGreaterThanToken = minusMinusGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanExclamationMinusMinusToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, minusMinusGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanExclamationMinusMinusToken)
            Me._lessThanExclamationMinusMinusToken = lessThanExclamationMinusMinusToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(minusMinusGreaterThanToken)
            Me._minusMinusGreaterThanToken = minusMinusGreaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlCommentSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanExclamationMinusMinusToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanExclamationMinusMinusToken
            End Get
        End Property

        Friend ReadOnly Property TextTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlTextTokenSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._textTokens)
            End Get
        End Property

        Friend ReadOnly Property MinusMinusGreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._minusMinusGreaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanExclamationMinusMinusToken
                Case 1
                    Return Me._textTokens
                Case 2
                    Return Me._minusMinusGreaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlCommentSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanExclamationMinusMinusToken, _textTokens, _minusMinusGreaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlCommentSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanExclamationMinusMinusToken, _textTokens, _minusMinusGreaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlComment(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML processing instruction of the form '&lt;? XMLProcessingTarget
    ''' XMLProcessingValue ?&gt;'.
    ''' </summary>
    Friend NotInheritable Class XmlProcessingInstructionSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanQuestionToken as PunctuationSyntax
        Friend ReadOnly _name as XmlNameTokenSyntax
        Friend ReadOnly _textTokens as GreenNode
        Friend ReadOnly _questionGreaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanQuestionToken As InternalSyntax.PunctuationSyntax, name As InternalSyntax.XmlNameTokenSyntax, textTokens As GreenNode, questionGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(lessThanQuestionToken)
            Me._lessThanQuestionToken = lessThanQuestionToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(questionGreaterThanToken)
            Me._questionGreaterThanToken = questionGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanQuestionToken As InternalSyntax.PunctuationSyntax, name As InternalSyntax.XmlNameTokenSyntax, textTokens As GreenNode, questionGreaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanQuestionToken)
            Me._lessThanQuestionToken = lessThanQuestionToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(questionGreaterThanToken)
            Me._questionGreaterThanToken = questionGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanQuestionToken As InternalSyntax.PunctuationSyntax, name As InternalSyntax.XmlNameTokenSyntax, textTokens As GreenNode, questionGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(lessThanQuestionToken)
            Me._lessThanQuestionToken = lessThanQuestionToken
            AdjustFlagsAndWidth(name)
            Me._name = name
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(questionGreaterThanToken)
            Me._questionGreaterThanToken = questionGreaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlProcessingInstructionSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanQuestionToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanQuestionToken
            End Get
        End Property

        Friend ReadOnly Property Name As InternalSyntax.XmlNameTokenSyntax
            Get
                Return Me._name
            End Get
        End Property

        Friend ReadOnly Property TextTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlTextTokenSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._textTokens)
            End Get
        End Property

        Friend ReadOnly Property QuestionGreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._questionGreaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanQuestionToken
                Case 1
                    Return Me._name
                Case 2
                    Return Me._textTokens
                Case 3
                    Return Me._questionGreaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlProcessingInstructionSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanQuestionToken, _name, _textTokens, _questionGreaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlProcessingInstructionSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanQuestionToken, _name, _textTokens, _questionGreaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlProcessingInstruction(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an XML CDATA section in an XML literal expression.
    ''' </summary>
    Friend NotInheritable Class XmlCDataSectionSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _beginCDataToken as PunctuationSyntax
        Friend ReadOnly _textTokens as GreenNode
        Friend ReadOnly _endCDataToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, beginCDataToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, endCDataToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(beginCDataToken)
            Me._beginCDataToken = beginCDataToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(endCDataToken)
            Me._endCDataToken = endCDataToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, beginCDataToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, endCDataToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(beginCDataToken)
            Me._beginCDataToken = beginCDataToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(endCDataToken)
            Me._endCDataToken = endCDataToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), beginCDataToken As InternalSyntax.PunctuationSyntax, textTokens As GreenNode, endCDataToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(beginCDataToken)
            Me._beginCDataToken = beginCDataToken
            If textTokens IsNot Nothing Then
                AdjustFlagsAndWidth(textTokens)
                Me._textTokens = textTokens
            End If
            AdjustFlagsAndWidth(endCDataToken)
            Me._endCDataToken = endCDataToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlCDataSectionSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property BeginCDataToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._beginCDataToken
            End Get
        End Property

        Friend ReadOnly Property TextTokens As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of XmlTextTokenSyntax)
            Get
                Return New Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(of GreenNode)(Me._textTokens)
            End Get
        End Property

        Friend ReadOnly Property EndCDataToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._endCDataToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._beginCDataToken
                Case 1
                    Return Me._textTokens
                Case 2
                    Return Me._endCDataToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlCDataSectionSyntax(Me.Kind, newErrors, GetAnnotations, _beginCDataToken, _textTokens, _endCDataToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlCDataSectionSyntax(Me.Kind, GetDiagnostics, annotations, _beginCDataToken, _textTokens, _endCDataToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlCDataSection(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an embedded expression in an XML literal e.g. '&lt;name&gt;&lt;%=
    ''' obj.Name =%&gt;&lt;/name&gt;'.
    ''' </summary>
    Friend NotInheritable Class XmlEmbeddedExpressionSyntax
        Inherits XmlNodeSyntax

        Friend ReadOnly _lessThanPercentEqualsToken as PunctuationSyntax
        Friend ReadOnly _expression as ExpressionSyntax
        Friend ReadOnly _percentGreaterThanToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, lessThanPercentEqualsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, percentGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanPercentEqualsToken)
            Me._lessThanPercentEqualsToken = lessThanPercentEqualsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(percentGreaterThanToken)
            Me._percentGreaterThanToken = percentGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, lessThanPercentEqualsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, percentGreaterThanToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(lessThanPercentEqualsToken)
            Me._lessThanPercentEqualsToken = lessThanPercentEqualsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(percentGreaterThanToken)
            Me._percentGreaterThanToken = percentGreaterThanToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), lessThanPercentEqualsToken As InternalSyntax.PunctuationSyntax, expression As ExpressionSyntax, percentGreaterThanToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(lessThanPercentEqualsToken)
            Me._lessThanPercentEqualsToken = lessThanPercentEqualsToken
            AdjustFlagsAndWidth(expression)
            Me._expression = expression
            AdjustFlagsAndWidth(percentGreaterThanToken)
            Me._percentGreaterThanToken = percentGreaterThanToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.XmlEmbeddedExpressionSyntax(Me, parent, startLocation)
        End Function

        Friend ReadOnly Property LessThanPercentEqualsToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._lessThanPercentEqualsToken
            End Get
        End Property

        Friend ReadOnly Property Expression As InternalSyntax.ExpressionSyntax
            Get
                Return Me._expression
            End Get
        End Property

        Friend ReadOnly Property PercentGreaterThanToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._percentGreaterThanToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._lessThanPercentEqualsToken
                Case 1
                    Return Me._expression
                Case 2
                    Return Me._percentGreaterThanToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new XmlEmbeddedExpressionSyntax(Me.Kind, newErrors, GetAnnotations, _lessThanPercentEqualsToken, _expression, _percentGreaterThanToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new XmlEmbeddedExpressionSyntax(Me.Kind, GetDiagnostics, annotations, _lessThanPercentEqualsToken, _expression, _percentGreaterThanToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitXmlEmbeddedExpression(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract node class that represents the textual description of a type, possibly
    ''' include generic type arguments, qualified names, array specifiers, nullable
    ''' specifier and the like.
    ''' </summary>
    Friend MustInherit Class TypeSyntax
        Inherits ExpressionSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Represents an array type, such as "A() or "A(,)", without bounds specified for
    ''' the array.
    ''' </summary>
    Friend NotInheritable Class ArrayTypeSyntax
        Inherits TypeSyntax

        Friend ReadOnly _elementType as TypeSyntax
        Friend ReadOnly _rankSpecifiers as GreenNode

        Friend Sub New(ByVal kind As SyntaxKind, elementType As TypeSyntax, rankSpecifiers As GreenNode)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elementType)
            Me._elementType = elementType
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elementType As TypeSyntax, rankSpecifiers As GreenNode, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elementType)
            Me._elementType = elementType
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elementType As TypeSyntax, rankSpecifiers As GreenNode)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elementType)
            Me._elementType = elementType
            If rankSpecifiers IsNot Nothing Then
                AdjustFlagsAndWidth(rankSpecifiers)
                Me._rankSpecifiers = rankSpecifiers
            End If

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.ArrayTypeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The type of the elements of the array.
        ''' </summary>
        Friend ReadOnly Property ElementType As InternalSyntax.TypeSyntax
            Get
                Return Me._elementType
            End Get
        End Property

        ''' <summary>
        ''' Represents the list of "()" or "(,,)" modifiers on the array type.
        ''' </summary>
        Friend ReadOnly Property RankSpecifiers As Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)
            Get
                Return new Global.Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList(Of ArrayRankSpecifierSyntax)(Me._rankSpecifiers)
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elementType
                Case 1
                    Return Me._rankSpecifiers
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new ArrayTypeSyntax(Me.Kind, newErrors, GetAnnotations, _elementType, _rankSpecifiers)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new ArrayTypeSyntax(Me.Kind, GetDiagnostics, annotations, _elementType, _rankSpecifiers)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitArrayType(Me)
        End Function

    End Class

    ''' <summary>
    ''' A type name that represents a nullable type, such as "Integer?".
    ''' </summary>
    Friend NotInheritable Class NullableTypeSyntax
        Inherits TypeSyntax

        Friend ReadOnly _elementType as TypeSyntax
        Friend ReadOnly _questionMarkToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, elementType As TypeSyntax, questionMarkToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elementType)
            Me._elementType = elementType
            AdjustFlagsAndWidth(questionMarkToken)
            Me._questionMarkToken = questionMarkToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, elementType As TypeSyntax, questionMarkToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(elementType)
            Me._elementType = elementType
            AdjustFlagsAndWidth(questionMarkToken)
            Me._questionMarkToken = questionMarkToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), elementType As TypeSyntax, questionMarkToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(elementType)
            Me._elementType = elementType
            AdjustFlagsAndWidth(questionMarkToken)
            Me._questionMarkToken = questionMarkToken

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.NullableTypeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The kind of type that is this type is a nullable of. Cannot be an array type or
        ''' a nullable type.
        ''' </summary>
        Friend ReadOnly Property ElementType As InternalSyntax.TypeSyntax
            Get
                Return Me._elementType
            End Get
        End Property

        ''' <summary>
        ''' The "?" token.
        ''' </summary>
        Friend ReadOnly Property QuestionMarkToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._questionMarkToken
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._elementType
                Case 1
                    Return Me._questionMarkToken
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new NullableTypeSyntax(Me.Kind, newErrors, GetAnnotations, _elementType, _questionMarkToken)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new NullableTypeSyntax(Me.Kind, GetDiagnostics, annotations, _elementType, _questionMarkToken)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitNullableType(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents an occurrence of a Visual Basic built-in type such as Integer or
    ''' String in source code.
    ''' </summary>
    Friend NotInheritable Class PredefinedTypeSyntax
        Inherits TypeSyntax

        Friend ReadOnly _keyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, keyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), keyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(keyword)
            Me._keyword = keyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.PredefinedTypeSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The keyword that was used to describe the built-in type.
        ''' </summary>
        Friend ReadOnly Property Keyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._keyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._keyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new PredefinedTypeSyntax(Me.Kind, newErrors, GetAnnotations, _keyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new PredefinedTypeSyntax(Me.Kind, GetDiagnostics, annotations, _keyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitPredefinedType(Me)
        End Function

    End Class

    ''' <summary>
    ''' Abstract node class that represents a name, possibly include generic arguments
    ''' and qualified names.
    ''' </summary>
    Friend MustInherit Class NameSyntax
        Inherits TypeSyntax


        Friend Sub New(ByVal kind As SyntaxKind)
            MyBase.New(kind)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation())
            MyBase.New(kind, errors, annotations)
        End Sub

    End Class

    ''' <summary>
    ''' Abstract node class that represents a name, possibly include generic arguments.
    ''' </summary>
    Friend MustInherit Class SimpleNameSyntax
        Inherits NameSyntax

        Friend ReadOnly _identifier as IdentifierTokenSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, errors, annotations)

            AdjustFlagsAndWidth(identifier)
            Me._identifier = identifier

        End Sub

        ''' <summary>
        ''' The identifier in the name.
        ''' </summary>
        Friend ReadOnly Property Identifier As InternalSyntax.IdentifierTokenSyntax
            Get
                Return Me._identifier
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Represents a type name consisting of a single identifier (which might include
    ''' brackets or a type character).
    ''' </summary>
    Friend NotInheritable Class IdentifierNameSyntax
        Inherits SimpleNameSyntax


        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, identifier)
            Me.SlotCount = 1
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, identifier)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)
        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax)
            MyBase.New(kind, errors, annotations, identifier)
            Me.SlotCount = 1
        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.IdentifierNameSyntax(Me, parent, startLocation)
        End Function

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._identifier
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new IdentifierNameSyntax(Me.Kind, newErrors, GetAnnotations, _identifier)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new IdentifierNameSyntax(Me.Kind, GetDiagnostics, annotations, _identifier)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitIdentifierName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a simple type name with one or more generic arguments, such as "X(Of
    ''' Y, Z).
    ''' </summary>
    Friend NotInheritable Class GenericNameSyntax
        Inherits SimpleNameSyntax

        Friend ReadOnly _typeArgumentList as TypeArgumentListSyntax

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, typeArgumentList As TypeArgumentListSyntax)
            MyBase.New(kind, identifier)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(typeArgumentList)
            Me._typeArgumentList = typeArgumentList

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, identifier As InternalSyntax.IdentifierTokenSyntax, typeArgumentList As TypeArgumentListSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind, identifier)
            Me.SlotCount = 2
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(typeArgumentList)
            Me._typeArgumentList = typeArgumentList

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), identifier As InternalSyntax.IdentifierTokenSyntax, typeArgumentList As TypeArgumentListSyntax)
            MyBase.New(kind, errors, annotations, identifier)
            Me.SlotCount = 2

            AdjustFlagsAndWidth(typeArgumentList)
            Me._typeArgumentList = typeArgumentList

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GenericNameSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The generic argument list.
        ''' </summary>
        Friend ReadOnly Property TypeArgumentList As InternalSyntax.TypeArgumentListSyntax
            Get
                Return Me._typeArgumentList
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._identifier
                Case 1
                    Return Me._typeArgumentList
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GenericNameSyntax(Me.Kind, newErrors, GetAnnotations, _identifier, _typeArgumentList)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GenericNameSyntax(Me.Kind, GetDiagnostics, annotations, _identifier, _typeArgumentList)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGenericName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a qualified type name, for example X.Y or X(Of Z).Y.
    ''' </summary>
    Friend NotInheritable Class QualifiedNameSyntax
        Inherits NameSyntax

        Friend ReadOnly _left as NameSyntax
        Friend ReadOnly _dotToken as PunctuationSyntax
        Friend ReadOnly _right as SimpleNameSyntax

        Friend Sub New(ByVal kind As SyntaxKind, left As NameSyntax, dotToken As InternalSyntax.PunctuationSyntax, right As SimpleNameSyntax)
            MyBase.New(kind)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, left As NameSyntax, dotToken As InternalSyntax.PunctuationSyntax, right As SimpleNameSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 3
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), left As NameSyntax, dotToken As InternalSyntax.PunctuationSyntax, right As SimpleNameSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 3

            AdjustFlagsAndWidth(left)
            Me._left = left
            AdjustFlagsAndWidth(dotToken)
            Me._dotToken = dotToken
            AdjustFlagsAndWidth(right)
            Me._right = right

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.QualifiedNameSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The part of the name that appears to the left of the dot. This can itself be
        ''' any name.
        ''' </summary>
        Friend ReadOnly Property Left As InternalSyntax.NameSyntax
            Get
                Return Me._left
            End Get
        End Property

        ''' <summary>
        ''' The "." token that separates the names.
        ''' </summary>
        Friend ReadOnly Property DotToken As InternalSyntax.PunctuationSyntax
            Get
                Return Me._dotToken
            End Get
        End Property

        ''' <summary>
        ''' The part of the name that appears to the right of the dot. This must be a
        ''' simple identifier.
        ''' </summary>
        Friend ReadOnly Property Right As InternalSyntax.SimpleNameSyntax
            Get
                Return Me._right
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            Select case i
                Case 0
                    Return Me._left
                Case 1
                    Return Me._dotToken
                Case 2
                    Return Me._right
                Case Else
                    Debug.Assert(false, "child index out of range")
                    Return Nothing
            End Select
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new QualifiedNameSyntax(Me.Kind, newErrors, GetAnnotations, _left, _dotToken, _right)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new QualifiedNameSyntax(Me.Kind, GetDiagnostics, annotations, _left, _dotToken, _right)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitQualifiedName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a name in the global namespace.
    ''' </summary>
    Friend NotInheritable Class GlobalNameSyntax
        Inherits NameSyntax

        Friend ReadOnly _globalKeyword as KeywordSyntax

        Friend Sub New(ByVal kind As SyntaxKind, globalKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(globalKeyword)
            Me._globalKeyword = globalKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, globalKeyword As InternalSyntax.KeywordSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 1
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(globalKeyword)
            Me._globalKeyword = globalKeyword

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), globalKeyword As InternalSyntax.KeywordSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 1

            AdjustFlagsAndWidth(globalKeyword)
            Me._globalKeyword = globalKeyword

        End Sub

        Friend Overrides Function CreateRed(ByVal parent As SyntaxNode, ByVal startLocation As Integer) As SyntaxNode
            Return new Microsoft.CodeAnalysis.VisualBasic.Syntax.GlobalNameSyntax(Me, parent, startLocation)
        End Function

        ''' <summary>
        ''' The "Global" keyword.
        ''' </summary>
        Friend ReadOnly Property GlobalKeyword As InternalSyntax.KeywordSyntax
            Get
                Return Me._globalKeyword
            End Get
        End Property

        Friend Overrides Function GetSlot(i as Integer) as GreenNode
            If i = 0 Then
                Return Me._globalKeyword
            Else
                Debug.Assert(false, "child index out of range")
                Return Nothing
            End If
        End Function


        Friend Overrides Function SetDiagnostics(ByVal newErrors As DiagnosticInfo()) As GreenNode
            Return new GlobalNameSyntax(Me.Kind, newErrors, GetAnnotations, _globalKeyword)
        End Function

        Friend Overrides Function SetAnnotations(ByVal annotations As SyntaxAnnotation()) As GreenNode
            Return new GlobalNameSyntax(Me.Kind, GetDiagnostics, annotations, _globalKeyword)
        End Function

        Public Overrides Function Accept(ByVal visitor As VisualBasicSyntaxVisitor) As VisualBasicSyntaxNode
            Return visitor.VisitGlobalName(Me)
        End Function

    End Class

    ''' <summary>
    ''' Represents a parenthesized list of generic type arguments.
    ''' </summary>
    Friend NotInheritable Class TypeArgumentListSyntax
        Inherits VisualBasicSyntaxNode

        Friend ReadOnly _openParenToken as PunctuationSyntax
        Friend ReadOnly _ofKeyword as KeywordSyntax
        Friend ReadOnly _arguments as GreenNode
        Friend ReadOnly _closeParenToken as PunctuationSyntax

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax, context As ISyntaxFactoryContext)
            MyBase.New(kind)
            Me.SlotCount = 4
            Me.SetFactoryContext(context)

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = ofKeyword
            If arguments IsNot Nothing Then
                AdjustFlagsAndWidth(arguments)
                Me._arguments = arguments
            End If
            AdjustFlagsAndWidth(closeParenToken)
            Me._closeParenToken = closeParenToken

        End Sub

        Friend Sub New(ByVal kind As SyntaxKind, ByVal errors as DiagnosticInfo(), ByVal annotations as SyntaxAnnotation(), openParenToken As InternalSyntax.PunctuationSyntax, ofKeyword As InternalSyntax.KeywordSyntax, arguments As GreenNode, closeParenToken As InternalSyntax.PunctuationSyntax)
            MyBase.New(kind, errors, annotations)
            Me.SlotCount = 4

            AdjustFlagsAndWidth(openParenToken)
            Me._openParenToken = openParenToken
            AdjustFlagsAndWidth(ofKeyword)
            Me._ofKeyword = of