// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.Arm;
using Xunit;

// Generated by Fuzzlyn v2.2 on 2024-07-29 22:58:13
// Run on Arm64 Linux
// Seed: 8901978342210794942-vectort,vector64,vector128,armadvsimd,armadvsimdarm64,armaes,armarmbase,armarmbasearm64,armcrc32,armcrc32arm64,armdp,armrdm,armrdmarm64,armsha1,armsha256
// Reduced from 221.5 KiB to 0.6 KiB in 00:04:47
// Debug: Outputs <1127468983, 0>
// Release: Outputs <1127468983, 2147483648>

public class Runtime_105716
{
    public static Vector64<float> s_3 = Vector64.Create<float>(-1);

    [Fact]
    public static void TestEntryPoint()
    {
        if (AdvSimd.Arm64.IsSupported)
        {
            var vr3 = Vector64.Create(-179.81139f, 0);
            var vr5 = Vector64.CreateScalar(0f);
            Vector64<float> vr6 = AdvSimd.SubtractScalar(s_3, vr5);
            s_3 = AdvSimd.Arm64.MultiplyExtended(vr3, vr6);
            Assert.Equal(Vector64.Create(179.81139f, 0f), s_3);
        }
    }
}