//Written in the D programming language
/**
 * License: $(HTTP boost.org/LICENSE_1_0.txt, Boost License 1.0).
 *
 * Authors: Dmitry Olshansky
 *
 */
// !!! DO NOT EDIT !!!
// !!! Did you even read the comment? !!!
// This module is automatically generated from Unicode Character Database files
// https://github.com/dlang/phobos/blob/master/tools/unicode_table_generator.d
//dfmt off
module std.internal.unicode_grapheme;
import std.internal.unicode_tables;

package(std):


static if (size_t.sizeof == 4)
{
//832 bytes
enum hangulLVTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000004000000080",
x"
000001000000008000000A00",
x"
000000000002010000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000020001000400030006000500010007000300020005000400070006000200010004000300060005
000100070003000200050004000700060002000100040003000600050001000700030002000500040007000600080001
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000001000000101000000001000000001000000001000000001000000001010000001
010000000010000000010000000010000000010000000010100000010100000000100000000100000000100000000100
000000101000000101000000001000000001000000001000000001000000001010000001010000000010000000010000
000010000000010000000010100000010100000000100000000100000000100000000100000000101000000101000000
001000000001000000001000000001000000001010000001010000000010000000010000000010000000010000000010
010000000010000000010000000010000000010000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//832 bytes
enum hangulLVTTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000004000000080",
x"
000001000000008000000A00",
x"
000000000002010000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000020001000400030006000500010007000300020005000400070006000200010004000300060005
000100070003000200050004000700060002000100040003000600050001000700030002000500040007000600080001
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000EFFFFFFEFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFEFFFFFFE
FEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFEFFFFFFEFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFF
FFFFFFEFEFFFFFFEFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFEFFFFFFEFEFFFFFFFFEFFFFFFFFEFFFF
FFFFEFFFFFFFFEFFFFFFFFEFEFFFFFFEFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFEFFFFFFEFEFFFFFF
FFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFEFFFFFFEFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEF
FEFFFFFFFFEFFFFFFFFEFFFFFFFFEFFFFFFFFEFF0000000F000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//928 bytes
enum prependTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000004000000080",
x"
000001000000008000000D00",
x"
010101000101010101010102010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000002000100000003000000000004000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000060005000700000000000000000000
0008000000000009000A0000000B00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000003F00000000000000000000000000000000000000002000000000000000
000080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000300000000000000000000000000040000000000000000000040000000000000000000000000000000000000000000
000000000000000000000000000000000000000020000000000020000000000000000000000000000000000000000000
00000000000000000000000C000000000000000000000000000000000000000000000000000000000002000000000000
000000008000000000000002000000000000000000000000000000000000000000000000040000000000000000000000
000003F00000000000000000000000000000000000000000000000400000000000000000000000000000000000000000
000000040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//1280 bytes
enum controlTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
0000000000000040000000D0",
x"
000001000000012000000E00",
x"
020201000302020202020402020605020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020702020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000000010001000100010001000200010001000100010001000100010001
000100010001000100010001000100010001000300010001000100010001000100010004000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010006000500010001000100010001000100010001
000100010001000100010001000100010001000100010001000100070001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010008000100010001000100010001000100010001000100010001000100010001000100010001
0009000100010001000100010001000100010001000100010001000100010001000B000A000C000C000C000C000C000C
000C000C000C000C000C000C000C000C0001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
00010001000100010001000100010001FFFFDBFF000000000000000080000000FFFFFFFF000020000000000000000000
000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000
000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000
0000C80000007F00000000000000FFFF0000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000080000000000000000000000000000000000000000000000000000000000000000FFF0000
00000000FFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000F000000000000000000000000000000000000000007F8000000000000000000000000000000000000
FFFFFFFF000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
000000000000000000000000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000000000000000000000000000000000000000000000000000000000000",
);
//1792 bytes
enum spacingMarkTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
0000000000000040000000A0",
x"
00000100000000C000002400",
x"
010101000101020104010103010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000010000000300020005000400070006
00000008000000000000000000090000000A0000000C000B0000000D0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000F000E00110010000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00130012001500140017001600190018001B001A0000001C001E001D0020001F00210000000000000000000000000000
000000000000000000000000002200000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000008C80000000000DE01000000000000000C80000000000019810000000000000008C00000000000000100000000
00000008C000000000001A01000000000000000C000000000000198100000000000000008000000000001DC600000000
0000000E000000000000001E000000000000000C400000000000001A000800000000000C8000000000001DC100000000
0000000C000000007F030000000C00000000000000080000000000000000000000000000000800000000000000000000
00000000C0000000000000008000000000000000000000000000000000000000000000001802000000C0000000000000
000000100000000000000000000000000000000000000000000000000000000000000000C0400000000001BF00000000
0000000001FB0E78000000000000000000000000000000000000000000000000060000000000000000A000000007E000
0000000000000000000000000000000000000010C0000000000000030000000000000004000000C20000000000005C80
0000000000300FF000000000000000000000000000000000000000000080000200000000000000980000000000000000
00000003FFF000000000000F000000000000000000000000000400000000000000000008CC3000000000000000000000
000000000019800000002000000000000000000000000000000000000020C80000000000000000000000000000000000
000000000000000000000000000016D80000000500000000000000000000000000000004018700000000000000000000
000000000000100000000060000000000000000480380000000040000000000000000000000C70000000000000000000
000000000000000000000000000000070000000C800000000000199E0000000C00000000060000000000340000000000
0000000000E000000000002300000000000000005A060000000000020000000000000000000000000000000000000000
000000004F030000000000000000000000000000580700000000000000000000000000000000D0000000000000000000
400000000000004000000000000000000000000000000000000000000000000000000000010070000000000000000000
000000000000000000000000000000000000000001BE000000000005000000000000000000000000F00E000000000010
000000000200000001800000000000000080000000000000000000000000000000000000400080000000000000000000
000000000012020000000000000000000000000000000000000000000000000000587C00000000000000000000000000
000000000000000000000000000000000000000000000000000000000060000000000008C03000000000000000000000
000000000000000000000000000000000000000000001C00000000000000000000000000000000000000000000000000
0000000000000000FFFE0000FFFFFFFF000000FF00000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//3552 bytes
enum graphemeExtendTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000004000000110",
x"
00000100000001A000004D00",
x"
0202010004020302070206050A0908020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020B02020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000001000000030002000500040007000600090008000B000A000D000C
0000000E000F000000000000001000000012001100140013001600150000000000000017000000000000000000000000
000000000000000000190018000000000000001A00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000001B001D001C001F001E0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000002000000000000000220021
0023000000250024000000000000000000000000000000260027000000290028002B002A002D002C002F002E00310030
003300320000003400360035003800370000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000390000000000000000000000000000000000000000003A0000000000000000000000000000
00000000003C003B00000000003D00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000003E0000000000000000000000000000000000000000000000000000000000000000003F0000
0040000000000041000000000000000000000000000000420000000000000000003C0043000000440046004500000000
004800470000000000000000000000000000000000490000000000000000000000000000000000000000000000000000
004B004A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00000000000000000000000000000000
00000000000000000000000000000000000003F800000000000000000000000000000000000000000000000000000000
FFFE0000BFFFFFFF000000B60000000007FF000000000000FFFFF8000001000000000000000000009FC0000000003D9F
00020000FFFF0000000007FF00000000000000000001FFC000000000200FF800FBC0000000003EEF0E00000000000000
FF80000000000000FFFFFC00FFFFFFFB000000071400000000FE21FE0000000C00000002500000000080201E4000000C
000000061000000000023986002300000000000610000000000021BEFC00000C00000002D000000000E0201E0000000C
0000000440000000008020010000000000000011D000000000603DC10000000C000000029000000000603DC50000000C
00000003580000000080201E0000000C0000000200000000805C8400000000000000000007F2000000007F8000000000
000000001FF2000000007F00000000000300000002A00000000000007FFE0000FEFFE0DF1FFFFFFF0000004000000000
0000000066FDE000C3000000001E0001200020640000000000000000000000000000000000000000E000000000000000
00000000000000000000000000000000003C0000001C0000000C0000000C0000000000003FB00000200FFE4000000000
0000B80000000000000000000000000000000060000002000000000000000000000000000E0401870000000000000000
0000000000000000000000000000000009800000000000007F4000009FF81FE500000000FFFF000000007FFF00000000
0000000F3FF000000000001C000FF8000000000300003F3C00000000000FA3400000000000CFF0000000000000000000
0000000000000000FFF70000031021FD000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFF
000010000000000000000000000000000000000000000000FFFF00000001FFFF00000000000000000000000000000000
0000000000000000000000000003800000000000000000000000000080000000000000000000000000000000FFFFFFFF
000000000000FC000000000000000000060000000000000000000000000000000000000000000000000000003FF78000
C0000000000000000000000000030000000008440000106000000000000000000000000000000000000000308003FFFF
0000000000003FC0000BFF80000000000000000733C8000000000001000000200000000000667E000000100810000000
00000000C19D000000000002004030000000000000000000000000000000000000000000000000000000000000002120
40000000000000000000000000000000000000000000000000000000000000000000FFFF0000FFFF0000000000000000
0000000000000000000000000000000000000000000000000000000000000000C0000000000000000000000000000000
000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000
0000000000000000000000000000000100000000000000000000000007C0000000000000000000000000000000000000
0000F06E8700000000000000000000000000000000000000000000000000006000000000000000F00000000000003E00
0000000000000000000000000000000000000000000000000000000000000000000000000000180000000000F0000000
00000000000000000001FFC0000000000000003C00000000000000000000000000000002FF0000000000007F80190000
0000000306780000000000040000000000000007001FEF800000000000080000000000037FC0000000009E0100000000
0000000040F380000000000200000000000000000000000080000000000007F8000000035800000000802001001F1FC0
00000000F90000000005C3A50000000600000000FF0000004000005C0000000000000000A5F900000000000D00000000
0000000000000000000000000000000000000000B03C8000300000010000000000000000A7F800000000000100000000
0000000000FF28000000000000000000A000000000000FBC000000000000000000000000000000000000000000000000
0000000006FF800000000000000000000000000000000000000000000000000000000000780100000000000800000000
00000000000000000CF0000000000001000007FE79F800000E7E008000000000037FFC00000000000000000000000000
00000000BF7F00000000000000000000FFFC0000006DFCFF000000000000000000000000B47E0000000000BF00000000
00A300000000000000000000000000000000000000000000000000000000000000000000000000000000000000180000
0000000307C000000400000700000000000000000000000000000000000000000000000000000000003FFF8100000000
00000000000000000000000000000000C00000000000E3FF000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000001F000000000000007F00000000000000000000
000000000000000000000000000000000000000000000000000080000000000000078000000000000000000000030010
0000000000000000000000000000000060000000000000000000000000000000FFFFFFFFFFFF3FFF0000007F00000000
00000000000000000000000000000000000000000000000000000000F807E3E000000FE700003C000000000000000000
00000000000000000000001C0000000000000000000000000000000000000000FFFFFFFFF87FFFFFFFFFFFFF00201FFF
F80000100000FFFE0000000000000000F9FFFF7F000007DB000000000000000000008000000000000000000000000000
000000000000000000000000000000000000000000004000000000000000F00000000000000000000000000000000000
0000000000000000000000000000F000000000000000000000000000000000000000000000000000000000000000C000
000000000000000000000000000000000000000000000000007F0000000000000000000000000000000007F000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F8000000
00000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000000000000000000000000000000000000000000000000000000000000000",
);
//1344 bytes
enum Extended_PictographicTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000004000000090",
x"
00000100000000A000001800",
x"
020201000202020202020202030202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000000010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100030002000400010006000500080007
00090001000A000100010001000100010001000B0001000C000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000E000D0010000F0011000D00130012001500140001000D000D000D0016000D00010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000000000000000000000000000000000000000000004200000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000010000000000002000000000000000000000000000000000000000000
0000000002000004000000000000000003F000000000060000000000000000000C000000000001000000000000000000
000001000000000000008000070FFE000000000000000000000000000000000000000000000000000000000400000000
000000000000000000000000000000000000000000400C000000000178000000FFF7FFBFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF003FFFFFFFFFFFFFFFFFFFFFFFFF2057FF3F0018010200B85090000000F800E00000800100020000000000000000
0000000000300000000000000000000000000000000000000000000000000000180000E0000000000021000000000000
000000000000000000000000000000000000000020010000000000000000000000000000000000000000000000000000
0000000000000000000000000000000002800000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000E0000000800000000000C003F00007FE4000FFFFE000FFFFFFFF0000003F
0400FFFEF7FC8000FFFFFE00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF07FFFFFFFFFFFFFF3FFFFFFFFFFFFFC0FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000FFF00000
0000000000000000FFE00000FFFFFFFF0000F00000000000FC00FF00000000000000FF00FFFFC000FFFFFFFFFFFFFFFF
FFFFF000F7FFFFFFFFFFFFBFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFF0000000000000000000000000000000000000000000000000000000000000000",
);

}


static if (size_t.sizeof == 8)
{
//832 bytes
enum hangulLVTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000040",
x"
000000000000010000000000000000800000000000000A00",
x"
000201000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000040003000200010001000700060005000500040003000200020001000700060006000500040003
000300020001000700070006000500040004000300020001000100070006000500050004000300020008000100070006
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000100000010000001000100000010000000000100000010001000000100000010
001000000100000000001000000100000000001000000100010000001000000100010000001000000000010000001000
100000010000001000100000010000000000100000010000000000100000010001000000100000010001000000100000
000001000000100010000001000000100010000001000000000010000001000000000010000001000100000010000001
000100000010000000000100000010001000000100000010001000000100000000001000000100000000001000000100
001000000100000000001000000100000000000000000100000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//832 bytes
enum hangulLVTTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000040",
x"
000000000000010000000000000000800000000000000A00",
x"
000201000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000040003000200010001000700060005000500040003000200020001000700060006000500040003
000300020001000700070006000500040004000300020001000100070006000500050004000300020008000100070006
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FEFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFEF
FFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFF
EFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFEFFFEFFFFFFEFFFFF
FFFFFEFFFFFFEFFFEFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFE
FFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFEFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFFFFFFFFEFFFFFFEFF
FFEFFFFFFEFFFFFFFFFFEFFFFFFEFFFF0000000FFFFFFEFF000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//928 bytes
enum prependTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000040",
x"
000000000000010000000000000000800000000000000D00",
x"
010101010101010001010101010101020101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000200010000000000000000000000030000000000040000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000070000000600050000000000000000
0000000900080000000B0000000A00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000003F000000000000000000000000000000000000000020000000
000000000000800000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000003000000000004000000000000000000000000000000000000400000000000000000000000000000000000
000000000000000000000000000000002000000000000000000000000000200000000000000000000000000000000000
0000000000000000000000000000000C0000000000000000000000000000000000000000000000000000000000020000
800000000000000000000000000000020000000000000000000000000000000004000000000000000000000000000000
00000000000003F000000000000000000000000000000000000000000000004000000000000000000000000000000000
000000000000000400000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//1280 bytes
enum controlTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000068",
x"
000000000000010000000000000001200000000000000E00",
x"
030202020202010002060502020204020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020207020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000100010000000100020001000100010001000100010001000100010001
000100010001000100010001000100010001000100010003000100010001000100010001000100040001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000600050001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000700010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100080001000100010001000100010001000100010001000100010001000100010001
0001000100090001000100010001000100010001000100010001000100010001000C000C000B000A000C000C000C000C
000C000C000C000C000C000C000C000C0001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
0001000100010001000100010001000100000000FFFFDBFF800000000000000000002000FFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000
000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000
00007F000000C8000000FFFF000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000080000000000000000000000000000000000000000000000000000000000000000FFF000000000000
FFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000F000000000000000000000000000000000000000007F800000000000000000000000000000000000000000000
00000000FFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
0000000000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000000000000000000000000000000000000000000000000000000000000",
);
//1792 bytes
enum spacingMarkTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000050",
x"
000000000000010000000000000000C00000000000002400",
x"
010102010101010001010101040101030101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101010101010000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000030002000100000007000600050004
00000000000000080009000000000000000C000B000A0000000000000000000D00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000110010000F000E000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001500140013001200190018001700160000001C001B001A0020001F001E001D00000000002100000000000000000000
000000000000000000220000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
C800000000000008000000000000DE01800000000000000C0000000000001981C0000000000000080000000000000001
C0000000000000080000000000001A01000000000000000C000000000000198180000000000000000000000000001DC6
000000000000000E000000000000001E400000000000000C000800000000001A800000000000000C0000000000001DC1
000000000000000C000C00007F0300000008000000000000000000000000000000080000000000000000000000000000
C00000000000000080000000000000000000000000000000000000000000000018020000000000000000000000C00000
0000000000000010000000000000000000000000000000000000000000000000C04000000000000000000000000001BF
01FB0E780000000000000000000000000000000000000000000000000000000000000000060000000007E00000A00000
00000000000000000000000000000000C0000000000000100000000000000003000000C20000000400005C8000000000
00300FF00000000000000000000000000000000000000000008000020000000000000098000000000000000000000000
FFF0000000000003000000000000000F00000000000000000000000000040000CC300000000000080000000000000000
0019800000000000000000000000200000000000000000000020C8000000000000000000000000000000000000000000
0000000000000000000016D8000000000000000000000005000000000000000001870000000000040000000000000000
0000100000000000000000000000006080380000000000040000000000004000000C7000000000000000000000000000
00000000000000000000000700000000800000000000000C0000000C0000199E06000000000000000000000000003400
00E000000000000000000000000000235A06000000000000000000000000000200000000000000000000000000000000
4F030000000000000000000000000000580700000000000000000000000000000000D000000000000000000000000000
000000404000000000000000000000000000000000000000000000000000000001007000000000000000000000000000
0000000000000000000000000000000001BE0000000000000000000000000005000000000000000000000010F00E0000
020000000000000000000000018000000000000000800000000000000000000040008000000000000000000000000000
00120200000000000000000000000000000000000000000000000000000000000000000000587C000000000000000000
0000000000000000000000000000000000000000000000000060000000000000C0300000000000080000000000000000
0000000000000000000000000000000000001C0000000000000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFE000000000000000000FF000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//3552 bytes
enum graphemeExtendTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000088",
x"
000000000000010000000000000001A00000000000004D00",
x"
04020302020201000A090802070206050202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
02020202020202020202020202020202020202020202020B020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000100000000000000050004000300020009000800070006000D000C000B000A
000F00000000000E00100000000000000014001300120011000000000016001500000000000000170000000000000000
00000000000000000000000000190018000000000000001A000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000001B00000000001F001E001D001C0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000200000000000000022002100000000
0025002400230000000000000000000000000026000000000029002800270000002D002C002B002A00310030002F002E
000000340033003200380037003600350000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000390000000000000000000000000000000000000000003A00000000000000000000
003C003B00000000003D0000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000003E000000000000000000000000000000000000000000000000003F000000000000
000000410040000000000000000000000000004200000000000000000000000000000044003C00430000000000460045
000000000048004700000000000000000049000000000000000000000000000000000000000000000000000000000000
00000000004B004A00000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00000000000000000000000000000000
0000000000000000000000000000000000000000000003F8000000000000000000000000000000000000000000000000
BFFFFFFFFFFE000000000000000000B60000000007FF000000010000FFFFF800000000000000000000003D9F9FC00000
FFFF00000002000000000000000007FF0001FFC000000000200FF8000000000000003EEFFBC00000000000000E000000
00000000FF800000FFFFFFFBFFFFFC0014000000000000070000000C00FE21FE50000000000000024000000C0080201E
100000000000000600230000000239861000000000000006FC00000C000021BED0000000000000020000000C00E0201E
40000000000000040000000000802001D0000000000000110000000C00603DC190000000000000020000000C00603DC5
58000000000000030000000C0080201E000000000000000200000000805C840007F20000000000000000000000007F80
1FF20000000000000000000000007F0002A00000030000007FFE0000000000001FFFFFFFFEFFE0DF0000000000000040
66FDE00000000000001E0001C300000000000000200020640000000000000000000000000000000000000000E0000000
00000000000000000000000000000000001C0000003C0000000C0000000C00003FB000000000000000000000200FFE40
000000000000B8000000000000000000000002000000006000000000000000000E040187000000000000000000000000
0000000000000000000000000000000000000000098000009FF81FE57F400000FFFF0000000000000000000000007FFF
3FF000000000000F000FF8000000001C00003F3C00000003000FA3400000000000CFF000000000000000000000000000
0000000000000000031021FDFFF70000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFF
0000000000001000000000000000000000000000000000000001FFFFFFFF000000000000000000000000000000000000
00000000000000000003800000000000000000000000000080000000000000000000000000000000FFFFFFFF00000000
0000FC000000000000000000000000000000000006000000000000000000000000000000000000003FF7800000000000
00000000C000000000030000000000000000106000000844000000000000000000000000000000008003FFFF00000030
00003FC00000000000000000000BFF8033C8000000000007000000200000000100667E00000000001000000000001008
C19D00000000000000403000000000020000000000000000000000000000000000000000000000000000212000000000
00000000400000000000000000000000000000000000000000000000000000000000FFFF0000FFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000C00000000000000000000000
000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000
00000000000000000000000100000000000000000000000007C000000000000000000000000000000000000000000000
870000000000F06E000000000000000000000000000000000000006000000000000000F00000000000003E0000000000
00000000000000000000000000000000000000000000000000000000000000000000180000000000F000000000000000
0000000000000000000000000001FFC0000000000000003C0000000000000000FF00000000000002801900000000007F
06780000000000030000000000000004001FEF800000000700080000000000007FC00000000000030000000000009E01
40F380000000000000000000000000020000000000000000000007F8800000005800000000000003001F1FC000802001
F900000000000000000000060005C3A5FF00000000000000000000004000005CA5F9000000000000000000000000000D
00000000000000000000000000000000B03C8000000000000000000030000001A7F80000000000000000000000000001
00FF280000000000000000000000000000000FBCA0000000000000000000000000000000000000000000000000000000
06FF80000000000000000000000000000000000000000000000000000000000078010000000000000000000000000008
0000000000000000000000010CF0000079F80000000007FE000000000E7E008000000000037FFC000000000000000000
BF7F0000000000000000000000000000006DFCFFFFFC00000000000000000000B47E00000000000000000000000000BF
0000000000A3000000000000000000000000000000000000000000000000000000000000000000000018000000000000
07C0000000000003000000000400000700000000000000000000000000000000000000000000000000000000003FFF81
000000000000000000000000000000000000E3FFC0000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000001F000000000000007F0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000800000000000000780000003001000000000
0000000000000000000000000000000000000000600000000000000000000000FFFF3FFFFFFFFFFF000000000000007F
000000000000000000000000000000000000000000000000F807E3E00000000000003C0000000FE70000000000000000
0000000000000000000000000000001C00000000000000000000000000000000F87FFFFFFFFFFFFF00201FFFFFFFFFFF
0000FFFEF80000100000000000000000000007DBF9FFFF7F000000000000000000000000000080000000000000000000
0000000000000000000000000000000000004000000000000000F0000000000000000000000000000000000000000000
00000000000000000000F000000000000000000000000000000000000000000000000000000000000000C00000000000
00000000000000000000000000000000000000000000000000000000007F0000000000000000000000000000000007F0
00000000000000000000000000000000000000000000000000000000000000000000000000000000F800000000000000
FFFFFFFF00000000FFFFFFFFFFFFFFFF00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000",
);
//1344 bytes
enum Extended_PictographicTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000048",
x"
000000000000010000000000000000A00000000000001800",
x"
020202020202010003020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000100010000000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100040001000300020008000700060005
000A00010009000100010001000100010001000C0001000B000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
0010000F000E000D001300120011000D0001000D001500140016000D000D000D00010001000100010001000100010001
000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001
000000000000000000000000000000000000420000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000001000000000000000000000000000020000000000000000000000000000000000
020000040000000000000000000000000000060003F000000000000000000000000001000C0000000000000000000000
0000000000000100070FFE00000080000000000000000000000000000000000000000000000000000000000000000004
0000000000000000000000000000000000400C00000000007800000000000001FFFFFFFFFFF7FFBFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF003FFFFFFFFFFFFFFFFF001801022057FF3F000000F800B850908001000200E000000000000000000000
003000000000000000000000000000000000000000000000000000000000000000000000180000E00000000000210000
000000000000000000000000000000002001000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000028000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000080000000E000C003F00000000000FFFFE00007FE40000000003FFFFFFFFF
F7FC80000400FFFEFFFFFFFFFFFFFE00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF07FFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FFF0000000000000
0000000000000000FFFFFFFFFFE00000000000000000F00000000000FC00FF00FFFFC0000000FF00FFFFFFFFFFFFFFFF
F7FFFFFFFFFFF000FFFFFFFFFFFFFFBFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000",
);

}

