Original Code - Copyright (c) 2001 Anthony L Shipman
MLton Port Modifications - Copyright (c) Ray Racine

Permission is granted to anyone to use this version of the software
for any purpose, including commercial applications, and to alter it and
redistribute it freely, subject to the following restrictions:

    1. Redistributions in source code must retain the above copyright
    notice, this list of conditions, and the following disclaimer.

    2. The origin of this software must not be misrepresented; you must
    not claim that you wrote the original software. If you use this
    software in a product, an acknowledgment in the product documentation
    would be appreciated but is not required.

    3. If any files are modified, you must cause the modified files to
    carry prominent notices stating that you changed the files and the
    date of any change.

Disclaimer

    THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
    INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
    STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.

Modification History
====================
Ray Racine 6/3/2005 - MLton Port and idiomatic fixups.

(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct

    fun ibr rdr the_cstrm =
    let
	(*  Read all characters to the end of the
	    string or a newline.  This returns the
	    line and the rest of the stream.
	*)
	fun get_line cstrm rev_line =
	(
	    case rdr cstrm of
	      NONE => (cstrm, implode(rev rev_line))
	      			(* ran out of chars *)

	    | SOME (c, rest) => 
	    (
		if c = #"\n"
		then
		    (rest, implode(rev rev_line))
		else
		    get_line rest (c::rev_line)
	    )
	)

	val (strm_out, line) = get_line the_cstrm []
	val l1 = Substring.all line

	val (i, l2) = valOf(Int.scan StringCvt.DEC
				Substring.getc l1)
	val (b, l3) = valOf(Bool.scan Substring.getc l2)
	val (r, l4) = valOf(Real.scan Substring.getc l3)
    in
	SOME((i, b, r), strm_out)
    end
    handle Option => NONE



    fun main(arg0, argv) =
    let
	val text = "\
		\  123 true  23.4       \n\
		\  -1  false -1.3e3     \n\
		\"
    in
	case StringCvt.scanString ibr text of
	  NONE => print "ibr failed\n"

	| SOME (i, b, r) => print(concat[
		Int.toString i, " ",
		Bool.toString b, " ",
		Real.toString r, "\n"
		]);

        OS.Process.success
    end


    val _ = SMLofNJ.exportFn("ibr_cvt", main)
end
