/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xba, 0xd2, 0x5c, 0x68, 0x1f, 0x88, 0xfd, 0x3a, 0x57, 0x35, 0x34, 0xaa,
        0xfa, 0xcd, 0x2b, 0x14, 0xfd, 0x7c, 0xb4, 0x82, 0x9a, 0x3e, 0x03, 0x03,
        0x74, 0xaf, 0x4c, 0x0a, 0x3e, 0x3d, 0x3f, 0x52, 0xc3, 0x2e, 0x8f, 0xe6,
        0xdb, 0x7c, 0x9e, 0xf3, 0x8f, 0x3e, 0x01, 0x10, 0x3f, 0xeb, 0x16, 0x21,
        0xc2, 0xb6, 0xef, 0x3e, 0xde, 0x05, 0xbf, 0x95, 0x6b, 0x5b, 0x2f, 0x5d,
        0xc8, 0x2b, 0xb4, 0x68, 0x4a, 0xb7, 0xc9, 0x08, 0x76, 0xfc, 0x68, 0x1e,
        0xd6, 0xd8, 0x41, 0x21, 0x67, 0xd3, 0x6c, 0x84, 0xe0, 0xcc, 0x57, 0x90,
        0xc1, 0x7d, 0x60, 0xb7, 0xe9, 0x33, 0x42, 0x8d, 0x57, 0x3c, 0x7e, 0x64,
        0x03, 0x4e, 0x62, 0x4e, 0x5a, 0x19, 0xeb, 0x82, 0x0c, 0x1b, 0xe6, 0xb2,
        0xe4, 0xcc, 0x00, 0x36, 0x2f, 0x40, 0x0d, 0xf6, 0x2d, 0xab, 0x72, 0xb4,
        0x81, 0x09, 0x5c, 0xee, 0x37, 0xad, 0xed, 0xf2, 0xc8, 0xd3, 0x3f, 0x3c,
        0xf9, 0x24, 0xa8, 0x08, 0xb3, 0xb2, 0x97, 0xa8, 0x32, 0x7b, 0xed, 0x3c,
        0x68, 0x3d, 0x4c, 0xe1, 0x6b, 0xe7, 0x5c, 0x96, 0x3f, 0x65, 0xcb, 0x8b,
        0x42, 0x9f, 0x01, 0x9e, 0x4d, 0xe4, 0xbb, 0xf9, 0x04, 0xba, 0x8a, 0xf0,
        0x5b, 0xca, 0x25, 0xd9, 0xe5, 0x97, 0x11, 0x10, 0xa6, 0xb4, 0x3c, 0xbe,
        0x64, 0x9f, 0x9f, 0xc3, 0x0e, 0x2c, 0x71, 0x46, 0x00, 0xd2, 0x08, 0xc3,
        0x73, 0xa4, 0x2c, 0x33, 0x52, 0xd2, 0xc1, 0x22, 0x79, 0xf3, 0xe8, 0xc6,
        0xe5, 0xcf, 0x35, 0x5e, 0x2a, 0x6b, 0xaf, 0xfd, 0xea, 0x1f, 0xfe, 0x04,
        0x5f, 0xe7, 0x3b, 0x02, 0x07, 0x25, 0xc7, 0xf0, 0xe2, 0xfa, 0x43, 0xe8,
        0x49, 0xf7, 0xdd, 0x8c, 0x62, 0x71, 0xd0, 0x9d, 0x3a, 0x5a, 0x65, 0xb6,
        0x81, 0xf1, 0xe3, 0xf2, 0x32, 0xe4, 0x72, 0x99, 0x0f, 0xfa, 0x17, 0x16,
        0xcd, 0x1e, 0x9c, 0x07
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.76 */
